/******************************************************************************\
*           Copyright (C) 1999 Texas Instruments Incorporated.
*                           All Rights Reserved
*------------------------------------------------------------------------------
* MODULE.NAME... HCFG - HAL configuration module
* FILENAME...... csl_std.h
* DATE CREATED.. 03/11/1999 
* PROJECT....... CSL - Chip Support Library
* COMPONENT..... HAL
* IMPORTS....... 
*------------------------------------------------------------------------------
* HISTORY:
*   CREATED:       03/11/1999 
*   MODIFIED:      05/04/1999 modified for c54x
*   MODIFIED:      06/19/2000
*   MODIFIED:      07/13/2000 modified for c5510
*   LAST MODIFIED: 03/23/2001 modified to redefine type that conflict with BIOS
*   LAST MODIFIED: 04/16/2001 updated FILENAME and other header comments
*                  01/06/2005 Added _TI_STD_TYPES  directive to protect 
*                              multiple definition of datatypes.
*------------------------------------------------------------------------------
* DESCRIPTION:  (CHIP memory mapped register definitions)
*
*
*
\******************************************************************************/


#ifndef _CSL_STDINC_H_
#define _CSL_STDINC_H_


typedef unsigned short  CSLBool;
typedef int  CSLInt;
typedef char CSLChar;
typedef unsigned int CSLUint;


/****************************************\
* STDINC macro declarations
\****************************************/

#ifndef TRUE
#define TRUE   ((CSLBool)(1))
#endif
#ifndef FALSE
#define FALSE  ((CSLBool)(0))
#endif
#define YES    ((CSLBool)(1))
#define NO     ((CSLBool)(0))

/* invalid pointer */
#define INV    ((void*)(-1))

/* useful macros for declaring peripheral registers */

#define REG16(addr)		(*(volatile Uint16*)(addr))

/****************************************\
* STDINC macrso for enabling/disabling   
* interrupts
\****************************************/

#define ENABLE_INTERRUPTS\
 { asm("\t BIT(ST1, #ST1_INTM) = #0 ;====> CODE AUTO-GENERATED by CSL");\
 }
#define DISABLE_INTERRUPTS\
 { asm("\t BIT(St1, #ST1_INTM) = #1 ;====> CODE AUTO-GENERATED by CSL");\
 }


/****************************************\
* STDINC typedef declarations
\****************************************/

#include <tistdtypes.h>  /* use typedefs provided with CCS */


typedef unsigned char	  Uchar;
typedef void *          Handle;
   
/****************************************\
* STDINC variable declarations
\****************************************/
// Note in Large Model CSL_DATA_PTR takes up location 7A & 7B

#define CSL_DATA_PTR		   (0x007au)

/****************************************\
* STDINC generic macro declarations
\****************************************/
  #define _CHIP_PERBASE_ADDR      (0x0000u)

 /*============================================================================*\
 * register bit manipulation macros
 \*============================================================================*/

  /* memory mapped register macros */
  #define _FIELD_GET(RegAddr,FIELD) (Uint16)( \
  (REG16(RegAddr)&##FIELD##_MASK)>>##FIELD##_SHIFT \
  ) 

  #define _FIELD_SET(RegAddr,FIELD,Val) REG16(RegAddr)=(Uint16)( \
  (REG16(RegAddr)&##FIELD##_CLR)| \
  ((Uint16)##FIELD##_MK(Val)) \
  )

  #define _FIELD_SHIFT(FIELD,Val) \
  ((Uint16)##FIELD##_MK(Val))

  #define _REG32_GET(RegAddr) \
  (Uint32)Reg32(RegAddr)

  #define _REG_GET(RegAddr) \
  (Uint16)REG16(RegAddr)

  #define _REG32_SET(RegAddr,Val) \
   Reg32(RegAddr)=(Uint32)(Val)
  
  #define _REG_SET(RegAddr,Val) \
   REG16(RegAddr)=(Uint16)(Val)

  /*============================================================================*\
  * Peripheral Register bit manipulation macros
  \*============================================================================*/
  #define _PFIELD_GET(PregAddr,FIELD) (Uint16)( \
  (PREG16(PregAddr)&##FIELD##_MASK)>>##FIELD##_SHIFT \
  ) 

  #define _PFIELD_SET(PregAddr,FIELD,Val) PREG16(PregAddr)=(Uint16)( \
  (PREG16(PregAddr)&##FIELD##_CLR)| \
  ((Uint16)##FIELD##_MK(Val)) \
  )

  #define _PFIELD_AOI(PregAddr,FIELD,AND,OR,INV) PREG16(PregAddr)=(Uint16)( \
  ((PREG16(PregAddr)& ##FIELD##_CLR)| ((((PREG16(PregAddr) & ##FIELD##_MASK) & AND) | OR) ^ INV))\
  )

  /*============================================================================*\
  * Peripheral register read/write macros
  \*============================================================================*/
  #define _PREG_SET(PregAddr, Val)               PREG16(PregAddr) = (Uint16)Val
  #define _PREG_AOI(PregAddr,AND,OR,INV)\
     PREG16(PregAddr) = (((PREG16(PregAddr) & AND) | OR ) ^ INV)

  #define _PREG_GET(PregAddr)                    PREG16(PregAddr)

  #define _PREG32_SET(PregAddr, Val)             PREG32(PregAddr) = (Uint32)Val
  #define _PREG32_AOI(PregAddr,AND,OR,INV)\
     PREG32(PregAddr) = (((PREG32(PregAddr) & AND) | OR ) ^ INV)

  #define _PREG32_GET(PregAddr)                    PREG32(PregAddr)


 /*===========================================================================*\
 * control register macros 
 \*===========================================================================*/

  #define _CRFIELD_GET(RegAddr,FIELD) (Uint16)( \
    (REG16(RegAddr)&##FIELD##_MASK)>>##FIELD##_SHIFT \
  )  

  #define _CRFIELD_SET(RegAddr,FIELD,Val) REG16(RegAddr)=(Uint16)( \
  (REG16(RegAddr)& ##FIELD##_CLR)| \
  (((Uint16) ##FIELD##_MK(Val)) \
  )


#endif
/******************************************************************************\
* End of csl_stdinc.h
\******************************************************************************/

