/*
 * ipc_interrupt.c
 *
 *  Created on: Dec 1, 2011
 *      Author: x0144789
 */
#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <ti/csl/csl_chip.h>
#include <ti/csl/src/intc/csl_intc.h>
#include <ti/csl/csl_cpintcAux.h>

#include "ipc_interrupt.h"

CSL_IntcGlobalEnableState state;
CSL_IntcContext context;
CSL_IntcEventHandlerRecord Record[CSL_INTC_EVENTID_CNT];
CSL_IntcEventHandlerRecord  EventRecord;
uint32_t        coreVector[MAX_CORE_NUM];
CSL_IntcObj     intcObj[16];
CSL_IntcHandle  hintc[16];
volatile Uint32 interruptNumber=0;

/* IPCGR Info */
int32_t iIPCGRInfo[CORENUM] = {
								IPCGR0,
								IPCGR1,
								IPCGR2,
								IPCGR3,
								IPCGR4,
								IPCGR5,
								IPCGR6,
								IPCGR7
							 };
/* IPCAR Info */
int32_t iIPCARInfo[CORENUM] = {
								IPCAR0,
								IPCAR1,
								IPCAR2,
								IPCAR3,
								IPCAR4,
								IPCAR5,
								IPCAR6,
								IPCAR7
							 };

interruptCfg intInfo[MAX_SYSTEM_VECTOR] =
{
	/* core   event   vector*/
	{  0,     91,     CSL_INTC_VECTID_4, &IPC_ISR},
	{  1,     91,     CSL_INTC_VECTID_4, &IPC_ISR},
	{  2,     91,     CSL_INTC_VECTID_4, &IPC_ISR},
	{  3,     91,     CSL_INTC_VECTID_4, &IPC_ISR},
	{  4,     91,     CSL_INTC_VECTID_4, &IPC_ISR},
	{  5,     91,     CSL_INTC_VECTID_4, &IPC_ISR},
	{  6,     91,     CSL_INTC_VECTID_4, &IPC_ISR},
	{  7,     91,     CSL_INTC_VECTID_4, &IPC_ISR},
};


/**
 *  @b Description
 *  @n
 *      The functions initializes the INTC module.
 *
 *  @retval
 *      Success -   0
 *  @retval
 *      Error   -   <0
 */
int32_t intcInit()
{
    /* INTC module initialization */
    context.eventhandlerRecord = Record;
    context.numEvtEntries      = CSL_INTC_EVENTID_CNT;
    if (CSL_intcInit (&context) != CSL_SOK)
        return -1;

    /* Enable NMIs */
    if (CSL_intcGlobalNmiEnable () != CSL_SOK)
        return -1;

    /* Enable global interrupts */
    if (CSL_intcGlobalEnable (&state) != CSL_SOK)
        return -1;

    /* INTC has been initialized successfully. */
    return 0;
}

/*  @b Description
 *  @n
 *
 *      Function registers the high priority interrupt.
 *  @retval
 *      Success -   0
 *  @retval
 *      Error   -   <0
 */

int32_t registerInterrupt()
{
	uint32_t i;
	uint32_t event;
	uint32_t vector;
	uint32_t core;
	uint32_t coreID = CSL_chipReadReg (CSL_CHIP_DNUM);
	CSL_IntcEventHandler isr;

	for (i=0; i<MAX_CORE_NUM; i++)
	{
		coreVector[i] = 0;
	}

	for (i=0; i<MAX_SYSTEM_VECTOR; i++)
	{
		core   = intInfo[i].core;
		if (coreID == core)
		{
			event  = intInfo[i].event;
			vector = intInfo[i].vect;
			isr    = intInfo[i].isr;

			if (MAX_CORE_VECTOR <= coreVector[core])
			{
				printf("Core %d Vector Number Exceed\n");
			}

    		    hintc[vector] = CSL_intcOpen (&intcObj[vector], event, (CSL_IntcParam*)&vector , NULL);
		    if (hintc[vector] == NULL)
		    {
		        printf("Error: GEM-INTC Open failed\n");
		        return -1;
		    }

		    /* Register an call-back handler which is invoked when the event occurs. */
		    EventRecord.handler = isr;
		    EventRecord.arg = 0;
		    if (CSL_intcPlugEventHandler(hintc[vector],&EventRecord) != CSL_SOK)
		    {
		        printf("Error: GEM-INTC Plug event handler failed\n");
		        return -1;
		    }

			/* clear the events. */
		    if (CSL_intcHwControl(hintc[vector],CSL_INTC_CMD_EVTCLEAR, NULL) != CSL_SOK)
		    {
		        printf("Error: GEM-INTC CSL_INTC_CMD_EVTCLEAR command failed\n");
		        return -1;
		    }

			/* Enabling the events. */
		    if (CSL_intcHwControl(hintc[vector],CSL_INTC_CMD_EVTENABLE, NULL) != CSL_SOK)
		    {
		        printf("Error: GEM-INTC CSL_INTC_CMD_EVTENABLE command failed\n");
		        return -1;
		    }
			coreVector[core]++;
		}
	}

    return 0;
}
// BOOT and CONFIG dsp system modules Definitions
#define CHIP_LEVEL_REG  0x02620000
// Boot cfg registers
#define KICK0			*(unsigned int*)(CHIP_LEVEL_REG + 0x0038)
#define KICK1			*(unsigned int*)(CHIP_LEVEL_REG + 0x003C)
#define KICK0_UNLOCK (0x83E70B13)
#define KICK1_UNLOCK (0x95A4F1E0)
#define KICK_LOCK    0

void IssueInterruptToNextCore()
{
   uint32_t CoreNum;
   uint32_t iNextCore;
   static uint32_t interruptInfo=0;

   CoreNum = CSL_chipReadReg (CSL_CHIP_DNUM);

   iNextCore = (CoreNum + 1)%8; //

   printf("Set interrupt from Core %x to Core %d, cycle = %d\n", CoreNum, iNextCore, TSCL);

   interruptInfo +=16;

	// Unlock Config
	KICK0 = KICK0_UNLOCK;
	KICK1 = KICK1_UNLOCK;

   *(volatile uint32_t *) iIPCGRInfo[iNextCore] = interruptInfo;

   *(volatile uint32_t *) iIPCGRInfo[iNextCore] |= 1;
	// lock Config
	KICK0 = KICK_LOCK;
	KICK1 = KICK_LOCK;
   printf("Interrupt Info %d\n", interruptInfo);

}

/**
 *  @b Description
 *  @n
 *      IPC interrupt service routine
 *
 *
 *  @retval
 *      Setup corresponding flags based on SRC of IPCGR
 */
void IPC_ISR()
{
	volatile uint32_t read_ipcgr;
    uint32_t CoreNum;
    uint32_t iPrevCore;
    CoreNum = CSL_chipReadReg (CSL_CHIP_DNUM);;

    iPrevCore = (CoreNum - 1)%8;

    read_ipcgr = *(volatile Uint32 *) iIPCGRInfo[CoreNum];

    *(volatile uint32_t *) iIPCARInfo[CoreNum] = read_ipcgr; //clear the related source info

    printf("Receive interrupt from Core %d with info 0x%x, cycle = %d\n", iPrevCore, read_ipcgr, TSCL);

    interruptNumber++;

    if(CoreNum!=0)//
    {
    	IssueInterruptToNextCore();
    }
    else
    {
    	printf("IPC test passed!\n");
    }
}



