/*
 * ipc_interrupt.h
 *
 *  Created on: Dec 1, 2011
 *      Author: x0144789
 */

#ifndef IPC_INTERRUPT_H_
#define IPC_INTERRUPT_H_

#define MAX_CORE_NUM                  (8)
#define MAX_SYSTEM_VECTOR             (8)
#define MAX_CORE_VECTOR               (12)

/************************ USER DEFINES ********************/
#define CORENUM                         8
#define IPCGR0  						(0x02620240u)
#define IPCGR1							(0x02620244u)
#define IPCGR2  						(0x02620248u)
#define IPCGR3  						(0x0262024Cu)
#define IPCGR4  						(0x02620250u)
#define IPCGR5							(0x02620254u)
#define IPCGR6  						(0x02620258u)
#define IPCGR7  						(0x0262025Cu)
#define IPCAR0  						(0x02620280u)
#define IPCAR1  						(0x02620284u)
#define IPCAR2  						(0x02620288u)
#define IPCAR3  						(0x0262028Cu)
#define IPCAR4  						(0x02620290u)
#define IPCAR5  						(0x02620294u)
#define IPCAR6  						(0x02620298u)
#define IPCAR7  						(0x0262029Cu)

#define INTC_EVENTID_IPC_LOCAL          (91)



typedef struct
{
	uint32_t core;        // CoreID
	uint32_t event;       // INTC event
	CSL_IntcVectId vect;  // Core interrupt vector
	CSL_IntcEventHandler isr;
}interruptCfg;

int32_t intcInit();
int32_t registerInterrupt();
void IssueInterruptToNextCore();
void IPC_ISR();

#endif /* IPC_INTERRUPT_H_ */
