/*********************************************************************
 *          (C) COPYRIGHT TEXAS INSTRUMENTS, INC. 2000
 * flash.h -- Flash Memory handler info & prototypes.
 */

/* Change Log:
 */
/*
 *$Log: /boards/dsk5509a/flashburn/FBTC55/flash.h $
 * 
 * 1     11/10/05 12:58p Shilpab
 *Revision 1.1  2001/02/14 17:13:52  heeschen
 *v00.11 Beta
 *Capturing this new FBTC55 module. Successfully
 *reads/writes flash memory. Untested for bootability
 *of written program.
 *
 */

#ifndef _FLASH_H_
#define _FLASH_H_

#include "type.h"

#define OK          0
#define ERROR       -1

#define	FLASH_BASE_ADDR		0x200000ul	//linear base word address

#define FLSIZEBYTES         0x00020000UL
#define	FLEND		        (FLASH_BASE_ADDR + FLSIZEBYTES)

/* Reset the flash chip(s) to read state
 */
void flash_reset();


/* Erases entire flash memory.
 */
void chip_erase(void);

/*  Writes a block of data into flash memory. The flash is
 *	addressed with a linear address scheme that addresses the words of the
 *	flash memory as an offset from the start of the flash chip. In other
 *	words, a dest of 0 will result in a write to sector 0, page 0, address
 *	as viewed by the CPU, will be 0x8000.
 *
 *  source is an array of words to be written.
 *	dest is flash destination address
 *	length is in words.
 *
 *  Returns OK or ERROR
 */
int flash_write(u16 *source, u16 *dest, u16 length);


#endif

