/*H***************************************************************************
*
* $Archive:: /boards/dsk5509a/include/dsk5509.h                               $
* $Revision:: 2                                                               $
* $Date:: 11/11/05 11:55a                                                     $
* $Author:: Vss6admin                                                         $
*
* DESCRIPTION: This files contains DSK5509 board specific I/O registers
*              define for the CPLD.
*
* 
* NOTES :  BSL Version# 3.00 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#ifndef DSK5509_
#define DSK5509_

#ifdef __cplusplus
extern "C" {
#endif

#include <csl.h>

/*
 *  Note:  Bit definitions for each register field
 *         needs to be supplied here for the CPLD
 *         and other board periperals.
 */

/* CPLD address definitions */
#define DSK5509_CPLD_BASE    0x3F0000

/* CPLD Register Indices */
#define DSK5509_USER_REG     0
#define DSK5509_DC_REG       1
#define DSK5509_VERSION      4
#define DSK5509_MISC         6
#define DSK5509_NISTAT		 8

/* CPLD Register Bits */
#define DC_DET               0x80
#define DC_STAT1             0x20
#define DC_STAT0             0x10
#define DC_CNTL1             0x02
#define DC_CNTL0             0x01

/* MISC Register Bits */
#define MISC_RSV0            0x01
#define MISC_RSV1            0x02
#define MISC_TIM_INOUT_SEL   0x04
#define MISC_NITRIG          0x08
#define MISC_CORE_VCNTL_SEL  0x10
#define MISC_NITEST          0x20
#define MISC_CORE_VCNTL0     0x40
#define MISC_CORE_VCNTL1     0x80

/* NI Specific BPLD register bits */
#define NISTAT_FREQ_MASK     0x1F	// 5Bits of freq code
#define NISTAT_VALID         0x20	// 1-Freq Valid
#define NISTAT_POWERON       0x40	// NI logic is powered
#define NISTAT_NIOE		  	 0x80	// Signals to NI active (!Hiz)

/* Initialize all board APIs */
void DSK5509_init();

/* Read a 8-bit value from a CPLD register */
Uint16 DSK5509_rget(Int16 regnum);

/* Write a 8-bit value to a CPLD register */
void DSK5509_rset(Int16 regnum, Uint16 regval);

/* Read a 16-bit value from a 23-bit memory address */
Uint16 DSK5509_mget(Uint32 memaddr);

/* Write a 16-bit value to a 23-bit memory address */
void DSK5509_mset(Uint32 memaddr, Uint16 memval);

/* Spin in a delay loop for delay iterations */
void DSK5509_wait(Uint32 delay);

/* Spin in a delay loop for delay microseconds */
void DSK5509_waitusec(Uint32 delay);

#ifdef __cplusplus
}
#endif

#endif
