/*
 *  Copyright 2004 by Spectrum Digital Incorporated.
 *  All rights reserved. Property of Spectrum Digital Incorporated.
 */
 
/*
 *  ======== dsk5509_flash.h ========
 *
 *  Interface for the AMD29LV400BT Flash on the DSK5509 board
 */
#ifndef DSK5509_FLASH_
#define DSK5509_FLASH_

#ifdef __cplusplus
extern "C" {
#endif

#include <csl.h>

/* Flash address definitions */
#define DSK5509_FLASH_BASE          ((Uint32)0x200000)
#define DSK5509_FLASH_PAGESIZE      ((Uint32)0x008000)
#define DSK5509_FLASH_PAGES         ((Uint32)0x8)
#define DSK5509_FLASH_SIZE          ((Uint32)0x040000)
#define DSK5509_FLASH_CTL555        ((Uint32)(DSK5509_FLASH_BASE + 0x555))
#define DSK5509_FLASH_CTL2AA        ((Uint32)(DSK5509_FLASH_BASE + 0x2aa))
#define DSK5509_FLASH_SUPPORT       1
 
/* Calculate the checksum of a data range in Flash */
Uint32 DSK5509_FLASH_checksum(Uint32 start, Uint32 length);

/* Erase a segment of Flash memory */
void DSK5509_FLASH_erase(Uint32 start, Uint32 length);

/* Read data from a range in Flash */
void DSK5509_FLASH_read(Uint32 src, Uint32 dst, Uint32 length);

/* Write data to a data range in Flash */
void DSK5509_FLASH_write(Uint32 src, Uint32 dst, Uint32 length);

#ifdef __cplusplus
}
#endif

#endif

