/*H***************************************************************************
*
* $Archive:: /boards/dsk5509a/include/dsk5509_led.h                           $
* $Revision:: 1                                                               $
* $Date:: 11/10/05 11:38a                                                     $
* $Author:: Shilpab                                                           $
*
* DESCRIPTION:  Interface for LEDs on the DSK5509 board
* 
* NOTES : 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#ifndef DSK5509_LED_
#define DSK5509_LED_

#ifdef __cplusplus
extern "C" {
#endif

#include <csl.h>

/* Initialize the LEDs */
void DSK5509_LED_init();

/* Turn the LED numbered ledNum off */
void DSK5509_LED_off(Uint32 ledNum);

/* Turn the LED numbered ledNum on */
void DSK5509_LED_on(Uint32 ledNum);

/* Toggle the LED numbered ledNum */
void DSK5509_LED_toggle(Uint32 ledNum);

#ifdef __cplusplus
}
#endif

#endif

