/*H***************************************************************************
*
* $Archive:: /boards/dsk5509a/include/dsk5509_srom.h                          $
* $Revision:: 1                                                               $
* $Date:: 11/10/05 11:38a                                                     $
* $Author:: Shilpab                                                           $
*
* DESCRIPTION:  Interface for the AT25F512 serial Flash on the 5509 DSK board
* 
* NOTES : 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/


#ifndef DSK5509_SROM_
#define DSK5509_SROM_

#ifdef __cplusplus
extern "C" {
#endif

#include <csl.h>

/* SROM definitions */
#define DSK5509_SROM_SIZE           0x010000
#define DSK5509_SROM_BASE           0x000000
#define DSK5509_SROM_PAGESIZE       0x001000
#define DSK5509_SROM_PAGES          0x4
#define DSK5509_SROM_BLOCKSIZE      64
#define DSK5509_SROM_BLOCKMASK      0xffffff00

#define DSK5509_SROM_WREN           0x06
#define DSK5509_SROM_WRDI           0x04
#define DSK5509_SROM_RDSR           0x05
#define DSK5509_SROM_WRSR           0x01
#define DSK5509_SROM_READ           0x03
#define DSK5509_SROM_PROGRAM        0x02

/* Read data from a range in Flash */
extern void DSK5509_SROM_read(Uint32 src, Uint32 dst, Uint32 length);

/* Write data to a data range in Flash */
extern void DSK5509_SROM_write(Uint32 src, Uint32 dst, Uint32 length);

/* Erase a block of the SROM */
extern void DSK5509_SROM_erase(Uint32 start, Uint32 length);

#ifdef __cplusplus
}
#endif

#endif

