/*H***************************************************************************
*
* $Archive:: /boards/dsk5509a/lib/dsk5509bsl/dsk5509.c                        $
* $Revision:: 2                                                               $
* $Date:: 11/11/05 11:59a                                                     $
* $Author:: Vss6admin                                                         $
*
* DESCRIPTION: Board setup initializion implementation 
*
* 
* NOTES : 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#include <csl.h>
#include <csl_emif.h>
#include <csl_i2c.h>
#include <csl_pll.h>

#include <dsk5509.h>

EMIF_Config emifCfg0 = {
    EMIF_EGCR_RMK(  1, //EMIF_EGCR_MEMFREQ_2X,
                    EMIF_EGCR_WPE_OFF,
                    EMIF_EGCR_MEMCEN_ON,
                    EMIF_EGCR_NOHOLD_NOHOLD ),
    EMIF_EMIRST_RMK( EMIF_EMIRST_EMIRST_0F( 0xFFFF ) ),
    /* CE0_1, CE0_2, & CE0_3 */
    EMIF_CEx1_RMK(  EMIF_CEx1_MTYPE_SDRAM32,
                    EMIF_CEx1_RDSETUP_OF( 15 ),
                    EMIF_CEx1_RDSTROBE_OF( 63 ),
                    EMIF_CEx1_RDHOLD_OF( 3 ) ),
    EMIF_CEx2_RMK(  EMIF_CEx2_RDEXHLD_OF( 1 ),
                    EMIF_CEx2_WREXHLD_OF( 1 ),
                    EMIF_CEx2_WRSETUP_OF( 15 ),
                    EMIF_CEx2_WRSTROBE_OF( 63 ),
                    EMIF_CEx2_WRHOLD_OF( 3 ) ),
    EMIF_CEx3_RMK(  EMIF_CEx3_TIMOUT_OF( 0 ) ),
    /* CE1_1, CE1_2, & CE1_3 */
    EMIF_CEx1_RMK(  EMIF_CEx1_MTYPE_ASYNC16,
                    EMIF_CEx1_RDSETUP_OF( 0 ),
                    EMIF_CEx1_RDSTROBE_OF( 14 ),
                    EMIF_CEx1_RDHOLD_OF( 0 ) ),
    EMIF_CEx2_RMK(  EMIF_CEx2_RDEXHLD_OF( 0 ),
                    EMIF_CEx2_WREXHLD_OF( 0 ),
                    EMIF_CEx2_WRSETUP_OF( 0 ),
                    EMIF_CEx2_WRSTROBE_OF( 14 ),
                    EMIF_CEx2_WRHOLD_OF( 0 ) ),
    EMIF_CEx3_RMK(  EMIF_CEx3_TIMOUT_OF( 0 ) ),
    /* CE2_1, CE2_2, & CE2_3 */
    EMIF_CEx1_RMK(  EMIF_CEx1_MTYPE_ASYNC16,
                    EMIF_CEx1_RDSETUP_OF( 0 ),
                    EMIF_CEx1_RDSTROBE_OF( 20 ),
                    EMIF_CEx1_RDHOLD_OF( 0 ) ),
    EMIF_CEx2_RMK(  EMIF_CEx2_RDEXHLD_OF( 0 ),
                    EMIF_CEx2_WREXHLD_OF( 0 ),
                    EMIF_CEx2_WRSETUP_OF( 0 ),
                    EMIF_CEx2_WRSTROBE_OF( 20 ),
                    EMIF_CEx2_WRHOLD_OF( 0 ) ),
    EMIF_CEx3_RMK(  EMIF_CEx3_TIMOUT_OF( 0 ) ),
    /* CE3_1, CE3_2, & CE3_3 */
    EMIF_CEx1_RMK(  EMIF_CEx1_MTYPE_ASYNC16,
                    EMIF_CEx1_RDSETUP_OF( 0 ),
                    EMIF_CEx1_RDSTROBE_OF( 20 ),
                    EMIF_CEx1_RDHOLD_OF( 0 ) ),
    EMIF_CEx2_RMK(  EMIF_CEx2_RDEXHLD_OF( 0 ),
                    EMIF_CEx2_WREXHLD_OF( 0 ),
                    EMIF_CEx2_WRSETUP_OF( 0 ),
                    EMIF_CEx2_WRSTROBE_OF( 20 ),
                    EMIF_CEx2_WRHOLD_OF( 0 ) ),
    EMIF_CEx3_RMK(  EMIF_CEx3_TIMOUT_OF( 0 ) ),
    /* SDRAM: SDC1, SDPER, INIT, & SDC2 */
    EMIF_SDC1_MK(   EMIF_SDC1_TRC_OF( 5 ),
                    EMIF_SDC1_SDSIZE_16M,
                    EMIF_SDC1_SDWID_OFF,
                    EMIF_SDC1_RFEN_ENABLE,
                    EMIF_SDC1_TRCD_OF( 1 ),
                    EMIF_SDC1_TRP_OF( 1 ) ),
    EMIF_SDPER_RMK( EMIF_SDPER_PERIOD_OF( 0x578 ) ),
    EMIF_INIT_RMK(  EMIF_SDINIT_INIT_OF( 0xFFFF ) ),
    EMIF_SDC2_RMK(  EMIF_SDC2_SDACC_16BITBUS,
                    EMIF_SDC2_TMRD_OF( 1 ),
                    EMIF_SDC2_TRAS_OF( 3 ),
                    EMIF_SDC2_TACTV2ACTV_OF( 5 ) )
};

/* Initialize the board APIs */
void DSK5509_init()
{

	ioport volatile Uint16 * pClkDiv = (ioport volatile Uint16 *)0x07FD;
    Uint16 value;

    I2C_Setup i2cSetup = {
        0,              /* 7 bit address mode */
        0x007F,         /* own address - dont care if master */
        75,             /* clkout value (Mhz) */
        400,            /* a number between 10 and 400 */
        0,              /* num of bits/bytes to be received/transmitted (8) */
        0,              /* DLB mode off */
        0               /* FREE mode of operation off */
    };

    /* Initialize CSL */
    CSL_init();

    /* Configure EMIF */
    EMIF_config(&emifCfg0);

	// Set clockout to div 4 mode
	value = *pClkDiv;
	value &= 0xFFF0;
	value += 2;
	*pClkDiv = value;

    /* Set CPLD registers to default values */
    DSK5509_rset(DSK5509_USER_REG, 0);
    DSK5509_rset(DSK5509_DC_REG,   0);
    DSK5509_rset(DSK5509_MISC,     0);

    /* Initialize I2C interface */
    I2C_setup(&i2cSetup);
}

/* Read a 16-bit value from a CPLD register */
Uint16 DSK5509_rget(Int16 regnum)
{
    return DSK5509_mget(DSK5509_CPLD_BASE + regnum);
}

/* Write a 16-bit value to a CPLD register */
void DSK5509_rset(Int16 regnum, Uint16 regval)
{
    DSK5509_mset(DSK5509_CPLD_BASE + regnum, regval);
}

/* Spin in a delay loop for delay iterations */
void DSK5509_wait(Uint32 delay)
{
    volatile Uint32 i, n;

    n = 0;
    for (i = 0; i < delay; i++)
    {
        n = n + 1;
    }
}

/* Spin in a delay loop for delay microseconds */
void DSK5509_waitusec(Uint32 delay)
{
    DSK5509_wait(delay * 13);
}
