/*H***************************************************************************
*
* $Archive:: /boards/dsk5509a/lib/dsk5509_aic23_closecodec.c                  $
* $Revision:: 1                                                               $
* $Date:: 11/10/05 11:38a                                                     $
* $Author:: Shilpab                                                           $
*
* DESCRIPTION:DSK5509_AIC23_closeCodec() implementation
*
* 
* NOTES : 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#include <dsk5509.h>
#include <dsk5509_aic23.h>

/*
 *  ======== DSK5509_AIC23_closeCodec ========
 *  Close the codec
 */
void DSK5509_AIC23_closeCodec(DSK5509_AIC23_CodecHandle hCodec)
{
    /* Disable codec data path */
    DSK5509_rset(DSK5509_MISC, DSK5509_rget(DSK5509_MISC) & 0xfe);

    /* Put codec in slave mode to stop driving outputs */
    DSK5509_AIC23_rset(hCodec, DSK5509_AIC23_DIGIF, DSK5509_AIC23_rget(hCodec, DSK5509_AIC23_DIGIF) & 0xbf);

    /* Turn the codec off */
    DSK5509_AIC23_rset(hCodec, DSK5509_AIC23_POWERDOWN, 0xff);

    /* Close data channel */
    MCBSP_close(DSK5509_AIC23_DATAHANDLE);
}
