/*H***************************************************************************
*
* $Archive:: /boards/dsk5509a/lib/dsk5509_aic23_loopback.c                    $
* $Revision:: 1                                                               $
* $Date:: 11/10/05 11:38a                                                     $
* $Author:: Shilpab                                                           $
*
* DESCRIPTION:dsk5509_aic23_loopback() implementation
*
* 
* NOTES : 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#include <dsk5509.h>
#include <dsk5509_aic23.h>

/*
 *  ======== DSK5509_AIC23_loopback ========
 *  Enable/disable codec loopback mode
 */
void DSK5509_AIC23_loopback(DSK5509_AIC23_CodecHandle hCodec, Int16 mode)
{
    int regval;

    /* Set bypass bit if mode is true */
    regval = (mode != 0) ? 0x8 : 0x0;

    /* Write to codec register */
    DSK5509_AIC23_rset(hCodec, DSK5509_AIC23_ANAPATH,
        (DSK5509_AIC23_rget(hCodec, DSK5509_AIC23_ANAPATH) & 0xfff7 | regval));
}
