/*H***************************************************************************
*
* $Archive:: /boards/dsk5509a/lib/dsk5509_aic23_mute.c                        $
* $Revision:: 1                                                               $
* $Date:: 11/10/05 11:38a                                                     $
* $Author:: Shilpab                                                           $
*
* DESCRIPTION:dsk5509_aic23_mute() implementation
*
* 
* NOTES : 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#include <dsk5509.h>
#include <dsk5509_aic23.h>

/*
 *  ======== DSK5509_AIC23_mute ========
 *  Enable/disable codec mute mode
 */
void DSK5509_AIC23_mute(DSK5509_AIC23_CodecHandle hCodec, Int16 mode)
{
    int regval;

    /* Enable mute if mode is true */
    regval = (mode != 0) ? 0x08 : 0x00;

    /* Write to codec registers (left and right) */
    DSK5509_AIC23_rset(hCodec, DSK5509_AIC23_DIGPATH,
        (DSK5509_AIC23_rget(hCodec, DSK5509_AIC23_DIGPATH) & 0xfff7) | regval);
}
