/*H***************************************************************************
*
* $Archive:: /boards/dsk5509a/lib/dsk5509bsl/dsk5509_aic23_opencodec.c        $
* $Revision:: 2                                                               $
* $Date:: 11/11/05 11:59a                                                     $
* $Author:: Vss6admin                                                         $
*
* DESCRIPTION:
*
* 
* NOTES : 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

/*
 *  ======== dsk5509_aic23_openCodec.c ========
 *  DSK5509_AIC23_openCodec() implementation
 */

#include <csl.h>
#include <csl_mcbsp.h>
#include <csl_i2c.h>

#include <dsk5509.h>
#include <dsk5509_aic23.h>

/* AIC23 McBSP handles */
MCBSP_Handle DSK5509_AIC23_DATAHANDLE;

/*
 *  ======== DSK5509_AIC23_openCodec ========
 *  Open the codec and return a codec handle
 */
DSK5509_AIC23_CodecHandle DSK5509_AIC23_openCodec(int id, DSK5509_AIC23_Config *Config)
{
    MCBSP_Config mcbspCfgData = {
        0x0000,  /*  Serial Port Control Register 1   */
        0x0000,  /*  Serial Port Control Register 2   */
        0x0140,  /*  Receive Control Register 1   */
        0x0000,  /*  Receive Control Register 2   */
        0x0140,  /*  Transmit Control Register 1   */
        0x0000,  /*  Transmit Control Register 2   */
        0x0000,  /*  Sample Rate Generator Register 1   */
        0x0000,  /*  Sample Rate Generator Register 2   */
        0x0000,  /*  Multichannel Control Register 1   */
        0x0000,  /*  Multichannel Control Register 2   */
        0x0003,  /*  Pin Control Register   */
        0x0000,  /*  Receive Channel Enable Register Partition A   */
        0x0000,  /*  Receive Channel Enable Register Partition B   */
        0x0000,  /*  Receive Channel Enable Register Partition C   */
        0x0000,  /*  Receive Channel Enable Register Partition D   */
        0x0000,  /*  Receive Channel Enable Register Partition E   */
        0x0000,  /*  Receive Channel Enable Register Partition F   */
        0x0000,  /*  Receive Channel Enable Register Partition G   */
        0x0000,  /*  Receive Channel Enable Register Partition H   */
        0x0000,  /*  Transmit Channel Enable Register Partition A   */
        0x0000,  /*  Transmit Channel Enable Register Partition B   */
        0x0000,  /*  Transmit Channel Enable Register Partition C   */
        0x0000,  /*  Transmit Channel Enable Register Partition D   */
        0x0000,  /*  Transmit Channel Enable Register Partition E   */
        0x0000,  /*  Transmit Channel Enable Register Partition F   */
        0x0000,  /*  Transmit Channel Enable Register Partition G   */
        0x0000   /*  Transmit Channel Enable Register Partition H   */
    };

    /* Enable codec data path on board */
    DSK5509_rset(DSK5509_MISC, DSK5509_rget(DSK5509_MISC) | 1);

    /* Reset the AIC23 */
    DSK5509_AIC23_rset(0, DSK5509_AIC23_RESET, 0);

    /* Configure the rest of the AIC23 registers */
    DSK5509_AIC23_config(0, Config);

    /* Open codec data handle */
    DSK5509_AIC23_DATAHANDLE = MCBSP_open(MCBSP_PORT0, MCBSP_OPEN_RESET);
    if (DSK5509_AIC23_DATAHANDLE == INV)
        return (DSK5509_AIC23_CodecHandle)0;

    /* Configure codec data McBSP */
    MCBSP_config(DSK5509_AIC23_DATAHANDLE, &mcbspCfgData);

    /* Clear any garbage from the codec data port */
    if (MCBSP_rrdy(DSK5509_AIC23_DATAHANDLE))
        MCBSP_read16(DSK5509_AIC23_DATAHANDLE);

    /* Start McBSP1 as the codec data channel */
    MCBSP_start(DSK5509_AIC23_DATAHANDLE, MCBSP_XMIT_START | MCBSP_RCV_START |
    MCBSP_SRGR_START | MCBSP_SRGR_FRAMESYNC, 1000);

    return (0);
}
