/*H***************************************************************************
*
* $Archive:: /boards/dsk5509a/lib/dsk5509_aic23_outgain.c                     $
* $Revision:: 1                                                               $
* $Date:: 11/10/05 11:38a                                                     $
* $Author:: Shilpab                                                           $
*
* DESCRIPTION:
*
* 
* NOTES : 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

/*
 *  ======== dsk5509_aic23_setfreq.c ========
 *  DSK5509_AIC23_setFreq() implementation
 */

#include <dsk5509.h>
#include <dsk5509_aic23.h>

/*
 *  ======== DSK5509_AIC23_outGain ========
 *  Set the output gain on the codec
 */
void DSK5509_AIC23_outGain(DSK5509_AIC23_CodecHandle hCodec, Uint16 outGain)
{
    /* Write to codec registers (left and right) */
    DSK5509_AIC23_rset(hCodec, DSK5509_AIC23_LEFTHPVOL,
        (DSK5509_AIC23_rget(hCodec, DSK5509_AIC23_LEFTHPVOL) & 0xff80) | (outGain & 0x7f));
    DSK5509_AIC23_rset(hCodec, DSK5509_AIC23_RIGHTHPVOL,
        (DSK5509_AIC23_rget(hCodec, DSK5509_AIC23_RIGHTHPVOL) & 0xff80) | (outGain & 0x7f));
}

