/*H***************************************************************************
*
* $Archive:: /boards/dsk5509a/lib/dsk5509_aic23_powerdown.c                   $
* $Revision:: 1                                                               $
* $Date:: 11/10/05 11:38a                                                     $
* $Author:: Shilpab                                                           $
*
* DESCRIPTION:
*
* 
* NOTES : 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

/*
 *  ======== dsk5509_aic23_powerDown.c ========
 *  DSK5509_AIC23_powerDown() implementation
 */

#include <dsk5509.h>
#include <dsk5509_aic23.h>

/*
 *  ======== DSK5509_AIC23_powerDown ========
 *  Enable/disable powerdown modes for the DAC and ADC codec subsections
 */
void DSK5509_AIC23_powerDown(DSK5509_AIC23_CodecHandle hCodec, Uint16 sect)
{
    /* Write to codec register */
    DSK5509_AIC23_rset(hCodec, DSK5509_AIC23_POWERDOWN,
        (DSK5509_AIC23_rget(hCodec, DSK5509_AIC23_POWERDOWN) & 0xff00) | (sect & 0xff));
}
