/*H***************************************************************************
*
* $Archive:: /boards/dsk5509a/lib/dsk5509_aic23_registers.c                   $
* $Revision:: 1                                                               $
* $Date:: 11/10/05 11:38a                                                     $
* $Author:: Shilpab                                                           $
*
* DESCRIPTION:
*
* 
* NOTES : 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

/*
 *  ======== dsk5509_aic23_registers.c ========
 *  DSK5509_AIC23_rset() and DSK5509_AIC23_rget() implementation
 */

#include <csl.h>
#include <csl_i2c.h>

#include <dsk5509.h>
#include <dsk5509_aic23.h>

/* Internal codec state used to simulate read/write functionality */
static DSK5509_AIC23_Config codecstate = DSK5509_AIC23_DEFAULTCONFIG;

/*
 *  ======== DSK5509_AIC23_rset ========
 *  Set codec register regnum to value regval
 */

void DSK5509_AIC23_rset(DSK5509_AIC23_CodecHandle hCodec, Uint16 regnum, Uint16 regval)
{
    Uint16 buf[2];

    buf[0] = (Uint16)((regnum<<1)+(regval>>8));
    buf[1] = (Uint16)(regval & 0x00FF);

    I2C_write(buf, 2, 1, DSK5509_AIC23_I2CADDR, 1, 100);
}


/*
 *  ======== DSK5509_AIC23_rget ========
 *  Return value of codec register regnum
 */
Uint16 DSK5509_AIC23_rget(DSK5509_AIC23_CodecHandle hCodec, Uint16 regnum)
{
    if (regnum < DSK5509_AIC23_NUMREGS)
        return codecstate.regs[regnum];
    else
        return 0;
}

/*
 *  ======== DSK5509_AIC23_config ========
 *  Set the default codec register config values
 */
void DSK5509_AIC23_config(DSK5509_AIC23_CodecHandle hCodec, DSK5509_AIC23_Config *Config)
{
    int i;

    /* Use default parameters if none are given */
    if (Config == NULL)
        Config = &codecstate;

    /* Configure power down register first */
    DSK5509_AIC23_rset(hCodec, DSK5509_AIC23_POWERDOWN,
        Config -> regs[DSK5509_AIC23_POWERDOWN]);

    /* Assign each register */
    for (i = 0; i < DSK5509_AIC23_NUMREGS; i++)
        if (i != DSK5509_AIC23_POWERDOWN)
            DSK5509_AIC23_rset(hCodec, i, Config -> regs[i]);
}
