/*H***************************************************************************
*
* $Archive:: /boards/dsk5509a/lib/dsk5509_aic23_write16.c                     $
* $Revision:: 1                                                               $
* $Date:: 11/10/05 11:38a                                                     $
* $Author:: Shilpab                                                           $
*
* DESCRIPTION:
*
* 
* NOTES : 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

/*
 *  ======== dsk5509_aic23_write16.c ========
 *  dsk5509_aic23_write16() implementation
 */

#include <dsk5509.h>
#include <dsk5509_aic23.h>


/*
 *  ======== DSK5509_AIC23_write16 ========
 *  Write a 16-bit value to the codec
 */
Int16 DSK5509_AIC23_write16(DSK5509_AIC23_CodecHandle hCodec, Int16 val)
{
    /* If McBSP not ready for new data, return 0 */
    if (!MCBSP_xrdy(DSK5509_AIC23_DATAHANDLE)) {
        return (0);
    }

    /* Write 16 bit data value to DXR */
    MCBSP_write16(DSK5509_AIC23_DATAHANDLE, val);

    DSK5509_waitusec(1);

    return(1);
}
