/*H***************************************************************************
*
* $Archive:: /boards/dsk5509a/lib/dsk5509_aic23_write32.c                     $
* $Revision:: 1                                                               $
* $Date:: 11/10/05 11:38a                                                     $
* $Author:: Shilpab                                                           $
*
* DESCRIPTION:
*
* 
* NOTES : 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

/*
 *  ======== dsk5509_aic23_write32.c ========
 *  dsk5509_aic23_write32() implementation
 */

#include <dsk5509.h>
#include <dsk5509_aic23.h>

/*
 *  ======== DSK5509_AIC23_write32 ========
 *  Write a 32-bit value to the codec
 */
Int16 DSK5509_AIC23_write32(DSK5509_AIC23_CodecHandle hCodec, Int32 val)
{
    /* If McBSP doesn't have new data available, return 0 */
    if(!MCBSP_xrdy(DSK5509_AIC23_DATAHANDLE)) {
        return (0);
    }

    /* Write 32 bit data value to DXR, shift to match format mode */
    MCBSP_write32(DSK5509_AIC23_DATAHANDLE, val);

    return (1);
}
