/*H***************************************************************************
*
* $Archive:: /boards/dsk5509a/lib/dsk5509_dip.c                               $
* $Revision:: 1                                                               $
* $Date:: 11/10/05 11:38a                                                     $
* $Author:: Shilpab                                                           $
*
* DESCRIPTION:
*
* 
* NOTES : 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

/*
 *  ======== dsk5509_dip.c ========
 *  DIP switch implementation
 */

#include <csl.h>

#include <dsk5509.h>
#include <dsk5509_dip.h>

void DSK5509_DIP_init()
{
}

Uint32 DSK5509_DIP_get(Uint32 dipNum)
{
    /* Check bounds for dipNum */
    if (dipNum >= 4)
        return (Uint32)-1;

    /* Read DIP switch */
    if ((DSK5509_rget(DSK5509_USER_REG) & (0x10 << dipNum)) == 0)
        return 0;
    else
        return 1;
}

