/*H***************************************************************************
*
* $Archive:: /boards/dsk5509a/lib/dsk5509_flash_checksum.c                    $
* $Revision:: 1                                                               $
* $Date:: 11/10/05 11:38a                                                     $
* $Author:: Shilpab                                                           $
*
* DESCRIPTION:
*
* 
* NOTES : 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

/*
 *  ======== dsk5509_flash_checksum.c ========
 *  DSK5509_FLASH_checksum() implementation
 */

#include <std.h>
#include <csl.h>

#include <dsk5509.h>
#include <dsk5509_flash.h>

/* Calculate the checksum of a data range in Flash */
Uint32 DSK5509_FLASH_checksum(Uint32 start, Uint32 length)
{
    Uint32 i, checksum;

    /* Calculate checksum by adding each word to the total */
    checksum = 0;
    for (i = 0; i < length; i++)
    {
        checksum += DSK5509_mget(start++);
    }

    return checksum;
}
