/*H***************************************************************************
*
* $Archive:: /boards/dsk5509a/lib/dsk5509_flash_write.c                       $
* $Revision:: 1                                                               $
* $Date:: 11/10/05 11:38a                                                     $
* $Author:: Shilpab                                                           $
*
* DESCRIPTION:
*
* 
* NOTES : 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

/*
 *  ======== dsk5509_flash_write.c ========
 *  DSK5509_FLASH_write() implementation
 */

#include <std.h>
#include <csl.h>

#include <dsk5509.h>
#include <dsk5509_flash.h>

/* Write data to a data range in Flash */
void DSK5509_FLASH_write(Uint32 src, Uint32 dst, Uint32 length)
{
    Uint32 i, tmpval;

    /* Establish source and destination */
    for (i = 0; i < length; i++)
    {
        // Program one 16-bit word
        DSK5509_mset(DSK5509_FLASH_CTL555, 0xaa);
        DSK5509_mset(DSK5509_FLASH_CTL2AA, 0x55);
        DSK5509_mset(DSK5509_FLASH_CTL555, 0xa0);
        tmpval = DSK5509_mget(src);
        DSK5509_mset(dst, tmpval);

        // Wait for operation to complete
        while(1)
        {
            tmpval = DSK5509_mget(src);
            if (DSK5509_mget(dst) == tmpval)
                break;
        }

        src++;
        dst++;
    }

    /* Put back in read mode */
    DSK5509_mset(DSK5509_FLASH_BASE, 0xf0);
}



