/*H***************************************************************************
*
* $Archive:: /boards/dsk5509a/lib/dsk5509_led.c                               $
* $Revision:: 1                                                               $
* $Date:: 11/10/05 11:38a                                                     $
* $Author:: Shilpab                                                           $
*
* DESCRIPTION:
*
* 
* NOTES : 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

/*
 *  ======== dsk5509_led.c ========
 *  LED implementation
 */

#include <csl.h>

#include "dsk5509.h"
#include "dsk5509_led.h"

static Int16 ledstate;

void DSK5509_LED_init()
{
    /* Turn all LEDs off */
    ledstate = 0;
    DSK5509_rset(DSK5509_USER_REG, ledstate);
}

void DSK5509_LED_off(Uint32 ledNum)
{
    /* Check bounds for ledNum */
    if (ledNum >= 4)
        return;

    /* Clear the LED bit */
    ledstate &= ~(1 << ledNum);
    DSK5509_rset(DSK5509_USER_REG, ledstate);
}

void DSK5509_LED_on(Uint32 ledNum)
{
    /* Check bounds for ledNum */
    if (ledNum >= 4)
        return;

    /* Set the LED bit */
    ledstate |= 1 << ledNum;
    DSK5509_rset(DSK5509_USER_REG, ledstate);
}

void DSK5509_LED_toggle(Uint32 ledNum)
{
    /* Check bounds for ledNum */
    if (ledNum >= 4)
        return;

    /* Toggle the LED bit */
    if ((DSK5509_rget(DSK5509_USER_REG) & (1 << ledNum)) == 0)
        DSK5509_LED_on(ledNum);
    else
        DSK5509_LED_off(ledNum);
}


