#ifndef _SERIALBURN_H_
#define _SERIALBURN_H_

#define EMIF_CE_BASE_ADDR    0xA0000000
#define UART_RBR_OFFSET        0x00
#define UART_THR_OFFSET        0x04
#define UART_CR_OFFSET          0x08
#define UART_LCR_OFFSET         0x0C
#define UART_BAUDCR_OFFSET   0x10
#define UART_SR_OFFSET           0x14

#define DISABLE_CR_VALUE     0x03
#define ENABLE_CR_VALUE      0x04
#define LCR_VALUE                  0x00 // 8,1,N
#define BAUDCR_VALUE           0x07 // 115200

#define FLASH_BASE_ADDR    0xB0000000
#define IMAGE_FLASH_SIZE    0x400000

#define SOH                  0x01
#define EOT                  0x04
#define ACK                  0x06
#define NAK                  0x15
#define CAN                  0x18
#define STX                   0x02
#define CTRL_Z              0x1A
#define BGN                   0x43
#define NEXT                 0x6E

#define WRITE_FAILED     0x0
#define END_SIGN            0x1
#define WRITE_SUCCESS  0x2
#define READ_SUCCESS    0x3

#define FRAME_BUFFER_SIZE 128

typedef struct{
	Uint8    Xs;
	Uint8    x1;
	Uint8    x2;
	Uint8    buffer[FRAME_BUFFER_SIZE];
	Uint32   crc;
}FrameBUFF;

void OEMDebugInit(void);
Int32 OEMReadDebugByte(void);
Uint8 OEMReadByte(void);
void OEMWriteByte(Uint8 data);
void OEMOutputDebugString (char * string);
Uint32 ReadSectorInfo( Uint32 *pStartAdd, Uint32 *pLength);
Bool isValidFlashAddr(Uint32 iAddr);
Uint32 RcvWriteSector();
void DownloadImage(void);
void WaitForDownload();	
void IsDownLoadImage();

#endif /* _SERIALBURN_H_*/
