
#ifndef _WND_MGR_H_
#define _WND_MGR_H_

#include "typeDefs.h"


typedef int (*PWNDRT)(uint, uint);

typedef struct _uintx { uint x_l; uint x_h; } uintx;

typedef PVOID HWND;
typedef PVOID HDAT;
typedef PVOID HFCS;
/////////////////////////////////////
#define MSG_FLG ((uint)(1<<31))

#define EVENT_HWI 0x01
#define EVENT_TCH 0x02
#define EVENT_KEY 0x04
#define EVENT_PRD 0x08
#define EVENT_USER	0x20

#define _evtType(info) ((info>>16)&0xFF)
#define _pointX(info) ((uchar)(info&0xFF))
#define _pointY(info) ((uchar)((info>>8)&0xFF))
#define _keyVal(info) (info&0xFF)

#define KEY_FY 0x01
#define KEY_FN 0x02
#define KEY_FL 0x03
#define KEY_FR 0x04
#define KEY_FU 0x05
#define KEY_FD 0x06

#define KEY_FT 0x07
/////////////////////////////////////
#define WDAT_TYPE_STRING 0x0001
#define WDAT_TYPE_INTEGER 0x0002
#define WDAT_TYPE_BITMAP 0x0004
#define WDAT_TYPE_USER 0x8000
/////////////////////////////////////
// Color Table
#define _Tbl(uColor) uColor
/////////////////////////////////////
#define DEF_FONT_TYPE 0
#define DEF_FONT_SIZE 24
#define DEF_FONT_SIZE32 32
#define DEF_FONT_SIZE64 64

#define DEF_BWND_COLOR 		0xa0a0
#define DEF_BWND_BACKCOLOR 	0x0A0A
//#define DEF_BWND_COLOR 255

#define WHK_Type_hide 0
#define WHK_Type_show 1

#define WND_Type_AllocBuffer 0
#define WND_Type_NoBuffer 1

typedef void (*_FcsPixel)(uint, int, int, UINT16 *);
#define _def_FcsPixel_INV ((_FcsPixel)1)
#define _def_FcsPixel_IMG ((_FcsPixel)2)
#define _def_FcsPixel_RSV ((_FcsPixel)3)
#define _FcsPixel_INV 1
#define _FcsPixel_IMG 2
#define _FcsPixel_RSV 3

#define DRAW_Type_ROW 0
#define DRAW_Type_COL 1

/////////////////////////////////////
// Functions For Application

HWND CreateWnd(POSITION pos, int w, int h, UINT16 uColor,UINT16 uBackColor, uchar uType);
VOID DestroyWnd(HWND hWnd);

bool SetWndIdentity(HWND hWnd, uint uIdentity);
bool GetWndIdentity(HWND hWnd, uint *pIdentity);
HWND GetWndByIdentity(uint uIdentity);

VOID SetCurWnd(HWND hWnd);
	
bool IsVisible(HWND hWnd);
VOID SetWndBorder(HWND hWnd, bool f_border);

VOID IncRefreshDelcount();
VOID DecRefreshDelcount();

VOID ShowWnd(HWND hWnd);
VOID HideWnd(HWND hWnd);
VOID MoveWnd(HWND hWnd, int deltX, int deltY);
VOID RefreshWnd(HWND hWnd, bool f_show);

VOID ScrollWnd(HWND hWnd, int deltX, int deltY);

HWND GetCurrentWnd();

VOID DrawPoint(HWND hWnd, int px, int py);
VOID DrawLine(HWND hWnd, POSITION posLeft, POSITION posRight);

VOID DrawWndRegion(HWND hWnd, REGION region, UINT16 *pBuffer, uint uType);

VOID SetWndText(HWND hWnd, tchar *pText, POSITION iPos);
VOID ResetWndContent(HWND hWnd);

VOID SetWndRegionText(HWND hWnd, REGION region, tchar *pText);
VOID ResetWndRegionContent(HWND hWnd, REGION region);

VOID SetWndColor(HWND hWnd, UINT16 uColor);
VOID SetWndFontSize(HWND hWnd, UINT16 size);
VOID SetWndDataBorder(HWND hWnd, bool f_databorder);

VOID SetupWndRoutine(HWND hWnd, PWNDRT pWndRt);
VOID SetupWndHook(HWND hWnd, void (*pFxnHk)(uint), uint uType);
PWNDRT SetupHookRoutine(PWNDRT pWndHk);

POSITION GetWndPosition(HWND hWnd);
VOID GetDisplayResolution(int *pResX, int *pResY);

HWND GetBottomWnd();
HWND GetTopWnd();

HDAT CreateWndData(HWND hWnd, REGION region, uint content, uint uType, uint uInfo, void (*pFxnDisplay)(uint), void (*pFxnCreate)(uint), void (*pFxnDelete)(uint));
VOID DeleteWndData(HDAT hDat);

PVOID GetDataContent(HDAT hDat);
void SetDataContent(HDAT hDat,uint content);
bool GetDataType(HDAT hDat, uint *pType);
bool GetDataInfo(HDAT hDat, uint *pInfo);
bool SetDataInfo(HDAT hDat, uint uInfo);

HDAT GetFirstData(HWND hWnd);
HDAT GetNextData(HDAT hDat);

VOID UpdataWndData(HWND hWnd, HDAT hDat);

HFCS CreateWndFocus(HWND hWnd, POSITION pos, uint cx, uint cy, uint data, void (*pFxnPixel)(uint,int,int,UINT16*));
VOID DeleteWndFocus(HFCS hFcs);

bool GetFocusData(HFCS hFcs, uint *pData);

HFCS GetCurrentFocus(HWND hWnd);
HFCS GetRelatFocus(HFCS hFcs, int n);
HFCS GetNextFocus(HFCS hFcs);
HFCS GetLastFocus(HFCS hFcs);

VOID SetNextFocus(HWND hWnd);
VOID SetLastFocus(HWND hWnd);
VOID SetWndFocus(HFCS hFcs);

void eraseWndFocus(HWND hWnd);
void drawWndFocus(HWND hWnd);
int InitWndMgr(/*int resX, int resY*/);

VOID XDisplay();

bool PostMessage(HWND hWnd, uint info);

int CreateWndTimer(HWND hWnd, uint prdTicks, uint info, uint state/*, void (*pTimerRt)(uint,uint)*/);
VOID DeleteWndTimer(HWND hWnd, int timerID);
bool EnableWndTimer(HWND hWnd, int timerID);
bool DisableWndTimer(HWND hWnd, int timerID);

int GetFirstTimer(HWND hWnd);
int GetNextTimer(int timerID);


#define REFRESH_DIRECTLY

#endif /*_WND_MGR_H_*/

