#ifndef _DATA_HOME_H_
#define _DATA_HOME_H_

#include "typeDefs.h"

#define CELL_TYPE_DATA (0<<0)
#define CELL_TYPE_HEAD (1<<0)

#define CELL_TYPE_XAREA (0<<1)
#define CELL_TYPE_YAREA (1<<1)

#define FRAME_NUMBER_FIELD_OFFSET 2
#define FRAME_NUMBER_FIELD_MASK 0xFC

#define numFromType(x) (x>>FRAME_NUMBER_FIELD_OFFSET)
#define areaFromType(x) ((x>>1)&1)

#define DEFAULT_FRAME_NUMBER 11

#define CONTENT_MODE_CIRCULAR 0
#define CONTENT_MODE_FIXED 1

#define MAX_FRAME_NUMBER 64
#define MAX_CELL_TYPE_NUM 12

#define LOW_SNR_CHNL_MODE 0
#define HIGH_SNR_CHNL_MODE 1

#define DATA_FILL_MODE_CIRCULAR 0x00
#define DATA_FILL_MODE_FIXED 0x01

#define FillData(mode) (mode>>24);
#define FillMode(mode) (mode & 0xFF)
#define MakeFillModeInfo(mode, data) ((data<<24)|(mode&0xFF))

#define TEST_CELL_FLAG 0x1234

#define CELL_DATA_OFFSET 2 // sizeof(unsigned short)
typedef struct _CELL
{
	struct _CELL *pNext;
	int offset;
	unsigned char  *buffer;
	unsigned char  type; 
	bool  fPseudo;
	short len;
} CELL, *PCELL;

typedef struct
{
	unsigned int xAreaCellNum;
	unsigned int yAreaCellNum;
	unsigned int xAreaCellType;
	unsigned int yAreaCellType;
} FRAMEAREA;

extern FRAMEAREA frameArea[MAX_FRAME_NUMBER];
#define sDelay(x) TaskSleep(x*1000)

PCELL GetCell(HANDLE hEvent);
void FreeCell(PCELL pCell);

PCELL GetFilledCell(bool fMust);
bool InsertFilledCell(PCELL pCell, bool fBlock);

void InsertFrame(int num);
void FillCellContent(int mode, unsigned char cVal);

bool SetDataGenInfo(unsigned int nCyc, unsigned int chlMode, unsigned int datMode, unsigned char *pFrmNum, unsigned char nMax, unsigned int *pTotalCell);
void StartDataGen();
void RestartDataGen();
void StopDataGen();

void ResetDataGenStatistics();
unsigned int GetGenCellCount();
unsigned int GetGenFrameCount();

bool UpdateFrameModeTab(void *pTab, unsigned int uVer, unsigned int uTime);
void GetFrameModeTab(void *pTab, unsigned int *pVer, unsigned int *pTime);
void GetFramVer(unsigned int *pVer);
void LoadFrameModeTab();
void SaveFrameModeTab();

unsigned int GetWorkStatus();

#endif /*_DATA_HOME_H_*/
