#ifndef _EDMA_H_
#define _EDMA_H_

#include "typeDefs.h"

#include <csl_edma3.h>

#define MAX_PARAMSET_NUM 256
#define CHNL_MAPPED_PARAMSET 255

#define DEFAULT_EDMA3_TCC 63

#define DATA_XMIT_DMA_CH DEFAULT_EDMA3_TCC  
#define DATA_XMIT_DMA_REGION CSL_EDMA3_REGION_1

#define OPTION_FIELD_TCCH_OFFSET 22
#define OPTION_FIELD_TCINT_OFFSET 20 

#define OPTION_FILED_TCCH (1<<OPTION_FIELD_TCCH_OFFSET)
#define OPTION_FIELD_TCINT (1<<OPTION_FIELD_TCINT_OFFSET)

#define DEFAULT_PARAMSET_OPT \
	CSL_EDMA3_OPT_MAKE \
	( \
		CSL_EDMA3_ITCCH_DIS, \
		CSL_EDMA3_TCCH_EN, \
		CSL_EDMA3_ITCINT_DIS, \
		CSL_EDMA3_TCINT_DIS, \
		DEFAULT_EDMA3_TCC, \
		CSL_EDMA3_TCC_NORMAL, \
		CSL_EDMA3_FIFOWIDTH_NONE, \
		CSL_EDMA3_STATIC_DIS, \
		CSL_EDMA3_SYNC_A, \
		CSL_EDMA3_ADDRMODE_INCR, \
		CSL_EDMA3_ADDRMODE_INCR \
	)

#define DEFAULT_PARAMSET_BIDX \
	CSL_EDMA3_BIDX_MAKE(0, 0) 

#define DEFAULT_PARAMSET_CIDX \
	CSL_EDMA3_CIDX_MAKE(0, 0) 

#define DEFAULT_PARAMSET_LINKBCNTRLD \
	CSL_EDMA3_LINKBCNTRLD_MAKE(CSL_EDMA3_LINK_NULL, 1) 

#define DEFAULT_PARAMSET_ABCNT CSL_EDMA3_CNT_MAKE(1, 1) 

#define DEFAULT_PARAMSET_CCNT 1 

HANDLE GetDmaPSet(int index); //All field is UNKNOWN
HANDLE GetDmaPSetWithDefaultContent(int index);  // SRC & DST field is UNKNOWN

#define SetPSetOption(hPSet, value, field) { \
	((CSL_Edma3ParamSetup *)(hPSet))->option = (((CSL_Edma3ParamSetup *)(hPSet))->option & (~(field))) | (value); \
}

#define SetPSetLink(hPSet, index) { \
	((CSL_Edma3ParamSetup *)(hPSet))->linkBcntrld = (((CSL_Edma3ParamSetup *)(hPSet))->linkBcntrld & 0xFFFF0000) + (index)*0x20; \
}

#define SetPSetAddress(hPSet, srcAddr, dstAddr) do { \
	if(srcAddr) \
		((CSL_Edma3ParamSetup *)(hPSet))->srcAddr = (srcAddr); \
	if(dstAddr) \
		((CSL_Edma3ParamSetup *)(hPSet))->dstAddr = (dstAddr); \
} while(0)


#define SetPSetCount(hPSet, aCnt, bCnt, cCnt) do { \
	if(aCnt) ((CSL_Edma3ParamSetup *)(hPSet))->aCntbCnt = (((CSL_Edma3ParamSetup *)(hPSet))->aCntbCnt & 0xFFFF0000) + ((aCnt)); \
	if(bCnt) ((CSL_Edma3ParamSetup *)(hPSet))->aCntbCnt = (((CSL_Edma3ParamSetup *)(hPSet))->aCntbCnt & 0x0000FFFF) + ((bCnt)<<16); \
	if(cCnt) ((CSL_Edma3ParamSetup *)(hPSet))->cCnt = (cCnt); \
} while(0)

void RegisterServPoint(HANDLE hEvent, unsigned int tcc, void (*pFxn)(unsigned int));

void SetupEdma();
void EnableDmaEvent();

#endif /*_EDMA_H_*/
