#ifndef _EDMAHELPER_H_
#define _EDMAHELPER_H_

#define _paramFirstLink 255
#define _default_opt_tcc 3

#define _defaultParam_option CSL_EDMA3_OPT_MAKE(0,0,0,1,_default_opt_tcc,0,0,0,0,0,0)
#define _defaultParam_srcAddr 0
#define _defaultParam_dstAddr 0
#define _defaultParam_srcDstBidx CSL_EDMA3_BIDX_MAKE(0,0)
#define _defaultParam_srcDstCidx CSL_EDMA3_CIDX_MAKE(0,0)
#define _defaultParam_linkBcntrld CSL_EDMA3_LINKBCNTRLD_MAKE(0xFFFF,1)
#define _defaultParam_aCntbCnt CSL_EDMA3_CNT_MAKE(1,1)
#define _defaultParam_cCnt 1

#define option(x,y) {x##.option = (Uint32)y;}
#define srcAddr(x,y) {x##.srcAddr = (Uint32)y;}
#define dstAddr(x,y) {x##.dstAddr = (Uint32)y;}
#define srcDstBidx(x,y) {x##.srcDstBidx = (Uint32)y;}
#define srcDstCidx(x,y) {x##.srcDstCidx = (Uint32)y;}
#define linkBcntrld(x,y) {x##.linkBcntrld = (Uint32)y;}
#define aCntbCnt(x,y) {x##.aCntbCnt = (Uint32)y;}
#define cCnt(x,y) {x##.cCnt = (Uint32)y;}

#define setupDefaultParamSet(x) { x.option = _defaultParam_option;\
	                            x.srcAddr = _defaultParam_srcAddr;\
	                            x.dstAddr = _defaultParam_dstAddr;\
	                            x.srcDstBidx = _defaultParam_srcDstBidx;\
	                            x.srcDstCidx = _defaultParam_srcDstCidx;\
	                            x.linkBcntrld = _defaultParam_linkBcntrld;\
	                            x.aCntbCnt = _defaultParam_aCntbCnt;\
	                            x.cCnt = _defaultParam_cCnt;}

#define setupParamLinks(i,j,ps,x,y,z) { \
	setupDefaultParamSet(ps);\
	for (i=1,j=lnkConfig.number;j>0;j--) { \
		srcAddr(ps,lnkConfig.srcAddr);\
		dstAddr(ps,lnkConfig.xBuffer[i]);\
		option(ps,CSL_EDMA3_OPT_MAKE(0,0,0,1,lnkConfig.xBuffer_tcc[i],0,0,0,0,0,0));\
		linkBcntrld(ps,CSL_EDMA3_LINKBCNTRLD_MAKE((lnkConfig.firstLnkParam-i)*0x20,1));\
		aCntbCnt(ps,CSL_EDMA3_CNT_MAKE(lnkConfig.xLength,1));\
		x = CSL_edma3GetParamHandle(y,lnkConfig.firstLnkParam-lnkConfig.number+j,&z);\
		z = CSL_edma3ParamSetup(x,&ps);\
		i++;\
		if (i == lnkConfig.number) i = 0;\
	} \
}

#endif /*_EDMAHELPER_H_*/
