#ifndef _EXEC_H_
#define _EXEC_H_
#include "C6455.h"
//DSP I2C address
#define CSL_I2C_MASTER_ADDR			0x10
#define CSL_I2C_SLAVE_OWN_ADDR		0x10    

//digital resister I2C address
#define CSL_I2C_SLAVE_RES_ADDR			0x28
#define CSL_I2C_SUB_RES_ADDR			0x00    

//RTC(PCF8563)  I2C address
#define CSL_I2C_SLAVE_RTC_ADDR			0xA2
#define CSL_I2C_SUB_RTC_ADDR			0x00  

#define UART_FRAME_HEAD					0xFE
#define UART_FRAME_TAIL					0xFA

#define UART_QUERY_CMD					0x01
#define UART_QUERY_RESP					0x02
#define UART_SET_CMD					0x03
#define UART_SET_RESP					0x22

#define UART_RESP_SUCCESS				0x00
#define UART_RESP_FAILED				0xFF

#define KEY_SET_SIGN					0x01
#define UNUSED_BYTE_VAL					0x00

#define KEY_QUERY_CMD					0x41
#define KEY_QUERY_RESP					0x42
#define KEY_SET_CMD						0x61
#define KEY_SET_RESP					0x62

#define KEY_RESP_SUCCESS				0x00
#define KEY_RESP_FAILED					0xFF

//command type
#define CMD_TYPE_OVERID			0x40
#define CMD_TYPE_FREQ			0x07//Ƶ
#define CMD_TYPE_BW				0x42
#define CMD_TYPE_SNR			0x43
#define CMD_TYPE_VOLT			0x44
#define CMD_TYPE_FILLDATA		0x45
#define CMD_TYPE_SENDCOUNT		0x46
#define CMD_TYPE_FILLMODE		0x47
#define CMD_TYPE_DOPPLER		0x48
#define CMD_TYPE_TESTMODE		0x51

#define CMD_TYPE_DEV_IP			0x49
#define CMD_TYPE_DEV_MAC		0x4A
#define CMD_TYPE_DEV_PORT		0x4B
#define CMD_TYPE_HOST_IP		0x4C
#define CMD_TYPE_HOST_PORT		0x4D
#define CMD_TYPE_NETSPEED		0x4E
#define	CMD_TYPE_LINKS			0x4F
#define CMD_TYPE_MODE			0x50
#define CMD_TYPE_ADDNOISE		0x52
#define CMD_TYPE_DOPPLERFREQ	0x53
#define CMD_TYPE_DOPPLERCHANGE	0x54

#define CMD_TYPE_RADMSWITCH		0x20//Ƶƿ
#define CMD_TYPE_RADOUTSWITCH	0x02//Ƶ
//Ƶ
#define CMD_TYPE_DSA			0x05//˥
#define CMD_TYPE_PLLLOCK		0x09//
#define CMD_TYPE_RADTEMP		0x0B//Ƶ¶


#define MODE_TAB_SET_CMD			0x31
#define MODE_TAB_SET_RESP			0x32

#define HTC16(a) ( (((a)>>8)&0xff) + (((a)<<8)&0xff00) )
#define HTC32(a) ( (((a)>>24)&0xff) + (((a)>>8)&0xff00) +  (((a)<<8)&0xff0000) + (((a)<<24)&0xff000000) )

#define BANDWIDTH_36MHZ	   0x0
#define BANDWIDTH_18MHZ	   0x1
#define BANDWIDTH_12MHZ	   0x2
#define BANDWIDTH_9MHZ	   0x3

#define MODETABIDC_OLDVER	   0x0
#define MODETABIDC_NEWVER	   0x1


//KEY 
#define NUM0_KEY		0
#define NUM1_KEY		1
#define NUM2_KEY		2
#define NUM3_KEY		3
#define NUM4_KEY		4
#define NUM5_KEY		5
#define NUM6_KEY		6
#define NUM7_KEY		7
#define NUM8_KEY		8
#define NUM9_KEY		9

#define UP_KEY			10
#define DOWN_KEY		11
#define LEFT_KEY		12
#define RIGHT_KEY		13
#define CANCEL_KEY		15
#define CONFIRM_KEY		14

#define NETSET_KEY		16
#define FREQ_KEY		17


#define KEY_INVALID				255
#define NUM0_KEY_ACTIVE			0
#define NUM1_KEY_ACTIVE			1
#define NUM2_KEY_ACTIVE			2
#define NUM3_KEY_ACTIVE			3
#define NUM4_KEY_ACTIVE			4
#define NUM5_KEY_ACTIVE			5
#define NUM6_KEY_ACTIVE			6
#define NUM7_KEY_ACTIVE			7
#define NUM8_KEY_ACTIVE			8
#define NUM9_KEY_ACTIVE			9

#define UP_KEY_ACTIVE			10
#define DOWN_KEY_ACTIVE			11
#define LEFT_KEY_ACTIVE			12
#define RIGHT_KEY_ACTIVE		13
#define CONFIRM_KEY_ACTIVE		14
#define CANCEL_KEY_ACTIVE		15

#define NETSET_KEY_ACTIVE		16
#define FREQ_KEY_ACTIVE			17

#define PARA_WORD_LENGTH		8

#define MAX_PARAM_ELEMENT_NUM 3

#define BaseBandBaseAddr 		(EMIFA_CE2_BASE_ADDR + 0x0000)//

#define BANDWIDTH_36MHZ	   0x0
#define BANDWIDTH_18MHZ	   0x1
#define BANDWIDTH_12MHZ	   0x2
#define BANDWIDTH_9MHZ	   0x3
typedef struct _PARELEMENT
{
	unsigned short len;
	unsigned char type;
	unsigned char rsv[1];
	unsigned char *pBuffer;
} PARELEMENT;

typedef struct _CMD
{
	struct _CMD *pNext;
	struct _CMDQ *pOutputQ;
	HANDLE hEvent;
	unsigned char *pStat;
	unsigned char id;
	unsigned char act;
	unsigned char num;
	unsigned char rsv;
	PARELEMENT paraElem[MAX_PARAM_ELEMENT_NUM];
} CMD, *PCMD;

typedef struct _CMDQ
{
	int count;
	PCMD pHead;
	PCMD pTail;
	HANDLE hEvent;
} CMDQ,*PCMDQ;

typedef struct  {
    volatile Uint16 SR;				//baseband state register 0 			0x0000
    volatile Uint16 RSV0;	
    volatile Uint16 WCR;			//baseband control register 			0x0004
	volatile Uint16 RSV1;
    volatile Uint16 SSR;			//signal power state regiter			0x0008
	volatile Uint16 RSV2;
    volatile Uint16	NSR;			//noise power state regiter			0x000c
	volatile Uint16 RSV3;
    volatile Uint16 BWCR;			//baseband bandwidth control register	0x0010
	volatile Uint16 RSV4;
    volatile Uint16	RSR;			//radioheating lock state register		0x0014
	volatile Uint16 RSV5;
    volatile Uint16 KSR;			//key state register					0x0018
	volatile Uint16 RSV6;
    volatile Uint32 RSV[15];		
	volatile Uint16	DCR;			//doppler contrl regiter				0x0058
	volatile Uint16 RSV7;
	volatile Uint16 DFCR;			//doppler freq contrl regiter			0x005c
	volatile Uint16 RSV8;
	volatile Uint16 DFSR;			//doppler freq period regiter			0x0060
	volatile Uint16 RSV9;
	volatile Uint16 DFRR;			//doppler freq range regiter			0x0064
	volatile Uint16 RSV10;
	volatile Uint16 FTR;			//FPGA temp regiter					0x0068
	volatile Uint16 RSV11;
	volatile Uint16 FCVR;			//FPGA core volt regiter				0x006c
	volatile Uint16 RSV12;
	volatile Uint16 FAVR;			//FPGA assistant volt regiter 			0x0070
} BaseRegs , *PBaseRegs;

typedef struct  {
    volatile Uint32 ISR;				//RS232 interrupt state register
} IntReg , *PIntReg;

typedef struct{
	UINT8 frmhead;
	UINT8 cmdword;
	UINT8 handlestatus;
	UINT8 rsv;
	UINT8 cmdtype;
	UINT8 parlength;
	UINT8 parval[PARA_WORD_LENGTH];
	UINT8 checkout;
	UINT8 frmtail;
}PARAFRM,*PPARAFRM;
extern BaseRegs *g_pBaseRegs;
//void SendCmd2Rad(Uint8 *pData, Uint32 length);
Uint8 calc_Verify(Uint8 *pData, Uint32 length);

void EnqCmdQ(PCMDQ pQ, PCMD pCmd);
PCMD DeqCmdQ(PCMDQ pQ, HANDLE hEvent);

PCMD GetEmptyCMD(HANDLE hEvent);
void FreeCMD(PCMD pCmd);

void PostCMD(PCMD pCmd);
#endif /*_EXEC_H_*/

