#ifndef _FLASH_H_
#define _FLASH_H_


#define FLASH_SIZE    0x800000   // 8MB 
#define ERASE_BLOCKS  64         // Total number of blocks (hiding parameter blocks).

Uint8 DetectFlashDevice(Uint32 FlashBaseAddress);
Bool FlashErase(Uint32 FlashStart, Uint32 FlashLength);
Bool FlashRead(Uint32 FlashStart, Uint8 *pDataBuffer, Uint32 DataLength);
Bool FlashWrite(Uint32 FlashStart, Uint8 *pDataBuffer, Uint32 DataLength);
Bool FlashByteWrite(Uint32 FlashAdd, Uint8 Data);
/*--------------------------
flash ʹ
0x000000->0x01FFFF => bootloader
0x020000->0x37FFFF => user app
0x380000->0x39FFFF => mode tab
0x3A0000->0x3BFFFF => sysinfo
0x3C0000->0x3FFFFF => back pic
---------------------------*/

#endif /*_FLASH_H_*/

