#ifndef _KEYDISPOSE_H_
#define _KEYDISPOSE_H_
#include "WndMgr.h"

#define LOWER_LIMIT_FREQ	950000
#define UPPER_LIMIT_FREQ	3000000

typedef struct {
	Uint8		overID;
	Uint32		freq;
	Uint8		bandwidth;	
	Int16 		snr;
	bool 		signal;
	bool 		noise;
	Int8		volt;
	Uint8		filldata;
	Uint32		cyctimes;
	Uint32		overcount;
	Uint8		testmode;
	Uint8		fillmode;
	int			doppler;
	
	Uint32		devip;	
	Uint8		devmac[6];
	Uint16		devport;
	//Uint32		hostip;
	//Uint16		hostport;
	//Uint16		netspeed;
	Uint32		uver;

	Uint8		dcr;
	float		dfsr;
	bool 		mswitch;
	bool 		outswitch;
	Uint32		saved_sign;
	Uint16		offsetfreq;
	Int8		offsetvolt;
	Int16		offsetsnr;
}SAVEINFO, *PSAVEINFO;

typedef struct {
	bool		lock;
	short		radtemp;
	Uint8		LinkStatus;
}UNSAVEINFO, *PUNSAVEINFO;

typedef struct {
	UINT16	OldModeTab[128];
	UINT16 	NewModeTab[128];
	UINT16	tab_crc;
}SAVEMODETAB, *PSAVEMODETAB;

typedef struct {
	SAVEINFO		SavedPar;
	UNSAVEINFO		UnsavedInfo;
	//SAVEMODETAB 	SavedModeTab;	
}STATUSINFO, *PSTATUSINFO;


//#define EVENT_USER 0x20

typedef struct _FCSDATA {
	char *pFcsPic;
	Uint32 uFcsData;//16λΪӦݿеλã16λΪݿ
} FCSDATA, *PFCSDATA;

extern STATUSINFO SysInfo;
extern STATUSINFO StsWndLastSysInfo1;
extern STATUSINFO StsWndLastSysInfo2;
extern STATUSINFO StsWndLastSysInfo3;
extern STATUSINFO SetWndLastSysInfo;
void CancelKeyChangeWnd(HWND hWnd);
HWND InitInfoWnd();
HWND InitWorkStatusWnd();
HWND InitMemuSetWnd();
HWND InitAllWnd(/*uint resX, uint resY*/);
HDAT GetDataByInfo(HWND hWnd, uint cInfo);
#endif /*_KEYDISPOSE_H_*/
