#ifndef _SERIAL_H_
#define _SERIAL_H_
#include "typeDefs.h"
#include "C6455.h"
#include "sysCfg.h"
//typedef PVOID PHOSTCMD;

#define MONITOR_UART	1
#define RAD_UART		2
#define MonSerialBaseAddr       (EMIFA_CE2_BASE_ADDR + 0x003c)	//ƴ
#define RadSerialBaseAddr       (EMIFA_CE2_BASE_ADDR + 0x0024)	//Ƶ

typedef struct  {
	volatile Uint16 CR;				//RS232 control register
	volatile Uint16 rsv0;
	volatile Uint16 LCR;				//RS232 line control register
	volatile Uint16 rsv1;
	volatile Uint16 BAUDCR;			//RS232 baud rate control register
	volatile Uint16 rsv2;
    volatile Uint16 SR;				//RS232 state register
    volatile Uint16 rsv3;
    volatile Uint16 RBR;				//RS232 receive buffer register
    volatile Uint16 rsv4;
    volatile Uint16 THR;				//RS232 transmit holding register
} SerialRegs , *PSerialRegs;

typedef struct  {
    volatile Uint8 Cr_Par;	
    volatile Uint8 Lcr_Par; //ݸʽ				
    volatile Uint8 Baud_Par;//						
} SerialPar;

extern SerialRegs  *g_pMonitorSerialRegs;
extern SerialRegs  *g_pRadSerialRegs;
extern SerialPar SerialDefPar;

void SerialDisable(SerialRegs  *g_pSerial);
void SerialEnable(SerialRegs  *g_pSerial);
void SerialParSet(SerialRegs  *g_pSerial,SerialPar  SerPar);
void SerialSet(SerialRegs  *g_pSerial,SerialPar  SerPar);
void ClrSerialRcvFIFO(SerialRegs  *g_pSerial);
void SendCommand(Uint8 port,Uint8 * pcommand);
#endif

