#ifndef _SYS_CFG_H_
#define _SYS_CFG_H_
#include "typeDefs.h"
#include <csl_pllc.h>
#include <csl_gpio.h>
#include <csl_emifa.h>
#include <csl_edma3.h>
#include <cslr_dev.h>
#include <cslr_gpio.h>
#include <netmain.h>
#include <_stack.h>
#include "c6455.h"


#define TCP_SERV_VER 0x01

#define FEED_COMPLETE_INT 4
#define EMAC_MDIO_INT 5
#define XSER_RECV_INT HWI_VECTID_INT7
#define RAD_DATA_INT  HWI_VECTID_INT8
#define KEY_INT		  HWI_VECTID_INT9

#define USER_SPACE_BASE_ADDRESS EMIFA_CE2_BASE_ADDR
#define FPGA_REGS_BASE_ADDR USER_SPACE_BASE_ADDRESS
//#define USER_SPACE_BASE_ADDRESS USER_SPACE_BASE_ADDRESS


#define SET_RIS_TRIG_ADDR 0x02B00024
#define CLR_RIS_TRIG_ADDR 0x02B00028
#define SET_FAL_TRIG_ADDR 0x02B0002C
#define CLR_FAL_TRIG_ADDR 0x02B00030

#define CONFIG_BASE_ADDR		0xB03A0000
#define SAVED_SET_PAR_ADDR		0xB03A0000//SysInfo
#define SAVED_TAB_ADDR			0xB0380000//Mode Tab
#define SAVED_CONST_PIC_ADDR	0xB03C0000//back pic

#define PIC_CONST_DDR_ADDR (0xE7040000)

#define HOST_CMD_LENGTH 16
#define HOST_CMD_QUE_DEPTH 8

#define ALFULL_DATA_QUANTITY (112*1024)

#define FPGA_DATA_RECV_FIFO_ADDR (FPGA_REGS_BASE_ADDR+0x0074)
#define FPGA_DATA_RECV_FIFO *((volatile unsigned short*)FPGA_DATA_RECV_FIFO_ADDR)

#define DEFAULT_TCP_SERV_PORT htons(10011)

#define DEFAULT_DEV_IP_ADDR \
	inet_addr("198.18.108.18")

#define DEFAULT_DEV_IP_MASK \
	inet_addr("255.255.255.0")
	
#define DEFAULT_DEV_IP_GATEWAY \
	inet_addr("198.18.108.6")

#define DEFAULT_DEV_IP_DNS 0

#define DEFAULT_DEV_DOMAIN_NAME "Goldhope.net"
#define DEFAULT_DEV_HOST_NAME "GHope"
typedef struct {
	CSL_GpioHandle hGpio;
	CSL_GpioObj gpioObj;
} GPIO_Dev;
typedef struct {
	UINT8 cmd[HOST_CMD_LENGTH];
	UINT8 count;
} HOSTCMD, *PHOSTCMD;
typedef struct {
	HOSTCMD cmdX[HOST_CMD_QUE_DEPTH];
	UINT8 wIndex;
	UINT8 rIndex;
} CMDBUFFER, *PCMDBUFFER;


/** @brief The defaults of EMIFA Async Wait structure */
#define CSL_EMIFA_ASYNCWAIT_SET {\
    (CSL_EmifaArdyPol)CSL_EMIFA_ARDYPOL_HIGH,\
    0x80, /*MAXEXTWAIT*/\
    0x00  /*TURNARND*/\
}

/** @brief The defaults of EMIFA CEConfig for Sync structure */
#define CSL_EMIFA_SYNCCFG_SET {\
    0x00, /*READBYTEEN*/\
    0x00, /*CHIPENEXT*/\
    0x01, /*READEN*/\
    0x00, /*WLTNCY*/\
    0x03, /*RLTNCY*/\
	0x01  /*SBSIZE*/\
}

/** @brief The defaults of EMIFA CEConfig for Async structure */
#define CSL_EMIFA_ASYNCCFG_SET {\
    0x00, /*SELECTSTROBE*/\
    0x00, /*WEMODE*/\
    0x00, /*ASYNCRDYEN*/\
    0x00, /*WSETUP*/\
    0x04, /*SSTROBE*/\
    0x00, /*WHOLD*/\
    0x00, /*RSETU*/\
    0x04, /*RSTROBE*/\
    0x00, /*RHOLD*/\
    0x02  /*ASIZE*/\
}

/** @brief The defaults of EMIFA Async Wait structure for CE3 */
#define CSL_EMIFA_ASYNCWAIT_FLASH {\
    (CSL_EmifaArdyPol)CSL_EMIFA_ARDYPOL_HIGH, \
/*MAXEXTWAIT*/    0x80, \
/*TURNARND*/    0x03 \
}

#define CSL_EMIFA_ASYNCCFG_FLASH {\
/*SELECTSTROBE*/    0x00, \
/*WEMODE*/    0x00, \
/*ASYNCRDYEN*/    0x00, \
/*WSETUP*/    0x0F, \
/*SSTROBE*/    0x3F, \
/*WHOLD*/    0x07,\
/*RSETU*/    0x0F, \
/*RSTROBE*/    0x3F, \
/*RHOLD*/    0x07, \
/*ASIZE*/    0x02 \
}
#define EMIFA_MEMTYPE_ASYNC 0
#define EMIFA_MEMTYPE_SYNC 1
#define SDRAM_REFRESH_RATE_DEFAULT (0x0000073B)

typedef enum
{
	typeBOOL = 0,
	typeCHAR = 1,
	typeUCHAR = 2,
	typeSHORT = 3,
	typeUSHORT = 4,
	typeINT = 5,
	typeUINT = 6,
	typeFLOAT = 7,
	typeUNKNOWN
} DatType;

typedef struct 
{
	volatile unsigned short CR;
	volatile unsigned short uCR;
	volatile unsigned short SR;
	volatile unsigned short uSR;
} *PBBREGS;

#define BBREGS (*((PBBREGS)(FPGA_REGS_BASE_ADDR)))
#define CELL_BUFFER_DDR_ADDR (0xE0000000)
#define _BCH_ENCODE_
#define ALLOC_IRAM_CELL_BUFFER
#define NET_MAGIC_NUMBER 0x87654321
typedef struct {
	UINT32 MagicNumber;
	UINT32 TcpPort;
	UINT32 IPAddr;
	UINT32 IPMask;
	UINT32 destIPAddr;
	UINT32 destIPMask;
	UINT32 IPGway;
	UINT32 IPDNS;
	char DomainName[16];
	char HostName[16];
	UINT8 MacAddr[6];
} NETCONFIG, *PNETCONFIG;

extern NETCONFIG netCfg;
extern GPIO_Dev g_GPIO_Dev;

//extern void* g_hExecSem;
extern void* g_hPCUartSem;
extern void* g_hRadUartSem;

extern CMDBUFFER cmdBuff;
extern CMDBUFFER RadCmdBuff;

extern unsigned char *gImage_back;


void enableGpioPER();

void CreatDefSysCfg();
void enableXserialInterrupt();
void enableKeyInterrupt();
void disableXserialInterrupt();
void enableRadInterrupt();
UINT32 SaveSysCfg();
void SetSnr();
void calculateSNR(const float snr,const UINT8 bw,UINT16 * fs,UINT16 * fn);
void calculateDopplerFreqR(Int32 infreq,uchar mode,Int32 *outfreq);
void calculateDopplerCyc(float cyc,UINT32 *outcyc);
void calculateDeltaFreq(UINT32 freq,UINT32 *outfreq);
#endif /*_SYS_CFG_H_*/
