
#ifndef _SYS_CONTEXT_H_
#define _SYS_CONTEXT_H_

#include "typeDefs.h"

#define Mem_NULL ((PVOID)0)

#define TO_FOREVER SYS_FOREVER

#define PRI_HIGH   5
#define PRI_NORM   4
#define PRI_LOW   3

#define STK_HIGH   8192
#define STK_NORM   4096
#define STK_LOW    3072

typedef PVOID HEVENT;

PVOID alloc_mem(uint size, uint align);
VOID free_mem(void *pmem, uint size);

VOID mmzero(void *pmem, uint size);
VOID mmcopy(void *pdst, const void *psrc, uint size);
VOID mmset(void *pmem, uint size, uchar value);
VOID mmset_16(void *pmem, uint size, unsigned short value);

void sysCritON();
void sysCritOFF();

void _llEnter();
void _llExit();

HEVENT CreateEvent(int count);
void DeleteEvent(HEVENT hEvt);
bool PendEvent(HEVENT hEvt, uint timeout);
VOID PostEvent(HEVENT hEvt);
VOID ResetEvent(HEVENT hEvt, int count);

/* Spin in a delay loop for delay iterations */
void delay(Uint32 delay);
VOID tsk_sleep(uint uTicks);

PVOID create_task(void(*pFun)(), char *name, int pri, uint stk, uint arg);

bool InitSysContext();

//---------------------------------------------
//---------------------------------------------
// Interrupt management wrapper
//---------------------------------------------
//---------------------------------------------

#define     MAX_NUM_SYSEVENTS   128

#define     MIN_EVENT_ID        3
#define     MAX_EVENT_ID        128

#define     MIN_INTVECT_ID      3
#define     MAX_INTVECT_ID      15

/** 
 * @brief 
 *  The structure describes the interrupt setup object defined by
 *  the interrupt management wrapper in os abstraction layer.
 *
 * @details
 *  This structure can be used by a driver/such in setting up 
 *  interrupts using the underlying os(bios) constructs without
 *  having to know the details of the os specific calls. All calls
 *  to the interrupt management wrapper require a handle to
 *  the structure described below.
 */
typedef struct _INTSETUP
{
    /**
     * @brief   HWI object number to use for setting up this 
     *          system event. The valid values for this range
     *          between 4 - 15 (both inclusive).
     */
    uchar       intvectId;                      

    /**
     * @brief   system event number(s) for which the 
     *          interrupts need to be setup. The valid values
     *          for this range between 4 - 127 (both inclusive).
     */
    uchar       sysEvtId[MAX_NUM_SYSEVENTS];   

    /**
     * @brief   Number of system events that need to be mapped 
     *          to a given dsp interrupt number and be serviced by
     *          a specified interrupt service routine.
     *          valid values for this range between 1 - 128.
     */
    uchar       sysEvtCnt;

    /**
     * @brief   The callback function to be triggered when the 
     *          interrupt occurs, i.e. the isr. This should not be
     *          set to null for a successful interrupt setup.
     */
    void        (*pFxn)(void* arg);

    /**
     * @brief   The arguments that need to be passed to the isr.
     *          can be null.
     */
    void*       arg;

    /**
     * @brief   Flag to indicate whether to enable/disable the
     *          interrupt by default. This flag is valid only
     *          when setting up combined interrupts, i.e., 
     *          multiple system events mapped to a single
     *          dsp interrupt number.       
     */    
    uchar       f_enable;

} INTSETUP,*PINTSETUP;

uint  CreateInterrupt(PINTSETUP pInt);
uint  DeleteInterrupt(PINTSETUP pInt);
uint  EnableInterrupt(PINTSETUP pInt);
uint  DisableInterrupt(PINTSETUP pInt);

void EnableSysInterrupt(int vectID);
void DisableSysInterrupt(int vectID);

#endif /*_SYS_CONTEXT_H_*/

