#include <std.h>
#include <stdio.h>
#include <c62.h>
#include <sys.h>
#include <mem.h>
#include <sem.h>
#include <math.h>

#include "keydispose.h"
#include "sysCfg.h"
#include "Exec.h"
#include "serial.h"

#include "dataHome.h"
#include "GTel.h"
#include "sysContext.h"

//------------------WND--------------------
#define DEVINIT_WND			0xAA

#define MAINSTATUSWND		0x01

#define MAINSETWINDOW		0x03
#define INFOWND				0x04
#define WORKSTATUS			0x05
#define OVERTAKEWND			0x06
#define BASEWND				0x07
#define RADPARWND			0x08
#define LOCALPARWND			0x09
#define LINEWND				0x0a
#define NETSWND				0x0b
#define SAVEPARWND			0x0C
#define SAVEMENUWND			0x0D

#define SET_OVERID_WND		0x31
#define SET_FREQ_WND		0x32
#define SET_BW_WND			0x33
#define SET_SNR_WND			0x34
#define SET_VOLT_WND		0x35
#define SET_TESTMODE_WND	0x36
#define	SET_SENDCOUNT_WND	0x37
//#define SET_ADDID_WND		0x38
#define SET_DOPPLER_WND		0x39

#define SET_DEVIP_WND		0x3A
#define SET_DEVMAC_WND		0x3C
#define SET_DEVPORT_WND		0x3E

#define SET_OVERCOUNT_WND	0x40

#define SET_FILLMODE_WND    0x41
#define SET_FILLDATA_WND	0x42
#define SET_ADDNOISE_WND	0x43
#define SET_OUTSWITCH_WND	0x44
#define SET_MSWITCH_WND		0x45

#define SET_OFFSETFREQ_WND	0x46
#define SET_OFFSETVOLT_WND	0x47
#define SET_OFFSETSNR_WND	0x48
#define SET_DOPPLERFREQ_WND	0x49
#define SET_DOPPLERCHANGE_WND	0x4A
//--------------------WND-----------------
//--------------------DATA-----------------
#define INFODATA			0x11
#define WORKSTATUSDATA		0X12
#define STATUS_SAVEPAR		0x16

#define STATUS_MENU			0x01

#define STATUS_OVERTAKE		0x23
#define STATUS_FILLDATA		0x24
#define STATUS_CYCTIMES		0x25
#define STATUS_TESTMODE		0x26
#define STATUS_DOPPLER		0x27
#define STATUS_OVERCOUNT	0x28
#define STATUS_SNR			0x12
#define STATUS_VOLT			0x13
#define STATUS_BW			0x14
#define STATUS_FREQ			0x15
#define STATUS_FILLMODE		0x29
#define STATUS_ADDNOISE		0x2A
#define STATUS_MSWITCH		0x2B
#define STATUS_OUTSWITCH	0x2C
#define STATUS_OFFSETFREQ	0x2D
#define STATUS_OFFSETVOLT	0x2E
#define STATUS_OFFSETSNR	0x2F
#define STATUS_DOPPLERCHANGE 	0x30
#define STATUS_DOPPLERFREQ	0x31

#define STATUS_DEVIP		0x17
#define STATUS_HOSTIP		0x18
#define STATUS_HOSTPORT		0x19
#define STATUS_DEVMAC		0x1A
#define STATUS_DEVPORT		0x1B
#define STATUS_NETSPEED		0x1C
#define STATUS_LINK			0x1D
#define STATUS_MODEEDTION	0x1E
#define STATUS_RADTEMP 		0x1F
//--------------------DATA----------------

#define CUR_DATA				0x1
#define CUR_DATA1			0x11
#define CUR_DATA2			(CUR_DATA1 + 1)
#define CUR_DATA3			(CUR_DATA1 + 2)
#define CUR_DATA4			(CUR_DATA1 + 3)

#define SET_DATA				0x2
#define SET_DATA1				0x21
#define SET_DATA2				(SET_DATA1 + 1)
#define SET_DATA3				(SET_DATA1 + 2)
#define SET_DATA4				(SET_DATA1 + 3)
#define SET_DATA5				(SET_DATA1 + 4)
#define SET_DATA6				(SET_DATA1 + 5)

#define IMAGE_DATA			0x3
#define IMAGE_DATA1			0x31
#define IMAGE_DATA2			(IMAGE_DATA1 + 1)
#define IMAGE_DATA3			(IMAGE_DATA1 + 2)
#define IMAGE_DATA4			(IMAGE_DATA1 + 3)
#define IMAGE_DATA5			(IMAGE_DATA1 + 4)
/*
#define WDAT_LENGTH_1_CHAR   0x0001
#define WDAT_LENGTH_2_CHAR   0x0002
#define WDAT_LENGTH_3_CHAR   0x0003
#define WDAT_LENGTH_4_CHAR   0x0004
#define WDAT_LENGTH_5_CHAR   0x0005
#define WDAT_LENGTH_6_CHAR   0x0006
#define WDAT_LENGTH_7_CHAR   0x0007
#define WDAT_LENGTH_8_CHAR   0x0008
*/
//#define TWO_CHIN_LENTH		4 //ַͼƬռõֽ

#define FOCUS_TICK		5		

static bool workflag = 0;

STATUSINFO SysInfo;
STATUSINFO StsWndLastSysInfo1;
STATUSINFO StsWndLastSysInfo2;
STATUSINFO StsWndLastSysInfo3;
STATUSINFO SetWndLastSysInfo;

bool bFirstInitWnd = TRUE;

Uint8 GetKeyValue(uint keyreg)
{
	Uint8 keystate;
	switch (keyreg & 0xFF)
		{
			case 0:
				keystate = NUM0_KEY_ACTIVE;
			break;
			case 1:
				keystate = NUM1_KEY_ACTIVE;
			break;
			case 2:
				keystate = NUM2_KEY_ACTIVE;
			break;
			case 3:
				keystate = NUM3_KEY_ACTIVE;
			break;
			case 4:
				keystate = NUM4_KEY_ACTIVE;
			break;
			case 5:
				keystate = NUM5_KEY_ACTIVE;
			break;
			case 6:
				keystate = NUM6_KEY_ACTIVE;
			break;
			case 7:
				keystate = NUM7_KEY_ACTIVE;
			break;
			case 8:
				keystate = NUM8_KEY_ACTIVE;
			break;
			case 9:
				keystate = NUM9_KEY_ACTIVE;
			break;
			case 10:
				keystate = UP_KEY_ACTIVE;
			break;
			case 11:
				keystate = DOWN_KEY_ACTIVE;
			break;
			case 12:
				keystate = LEFT_KEY_ACTIVE;
			break;
			case 13:
				keystate = RIGHT_KEY_ACTIVE;
			break;
			case 14:
				keystate = CONFIRM_KEY_ACTIVE;
			break;
			case 15:
				keystate = CANCEL_KEY_ACTIVE;
			break;
			case 16:
				keystate = NETSET_KEY_ACTIVE;
			break;
			case 17:
				keystate = FREQ_KEY_ACTIVE;
			break;
			default:
				keystate = KEY_INVALID;
			break;
		}
	return (keystate);
}

HDAT GetDataByInfo(HWND hWnd, uint cInfo)
{
	HDAT hData = NULL;
	uint uInfo;
	hData = GetFirstData(hWnd);
	do{
		GetDataInfo(hData, &uInfo);
		if(uInfo == cInfo) break;
		hData = GetNextData(hData);
	}while(hData);
	
	return hData;
}

int datacmp(char *str1,char *str2, uint length)
{
	uint i;
	for(i=0;i<length;i++)
	{
		if(*(str1+i) != *(str2+i)) return 1;
	}
	return 0;
}

void datacpy(char *dest,char *src, uint length)
{
	uint i;
	for(i=0;i<length;i++)
	{
		if(*(dest+i) = *(src+i));
	}
}

Uint8 CharToNum(char s)
{
	Uint8 data = 0;
	if((s >= '0') && (s <= '9'))
	{
		data = 0 + s - '0';
	}
	else if((s >= 'A') && (s <= 'F'))
	{
		data = 10 + s - 'A';
	}
	else if((s >= 'a') && (s <= 'f'))
	{
		data = 10 + s - 'a';
	}
	return  data;
}

void U8ToHexStr(Uint8 udata , char *pNum)
{
	Uint8 iTemp8;
	iTemp8 = udata >> 4;
	if(iTemp8 < 10)
	{
		*pNum = '0' + iTemp8;
	}
	else
	{
		*pNum = 'A' + iTemp8 - 10;
	}

	iTemp8 = udata & 0xF;
	if(iTemp8 < 10)
	{
		*(pNum+1) = '0' + iTemp8;
	}
	else
	{
		*(pNum+1) = 'A' + iTemp8 - 10;
	}
}

void U32ToHexStr(Uint32 udata , char *pNum)
{
	Uint8 iTemp8,i;
	for(i=0;i<4;i++)
	{
		iTemp8 = (udata >> (24 -8*i))&0xFF;
		U8ToHexStr(iTemp8, (pNum + i*2));
	}
}

//תΪŶַ
void IntToDecStr(int iData, char *pNum, uint length)
{
	uint uTemp,i;
	if(iData < 0)
	{
		*pNum = '-';
		uTemp = -iData;
	}
	else
	{
		*pNum = ' ';
		uTemp = iData;
	}
	
	for(i=0;i<length-1;i++)
	{
		*(pNum+length-i-1) = '0' + (uTemp % 10);
		uTemp /= 10;
	}
}

//תΪַ
void U32ToDecStr(uint uData , char *pNum , uint length)
{
	uint uTemp,i;
	
	uTemp = uData;
	
	for(i=0;i<length;i++)
	{
		*(pNum+length-i-1) = '0' + (uTemp % 10);
		uTemp /= 10;
	}
}

//תΪʵݳַ
void UintToDecStr(uint udata , char *pNum)
{
	int f,i,j,k,l,p;

	i=0;
	if(udata == 0) 
	{
		*pNum = '0';
		i++;
	}
	else
	{
		for(f=0,j=9;j>=0;j--) 
		{
			for(p=1,l=0;l<j;l++) p = p*10;
			k = udata/p;
			if(k>0 || f>0) 
			{
				udata = udata - k*p;
				*(pNum+i)= '0' + k;
				i++;
				f++;
			}
		}
	}
	//*(pNum+i) = '\0';
}
/*
//ԵûϵͳϢʾ
void GetStatusWnd1Info(void)
{
	SysInfo.UnsavedInfo.snr = g_pBaseRegs->SNR;
	SysInfo.UnsavedInfo.rcvvol = SysInfo.UnsavedInfo.snr + 743 - 1740; 
}

//ԵûϵͳϢʾ
void GetStatusWnd5Info(void)
{
	SysInfo.UnsavedInfo.carfreq = g_pBaseRegs->CWFOR;
	SysInfo.UnsavedInfo.codefreq = g_pBaseRegs->CFOR;
	SysInfo.UnsavedInfo.devtemp = ((g_pBaseRegs->SR0)>>8) &&0xFF;
}

//ԵûϵͳϢʾ
void GetAimStatusWndInfo(void)
{
	SysInfo.UnsavedInfo.snr = g_pBaseRegs->SNR;
	SysInfo.UnsavedInfo.agc = ((g_pBaseRegs->SR2)>>8) & 0xFF; 
}*/


//³֡
void UpdateOverIDStatus(PSTATUSINFO pInfo, HWND hWnd)
{
	HDAT hData;
	uint i;
	char *pCurChrData = NULL;
	//uint *pCurIntData = NULL;
	
	if(pInfo == NULL) return;
	if((pInfo->SavedPar.overID == SysInfo.SavedPar.overID) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.overID= SysInfo.SavedPar.overID;

	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update overID
		hData = GetDataByInfo(hWnd,STATUS_OVERTAKE);
		pCurChrData = GetDataContent(hData);
		if(SysInfo.SavedPar.overID> 64)
		{
			for(i=0;i<2;i++)
			{
				*(pCurChrData+i) = '-';
			}
		}
		else
		{
			U32ToDecStr(SysInfo.SavedPar.overID, pCurChrData, 2);	
			if(*pCurChrData == '0')
			{
				*pCurChrData = ' ';
			}	
		}
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		//update overID
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurChrData = GetDataContent(hData);
		*pCurChrData = SysInfo.SavedPar.overID;
		//UpdataWndData(hWnd, hData);
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}


//Ƶ

void UpdateFreqStatus(PSTATUSINFO pInfo,HWND hWnd)
{
	HDAT hData;
	char *pCurChrData = NULL;
	uint *pCurIntData = NULL;

	if(pInfo == NULL) return;
	if((pInfo->SavedPar.freq == SysInfo.SavedPar.freq) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.freq = SysInfo.SavedPar.freq;
	
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update frequence
		hData = GetDataByInfo(hWnd,STATUS_FREQ);
		pCurChrData = GetDataContent(hData);
		
		U32ToDecStr(SysInfo.SavedPar.freq, pCurChrData, 7);
		if(*pCurChrData == '0')
		{
			*pCurChrData = ' ';
		}
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		//update frequence
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurIntData = GetDataContent(hData);
		
		*pCurIntData = SysInfo.SavedPar.freq;
		//UpdataWndData(hWnd, hData);
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}


void UpdateOffsetFreqStatus(PSTATUSINFO pInfo, HWND hWnd)
{
	HDAT hData;
	char *pCurChrData = NULL;
	uint *pCurIntData = NULL;

	if(pInfo == NULL) return;
	if((pInfo->SavedPar.offsetfreq == SysInfo.SavedPar.offsetfreq) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.offsetfreq = SysInfo.SavedPar.offsetfreq;
	
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update host port
		hData = GetDataByInfo(hWnd,STATUS_OFFSETFREQ);
		pCurChrData = GetDataContent(hData);
		
		U32ToDecStr(SysInfo.SavedPar.offsetfreq, pCurChrData, 5);
		if(*pCurChrData == '0')
		{
			*pCurChrData = ' ';
			if(*(pCurChrData+1) == '0')
			{
				*(pCurChrData+1) = ' ';
				if(*(pCurChrData+2) == '0')
				{
					*(pCurChrData+2) = ' ';
					if(*(pCurChrData+3) == '0')
					{
						*(pCurChrData+3) = ' ';
					}
				}
			}
		}
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		//update host port
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurIntData = GetDataContent(hData);
		*pCurIntData = SysInfo.SavedPar.offsetfreq;
		//UpdataWndData(hWnd, hData);
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}

//źŴ
void UpdateBWStatus(PSTATUSINFO pInfo, HWND hWnd)
{
	HDAT hData;
	char *pCurChrData = NULL;

	if(pInfo == NULL) return;
	if((pInfo->SavedPar.bandwidth == SysInfo.SavedPar.bandwidth) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.bandwidth = SysInfo.SavedPar.bandwidth;
	
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update bandwidth
		hData = GetDataByInfo(hWnd,STATUS_BW);
		pCurChrData = GetDataContent(hData);	
		U32ToDecStr(SysInfo.SavedPar.bandwidth, pCurChrData, 2);
		if(*pCurChrData == '0')
		{
			*pCurChrData = ' ';
		}	
		//UpdataWndData(hWnd, hData);
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		//update bandwidth
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurChrData = GetDataContent(hData);
		*pCurChrData = SysInfo.SavedPar.bandwidth;	
		//UpdataWndData(hWnd, hData);	
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}

//
void UpdateSnrStatus(PSTATUSINFO pInfo, HWND hWnd)
{
	HDAT hData;
//	uint i;
	char *pCurChrData = NULL;
	
	if(pInfo == NULL) return;
	if((pInfo->SavedPar.snr == SysInfo.SavedPar.snr) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.snr= SysInfo.SavedPar.snr;

	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update snr
		hData = GetDataByInfo(hWnd,STATUS_SNR);
		pCurChrData = GetDataContent(hData);
		if(SysInfo.SavedPar.snr < -200) 
		{
			datacpy(pCurChrData, "<<-20", 5);
		}
		else if (SysInfo.SavedPar.snr > 200)
		{
			datacpy(pCurChrData, ">> 20", 5);
		}	
		else 
		{
			IntToDecStr(SysInfo.SavedPar.snr, pCurChrData, 4);	
			if(*(pCurChrData+1) == '0')
			{
				*(pCurChrData+1) = *pCurChrData;
				*pCurChrData = ' ';
			}
			*(pCurChrData+4) = *(pCurChrData+3) ;
			*(pCurChrData+3) = '.';
		}
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurChrData = GetDataContent(hData);
		IntToDecStr(SysInfo.SavedPar.snr, pCurChrData, 4);	
		if(*(pCurChrData+1) == '0')
		{
			*(pCurChrData+1) = *pCurChrData;
			*pCurChrData = ' ';
		}
		*(pCurChrData+4) = *(pCurChrData+3) ;
		*(pCurChrData+3) = '.';
		//UpdataWndData(hWnd, hData);
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}


void UpdateOffsetSnrStatus(PSTATUSINFO pInfo, HWND hWnd)
{
	HDAT hData;
//	uint i;
	char *pCurChrData = NULL;
	
	if(pInfo == NULL) return;
	if((pInfo->SavedPar.offsetsnr == SysInfo.SavedPar.offsetsnr) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.offsetsnr= SysInfo.SavedPar.offsetsnr;

	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update snr
		hData = GetDataByInfo(hWnd,STATUS_OFFSETSNR);
		pCurChrData = GetDataContent(hData);
		IntToDecStr(SysInfo.SavedPar.offsetsnr, pCurChrData, 4);	
		if(*(pCurChrData+1) == '0')
		{
			*(pCurChrData+1) = *pCurChrData;
			*pCurChrData = ' ';
		}
		*(pCurChrData+4) = *(pCurChrData+3) ;
		*(pCurChrData+3) = '.';
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurChrData = GetDataContent(hData);
		IntToDecStr(SysInfo.SavedPar.offsetsnr, pCurChrData, 4);	
		if(*(pCurChrData+1) == '0')
		{
			*(pCurChrData+1) = *pCurChrData;
			*pCurChrData = ' ';
		}
		*(pCurChrData+4) = *(pCurChrData+3) ;
		*(pCurChrData+3) = '.';
		//UpdataWndData(hWnd, hData);
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}


//¼ģʽ
void UpdateAddNoiseModeStatus(PSTATUSINFO pInfo,HWND hWnd)
{
	HDAT hData;
	char *pCurChrData = NULL;

	if(pInfo == NULL) return;
	if((pInfo->SavedPar.signal == SysInfo.SavedPar.signal)&&(pInfo->SavedPar.noise == SysInfo.SavedPar.noise)&& (!bFirstInitWnd)) return;
	pInfo->SavedPar.signal = SysInfo.SavedPar.signal;
	pInfo->SavedPar.noise = SysInfo.SavedPar.noise;
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		hData = GetDataByInfo(hWnd,STATUS_ADDNOISE);
		pCurChrData = GetDataContent(hData);
		
		if(SysInfo.SavedPar.signal == 1 && SysInfo.SavedPar.noise == 1)
			datacpy(pCurChrData, "ģʽ  ", 10);
		else if(SysInfo.SavedPar.signal == 1)
			datacpy(pCurChrData, "źģʽ", 10);
		else
			datacpy(pCurChrData, "ģʽ", 10);
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurChrData = GetDataContent(hData);
		
		if(SysInfo.SavedPar.signal == 1 && SysInfo.SavedPar.noise == 1)
			datacpy(pCurChrData, "ģʽ  ", 10);
		else if(SysInfo.SavedPar.signal == 1)
			datacpy(pCurChrData, "źģʽ", 10);
		else
			datacpy(pCurChrData, "ģʽ", 10);
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}

void UpdateOutSwitchStatus(PSTATUSINFO pInfo,HWND hWnd)
{
	HDAT hData;
	char *pCurChrData = NULL;

	if(pInfo == NULL) return;
	if((pInfo->SavedPar.outswitch== SysInfo.SavedPar.outswitch)&& (!bFirstInitWnd)) return;
	pInfo->SavedPar.outswitch = SysInfo.SavedPar.outswitch;
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		hData = GetDataByInfo(hWnd,STATUS_OUTSWITCH);
		pCurChrData = GetDataContent(hData);
		
		if(SysInfo.SavedPar.outswitch == 1)
			datacpy(pCurChrData, "", 2);
		else
			datacpy(pCurChrData, "", 2);
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurChrData = GetDataContent(hData);
		
		if(SysInfo.SavedPar.outswitch == 1)
			datacpy(pCurChrData, "", 2);
		else
			datacpy(pCurChrData, "", 10);
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}

void UpdateMSwitchStatus(PSTATUSINFO pInfo,HWND hWnd)
{
	HDAT hData;
	char *pCurChrData = NULL;

	if(pInfo == NULL) return;
	if((pInfo->SavedPar.mswitch== SysInfo.SavedPar.mswitch)&&(!bFirstInitWnd)) return;
	pInfo->SavedPar.mswitch = SysInfo.SavedPar.mswitch;
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		hData = GetDataByInfo(hWnd,STATUS_MSWITCH);
		pCurChrData = GetDataContent(hData);
		
		if(SysInfo.SavedPar.mswitch == 1)
			datacpy(pCurChrData, "", 2);
		else
			datacpy(pCurChrData, "", 2);
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurChrData = GetDataContent(hData);
		
		if(SysInfo.SavedPar.mswitch == 1)
			datacpy(pCurChrData, "", 2);
		else
			datacpy(pCurChrData, "", 10);
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}

//ƽ
void UpdateVoltStatus(PSTATUSINFO pInfo ,HWND hWnd)
{
	HDAT hData;
	uint i;
	char *pCurChrData = NULL;
	uint *pCurIntData = NULL;
	if(pInfo == NULL) return;
	if((pInfo->SavedPar.volt == SysInfo.SavedPar.volt) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.volt = SysInfo.SavedPar.volt;

	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update receive voltage
		hData = GetDataByInfo(hWnd,STATUS_VOLT);
		pCurChrData = GetDataContent(hData);
		if((SysInfo.SavedPar.volt > 70) || (SysInfo.SavedPar.volt < 20))
		{
			for(i=0;i<3;i++)
			{
				*(pCurChrData+i) = '-';
			}
			*(pCurChrData+3) = '-';
		}
		else
		{
			IntToDecStr(SysInfo.SavedPar.volt, pCurChrData, 3);	
			*pCurChrData = '-';
			*(pCurChrData+3) = '.';
			*(pCurChrData+4) = '0';
		}
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurIntData = GetDataContent(hData);
		*pCurIntData = SysInfo.SavedPar.volt;
		/*UpdataWndData(hWnd, hData);
		hData = GetDataByInfo(hWnd,CUR_DATA1);
		pCurChrData = GetDataContent(hData);
		*pCurChrData = '-';
		UpdataWndData(hWnd, hData);
		hData = GetDataByInfo(hWnd,SET_DATA1);
		pCurChrData = GetDataContent(hData);
		*pCurChrData = '-';*/
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}

//
void UpdateOffsetVoltStatus(PSTATUSINFO pInfo,HWND hWnd)
{
	HDAT hData,hData1;
	char *pCurChrData = NULL;
	int *pCurIntData = NULL;
	if(pInfo == NULL) return;
	if((pInfo->SavedPar.offsetvolt== SysInfo.SavedPar.offsetvolt) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.offsetvolt = SysInfo.SavedPar.offsetvolt;
	
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update frequence
		hData = GetDataByInfo(hWnd,STATUS_OFFSETVOLT);
		pCurChrData = GetDataContent(hData);
		IntToDecStr(SysInfo.SavedPar.offsetvolt, pCurChrData, 3);
		if(*(pCurChrData+1) == '0' )
			*(pCurChrData+1) = ' ';
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		//update
		hData1 = GetDataByInfo(hWnd,CUR_DATA1);
		pCurChrData = GetDataContent(hData1);
		
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurIntData = GetDataContent(hData);
		*pCurIntData = SysInfo.SavedPar.offsetvolt;
		if(*pCurIntData <0)
		{
			*pCurIntData = -*pCurIntData;
			*pCurChrData = '-';
		}
		else
		{
			*pCurChrData = ' ';
		}
		//UpdataWndData(hWnd, hData);
		UpdataWndData(hWnd, hData1);
		hData1 = GetDataByInfo(hWnd,SET_DATA1);
		pCurChrData = GetDataContent(hData1);
		*pCurChrData = ' ';
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}

//
void UpdateFillDataStatus(PSTATUSINFO pInfo,HWND hWnd)
{
	HDAT hData;
	char *pCurChrData = NULL;

	if(pInfo == NULL) return;
	if((pInfo->SavedPar.filldata == SysInfo.SavedPar.filldata) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.filldata = SysInfo.SavedPar.filldata;
	
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		hData = GetDataByInfo(hWnd,STATUS_FILLDATA);
		pCurChrData = GetDataContent(hData);
		U8ToHexStr(SysInfo.SavedPar.filldata, pCurChrData+2);
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurChrData = GetDataContent(hData);
		U8ToHexStr(SysInfo.SavedPar.filldata, pCurChrData+2);
		UpdataWndData(hWnd, hData);
		hData = GetDataByInfo(hWnd,SET_DATA);
		pCurChrData = GetDataContent(hData);
		U8ToHexStr(SysInfo.SavedPar.filldata, pCurChrData+2);
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}
//ѭ
void UpdateCycCountStatus(PSTATUSINFO pInfo,HWND hWnd)
{
	HDAT hData;
	char *pCurChrData = NULL;
	uint *pCurIntData = NULL;
	unsigned char bitnum;
	if(pInfo == NULL) return;
	if((pInfo->SavedPar.cyctimes== SysInfo.SavedPar.cyctimes) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.cyctimes = SysInfo.SavedPar.cyctimes;
	
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update frequence
		hData = GetDataByInfo(hWnd,STATUS_CYCTIMES);
		pCurChrData = GetDataContent(hData);
		if(SysInfo.SavedPar.cyctimes < 10)
		{
			bitnum = 1;
		}
		else if(SysInfo.SavedPar.cyctimes < 100)
		{
			bitnum = 2;
		}
		else if(SysInfo.SavedPar.cyctimes < 1000)
		{
			bitnum = 3;
		}
		else if(SysInfo.SavedPar.cyctimes < 10000)
		{
			bitnum = 4;
		}
		else if(SysInfo.SavedPar.cyctimes < 100000)
		{
			bitnum = 5;
		}
		else if(SysInfo.SavedPar.cyctimes < 1000000)
		{
			bitnum = 6;
		}
		else if(SysInfo.SavedPar.cyctimes < 10000000)
		{
			bitnum = 7;
		}
		else if(SysInfo.SavedPar.cyctimes < 100000000)
		{
			bitnum = 8;
		}
		else if(SysInfo.SavedPar.cyctimes < 1000000000)
		{
			bitnum = 9;
		}
		else
		{
			bitnum = 10;
		}
		U32ToDecStr(SysInfo.SavedPar.cyctimes, pCurChrData, bitnum);
		*(pCurChrData + bitnum) = '\0';
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		//update frequence
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurIntData = GetDataContent(hData);
		*pCurIntData = SysInfo.SavedPar.cyctimes;
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}

//·ͳ֡
void UpdateOverCountStatus(PSTATUSINFO pInfo,HWND hWnd)
{
	HDAT hData;
	char *pCurChrData = NULL;
	uint *pCurIntData = NULL;
	unsigned char bitnum;
	if(pInfo == NULL) return;
	if((pInfo->SavedPar.overcount== SysInfo.SavedPar.overcount) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.overcount = SysInfo.SavedPar.overcount;
	
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update frequence
		hData = GetDataByInfo(hWnd,STATUS_OVERCOUNT);
		pCurChrData = GetDataContent(hData);
		if(SysInfo.SavedPar.overcount < 10)
		{
			bitnum = 1;
		}
		else if(SysInfo.SavedPar.overcount < 100)
		{
			bitnum = 2;
		}
		else if(SysInfo.SavedPar.overcount < 1000)
		{
			bitnum = 3;
		}
		else if(SysInfo.SavedPar.overcount < 10000)
		{
			bitnum = 4;
		}
		else if(SysInfo.SavedPar.overcount < 100000)
		{
			bitnum = 5;
		}
		else if(SysInfo.SavedPar.overcount < 1000000)
		{
			bitnum = 6;
		}
		else if(SysInfo.SavedPar.overcount < 10000000)
		{
			bitnum = 7;
		}
		else if(SysInfo.SavedPar.overcount < 100000000)
		{
			bitnum = 8;
		}
		else if(SysInfo.SavedPar.overcount < 1000000000)
		{
			bitnum = 9;
		}
		else
		{
			bitnum = 10;
		}
		U32ToDecStr(SysInfo.SavedPar.overcount, pCurChrData, bitnum);
		*(pCurChrData + bitnum) = '\0';
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurIntData = GetDataContent(hData);
		*pCurIntData = SysInfo.SavedPar.overcount;
		UpdataWndData(hWnd, hData);
		hData = GetDataByInfo(hWnd,SET_DATA);
		pCurIntData = GetDataContent(hData);
		*pCurIntData = 0;
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}


//²
void UpdateTestModeStatus(PSTATUSINFO pInfo,HWND hWnd)
{
	HDAT hData;
	char *pCurChrData = NULL;
//	char *pSetChrData = NULL;
//	uint *pCurIntData = NULL;

	if(pInfo == NULL) return;
	if((pInfo->SavedPar.testmode == SysInfo.SavedPar.testmode) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.testmode = SysInfo.SavedPar.testmode;
	
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update frequence
		hData = GetDataByInfo(hWnd,STATUS_TESTMODE);
		pCurChrData = GetDataContent(hData);
		
		if(SysInfo.SavedPar.testmode == 0)
			datacpy(pCurChrData, "", 6);
		else
			datacpy(pCurChrData, "", 6);
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		//
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurChrData = GetDataContent(hData);
		
		if(SysInfo.SavedPar.testmode == 0){
			datacpy(pCurChrData, "", 6);
			}
		else{
			datacpy(pCurChrData, "", 6);
			}
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}



//
void UpdateRadTempStatus(PSTATUSINFO pInfo, HWND hWnd)
{
	HDAT hData;
//	uint i;
	char *pCurChrData = NULL;
	
	if(pInfo == NULL) return;
	if((pInfo->UnsavedInfo.radtemp == SysInfo.UnsavedInfo.radtemp) && (!bFirstInitWnd)) return;
	pInfo->UnsavedInfo.radtemp= SysInfo.UnsavedInfo.radtemp;

	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update snr
		hData = GetDataByInfo(hWnd,STATUS_RADTEMP);
		pCurChrData = GetDataContent(hData);

		IntToDecStr((SysInfo.UnsavedInfo.radtemp*10)/2-400, pCurChrData, 4);	
		if(*(pCurChrData+1) == '0')
		{
			*(pCurChrData+1) = *pCurChrData;
			*pCurChrData = ' ';
		}
		*(pCurChrData+4) = *(pCurChrData+3) ;
		*(pCurChrData+3) = '.';
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}

//ģʽ
void UpdateFillModeStatus(PSTATUSINFO pInfo,HWND hWnd)
{
	HDAT hData;
	char *pCurChrData = NULL;
//	char *pSetChrData = NULL;
//	uint *pCurIntData = NULL;

	if(pInfo == NULL) return;
	if((pInfo->SavedPar.fillmode == SysInfo.SavedPar.fillmode) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.fillmode = SysInfo.SavedPar.fillmode;
	
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update frequence
		hData = GetDataByInfo(hWnd,STATUS_FILLMODE);
		pCurChrData = GetDataContent(hData);
		
		if(SysInfo.SavedPar.fillmode == 0)
			datacpy(pCurChrData, "ѭ", 4);
		else
			datacpy(pCurChrData, "̶", 4);
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		//
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurChrData = GetDataContent(hData);
		
		if(SysInfo.SavedPar.fillmode == 0)
			datacpy(pCurChrData, "ѭ", 4);
		else
			datacpy(pCurChrData, "̶", 4);
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}

//¶
void UpdateDopplerStatus(PSTATUSINFO pInfo,HWND hWnd)
{
	HDAT hData,hData1;
	char *pCurChrData = NULL;
	int *pCurIntData = NULL;
	uchar bit_num;
	if(pInfo == NULL) return;
	if((pInfo->SavedPar.doppler == SysInfo.SavedPar.doppler) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.doppler = SysInfo.SavedPar.doppler;
	
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update frequence
		hData = GetDataByInfo(hWnd,STATUS_DOPPLER);
		pCurChrData = GetDataContent(hData);
		for(bit_num = 0;bit_num < 7;bit_num ++)
			*(pCurChrData + bit_num) = ' ';
		if(fabs(SysInfo.SavedPar.doppler) >= 100000)
			bit_num = 7;
		else if(fabs(SysInfo.SavedPar.doppler) >= 10000)
			bit_num = 6;
		else if(fabs(SysInfo.SavedPar.doppler) >= 1000)
			bit_num = 5;
		else if(fabs(SysInfo.SavedPar.doppler) >= 100)
			bit_num = 4;
		else if(fabs(SysInfo.SavedPar.doppler) >= 10)
			bit_num = 3;
		else
			bit_num = 2;
		IntToDecStr(SysInfo.SavedPar.doppler, pCurChrData, bit_num);
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		//update
		hData1 = GetDataByInfo(hWnd,CUR_DATA1);
		pCurChrData = GetDataContent(hData1);
		
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurIntData = GetDataContent(hData);
		*pCurIntData = SysInfo.SavedPar.doppler;
		if(*pCurIntData <0)
		{
			*pCurIntData = -*pCurIntData;
			*pCurChrData = '-';
		}
		else
		{
			*pCurChrData = ' ';
		}
		//UpdataWndData(hWnd, hData);
		UpdataWndData(hWnd, hData1);
		hData1 = GetDataByInfo(hWnd,SET_DATA1);
		pCurChrData = GetDataContent(hData1);
		*pCurChrData = ' ';
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}


void UpdateDopplerChangeStatus(PSTATUSINFO pInfo,HWND hWnd)
{
	HDAT hData;
	char *pCurChrData = NULL;
//	char *pSetChrData = NULL;
//	uint *pCurIntData = NULL;

	if(pInfo == NULL) return;
	if((pInfo->SavedPar.dcr == SysInfo.SavedPar.dcr) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.dcr = SysInfo.SavedPar.dcr;
	
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update frequence
		hData = GetDataByInfo(hWnd,STATUS_DOPPLERCHANGE);
		pCurChrData = GetDataContent(hData);
		
		if(SysInfo.SavedPar.dcr == 0x01)
			datacpy(pCurChrData, " ̶ ", 6);
		else if(SysInfo.SavedPar.dcr == 0x03)
			datacpy(pCurChrData, "ǲ", 6);
		else if(SysInfo.SavedPar.dcr == 0x05)
			datacpy(pCurChrData, "Ҳ", 6);
		else if(SysInfo.SavedPar.dcr == 0x07)
			datacpy(pCurChrData, "ݲ", 6);
		else
		{
			SysInfo.SavedPar.dcr = 0;
			datacpy(pCurChrData, "    ", 6);
		}
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		//
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurChrData = GetDataContent(hData);
		
		if(SysInfo.SavedPar.dcr == 0x01)
			datacpy(pCurChrData, " ̶ ", 6);
		else if(SysInfo.SavedPar.dcr == 0x03)
			datacpy(pCurChrData, "ǲ", 6);
		else if(SysInfo.SavedPar.dcr == 0x05)
			datacpy(pCurChrData, "Ҳ", 6);
		else if(SysInfo.SavedPar.dcr == 0x07)
			datacpy(pCurChrData, "ݲ", 6);
		else
		{
			SysInfo.SavedPar.dcr = 0;
			datacpy(pCurChrData, "    ", 6);
		}
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}


void UpdateDopplerFreqStatus(PSTATUSINFO pInfo,HWND hWnd)
{
	HDAT hData;
	char *pCurChrData = NULL;
	unsigned char i;
	if(pInfo == NULL) return;
	if((pInfo->SavedPar.dfsr == SysInfo.SavedPar.dfsr) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.dfsr = SysInfo.SavedPar.dfsr;
	
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update frequence
		hData = GetDataByInfo(hWnd,STATUS_DOPPLERFREQ);
		pCurChrData = GetDataContent(hData);
		for(i=0;i<5;i++)
			*(pCurChrData+i) = ' ';
		if(SysInfo.SavedPar.dfsr<0.01)
		{
			U32ToDecStr(SysInfo.SavedPar.dfsr*1000, pCurChrData+4, 1);
			*pCurChrData = '0';
			*(pCurChrData+1) = '.';
			*(pCurChrData+2) = '0';
			*(pCurChrData+3) = '0';
		}
		else if(SysInfo.SavedPar.dfsr<0.1)
		{
			U32ToDecStr(SysInfo.SavedPar.dfsr*1000, pCurChrData+3, 2);
			*(pCurChrData+0) = '0';
			*(pCurChrData+1) = '.';
			*(pCurChrData+2) = '0';
		}
		else if(SysInfo.SavedPar.dfsr<1)
		{
			U32ToDecStr(SysInfo.SavedPar.dfsr*1000, pCurChrData+2, 3);
			*(pCurChrData+0) = '0';
			*(pCurChrData+1) = '.';
		}
		else if(SysInfo.SavedPar.dfsr<10)
		{
			U32ToDecStr(SysInfo.SavedPar.dfsr*1000, pCurChrData, 4);
			*(pCurChrData+4) = *(pCurChrData+3);
			*(pCurChrData+3) = *(pCurChrData+2);
			*(pCurChrData+2) = *(pCurChrData+1);
			*(pCurChrData+1) = '.';
		}
		else if(SysInfo.SavedPar.dfsr<100)
		{
			U32ToDecStr(SysInfo.SavedPar.dfsr*100, pCurChrData, 4);
			*(pCurChrData+4) = *(pCurChrData+3);
			*(pCurChrData+3) = *(pCurChrData+2);
			*(pCurChrData+2) = '.';
		}
		else if(SysInfo.SavedPar.dfsr<1000)
		{
			U32ToDecStr(SysInfo.SavedPar.dfsr*10, pCurChrData, 4);
			*(pCurChrData+4) = *(pCurChrData+3);
			*(pCurChrData+3) = '.';
		}
		else
		{
			U32ToDecStr(SysInfo.SavedPar.dfsr, pCurChrData, 4);
		}
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		//update frequence
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurChrData = GetDataContent(hData);
		for(i=0;i<8;i++)
			*(pCurChrData+i) = ' ';
		if(SysInfo.SavedPar.dfsr<0.01)
		{
			U32ToDecStr(SysInfo.SavedPar.dfsr*1000, pCurChrData+7, 1);
			*(pCurChrData+3) = '0';
			*(pCurChrData+4) = '.';
			*(pCurChrData+5) = '0';
			*(pCurChrData+6) = '0';
		}
		else if(SysInfo.SavedPar.dfsr<0.1)
		{
			U32ToDecStr(SysInfo.SavedPar.dfsr*1000, pCurChrData+6, 2);
			*(pCurChrData+3) = '0';
			*(pCurChrData+4) = '.';
			*(pCurChrData+5) = '0';
		}
		else if(SysInfo.SavedPar.dfsr<1)
		{
			U32ToDecStr(SysInfo.SavedPar.dfsr*1000, pCurChrData+5, 3);
			*(pCurChrData+3) = '0';
			*(pCurChrData+4) = '.';
		}
		else if(SysInfo.SavedPar.dfsr<10)
		{
			U32ToDecStr(SysInfo.SavedPar.dfsr*1000, pCurChrData+4, 4);
			*(pCurChrData+3) = *(pCurChrData+4);
			*(pCurChrData+4) = '.';
		}
		else if(SysInfo.SavedPar.dfsr<100)
		{
			U32ToDecStr(SysInfo.SavedPar.dfsr*1000, pCurChrData+3, 5);
			*(pCurChrData+2) = *(pCurChrData+3);
			*(pCurChrData+3) = *(pCurChrData+4);
			*(pCurChrData+4) = '.';
		}
		else if(SysInfo.SavedPar.dfsr<1000)
		{
			U32ToDecStr(SysInfo.SavedPar.dfsr*10, pCurChrData+2, 6);
			*(pCurChrData+1) = *(pCurChrData+2);
			*(pCurChrData+2) = *(pCurChrData+3);
			*(pCurChrData+3) = *(pCurChrData+4);
			*(pCurChrData+4) = '.';
		}
		else
		{
			U32ToDecStr(SysInfo.SavedPar.dfsr, pCurChrData, 4);
			*(pCurChrData+4) = '.';
			*(pCurChrData+5) = '0';
			*(pCurChrData+6) = '0';
			*(pCurChrData+7) = '0';
		}
		UpdataWndData(hWnd, hData);
		hData = GetDataByInfo(hWnd,SET_DATA);
		pCurChrData = GetDataContent(hData);
		for(i=0;i<8;i++)
			*(pCurChrData+i) = ' ';
		*(pCurChrData+3) = '0';
		*(pCurChrData+4) = '.';
		*(pCurChrData+5) = '0';
		*(pCurChrData+6) = '0';
		*(pCurChrData+7) = '0';
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}

//±IP
void UpdateDevIPStatus(PSTATUSINFO pInfo, HWND hWnd)
{
	HDAT hData;
	Uint8 data,i;
	char *pCurChrData = NULL;
	//uint *pCurIntData = NULL;
	
	if(pInfo == NULL) return;
	if((pInfo->SavedPar.devip== SysInfo.SavedPar.devip) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.devip = SysInfo.SavedPar.devip;
	
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update device ip
		hData = GetDataByInfo(hWnd,STATUS_DEVIP);
		pCurChrData = GetDataContent(hData);

		for(i=0; i<4; i++)
		{
			data = (SysInfo.SavedPar.devip >> (8*i)) & 0xFF;
			U32ToDecStr(data, pCurChrData, 3);
			if(data >= 10){
				if(*pCurChrData == '0')
				{
					*pCurChrData = ' ';
				}	
			}
			else
			{

				*pCurChrData = ' ';
				*(pCurChrData + 1) = *(pCurChrData + 2);
				*(pCurChrData + 2) = ' ';
			}	
			pCurChrData += 4;
		}
		UpdataWndData(hWnd, hData);
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		//update device ip
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurChrData = GetDataContent(hData);

		for(i=0; i<4; i++)
		{
			data = (SysInfo.SavedPar.devip>> (8*i)) & 0xFF;
			U32ToDecStr(data, pCurChrData, 3);
			if(data >= 10){
				if(*pCurChrData == '0')
				{
					*pCurChrData = ' ';
				}	
			}
			else
			{
				*pCurChrData = ' ';
				*(pCurChrData + 1) = *(pCurChrData + 2);
				*(pCurChrData + 2) = ' ';
			}
			pCurChrData += 4;
		}
		UpdataWndData(hWnd, hData);
	}
	else
	{
		return;
	}
}

void UpdateDevMacStatus(PSTATUSINFO pInfo, HWND hWnd)
{
	HDAT hData;
	Uint8 i,j;
	char *pCurChrData = NULL;

	if(pInfo == NULL) return;
	
	for(i=0,j=0;i<6;i++)
	{
		if(pInfo->SavedPar.devmac[i]!= SysInfo.SavedPar.devmac[i])
		{
			pInfo->SavedPar.devmac[i] = SysInfo.SavedPar.devmac[i];
			j++;
		}
	}
	if((j == 0) && (!bFirstInitWnd)) return;

	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update device mac
		hData = GetDataByInfo(hWnd,STATUS_DEVMAC);
		pCurChrData = GetDataContent(hData);
		for(i=0;i<6;i++)
		{
			U8ToHexStr(SysInfo.SavedPar.devmac[i], pCurChrData);
			pCurChrData += 3;
		}
		UpdataWndData(hWnd, hData);
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurChrData = GetDataContent(hData);
		for(i=0;i<6;i++)
		{
			U8ToHexStr(SysInfo.SavedPar.devmac[i], pCurChrData);
			pCurChrData += 3;
		}
		UpdataWndData(hWnd, hData);
		hData = GetDataByInfo(hWnd,SET_DATA);
		pCurChrData = GetDataContent(hData);
		for(i=0;i<6;i++)
		{
			U8ToHexStr(SysInfo.SavedPar.devmac[i], pCurChrData);
			pCurChrData += 3;
		}
		UpdataWndData(hWnd, hData);
	}
	else
	{
		return;
	}
	
}


void UpdateDevPortStatus(PSTATUSINFO pInfo, HWND hWnd)
{
	HDAT hData;
	char *pCurChrData = NULL;
	uint *pCurIntData = NULL;

	if(pInfo == NULL) return;
	if((pInfo->SavedPar.devport == SysInfo.SavedPar.devport) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.devport = SysInfo.SavedPar.devport;
	
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update host port
		hData = GetDataByInfo(hWnd,STATUS_DEVPORT);
		pCurChrData = GetDataContent(hData);
		
		U32ToDecStr(SysInfo.SavedPar.devport, pCurChrData, 5);
		if(*pCurChrData == '0')
		{
			*pCurChrData = ' ';
			if(*(pCurChrData+1) == '0')
			{
				*(pCurChrData+1) = ' ';
				if(*(pCurChrData+2) == '0')
				{
					*(pCurChrData+2) = ' ';
					if(*(pCurChrData+3) == '0')
					{
						*(pCurChrData+3) = ' ';
					}
				}
			}
		}
	}
	else if(pInfo == (&SetWndLastSysInfo))
	{
		//update host port
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurIntData = GetDataContent(hData);
		*pCurIntData = SysInfo.SavedPar.devport;
		//UpdataWndData(hWnd, hData);
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}

void UpdateLinkStatus(PSTATUSINFO pInfo, HWND hWnd)
{
	HDAT hData;
	char *pCurChrData = NULL;
	if(pInfo == NULL) return;
	if((pInfo->UnsavedInfo.LinkStatus== SysInfo.UnsavedInfo.LinkStatus) && (!bFirstInitWnd)) return;
	pInfo->UnsavedInfo.LinkStatus = SysInfo.UnsavedInfo.LinkStatus;
	
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		hData = GetDataByInfo(hWnd,STATUS_LINK);
		pCurChrData = GetDataContent(hData);
		
		if(SysInfo.UnsavedInfo.LinkStatus == 0)
		{
			datacpy(pCurChrData, "δ", 6);
		}
		else
		{
			datacpy(pCurChrData, "", 6);
		}
		UpdataWndData(hWnd, hData);

		hData = GetDataByInfo(hWnd,STATUS_NETSPEED);
		pCurChrData = GetDataContent(hData);
		
		if(SysInfo.UnsavedInfo.LinkStatus == 0)
		{
			datacpy(pCurChrData, "No link", 7);
		}
		else if(SysInfo.UnsavedInfo.LinkStatus == 1|| SysInfo.UnsavedInfo.LinkStatus == 2)
		{
			datacpy(pCurChrData, "10Mbps", 7);
		}
		else if(SysInfo.UnsavedInfo.LinkStatus == 3 || SysInfo.UnsavedInfo.LinkStatus == 4)
		{
			datacpy(pCurChrData, "100Mbps", 7);
		}
		else
		{
			datacpy(pCurChrData, "1Gbps  ", 7);
		}
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}



void UpdateModeEdtionStatus(PSTATUSINFO pInfo, HWND hWnd)
{
	HDAT hData;
	char *pCurChrData = NULL;
	//uint *pCurIntData = NULL;

	if(pInfo == NULL) return;
	if((pInfo->SavedPar.uver== SysInfo.SavedPar.uver) && (!bFirstInitWnd)) return;
	pInfo->SavedPar.uver = SysInfo.SavedPar.uver;
	
	if(pInfo == (&StsWndLastSysInfo1) ||pInfo == (&StsWndLastSysInfo2) ||pInfo == (&StsWndLastSysInfo3))
	{
		//update host port
		hData = GetDataByInfo(hWnd,STATUS_MODEEDTION);
		pCurChrData = GetDataContent(hData);
		
		U32ToDecStr(SysInfo.SavedPar.uver, pCurChrData, 5);
		if(*pCurChrData == '0')
		{
			*pCurChrData = ' ';
			if(*(pCurChrData+1) == '0')
			{
				*(pCurChrData+1) = ' ';
				if(*(pCurChrData+2) == '0')
				{
					*(pCurChrData+2) = ' ';
					if(*(pCurChrData+3) == '0')
					{
						*(pCurChrData+3) = ' ';
					}
				}
			}
		}
	}
	else
	{
		return;
	}
	UpdataWndData(hWnd, hData);
}

void Hook_EnterWnd(uint uWnd)
{
	HWND hWnd;
	int timerID;
	uint wndname;
	//HDAT hData;
	//uint *pSetIntData = NULL;
	//REGION region;
	//POSITION posleft,posright;
	
	//hWnd = GetWndByIdentity(STATUSWND1);
	hWnd = (HWND)uWnd;
	GetWndIdentity(hWnd, &wndname);
	switch (wndname)
	{
		case DEVINIT_WND:
			break;
		case OVERTAKEWND:
			//UpdateOverIDStatus(&StsWndLastSysInfo1,hWnd);
			//UpdateFreqStatus(&StsWndLastSysInfo1,hWnd);
			UpdateBWStatus(&StsWndLastSysInfo1,hWnd);
			UpdateSnrStatus(&StsWndLastSysInfo1,hWnd);
			//UpdateVoltStatus(&StsWndLastSysInfo1,hWnd);
			UpdateFillDataStatus(&StsWndLastSysInfo1,hWnd);
			UpdateFillModeStatus(&StsWndLastSysInfo1,hWnd);
			UpdateTestModeStatus(&StsWndLastSysInfo1,hWnd);
			UpdateCycCountStatus(&StsWndLastSysInfo1,hWnd);
			//UpdateDopplerStatus(&StsWndLastSysInfo1,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case BASEWND:
			UpdateOverIDStatus(&StsWndLastSysInfo2,hWnd);
			//UpdateFreqStatus(&StsWndLastSysInfo2,hWnd);
			UpdateBWStatus(&StsWndLastSysInfo2,hWnd);
			UpdateSnrStatus(&StsWndLastSysInfo2,hWnd);
			UpdateAddNoiseModeStatus(&StsWndLastSysInfo2,hWnd);
			//UpdateVoltStatus(&StsWndLastSysInfo2,hWnd);
			UpdateFillDataStatus(&StsWndLastSysInfo2,hWnd);
			UpdateFillModeStatus(&StsWndLastSysInfo2,hWnd);
			UpdateTestModeStatus(&StsWndLastSysInfo2,hWnd);
			UpdateOverCountStatus(&StsWndLastSysInfo2,hWnd);
			//UpdateDopplerStatus(&StsWndLastSysInfo2,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case RADPARWND:
			//UpdateOverIDStatus(&StsWndLastSysInfo3,hWnd);
			UpdateFreqStatus(&StsWndLastSysInfo3,hWnd);
			//UpdateBWStatus(&StsWndLastSysInfo3,hWnd);
			//UpdateSnrStatus(&StsWndLastSysInfo3,hWnd);
			UpdateVoltStatus(&StsWndLastSysInfo3,hWnd);
			UpdateOutSwitchStatus(&StsWndLastSysInfo3,hWnd);
			UpdateMSwitchStatus(&StsWndLastSysInfo3,hWnd);
			UpdateRadTempStatus(&StsWndLastSysInfo3,hWnd);
			UpdateDopplerStatus(&StsWndLastSysInfo3,hWnd);
			UpdateDopplerChangeStatus(&StsWndLastSysInfo3,hWnd);
			UpdateDopplerFreqStatus(&StsWndLastSysInfo3,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case LOCALPARWND:
			UpdateDevIPStatus(&StsWndLastSysInfo1,hWnd);
			UpdateDevMacStatus(&StsWndLastSysInfo1,hWnd);
			UpdateDevPortStatus(&StsWndLastSysInfo1,hWnd);
			UpdateLinkStatus(&StsWndLastSysInfo1,hWnd);
			UpdateModeEdtionStatus(&StsWndLastSysInfo1,hWnd);
			UpdateOffsetFreqStatus(&StsWndLastSysInfo1,hWnd);
			UpdateOffsetVoltStatus(&StsWndLastSysInfo1,hWnd);
			UpdateOffsetSnrStatus(&StsWndLastSysInfo1,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SAVEPARWND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SAVEMENUWND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case WORKSTATUS:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case NETSWND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_OVERID_WND:
			UpdateOverIDStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_FREQ_WND:
			UpdateFreqStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_OFFSETFREQ_WND:
			UpdateOffsetFreqStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_BW_WND:
			UpdateBWStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_SNR_WND:
			UpdateSnrStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_OFFSETSNR_WND:
			UpdateOffsetSnrStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_ADDNOISE_WND:
			UpdateAddNoiseModeStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_VOLT_WND:
			UpdateVoltStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_OFFSETVOLT_WND:
			UpdateOffsetVoltStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_FILLDATA_WND:
			UpdateFillDataStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_SENDCOUNT_WND:
			UpdateCycCountStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_OVERCOUNT_WND:
			UpdateOverCountStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_FILLMODE_WND:
			UpdateFillModeStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_OUTSWITCH_WND:
			UpdateOutSwitchStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_MSWITCH_WND:
			UpdateMSwitchStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_TESTMODE_WND:
			UpdateTestModeStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_DOPPLER_WND:
			UpdateDopplerStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_DOPPLERFREQ_WND:
			UpdateDopplerFreqStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_DOPPLERCHANGE_WND:
			UpdateDopplerChangeStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_DEVIP_WND:
			UpdateDevIPStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;
		case SET_DEVPORT_WND:
			UpdateDevPortStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;

		case SET_DEVMAC_WND:
			UpdateDevMacStatus(&SetWndLastSysInfo,hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				EnableWndTimer(hWnd, timerID);
			}
			break;

		
		/*case SAVE_CFG_WND:
			region.sRow = 24;
			region.sCol = 12;
			region.eRow = 39;
			region.eCol = 147;
			SetWndRegionText(hWnd, region, (tchar *)"ȷϱò?");
			break;
		case SET_RESET_WND:
			break;*/
		default:
			break;
	}
}

void Hook_ExitWnd(uint uWnd)
{
	HWND hWnd;
	int timerID;
	uint wndname;
	uint iFcsAdd;
	//hWnd = GetWndByIdentity(STATUSWND1);
	hWnd = (HWND)uWnd;
	GetWndIdentity(hWnd, &wndname);
	switch (wndname)
	{
		case OVERTAKEWND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case BASEWND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case RADPARWND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case LOCALPARWND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SAVEPARWND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SAVEMENUWND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case WORKSTATUS:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}
			break;
		case SET_OVERID_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_FREQ_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_OFFSETFREQ_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_BW_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_SNR_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_OFFSETSNR_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_ADDNOISE_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_VOLT_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_OFFSETVOLT_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_FILLDATA_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_SENDCOUNT_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_OVERCOUNT_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_FILLMODE_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_OUTSWITCH_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_MSWITCH_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_TESTMODE_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_DOPPLER_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_DOPPLERFREQ_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_DOPPLERCHANGE_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_DEVIP_WND:
			GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
			switch (iFcsAdd>>16)
			{
				case 2:
					SetLastFocus(hWnd);
					break;
				case 3:
					SetNextFocus(hWnd);
					SetNextFocus(hWnd);
					break;
				case 4:
					SetNextFocus(hWnd);
					break;
				default:
					break;
			}
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_DEVMAC_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;
		case SET_DEVPORT_WND:
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}	
			break;

		default:
			break;
	}
}
void stopwork()
{
	HDAT hData;
	char *pChrData = NULL;
	workflag = 0;
	StopDataGen();
	SetWndColor(GetWndByIdentity(WORKSTATUS),0xF800);
	hData = GetDataByInfo(GetWndByIdentity(WORKSTATUS),WORKSTATUSDATA);
	pChrData = GetDataContent(hData);
	datacpy(pChrData, "ʼ", 8);
	UpdataWndData(GetWndByIdentity(WORKSTATUS), hData);
	eraseWndFocus(GetWndByIdentity(WORKSTATUS));
}
void startwork()
{
	HDAT hData;
	char *pChrData = NULL;
	unsigned int cellNum = 0;
	unsigned char pFrmNum[64];
	unsigned char pFrmcount = 0;
	unsigned int count;
	unsigned char i;
	uint iFcsAdd;
	
	workflag = 1;
	GetFocusData(GetCurrentFocus(GetWndByIdentity(MAINSETWINDOW)), &iFcsAdd);
	if(iFcsAdd >> 16 == 1)
	{
		for(i=0;i<64;i++)
		{
			if(frameArea[i].xAreaCellNum != 0 || frameArea[i].yAreaCellNum != 0)
			{
				pFrmNum[pFrmcount] = i;
				pFrmcount += 1;
			}
		}
		count = SysInfo.SavedPar.cyctimes;
	}
	else if(iFcsAdd >> 16 == 2)
	{
		count = SysInfo.SavedPar.overcount;
		if(frameArea[SysInfo.SavedPar.overID-1].xAreaCellNum != 0 || frameArea[SysInfo.SavedPar.overID-1].yAreaCellNum != 0)
		{
			pFrmNum[0] = SysInfo.SavedPar.overID-1;
			pFrmcount = 1;
		}
		else
		{
			return ;
		}
	}
	else
	{}
	SetWndColor(GetWndByIdentity(WORKSTATUS),0x07C0);
	hData = GetDataByInfo(GetWndByIdentity(WORKSTATUS),WORKSTATUSDATA);
	pChrData = GetDataContent(hData);
	datacpy(pChrData, "ֹͣ", 8);
	UpdataWndData(GetWndByIdentity(WORKSTATUS), hData);
	if(SetDataGenInfo(count, 
					SysInfo.SavedPar.testmode, 
					MakeFillModeInfo(SysInfo.SavedPar.fillmode,SysInfo.SavedPar.filldata), 
					pFrmNum, 
					pFrmcount, 
					&cellNum))
	{
		RestartDataGen();
	}
	
}

int SetOverIDWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	REGION region,region_image;
	uint *pSetIntData = NULL;
	uint *pCurIntData = NULL;
	Uint8 tempoverID;
	hWnd = (HWND)uWnd;
	if(_evtType(curMsg) == EVENT_KEY)
	{
		region.sRow = 102;
		region.sCol = 74;
		region.eRow = 125;
		region.eCol = 193;
		region_image.sRow = 102;
		region_image.sCol = 42;
		region_image.eRow = 125;
		region_image.eCol = 65;
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		
		keyvalue = GetKeyValue(curMsg);
		hData = GetDataByInfo(hWnd, iFcsAdd & 0xFFFF);
		pSetIntData = GetDataContent(hData);
		switch(keyvalue)
		{
			
			case NUM0_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10;
				UpdataWndData(hWnd, hData);
				break;
			case NUM1_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+1;
				UpdataWndData(hWnd, hData);
				break;
			case NUM2_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+2;
				UpdataWndData(hWnd, hData);
				break;
			case NUM3_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+3;
				UpdataWndData(hWnd, hData);
				break;
			case NUM4_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+4;
				UpdataWndData(hWnd, hData);
				break;
			case NUM5_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+5;
				UpdataWndData(hWnd, hData);
				break;
			case NUM6_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+6;
				UpdataWndData(hWnd, hData);
				break;
			case NUM7_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+7;
				UpdataWndData(hWnd, hData);
				break;
			case NUM8_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+8;
				UpdataWndData(hWnd, hData);
				break;
			case NUM9_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+9;
				UpdataWndData(hWnd, hData);
				break;
			case UP_KEY_ACTIVE:
				*pSetIntData = *pSetIntData+1;
				UpdataWndData(hWnd, hData);
				break;
			case DOWN_KEY_ACTIVE:
				*pSetIntData = *pSetIntData-1;
				UpdataWndData(hWnd, hData);
				break;
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,CUR_DATA);
				pCurIntData = GetDataContent(hData);

				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetIntData = GetDataContent(hData);
					
				if(*pCurIntData == *pSetIntData) 
				{	
					CancelKeyChangeWnd(hWnd);
					*pSetIntData = 0;
					return 0;//no change ,return	
				}
				
				if(frameArea[(*pSetIntData & 0xFF)-1].xAreaCellNum == 0 && frameArea[(*pSetIntData & 0xFF)-1].yAreaCellNum == 0)
				{
					SetWndRegionText(hWnd, region, (tchar *)"Ч֡");
					DrawWndRegion(hWnd,region_image,(UINT16 *)gImage_error,1);
					*pSetIntData = 0;
					UpdataWndData(hWnd, hData);
					return 0;
				}
				SysInfo.SavedPar.overID= *pSetIntData & 0xFF;
				stopwork();
				tempoverID = SysInfo.SavedPar.overID-1;
				InsertFrame(tempoverID);
				CancelKeyChangeWnd(hWnd);
				*pSetIntData = 0;
				return 0;
			case CANCEL_KEY_ACTIVE:
				if(*pSetIntData !=0)
				{
					*pSetIntData = 0;
					UpdataWndData(hWnd, hData);
					ResetWndRegionContent(hWnd, region);
					ResetWndRegionContent(hWnd, region_image);
					break;
				}
				else
				{
					CancelKeyChangeWnd(hWnd);
					return 0;
				}
			default:
				break;
		}

		if((*pSetIntData > 64)||(*pSetIntData < 1))
		{
			if(*pSetIntData != 0)
			{
				SetWndRegionText(hWnd, region, (tchar *)" Χ! ");
				DrawWndRegion(hWnd,region_image,(UINT16 *)gImage_error,1);
				*pSetIntData = 0;
				UpdataWndData(hWnd, hData);
				return 0;
			}
		}
		else
		{
			ResetWndRegionContent(hWnd, region);
			ResetWndRegionContent(hWnd, region_image);
		}
	}
	if(_evtType(curMsg) == EVENT_PRD)
	{
		drawWndFocus(hWnd);
	}
	return 0;
}

int SetFrqWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	uint *pSetIntData = NULL;
	uint *pCurIntData = NULL;
	uint temp_u32;
	REGION region,region_image;
	Uint8 InitCMD[16] = {0xFE,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFA};
	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{	
		region.sRow = 102;
		region.sCol = 74;
		region.eRow = 125;
		region.eCol = 181;
		region_image.sRow = 102;
		region_image.sCol = 42;
		region_image.eRow = 125;
		region_image.eCol = 65;
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		
		keyvalue = GetKeyValue(curMsg);
		hData = GetDataByInfo(hWnd, iFcsAdd & 0xFFFF);
		pSetIntData = GetDataContent(hData);
		switch(keyvalue)
		{
			case NUM0_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10;
				UpdataWndData(hWnd, hData);
				break;
			case NUM1_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+1;
				UpdataWndData(hWnd, hData);
				break;
			case NUM2_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+2;
				UpdataWndData(hWnd, hData);
				break;
			case NUM3_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+3;
				UpdataWndData(hWnd, hData);
				break;
			case NUM4_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+4;
				UpdataWndData(hWnd, hData);
				break;
			case NUM5_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+5;
				UpdataWndData(hWnd, hData);
				break;
			case NUM6_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+6;
				UpdataWndData(hWnd, hData);
				break;
			case NUM7_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+7;
				UpdataWndData(hWnd, hData);
				break;
			case NUM8_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+8;
				UpdataWndData(hWnd, hData);
				break;
			case NUM9_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+9;
				UpdataWndData(hWnd, hData);
				break;
			case DOWN_KEY_ACTIVE:
				break;
			case UP_KEY_ACTIVE:
				break;
			case LEFT_KEY_ACTIVE:
				break;
			case RIGHT_KEY_ACTIVE:
				break;
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,CUR_DATA);
				pCurIntData = GetDataContent(hData);
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetIntData = GetDataContent(hData);
				if(*pSetIntData < LOWER_LIMIT_FREQ)
				{
					SetWndRegionText(hWnd, region, (tchar *)"Χ!");
					DrawWndRegion(hWnd,region_image,(UINT16 *)gImage_error,1);
					*pSetIntData = 0;
					UpdataWndData(hWnd, hData);
					return 0;
				}
				if(*pCurIntData == *pSetIntData) 
				{
					CancelKeyChangeWnd(hWnd);
					*pSetIntData = 0;
					return 0;//Ƚ
				}
				stopwork();
				SysInfo.SavedPar.freq = *pSetIntData;
				if(SysInfo.SavedPar.mswitch)
					*pSetIntData = (*pSetIntData-100) * 10;
				else
					*pSetIntData = *pSetIntData * 10;
				InitCMD[2] = CMD_TYPE_FREQ;
				InitCMD[3] = 0x04;
				InitCMD[4] = (*pSetIntData) & 0xFF;
				InitCMD[5] = ((*pSetIntData) >> 8) & 0xFF;
				InitCMD[6] = ((*pSetIntData) >> 16) & 0xFF;
				InitCMD[7] = ((*pSetIntData) >> 24) & 0xFF;
				SendCommand(RAD_UART, InitCMD);
				calculateDeltaFreq(SysInfo.SavedPar.freq,&temp_u32);//Ƶƫ
				g_pBaseRegs->DFCR = temp_u32 & 0x7FFF;
				g_pBaseRegs->DFCR = ((temp_u32 >>15 )& 0x7FFF) | 0x8000;
				CancelKeyChangeWnd(hWnd);
				*pSetIntData = 0;
				return 0;
			case CANCEL_KEY_ACTIVE:
				if(*pSetIntData != 0)
				{
					*pSetIntData = 0;
					UpdataWndData(hWnd, hData);
					break;
				}
				else
				{
					CancelKeyChangeWnd(hWnd);
					return 0;
				}
			default:
				break;
		}

		if(*pSetIntData > UPPER_LIMIT_FREQ || (*pSetIntData>1450000 && *pSetIntData < 2500000))
		{
			SetWndRegionText(hWnd, region, (tchar *)"Χ!");
			DrawWndRegion(hWnd,region_image,(UINT16 *)gImage_error,1);
			*pSetIntData = 0;
			UpdataWndData(hWnd, hData);
			return 0;
		}
		else
		{
			ResetWndRegionContent(hWnd, region);
			ResetWndRegionContent(hWnd, region_image);
		}
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}

int SetOffsetFreqWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
//	uint wndname;
	uint *pSetIntData = NULL;
	uint *pCurIntData = NULL;
	Uint8 InitCMD[16] = {0xFE,0x61,0x61,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFA};
	//REGION region,region_image;
	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		
		keyvalue = GetKeyValue(curMsg);
		hData = GetDataByInfo(hWnd, iFcsAdd & 0xFFFF);
		pSetIntData = GetDataContent(hData);
		switch(keyvalue)
		{
			case NUM0_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10;
				UpdataWndData(hWnd, hData);
				break;
			case NUM1_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+1;
				UpdataWndData(hWnd, hData);
				break;
			case NUM2_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+2;
				UpdataWndData(hWnd, hData);
				break;
			case NUM3_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+3;
				UpdataWndData(hWnd, hData);
				break;
			case NUM4_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+4;
				UpdataWndData(hWnd, hData);
				break;
			case NUM5_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+5;
				UpdataWndData(hWnd, hData);
				break;
			case NUM6_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+6;
				UpdataWndData(hWnd, hData);
				break;
			case NUM7_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+7;
				UpdataWndData(hWnd, hData);
				break;
			case NUM8_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+8;
				UpdataWndData(hWnd, hData);
				break;
			case NUM9_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+9;
				UpdataWndData(hWnd, hData);
				break;
			case DOWN_KEY_ACTIVE:
				*pSetIntData = *pSetIntData-1;
				UpdataWndData(hWnd, hData);
				break;
			case UP_KEY_ACTIVE:
				*pSetIntData = *pSetIntData+1;
				UpdataWndData(hWnd, hData);
				break;
			case LEFT_KEY_ACTIVE:
				break;
			case RIGHT_KEY_ACTIVE:
				break;
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetIntData = GetDataContent(hData);
				hData = GetDataByInfo(hWnd,CUR_DATA);
				pCurIntData = GetDataContent(hData);
				if(*pCurIntData == *pSetIntData) 
				{
					CancelKeyChangeWnd(hWnd);
					*pSetIntData = 0;
					return 0;//Ƚ
				}
				SysInfo.SavedPar.offsetfreq = *pSetIntData;
				InitCMD[4] = SysInfo.SavedPar.offsetfreq&0xFF;
				InitCMD[5] = SysInfo.SavedPar.offsetfreq >>8 & 0xFF;
				SendCommand(RAD_UART, InitCMD);
				CancelKeyChangeWnd(hWnd);
				*pSetIntData = 0;
				break;
			case CANCEL_KEY_ACTIVE:
				if(*pSetIntData != 0)
				{
					*pSetIntData = 0;
					UpdataWndData(hWnd, hData);
				}
					
				else
				{
					CancelKeyChangeWnd(hWnd);
				}
				break;
			default:
				break;
		}
		
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}


int SetBWWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	REGION region,region_image;
	char *pSetChrData = NULL;
	char *pCurChrData = NULL;
//	unsigned short fs,fn;
	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{
		region.sRow = 102;
		region.sCol = 74;
		region.eRow = 125;
		region.eCol = 181;
		region_image.sRow = 102;
		region_image.sCol = 42;
		region_image.eRow = 125;
		region_image.eCol = 65;
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		keyvalue = GetKeyValue(curMsg);
		hData = GetDataByInfo(hWnd, iFcsAdd & 0xFFFF);
		pSetChrData = GetDataContent(hData);
		switch(keyvalue)
		{
			case NUM0_KEY_ACTIVE:
				*pSetChrData = *pSetChrData*10;
				UpdataWndData(hWnd, hData);
				break;
			case NUM1_KEY_ACTIVE:
				*pSetChrData = *pSetChrData*10+1;
				UpdataWndData(hWnd, hData);
				break;
			case NUM2_KEY_ACTIVE:
				*pSetChrData = *pSetChrData*10+2;
				UpdataWndData(hWnd, hData);
				break;
			case NUM3_KEY_ACTIVE:
				*pSetChrData = *pSetChrData*10+3;
				UpdataWndData(hWnd, hData);
				break;
			case NUM4_KEY_ACTIVE:
				*pSetChrData = *pSetChrData*10+4;
				UpdataWndData(hWnd, hData);
				break;
			case NUM5_KEY_ACTIVE:
				*pSetChrData = *pSetChrData*10+5;
				UpdataWndData(hWnd, hData);
				break;
			case NUM6_KEY_ACTIVE:
				*pSetChrData = *pSetChrData*10+6;
				UpdataWndData(hWnd, hData);
				break;
			case NUM7_KEY_ACTIVE:
				*pSetChrData = *pSetChrData*10+7;
				UpdataWndData(hWnd, hData);
				break;
			case NUM8_KEY_ACTIVE:
				*pSetChrData = *pSetChrData*10+8;
				UpdataWndData(hWnd, hData);
				break;
			case NUM9_KEY_ACTIVE:
				*pSetChrData = *pSetChrData*10+9;
				UpdataWndData(hWnd, hData);
				break;
			case UP_KEY_ACTIVE:
				hData = GetDataByInfo(hWnd, SET_DATA);
				pSetChrData = GetDataContent(hData);
				
				if(*pSetChrData == 9)
				{
					*pSetChrData = 12;
				}
				else if(*pSetChrData == 12)
				{
					*pSetChrData = 18;
				}
				else if(*pSetChrData == 18)
				{
					*pSetChrData = 36;
				}
				else
				{
					*pSetChrData = 9;
				}
				
				UpdataWndData(hWnd, hData);
				break;
			case DOWN_KEY_ACTIVE:
				hData = GetDataByInfo(hWnd, SET_DATA);
				pSetChrData = GetDataContent(hData);

				if(*pSetChrData == 9)
				{
					*pSetChrData = 36;
				}
				else if(*pSetChrData == 12)
				{
					*pSetChrData = 9;
				}
				else if(*pSetChrData == 18)
				{
					*pSetChrData = 12;
				}
				else
				{
					*pSetChrData = 18;
				}

				UpdataWndData(hWnd, hData);
				break;
				
			case LEFT_KEY_ACTIVE:	
				CancelKeyChangeWnd(hWnd);
				*pSetChrData = 0;
				break;
				
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,CUR_DATA);
				pCurChrData = GetDataContent(hData);
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetChrData = GetDataContent(hData);

				if(*pCurChrData == *pSetChrData) 
				{
					CancelKeyChangeWnd(hWnd);
					*pSetChrData = 0;
					return 0;
				}
				stopwork();
				if(*pSetChrData == 9)
				{
					g_pBaseRegs->BWCR = BANDWIDTH_9MHZ;
					SysInfo.SavedPar.bandwidth = 9;
				}
				else if(*pSetChrData == 12)
				{
					g_pBaseRegs->BWCR = BANDWIDTH_12MHZ;
					SysInfo.SavedPar.bandwidth = 12;		
				}
				else if(*pSetChrData == 18)
				{
					g_pBaseRegs->BWCR = BANDWIDTH_18MHZ;
					SysInfo.SavedPar.bandwidth = 18;		
				}
				else
				{
					g_pBaseRegs->BWCR = BANDWIDTH_36MHZ;
					SysInfo.SavedPar.bandwidth = 36;
				}
				SetSnr();
				CancelKeyChangeWnd(hWnd);
				*pSetChrData = 0;
				return 0;
			case CANCEL_KEY_ACTIVE:
				if(*pSetChrData == 0)
				{
					CancelKeyChangeWnd(hWnd);
					return 0;
				}
				else
				{
					*pSetChrData = 0;
					break;
				}
				
			default:
				break;
		}
		if((*pSetChrData<10))
		{
			if((*pSetChrData!=1)&&(*pSetChrData!=3)&&(*pSetChrData!=9))
			{
				SetWndRegionText(hWnd, region, (tchar *)"Χ!");
				DrawWndRegion(hWnd,region_image,(UINT16 *)gImage_error,1);
				*pSetChrData = 0;
				UpdataWndData(hWnd, hData);
				return 0;
			}
			else
			{
				ResetWndRegionContent(hWnd, region);
				ResetWndRegionContent(hWnd, region_image);
			}
		}
		else if((*pSetChrData!=12)&&(*pSetChrData!=18)&&(*pSetChrData!=36) )
		{
			SetWndRegionText(hWnd, region, (tchar *)"Χ!");
			DrawWndRegion(hWnd,region_image,(UINT16 *)gImage_error,1);
			*pSetChrData = 0;
			UpdataWndData(hWnd, hData);
			return 0;
		}
		else
		{
			ResetWndRegionContent(hWnd, region);
		}
	}	
	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}

int SetSnrWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	Int16 snrdata;
  //	Uint16 fs,fn;
	char *pSetChrData = NULL;
	char *pCurChrData = NULL;
	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		
		keyvalue = GetKeyValue(curMsg);
		hData = GetDataByInfo(hWnd, iFcsAdd & 0xFFFF);
		pSetChrData = GetDataContent(hData);
		snrdata = (*(pSetChrData+1)-0x30) * 100 + (*(pSetChrData+2)-0x30) * 10 + *(pSetChrData+4)-0x30;
		switch(keyvalue)
		{
			case NUM0_KEY_ACTIVE:
				snrdata = snrdata * 10;
				break;
			case NUM1_KEY_ACTIVE:
				snrdata = snrdata * 10+1;
				break;
			case NUM2_KEY_ACTIVE:
				snrdata = snrdata * 10+2;
				break;
			case NUM3_KEY_ACTIVE:
				snrdata = snrdata * 10+3;
				break;
			case NUM4_KEY_ACTIVE:
				snrdata = snrdata * 10+4;
				break;
			case NUM5_KEY_ACTIVE:
				snrdata = snrdata * 10+5;
				break;
			case NUM6_KEY_ACTIVE:
				snrdata = snrdata * 10+6;
				break;
			case NUM7_KEY_ACTIVE:
				snrdata = snrdata * 10+7;
				break;
			case NUM8_KEY_ACTIVE:
				snrdata = snrdata * 10+8;
				break;
			case NUM9_KEY_ACTIVE:
				snrdata = snrdata * 10+9;
				break;
			case DOWN_KEY_ACTIVE:
			case UP_KEY_ACTIVE:
				if(*pSetChrData == '-')
					*pSetChrData = ' ';
				else
					*pSetChrData = '-';
				break;
			case LEFT_KEY_ACTIVE:
				break;
			case RIGHT_KEY_ACTIVE:
				break;
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,CUR_DATA);
				pCurChrData = GetDataContent(hData);
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetChrData = GetDataContent(hData);
				
				if(*pSetChrData == *pCurChrData &&
				   *(pSetChrData +1) == *(pCurChrData +1) &&
				   *(pSetChrData +2) == *(pCurChrData +2) &&
				   *(pSetChrData +4) == *(pCurChrData +4)) 
				{
					CancelKeyChangeWnd(hWnd);
					*(pSetChrData+0) = '-';  
					*(pSetChrData+1) = '0'; 
					*(pSetChrData+2) = '0'; 
					*(pSetChrData+3) = '.'; 
					*(pSetChrData+4) = '0'; 
					return 0;
				}
				if(*pSetChrData == '-')
					snrdata = -snrdata;
				SysInfo.SavedPar.snr = snrdata;
				stopwork();
				SetSnr();
				CancelKeyChangeWnd(hWnd);
				*(pSetChrData+0) = '-';  
				*(pSetChrData+1) = '0'; 
				*(pSetChrData+2) = '0'; 
				*(pSetChrData+3) = '.'; 
				*(pSetChrData+4) = '0'; 
				return 0;
				//break;
			case CANCEL_KEY_ACTIVE:
				if(snrdata == 0)
				{
					CancelKeyChangeWnd(hWnd);
					return 0;
				}
				else
				{ 
					snrdata = 0;
					break;
				}
				//break;
			default:
				break;
		}
		if(*pSetChrData == '-')
			snrdata = -snrdata;
		IntToDecStr(snrdata, pSetChrData, 4);	
		*(pSetChrData+4) = *(pSetChrData+3) ;
		*(pSetChrData+3) = '.';
		UpdataWndData(hWnd, hData);
		
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}


int SetOffsetSnrWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	Int16 snrdata;
	//Uint16 fs,fn;
	char *pSetChrData = NULL;
	char *pCurChrData = NULL;
	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		
		keyvalue = GetKeyValue(curMsg);
		hData = GetDataByInfo(hWnd, iFcsAdd & 0xFFFF);
		pSetChrData = GetDataContent(hData);
		snrdata = (*(pSetChrData+1)-0x30) * 100 + (*(pSetChrData+2)-0x30) * 10 + *(pSetChrData+4)-0x30;
		switch(keyvalue)
		{
			case NUM0_KEY_ACTIVE:
				snrdata = snrdata * 10;
				break;
			case NUM1_KEY_ACTIVE:
				snrdata = snrdata * 10+1;
				break;
			case NUM2_KEY_ACTIVE:
				snrdata = snrdata * 10+2;
				break;
			case NUM3_KEY_ACTIVE:
				snrdata = snrdata * 10+3;
				break;
			case NUM4_KEY_ACTIVE:
				snrdata = snrdata * 10+4;
				break;
			case NUM5_KEY_ACTIVE:
				snrdata = snrdata * 10+5;
				break;
			case NUM6_KEY_ACTIVE:
				snrdata = snrdata * 10+6;
				break;
			case NUM7_KEY_ACTIVE:
				snrdata = snrdata * 10+7;
				break;
			case NUM8_KEY_ACTIVE:
				snrdata = snrdata * 10+8;
				break;
			case NUM9_KEY_ACTIVE:
				snrdata = snrdata * 10+9;
				break;
			case DOWN_KEY_ACTIVE:
			case UP_KEY_ACTIVE:
				if(*pSetChrData == '-')
					*pSetChrData = ' ';
				else
					*pSetChrData = '-';
				break;
			case LEFT_KEY_ACTIVE:
				break;
			case RIGHT_KEY_ACTIVE:
				break;
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,CUR_DATA);
				pCurChrData = GetDataContent(hData);
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetChrData = GetDataContent(hData);
				
				if(*pSetChrData == *pCurChrData &&
				   *(pSetChrData +1) == *(pCurChrData +1) &&
				   *(pSetChrData +2) == *(pCurChrData +2) &&
				   *(pSetChrData +4) == *(pCurChrData +4)) 
				{
					CancelKeyChangeWnd(hWnd);
					*(pSetChrData+0) = '-';  
					*(pSetChrData+1) = '0'; 
					*(pSetChrData+2) = '0'; 
					*(pSetChrData+3) = '.'; 
					*(pSetChrData+4) = '0'; 
					return 0;
				}
				if(*pSetChrData == '-')
					snrdata = -snrdata;
				SysInfo.SavedPar.offsetsnr = snrdata;
				stopwork();
				SetSnr();
				CancelKeyChangeWnd(hWnd);
				*(pSetChrData+0) = '-';  
				*(pSetChrData+1) = '0'; 
				*(pSetChrData+2) = '0'; 
				*(pSetChrData+3) = '.'; 
				*(pSetChrData+4) = '0'; 
				return 0;
				//break;
			case CANCEL_KEY_ACTIVE:
				if(snrdata == 0)
				{
					CancelKeyChangeWnd(hWnd);
					return 0;
				}
				else
				{
					snrdata = 0; 
					break;
				}
				//break;
			default:
				break;
		}
		if(*pSetChrData == '-')
			snrdata = -snrdata;
		IntToDecStr(snrdata, pSetChrData, 4);	
		*(pSetChrData+4) = *(pSetChrData+3) ;
		*(pSetChrData+3) = '.';
		UpdataWndData(hWnd, hData);
		
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}

int SetAddNoiseModeWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	char *pSetChrData = NULL;
	//unsigned short fs,fn;
	hWnd = (HWND)uWnd;

	if(_evtType(curMsg) == EVENT_KEY)
	{
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		keyvalue = GetKeyValue(curMsg);
		
		switch(keyvalue)
		{
			case UP_KEY_ACTIVE:
				hData = GetDataByInfo(hWnd, SET_DATA);
				pSetChrData = GetDataContent(hData);
				
				if(datacmp(pSetChrData, "źģʽ", 10) == 0)
				{
					datacpy(pSetChrData, "ģʽ  ", 10);
				}
				else if(datacmp(pSetChrData, "ģʽ", 10) == 0)
				{
					datacpy(pSetChrData, "źģʽ", 10);
				}
				else
				{
					datacpy(pSetChrData, "ģʽ", 10);
				}
				UpdataWndData(hWnd, hData);
				break;
			case DOWN_KEY_ACTIVE:
				hData = GetDataByInfo(hWnd, SET_DATA);
				pSetChrData = GetDataContent(hData);
				
				if(datacmp(pSetChrData, "źģʽ", 10) == 0)
				{
					datacpy(pSetChrData, "ģʽ", 10);
				}
				else if(datacmp(pSetChrData, "ģʽ", 10) == 0)
				{
					datacpy(pSetChrData, "ģʽ  ", 10);
				}
				else
				{
					datacpy(pSetChrData, "źģʽ", 10);
				}
				UpdataWndData(hWnd, hData);
				break;
				
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetChrData = GetDataContent(hData);
				stopwork();					
				if(datacmp(pSetChrData, "źģʽ", 10) == 0)
				{
					SysInfo.SavedPar.signal = 1;
					SysInfo.SavedPar.noise = 0;
				}
				else if(datacmp(pSetChrData, "ģʽ", 10) == 0)
				{
					SysInfo.SavedPar.signal = 0;
					SysInfo.SavedPar.noise = 1;
				}
				else
				{
					SysInfo.SavedPar.signal = 1;
					SysInfo.SavedPar.noise = 1;
				}
				SetSnr();
				CancelKeyChangeWnd(hWnd);
				break;
				
			case LEFT_KEY_ACTIVE:
			case CANCEL_KEY_ACTIVE:
				CancelKeyChangeWnd(hWnd);
				break;
			default:
				break;
		}
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}

int SetVoltWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	Uint16 *pCurIntData;
	Uint16 *pSetIntData;
	REGION region,region_image;
	Uint8 InitCMD[16] = {0xFE,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFA};
	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{
		region.sRow = 102;
		region.sCol = 74;
		region.eRow = 125;
		region.eCol = 181;
		region_image.sRow = 102;
		region_image.sCol = 42;
		region_image.eRow = 125;
		region_image.eCol = 65;
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		
		keyvalue = GetKeyValue(curMsg);
		hData = GetDataByInfo(hWnd, iFcsAdd & 0xFFFF);
		pSetIntData = GetDataContent(hData);
		//voltdata = (*(pSetChrData)-0x30) * 100 + (*(pSetChrData+1)-0x30) * 10 + *(pSetChrData+3)-0x30;
		
		switch(keyvalue)
		{
			case NUM0_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10;
				break;
			case NUM1_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+1;
				break;
			case NUM2_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+2;
				break;
			case NUM3_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+3;
				break;
			case NUM4_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+4;
				break;
			case NUM5_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+5;
				break;
			case NUM6_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+6;
				break;
			case NUM7_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+7;
				break;
			case NUM8_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+8;
				break;
			case NUM9_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+9;
				break;
			case DOWN_KEY_ACTIVE:
			case UP_KEY_ACTIVE:
				break;
			case LEFT_KEY_ACTIVE:
				break;
			case RIGHT_KEY_ACTIVE:
				break;
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				if((*pSetIntData > 70) ||(*pSetIntData < 20) )
				{
					SetWndRegionText(hWnd, region, (tchar *)"Χ!");
					DrawWndRegion(hWnd,region_image,(UINT16 *)gImage_error,1);
					*pSetIntData = 0;
					UpdataWndData(hWnd, hData);
					return 0;
				}
				else
				{
					ResetWndRegionContent(hWnd, region);
					ResetWndRegionContent(hWnd, region_image);
				}
				hData = GetDataByInfo(hWnd,CUR_DATA);
				pCurIntData = GetDataContent(hData);
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetIntData = GetDataContent(hData);
				
				if(*pCurIntData == *pSetIntData) 
				{
					CancelKeyChangeWnd(hWnd);
					*pSetIntData = 0;
					return 0;
				}
				
				SysInfo.SavedPar.volt= (*pSetIntData);
				stopwork();
				InitCMD[2] = 0x05;
				InitCMD[3] = 0x01;
				InitCMD[4] = ((SysInfo.SavedPar.volt-SysInfo.SavedPar.offsetvolt)-20) * 4;//???
				SendCommand(RAD_UART, InitCMD);
				CancelKeyChangeWnd(hWnd);
				*pSetIntData = 0;
				return 0;
				//break;
			case CANCEL_KEY_ACTIVE:
				if(*pSetIntData == 0)
				{
					CancelKeyChangeWnd(hWnd);
					return 0;
				}
				else
				{
					*pSetIntData = 0;
					break;
				}
				//break;
			default:
				break;
		}
		if((*pSetIntData > 70))
		{
			SetWndRegionText(hWnd, region, (tchar *)"Χ!");
			DrawWndRegion(hWnd,region_image,(UINT16 *)gImage_error,1);
			*pSetIntData = 0;
			UpdataWndData(hWnd, hData);
			return 0;
		}
		else
		{
			ResetWndRegionContent(hWnd, region);
			ResetWndRegionContent(hWnd, region_image);
		}
		UpdataWndData(hWnd, hData);
		
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}

int SetOffsetVoltWndRoutine(uint uWnd, uint curMsg)
{
	char temp;
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	Uint16 *pCurIntData;
	Uint16 *pSetIntData;
	char *pCurChrData;
	char *pSetChrData;
	REGION region,region_image;
	Uint8 InitCMD[16] = {0xFE,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFA};
	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{
		region.sRow = 102;
		region.sCol = 74;
		region.eRow = 125;
		region.eCol = 181;
		region_image.sRow = 102;
		region_image.sCol = 42;
		region_image.eRow = 125;
		region_image.eCol = 65;
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		
		keyvalue = GetKeyValue(curMsg);
		hData = GetDataByInfo(hWnd, iFcsAdd & 0xFFFF);
		pSetIntData = GetDataContent(hData);
		//voltdata = (*(pSetChrData)-0x30) * 100 + (*(pSetChrData+1)-0x30) * 10 + *(pSetChrData+3)-0x30;
		
		switch(keyvalue)
		{
			case NUM0_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10;
				break;
			case NUM1_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+1;
				break;
			case NUM2_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+2;
				break;
			case NUM3_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+3;
				break;
			case NUM4_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+4;
				break;
			case NUM5_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+5;
				break;
			case NUM6_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+6;
				break;
			case NUM7_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+7;
				break;
			case NUM8_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+8;
				break;
			case NUM9_KEY_ACTIVE:
				*pSetIntData = *pSetIntData * 10+9;
				break;
			case DOWN_KEY_ACTIVE:
			case UP_KEY_ACTIVE:
				pSetChrData = GetDataContent(GetDataByInfo(hWnd, SET_DATA1));
				if(*pSetChrData == '-')
					*pSetChrData = ' ';
				else
					*pSetChrData = '-';

				UpdataWndData(hWnd, GetDataByInfo(hWnd, SET_DATA1));
				break;
			case LEFT_KEY_ACTIVE:
				break;
			case RIGHT_KEY_ACTIVE:
				break;
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,CUR_DATA);
				pCurIntData = GetDataContent(hData);
				hData = GetDataByInfo(hWnd,CUR_DATA1);
				pCurChrData = GetDataContent(hData);
				hData = GetDataByInfo(hWnd,SET_DATA1);
				pSetChrData = GetDataContent(hData);
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetIntData = GetDataContent(hData);
				if(*pSetChrData == '-')
				{
					temp = -*pSetIntData;
				}
				else
				{
					temp = *pSetIntData;
				}
				if(temp< -3 || temp > 3)
				{
					SetWndRegionText(hWnd, region, (tchar *)"Χ!");
					DrawWndRegion(hWnd,region_image,(UINT16 *)gImage_error,1);
					*pSetIntData = 0;
					UpdataWndData(hWnd, hData);
					return 0;
				}	
				else
				{
					ResetWndRegionContent(hWnd, region);
					ResetWndRegionContent(hWnd, region_image);
				}
				
				if(*pCurIntData == *pSetIntData && *pCurChrData == *pSetChrData ) 
				{
					CancelKeyChangeWnd(hWnd);
					*pSetIntData = 0;
					return 0;
				}
				
				SysInfo.SavedPar.offsetvolt= temp;
				stopwork();
				InitCMD[2] = 0x05;
				InitCMD[3] = 0x01;
				InitCMD[4] = (SysInfo.SavedPar.volt-SysInfo.SavedPar.offsetvolt-20) * 4;
				SendCommand(RAD_UART, InitCMD);
				CancelKeyChangeWnd(hWnd);
				*pSetIntData = 0;
				return 0;
				//break;
			case CANCEL_KEY_ACTIVE:
				if(*pSetIntData == 0)
				{
					CancelKeyChangeWnd(hWnd);
					return 0;
				}
				else
				{
					*pSetIntData = 0;
					break;
				}
				//break;
			default:
				break;
		}
		UpdataWndData(hWnd, hData);
		
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}


int SetFillDataWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	char *pSetChrData = NULL;
	char *pCurChrData = NULL;
	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		
		keyvalue = GetKeyValue(curMsg);
		hData = GetDataByInfo(hWnd, iFcsAdd & 0xFFFF);
		pSetChrData = GetDataContent(hData);
		pSetChrData = pSetChrData + 2;
		switch(keyvalue)
		{
			case NUM0_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '0';
				UpdataWndData(hWnd, hData);
				break;
			case NUM1_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '1';
				UpdataWndData(hWnd, hData);
				break;
			case NUM2_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '2';
				UpdataWndData(hWnd, hData);
				break;
			case NUM3_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '3';
				UpdataWndData(hWnd, hData);
				break;
			case NUM4_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '4';
				UpdataWndData(hWnd, hData);
				break;
			case NUM5_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '5';
				UpdataWndData(hWnd, hData);
				break;
			case NUM6_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '6';
				UpdataWndData(hWnd, hData);
				break;
			case NUM7_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '7';
				UpdataWndData(hWnd, hData);
				break;
			case NUM8_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '8';
				UpdataWndData(hWnd, hData);
				break;
			case NUM9_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '9';
				UpdataWndData(hWnd, hData);
				break;
			
			case UP_KEY_ACTIVE:
				if(*(pSetChrData + (iFcsAdd >> 16)) == '9')
				{
					*(pSetChrData + (iFcsAdd >> 16)) = 'A';
				}
				else if(*(pSetChrData + (iFcsAdd >> 16)) == 'F')	
				{
					*(pSetChrData + (iFcsAdd >> 16)) = '0';
				}
				else	
				{
					*(pSetChrData + (iFcsAdd >> 16)) += 1;
				}
				UpdataWndData(hWnd, hData);
				break;
				
			case DOWN_KEY_ACTIVE:
				if(*(pSetChrData + (iFcsAdd >> 16)) == '0')
				{
					*(pSetChrData + (iFcsAdd >> 16)) = 'F';
				}
				else if(*(pSetChrData + (iFcsAdd >> 16)) == 'A')	
				{
					*(pSetChrData + (iFcsAdd >> 16)) = '9';
				}
				else	
				{
					*(pSetChrData + (iFcsAdd >> 16)) -= 1;
				}
				UpdataWndData(hWnd, hData);
				break;

			case LEFT_KEY_ACTIVE:
				if((iFcsAdd >> 16) > 0)
				{
					SetLastFocus(hWnd);
				}
				else
				{
					CancelKeyChangeWnd(hWnd);
				}
				break;
			case RIGHT_KEY_ACTIVE:
				SetNextFocus(hWnd);
				break;
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetChrData = GetDataContent(hData);

				hData = GetDataByInfo(hWnd,CUR_DATA);
				pCurChrData = GetDataContent(hData);

				if(datacmp(pCurChrData+2, pSetChrData+2, 2) == 0) 
				{
					CancelKeyChangeWnd(hWnd);
					return 0;//Ƚ
				}
				SysInfo.SavedPar.filldata = (CharToNum(*(pSetChrData+2)) << 4) + CharToNum(*(pSetChrData+3));
				stopwork();
				CancelKeyChangeWnd(hWnd);
				break;
			case CANCEL_KEY_ACTIVE:
				if(*(pSetChrData) !='0' || *(pSetChrData+1) != '0')
				{
					*(pSetChrData) = '0';
					*(pSetChrData+1) = '0';
				}
				else
				{
					CancelKeyChangeWnd(hWnd);
					break;
				}
				UpdataWndData(hWnd, hData);
				break;
			default:
				break;
		}
		
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}


int SetCycTimesWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	REGION region,region_image;
	uint *pSetIntData = NULL;
	uint *pCurIntData = NULL;
	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{
		region.sRow = 102;
		region.sCol = 74;
		region.eRow = 125;
		region.eCol = 181;
		region_image.sRow = 102;
		region_image.sCol = 42;
		region_image.eRow = 125;
		region_image.eCol = 65;
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		
		keyvalue = GetKeyValue(curMsg);
		hData = GetDataByInfo(hWnd, iFcsAdd & 0xFFFF);
		pSetIntData = GetDataContent(hData);
		switch(keyvalue)
		{
			case NUM0_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10;
				UpdataWndData(hWnd, hData);
				break;
			case NUM1_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+1;
				UpdataWndData(hWnd, hData);
				break;
			case NUM2_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+2;
				UpdataWndData(hWnd, hData);
				break;
			case NUM3_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+3;
				UpdataWndData(hWnd, hData);
				break;
			case NUM4_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+4;
				UpdataWndData(hWnd, hData);
				break;
			case NUM5_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+5;
				UpdataWndData(hWnd, hData);
				break;
			case NUM6_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+6;
				UpdataWndData(hWnd, hData);
				break;
			case NUM7_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+7;
				UpdataWndData(hWnd, hData);
				break;
			case NUM8_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+8;
				UpdataWndData(hWnd, hData);
				break;
			case NUM9_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+9;
				UpdataWndData(hWnd, hData);
				break;
			case DOWN_KEY_ACTIVE:
				break;
			case UP_KEY_ACTIVE:
				break;
			case LEFT_KEY_ACTIVE:
				break;
			case RIGHT_KEY_ACTIVE:
				break;
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetIntData = GetDataContent(hData);
				hData = GetDataByInfo(hWnd,CUR_DATA);
				pCurIntData = GetDataContent(hData);
				if(*pCurIntData == *pSetIntData) 
				{
					CancelKeyChangeWnd(hWnd);
					*pSetIntData = 0;
					return 0;//Ƚ
				}
			
				SysInfo.SavedPar.cyctimes= *pSetIntData;
				stopwork();
				CancelKeyChangeWnd(hWnd);
				*pSetIntData = 0;
				return 0;
				//break;
			case CANCEL_KEY_ACTIVE:
				if(*pSetIntData == 0)
				{
					CancelKeyChangeWnd(hWnd);
					return 0;
				}
				else
				{
					*pSetIntData = 0;
					UpdataWndData(hWnd, hData);
					break;
				}
				//break;
			default:
				break;
		}
		if((*pSetIntData >= 0x80000000))
		{
			SetWndRegionText(hWnd, region, (tchar *)"Χ!");
			DrawWndRegion(hWnd,region_image,(UINT16 *)gImage_error,1);
			*pSetIntData = 0;
			UpdataWndData(hWnd, hData);
			return 0;
		}
		else
		{
			ResetWndRegionContent(hWnd, region);
			ResetWndRegionContent(hWnd, region_image);
		}
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}




int SetOverCountWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	REGION region,region_image;
	uint *pSetIntData = NULL;
	uint *pCurIntData = NULL;
	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{
		region.sRow = 102;
		region.sCol = 74;
		region.eRow = 125;
		region.eCol = 181;
		region_image.sRow = 102;
		region_image.sCol = 42;
		region_image.eRow = 125;
		region_image.eCol = 65;
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		
		keyvalue = GetKeyValue(curMsg);
		hData = GetDataByInfo(hWnd, iFcsAdd & 0xFFFF);
		pSetIntData = GetDataContent(hData);
		switch(keyvalue)
		{
			case NUM0_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10;
				UpdataWndData(hWnd, hData);
				break;
			case NUM1_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+1;
				UpdataWndData(hWnd, hData);
				break;
			case NUM2_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+2;
				UpdataWndData(hWnd, hData);
				break;
			case NUM3_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+3;
				UpdataWndData(hWnd, hData);
				break;
			case NUM4_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+4;
				UpdataWndData(hWnd, hData);
				break;
			case NUM5_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+5;
				UpdataWndData(hWnd, hData);
				break;
			case NUM6_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+6;
				UpdataWndData(hWnd, hData);
				break;
			case NUM7_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+7;
				UpdataWndData(hWnd, hData);
				break;
			case NUM8_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+8;
				UpdataWndData(hWnd, hData);
				break;
			case NUM9_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+9;
				UpdataWndData(hWnd, hData);
				break;
			case DOWN_KEY_ACTIVE:
				break;
			case UP_KEY_ACTIVE:
				break;
			case LEFT_KEY_ACTIVE:
				break;
			case RIGHT_KEY_ACTIVE:
				break;
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetIntData = GetDataContent(hData);
				hData = GetDataByInfo(hWnd,CUR_DATA);
				pCurIntData = GetDataContent(hData);
				if(*pCurIntData == *pSetIntData) 
				{
					CancelKeyChangeWnd(hWnd);
					*pSetIntData = 0;
					return 0;//Ƚ
				}
				SysInfo.SavedPar.overcount= *pSetIntData;
				stopwork();
				CancelKeyChangeWnd(hWnd);
				*pSetIntData = 0;
				return 0;
				//break;
			case CANCEL_KEY_ACTIVE:
				if(*pSetIntData == 0)
				{
					CancelKeyChangeWnd(hWnd);
					return 0;
				}
				else
				{
					*pSetIntData = 0;
					UpdataWndData(hWnd, hData);
					break;
				}
				//break;
			default:
				break;
		}
		if((*pSetIntData >= 0x80000000))
		{
			SetWndRegionText(hWnd, region, (tchar *)"Χ!");
			DrawWndRegion(hWnd,region_image,(UINT16 *)gImage_error,1);
			*pSetIntData = 0;
			UpdataWndData(hWnd, hData);
			return 0;
		}
		else
		{
			ResetWndRegionContent(hWnd, region);
			ResetWndRegionContent(hWnd, region_image);
		}
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}

int SetFillModeWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	char *pSetChrData = NULL;
	hWnd = (HWND)uWnd;

	if(_evtType(curMsg) == EVENT_KEY)
	{
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		keyvalue = GetKeyValue(curMsg);
		
		switch(keyvalue)
		{
			case UP_KEY_ACTIVE:
			case DOWN_KEY_ACTIVE:
				hData = GetDataByInfo(hWnd, SET_DATA);
				pSetChrData = GetDataContent(hData);
				
				if(datacmp(pSetChrData, "̶", 4) == 0)
				{
					datacpy(pSetChrData, "ѭ", 4);
				}
				else
				{
					datacpy(pSetChrData, "̶", 4);
				}
				UpdataWndData(hWnd, hData);
				break;
				
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetChrData = GetDataContent(hData);

				if(datacmp(pSetChrData, "ѭ", 4) == 0)
				{
					//GPIO_setOutput(GPIO_BANK6, GPIO_PIN3, OUTPUT_LOW);//enable power output	
					SysInfo.SavedPar.fillmode= 0;
				}
				else
				{
					SysInfo.SavedPar.fillmode= 1;
				}
				stopwork();
				CancelKeyChangeWnd(hWnd);
				break;
				
			case LEFT_KEY_ACTIVE:
			case CANCEL_KEY_ACTIVE:
				CancelKeyChangeWnd(hWnd);
				break;
			default:
				break;
		}
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}


int SetTestModeWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	char *pSetChrData = NULL;
	hWnd = (HWND)uWnd;

	if(_evtType(curMsg) == EVENT_KEY)
	{
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		keyvalue = GetKeyValue(curMsg);
		
		switch(keyvalue)
		{
			case UP_KEY_ACTIVE:
			case DOWN_KEY_ACTIVE:
				hData = GetDataByInfo(hWnd, SET_DATA);
				pSetChrData = GetDataContent(hData);
				
				if(datacmp(pSetChrData, "", 8) == 0)
				{
					datacpy(pSetChrData, "", 8);
				}
				else
				{
					datacpy(pSetChrData, "", 8);
				}
				UpdataWndData(hWnd, hData);
				break;
				
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetChrData = GetDataContent(hData);

				if(datacmp(pSetChrData, "", 8) == 0)
				{
					//GPIO_setOutput(GPIO_BANK6, GPIO_PIN3, OUTPUT_LOW);//enable power output	
					SysInfo.SavedPar.testmode= 1;
				}
				else
				{
					SysInfo.SavedPar.testmode= 0;
				}
				stopwork();
				CancelKeyChangeWnd(hWnd);
				break;
				
			case LEFT_KEY_ACTIVE:
			case CANCEL_KEY_ACTIVE:
				CancelKeyChangeWnd(hWnd);
				break;
			default:
				break;
		}
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}


int SetOutSwitchWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	char *pSetChrData = NULL;
	Uint8 InitCMD[16] = {0xFE,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFA};

//	unsigned short fs,fn;
	hWnd = (HWND)uWnd;
	if(_evtType(curMsg) == EVENT_KEY)
	{
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		keyvalue = GetKeyValue(curMsg);
		
		switch(keyvalue)
		{
			case UP_KEY_ACTIVE:
			case DOWN_KEY_ACTIVE:
				hData = GetDataByInfo(hWnd, SET_DATA);
				pSetChrData = GetDataContent(hData);
				
				if(datacmp(pSetChrData, "", 2) == 0)
				{
					datacpy(pSetChrData, "", 2);
				}
				else
				{
					datacpy(pSetChrData, "", 2);
				}
				UpdataWndData(hWnd, hData);
				break;
				
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetChrData = GetDataContent(hData);

				if(datacmp(pSetChrData, "", 2) == 0)
				{
					SysInfo.SavedPar.outswitch= 1;
				}
				else
				{
					SysInfo.SavedPar.outswitch= 0;
				}
				SetSnr();
				InitCMD[2] = 0x02;//
				InitCMD[3] = 0x01;//
				InitCMD[4] = SysInfo.SavedPar.outswitch;
				SendCommand(RAD_UART, InitCMD);
				stopwork();
				CancelKeyChangeWnd(hWnd);
				break;
				
			case LEFT_KEY_ACTIVE:
			case CANCEL_KEY_ACTIVE:
				CancelKeyChangeWnd(hWnd);
				break;
			default:
				break;
		}
	}
	if(_evtType(curMsg) == EVENT_PRD)
	{
		drawWndFocus(hWnd);
	}
	return 0;
}


int SetMSwitchWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	char *pSetChrData = NULL;
	Uint8 InitCMD[16] = {0xFE,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFA};
	unsigned int temp32;
  //	unsigned short fs,fn;
	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		keyvalue = GetKeyValue(curMsg);
		
		switch(keyvalue)
		{
			case UP_KEY_ACTIVE:
			case DOWN_KEY_ACTIVE:
				hData = GetDataByInfo(hWnd, SET_DATA);
				pSetChrData = GetDataContent(hData);
				
				if(datacmp(pSetChrData, "", 2) == 0)
				{
					datacpy(pSetChrData, "", 2);
				}
				else
				{
					datacpy(pSetChrData, "", 2);
				}
				UpdataWndData(hWnd, hData);
				break;
				
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetChrData = GetDataContent(hData);

				if(datacmp(pSetChrData, "", 2) == 0)
				{
					temp32 = (SysInfo.SavedPar.freq - 100)*10;
					InitCMD[2] = 0x07;
					InitCMD[3] = 0x04;
					InitCMD[7] = temp32 >> 24 & 0xFF;
					InitCMD[6] = temp32 >> 16 & 0xFF;
					InitCMD[5] = temp32 >> 8 & 0xFF;
					InitCMD[4] = temp32 & 0xFF;
					SendCommand(RAD_UART, InitCMD);
					SysInfo.SavedPar.mswitch= 1;
				}
				else
				{
					temp32 = (SysInfo.SavedPar.freq)*10;
					InitCMD[2] = 0x07;
					InitCMD[3] = 0x04;
					InitCMD[7] = temp32 >> 24 & 0xFF;
					InitCMD[6] = temp32 >> 16 & 0xFF;
					InitCMD[5] = temp32 >> 8 & 0xFF;
					InitCMD[4] = temp32 & 0xFF;
					SendCommand(RAD_UART, InitCMD);
					SysInfo.SavedPar.mswitch= 0;
				}
				SetSnr();
				InitCMD[2] = 0x20;//ƿ
				InitCMD[3] = 0x01;//
				InitCMD[4] = SysInfo.SavedPar.mswitch;
				InitCMD[5] = 0x00;
				InitCMD[6] = 0x00;
				InitCMD[7] = 0x00;
				SendCommand(RAD_UART, InitCMD);
				stopwork();
				CancelKeyChangeWnd(hWnd);
				break;
				
			case LEFT_KEY_ACTIVE:
			case CANCEL_KEY_ACTIVE:
				CancelKeyChangeWnd(hWnd);
				break;
			default:
				break;
		}
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}

int SetDopplerWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	int *pSetIntData = NULL;
	int *pCurIntData = NULL;
	int temp_32;
	uchar *pSetChrData = NULL;
	uchar *pCurChrData = NULL;
	REGION region,region_image;
	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{	
		region.sRow = 102;
		region.sCol = 74;
		region.eRow = 125;
		region.eCol = 181;
		region_image.sRow = 102;
		region_image.sCol = 42;
		region_image.eRow = 125;
		region_image.eCol = 65;
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		
		keyvalue = GetKeyValue(curMsg);
		
		hData = GetDataByInfo(hWnd, iFcsAdd & 0xFFFF);
		pSetIntData = GetDataContent(hData);
		switch(keyvalue)
		{
			case NUM0_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10;
				break;
			case NUM1_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+1;
				break;
			case NUM2_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+2;
				break;
			case NUM3_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+3;
				break;
			case NUM4_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+4;
				break;
			case NUM5_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+5;
				break;
			case NUM6_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+6;
				break;
			case NUM7_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+7;
				break;
			case NUM8_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+8;
				break;
			case NUM9_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+9;
				break;
			case DOWN_KEY_ACTIVE:
			case UP_KEY_ACTIVE:
				pSetChrData = GetDataContent(GetDataByInfo(hWnd, SET_DATA1));
				if(*pSetChrData == '-')
					*pSetChrData = ' ';
				else
					*pSetChrData = '-';

				UpdataWndData(hWnd, GetDataByInfo(hWnd, SET_DATA1));
				break;
			case LEFT_KEY_ACTIVE:
				break;
			case RIGHT_KEY_ACTIVE:
				break;
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,CUR_DATA);
				pCurIntData = GetDataContent(hData);
				hData = GetDataByInfo(hWnd,CUR_DATA1);
				pCurChrData = GetDataContent(hData);
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetIntData = GetDataContent(hData);
				hData = GetDataByInfo(hWnd,SET_DATA1);
				pSetChrData = GetDataContent(hData);
				
				if(*pCurIntData == *pSetIntData &&
				   *pCurChrData == *pSetChrData) 
				   {
				   	CancelKeyChangeWnd(hWnd);
					*pSetIntData = 0;
					return 0;
				   }
				if(*pSetChrData == '-')
					*pSetIntData = -*pSetIntData;
				SysInfo.SavedPar.doppler= *pSetIntData;
				calculateDopplerFreqR(SysInfo.SavedPar.doppler,SysInfo.SavedPar.dcr,&temp_32);
				g_pBaseRegs->DFRR = temp_32 & 0x7FFF;
				if(temp_32 < 0)
					g_pBaseRegs->DFRR = ((temp_32 >>15) & 0x7FFF) | 0xC000;
				else
					g_pBaseRegs->DFRR = ((temp_32 >>15) & 0x7FFF) | 0x8000;
				stopwork();
				CancelKeyChangeWnd(hWnd);
				*(pSetIntData) = 0;
				return 0;
				//break;
			case CANCEL_KEY_ACTIVE:
				if(*(pSetIntData) == 0)
				{
					CancelKeyChangeWnd(hWnd);
					return 0;
				}
				else
				{
					*(pSetIntData) = 0;
					break;
				}
			default:
				break;
		}
		if((*pSetIntData < -200000) || (*pSetIntData > 200000))
		{
			SetWndRegionText(hWnd, region, (tchar *)"Χ!");
			DrawWndRegion(hWnd,region_image,(UINT16 *)gImage_error,1);
			*pSetIntData = 0;
			UpdataWndData(hWnd, hData);
			return 0;
		}
		else
		{
			ResetWndRegionContent(hWnd, region);
			ResetWndRegionContent(hWnd, region_image);
		}
		UpdataWndData(hWnd, hData);
	}

	if(_evtType(curMsg) == EVENT_PRD)
	{
		drawWndFocus(hWnd);
	}
	return 0;
}

int SetDopplerChangeWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	int temp_32;
	HDAT hData;
	char *pSetChrData = NULL;
	hWnd = (HWND)uWnd;

	if(_evtType(curMsg) == EVENT_KEY)
	{
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		keyvalue = GetKeyValue(curMsg);
		
		switch(keyvalue)
		{
			case UP_KEY_ACTIVE:
				hData = GetDataByInfo(hWnd, SET_DATA);
				pSetChrData = GetDataContent(hData);
				
				if(datacmp(pSetChrData, " ̶ ", 6) == 0)
				{
					datacpy(pSetChrData, "    ", 6);
				}
				else if(datacmp(pSetChrData, "    ", 6) == 0)
				{
					datacpy(pSetChrData, "ݲ", 6);
				}
				else if(datacmp(pSetChrData, "ݲ", 6) == 0)
				{
					datacpy(pSetChrData, "Ҳ", 6);
				}
				else if(datacmp(pSetChrData, "Ҳ", 6) == 0)
				{
					datacpy(pSetChrData, "ǲ", 6);
				}
				else
				{
					datacpy(pSetChrData, " ̶ ", 6);
				}
				UpdataWndData(hWnd, hData);
				break;
			case DOWN_KEY_ACTIVE:
				hData = GetDataByInfo(hWnd, SET_DATA);
				pSetChrData = GetDataContent(hData);
				
				if(datacmp(pSetChrData, " ̶ ", 6) == 0)
				{
					datacpy(pSetChrData, "ǲ", 6);
				}
				else if(datacmp(pSetChrData, "ǲ", 6) == 0)
				{
					datacpy(pSetChrData, "Ҳ", 6);
				}
				else if(datacmp(pSetChrData, "Ҳ", 6) == 0)
				{
					datacpy(pSetChrData, "ݲ", 6);
				}
				else if(datacmp(pSetChrData, "ݲ", 6) == 0)
				{
					datacpy(pSetChrData, "    ", 6);
				}
				else
				{
					datacpy(pSetChrData, " ̶ ", 6);
				}
				UpdataWndData(hWnd, hData);
				break;
				
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetChrData = GetDataContent(hData);

				if(datacmp(pSetChrData, " ̶ ", 6) == 0)
				{
					SysInfo.SavedPar.dcr = 0x00<<1|0x01;
				}
				else if(datacmp(pSetChrData, "ǲ", 6) == 0)
				{
					SysInfo.SavedPar.dcr = 0x01<<1|0x01;
				}
				else if(datacmp(pSetChrData, "Ҳ", 6) == 0)
				{
					SysInfo.SavedPar.dcr = 0x02<<1|0x01;
				}
				else if(datacmp(pSetChrData, "ݲ", 6) == 0)
				{
					SysInfo.SavedPar.dcr = 0x03<<1|0x01;
				}
				else
				{
					SysInfo.SavedPar.dcr = 0x00;
				}
				g_pBaseRegs->DCR = 0x00;
				delay(10);
				g_pBaseRegs->DCR = SysInfo.SavedPar.dcr;
				calculateDopplerFreqR(SysInfo.SavedPar.doppler,SysInfo.SavedPar.dcr,&temp_32);
				g_pBaseRegs->DFRR = temp_32 & 0x7FFF;
				if(temp_32 < 0)
					g_pBaseRegs->DFRR = ((temp_32 >>15) & 0x7FFF) | 0xC000;
				else
					g_pBaseRegs->DFRR = ((temp_32 >>15) & 0x7FFF) | 0x8000;

				stopwork();
				CancelKeyChangeWnd(hWnd);
				break;
				
			case LEFT_KEY_ACTIVE:
			case CANCEL_KEY_ACTIVE:
				CancelKeyChangeWnd(hWnd);
				break;
			default:
				break;
		}
	}

	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}


int SetDopplerFreqWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue,i;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	REGION region,region_image;
	char *pSetChrData = NULL;
	char *pCurChrData = NULL;
	uint dopplerFreq;
	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{
		region.sRow = 102;
		region.sCol = 74;
		region.eRow = 125;
		region.eCol = 181;
		region_image.sRow = 102;
		region_image.sCol = 42;
		region_image.eRow = 125;
		region_image.eCol = 65;
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		
		keyvalue = GetKeyValue(curMsg);
		hData = GetDataByInfo(hWnd, iFcsAdd & 0xFFFF);
		pSetChrData = GetDataContent(hData);
		if(*(pSetChrData+0) == 0x20)
		{
			if(*(pSetChrData+1) == 0x20)
			{
				if(*(pSetChrData+2) == 0x20)
					dopplerFreq = (*(pSetChrData+3)-0x30) * 1000 + (*(pSetChrData+5)-0x30) * 100 + (*(pSetChrData+6)-0x30)*10 + *(pSetChrData+7)-0x30;
				else
					dopplerFreq = (*(pSetChrData+2)-0x30) * 10000 + (*(pSetChrData+3)-0x30) * 1000 + (*(pSetChrData+5)-0x30) * 100 + (*(pSetChrData+6)-0x30)*10 + *(pSetChrData+7)-0x30;
			}
			else
			dopplerFreq = (*(pSetChrData+1)-0x30) * 100000 + (*(pSetChrData+2)-0x30) * 10000 + (*(pSetChrData+3)-0x30) * 1000 + (*(pSetChrData+5)-0x30) * 100 + (*(pSetChrData+6)-0x30)*10 + *(pSetChrData+7)-0x30;	
		}
		else
			dopplerFreq = (*(pSetChrData+0)-0x30) * 1000000 + (*(pSetChrData+1)-0x30) * 100000 + (*(pSetChrData+2)-0x30) * 10000 + (*(pSetChrData+3)-0x30) * 1000 + (*(pSetChrData+5)-0x30) * 100 + (*(pSetChrData+6)-0x30)*10 + *(pSetChrData+7)-0x30;	
		
		switch(keyvalue)
		{
			case NUM0_KEY_ACTIVE:
				dopplerFreq = dopplerFreq*10;
				break;
			case NUM1_KEY_ACTIVE:
				dopplerFreq = dopplerFreq*10+1;
				break;
			case NUM2_KEY_ACTIVE:
				dopplerFreq = dopplerFreq*10+2;
				break;
			case NUM3_KEY_ACTIVE:
				dopplerFreq = dopplerFreq*10+3;
				break;
			case NUM4_KEY_ACTIVE:
				dopplerFreq = dopplerFreq*10+4;
				break;
			case NUM5_KEY_ACTIVE:
				dopplerFreq = dopplerFreq*10+5;
				break;
			case NUM6_KEY_ACTIVE:
				dopplerFreq = dopplerFreq*10+6;
				break;
			case NUM7_KEY_ACTIVE:
				dopplerFreq = dopplerFreq*10+7;
				break;
			case NUM8_KEY_ACTIVE:
				dopplerFreq = dopplerFreq*10+8;
				break;
			case NUM9_KEY_ACTIVE:
				dopplerFreq = dopplerFreq*10+9;
				break;
			case DOWN_KEY_ACTIVE:
				dopplerFreq = dopplerFreq-1;
				break;
			case UP_KEY_ACTIVE:
				dopplerFreq = dopplerFreq+1;
				break;
			case LEFT_KEY_ACTIVE:
				break;
			case RIGHT_KEY_ACTIVE:
				break;
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetChrData = GetDataContent(hData);
				hData = GetDataByInfo(hWnd,CUR_DATA);
				pCurChrData = GetDataContent(hData);
				if(*(pSetChrData+0) == *(pCurChrData+0)&&
				   *(pSetChrData+1) == *(pCurChrData+1)&&
				   *(pSetChrData+2) == *(pCurChrData+2)&&
				   *(pSetChrData+3) == *(pCurChrData+3)&&
				   *(pSetChrData+5) == *(pCurChrData+5)&&
				   *(pSetChrData+6) == *(pCurChrData+6)&&
				   *(pSetChrData+7) == *(pCurChrData+7)) 
				{
					CancelKeyChangeWnd(hWnd);
					return 0;	
				}
				if((dopplerFreq > 1000000) || (dopplerFreq < 1))
				{
					SetWndRegionText(hWnd, region, (tchar *)"Χ!");
					DrawWndRegion(hWnd,region_image,(UINT16 *)gImage_error,1);
					for(i=0;i<8;i++)
						*(pSetChrData+i) = ' ';
					*(pSetChrData+3) = '0';
					*(pSetChrData+4) = '.';
					*(pSetChrData+5) = '0';
					*(pSetChrData+6) = '0';
					*(pSetChrData+7) = '0';
					UpdataWndData(hWnd, hData);
					return 0;
				}
				SysInfo.SavedPar.dfsr= dopplerFreq/1000.0;
				calculateDopplerCyc(SysInfo.SavedPar.dfsr,&dopplerFreq);
				g_pBaseRegs->DFSR = dopplerFreq & 0x7FFF;
				g_pBaseRegs->DFSR = ((dopplerFreq >>15 )& 0x7FFF) | 0x8000;
				stopwork();
				CancelKeyChangeWnd(hWnd);
				return 0;
				//break;
			case CANCEL_KEY_ACTIVE:
				if(dopplerFreq ==0)
				{
					CancelKeyChangeWnd(hWnd);
					return 0;
				}
				else
				{
					dopplerFreq = 0;
					break;
				}
				//break;
			default:
				break;
		}
		if((dopplerFreq > 1000000) || (dopplerFreq < 1))
		{
			if(dopplerFreq != 0)
			{
				SetWndRegionText(hWnd, region, (tchar *)"Χ!");
				DrawWndRegion(hWnd,region_image,(UINT16 *)gImage_error,1);
				for(i=0;i<8;i++)
					*(pSetChrData+i) = ' ';
				*(pSetChrData+3) = '0';
				*(pSetChrData+4) = '.';
				*(pSetChrData+5) = '0';
				*(pSetChrData+6) = '0';
				*(pSetChrData+7) = '0';
				UpdataWndData(hWnd, hData);
				return 0;
			}
		}
		else
		{
			ResetWndRegionContent(hWnd, region);
			ResetWndRegionContent(hWnd, region_image);
		}
		for(i=0;i<8;i++)
			*(pSetChrData+i) = ' ';
		if(dopplerFreq<10)
		{
			U32ToDecStr(dopplerFreq, pSetChrData+7, 1);
			*(pSetChrData+3) = '0';
			*(pSetChrData+4) = '.';
			*(pSetChrData+5) = '0';
			*(pSetChrData+6) = '0';
		}
		else if(dopplerFreq<100)
		{
			U32ToDecStr(dopplerFreq, pSetChrData+6, 2);
			*(pSetChrData+3) = '0';
			*(pSetChrData+4) = '.';
			*(pSetChrData+5) = '0';
		}
		else if(dopplerFreq<1000)
		{
			U32ToDecStr(dopplerFreq, pSetChrData+5, 3);
			*(pSetChrData+3) = '0';
			*(pSetChrData+4) = '.';
		}
		else if(dopplerFreq<10000)
		{
			U32ToDecStr(dopplerFreq, pSetChrData+4, 4);
			*(pSetChrData+3) = *(pSetChrData+4) ;
			*(pSetChrData+4) = '.';
		}
		else if(dopplerFreq<100000)
		{
			U32ToDecStr(dopplerFreq, pSetChrData+3, 5);
			*(pSetChrData+2) = *(pSetChrData+3);
			*(pSetChrData+3) = *(pSetChrData+4);
			*(pSetChrData+4) = '.';
		}
		else if(dopplerFreq<1000000)
		{
			U32ToDecStr(dopplerFreq, pSetChrData+2, 6);
			*(pSetChrData+1) = *(pSetChrData+2);
			*(pSetChrData+2) = *(pSetChrData+3);
			*(pSetChrData+3) = *(pSetChrData+4);
			*(pSetChrData+4) = '.';
		}
		else
		{
			U32ToDecStr(dopplerFreq/1000, pSetChrData, 4);
			*(pSetChrData+4) = '.';
			*(pSetChrData+5) = '0';
			*(pSetChrData+6) = '0';
			*(pSetChrData+7) = '0';
		}
		UpdataWndData(hWnd, hData);
	}

	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}

int SetIPWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	uint wndname;
	uint i,j;
	Uint8 keycmd[4];
	uint *pSetIntData = NULL;
	uint *pCurIntData = NULL;
	REGION region,region_image;
	hWnd = (HWND)uWnd;
	if(_evtType(curMsg) == EVENT_KEY)
	{
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		
		keyvalue = GetKeyValue(curMsg);
		hData = GetDataByInfo(hWnd, iFcsAdd & 0xFFFF);
		pSetIntData = GetDataContent(hData);
		switch(keyvalue)
		{
			case NUM0_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10;
				if(*pSetIntData > 255)
				{
					*pSetIntData = 255;
				}
				UpdataWndData(hWnd, hData);
				if(*pSetIntData > 100)
				{
					SetNextFocus(hWnd);
				}
				break;
			case NUM1_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+1;
				if(*pSetIntData > 255)
				{
					*pSetIntData = 255;
				}
				UpdataWndData(hWnd, hData);
				if(*pSetIntData > 100)
				{
					SetNextFocus(hWnd);
				}
				break;
			case NUM2_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+2;
				if(*pSetIntData > 255)
				{
					*pSetIntData = 255;
				}
				UpdataWndData(hWnd, hData);
				if(*pSetIntData > 100)
				{
					SetNextFocus(hWnd);
				}
				break;
			case NUM3_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+3;
				if(*pSetIntData > 255)
				{
					*pSetIntData = 255;
				}
				UpdataWndData(hWnd, hData);
				if(*pSetIntData > 100)
				{
					SetNextFocus(hWnd);
				}
				break;
			case NUM4_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+4;
				if(*pSetIntData > 255)
				{
					*pSetIntData = 255;
				}
				UpdataWndData(hWnd, hData);
				if(*pSetIntData > 100)
				{
					SetNextFocus(hWnd);
				}
				break;
			case NUM5_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+5;
				if(*pSetIntData > 255)
				{
					*pSetIntData = 255;
				}
				UpdataWndData(hWnd, hData);
				if(*pSetIntData > 100)
				{
					SetNextFocus(hWnd);
				}
				break;
			case NUM6_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+6;
				if(*pSetIntData > 255)
				{
					*pSetIntData = 255;
				}
				UpdataWndData(hWnd, hData);
				if(*pSetIntData > 100)
				{
					SetNextFocus(hWnd);
				}
				break;
			case NUM7_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+7;
				if(*pSetIntData > 255)
				{
					*pSetIntData = 255;
				}
				UpdataWndData(hWnd, hData);
				if(*pSetIntData > 100)
				{
					SetNextFocus(hWnd);
				}
				break;
			case NUM8_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+8;
				if(*pSetIntData > 255)
				{
					*pSetIntData = 255;
				}
				UpdataWndData(hWnd, hData);
				if(*pSetIntData > 100)
				{
					SetNextFocus(hWnd);
				}
				break;
			case NUM9_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+9;
				if(*pSetIntData > 255)
				{
					*pSetIntData = 255;
				}
				UpdataWndData(hWnd, hData);
				if(*pSetIntData > 100)
				{
					SetNextFocus(hWnd);
				}
				break;
			case UP_KEY_ACTIVE:
				break;
			case DOWN_KEY_ACTIVE:
				break;
			case LEFT_KEY_ACTIVE:
				/*if(((iFcsAdd >> 16) == 1)&&((iFcsAdd & 0xFFFF) == SET_DATA1))
				{
					CancelKeyChangeWnd(hWnd);
				}
				else*/
				{
					SetLastFocus(hWnd);
				}
				break;
			case RIGHT_KEY_ACTIVE:
				SetNextFocus(hWnd);
				break;
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				j = 0;
				for(i=0; i<4; i++)
				{
					hData = GetDataByInfo(hWnd,CUR_DATA1 + i);
					pCurIntData = GetDataContent(hData);

					hData = GetDataByInfo(hWnd,SET_DATA1 + i);
					pSetIntData = GetDataContent(hData);

					if(*pCurIntData != *pSetIntData) j++;	
					keycmd[i] = *pSetIntData & 0xFF;
				}

				if(j == 0) 
				{
					CancelKeyChangeWnd(hWnd);
					for(i=0;i<4;i++)
					{
						hData = GetDataByInfo(hWnd,SET_DATA1 + i);
						pSetIntData = GetDataContent(hData);
						*pSetIntData = 0;
					}
					return 0;//no change ,return
				}
				
				GetWndIdentity(hWnd, &wndname);
				switch(wndname)
				{
					case SET_DEVIP_WND:
						//g_pBaseRegs->DIPR0= (keycmd[2] << 8) + keycmd[3];
						//g_pBaseRegs->DIPR1= (keycmd[0] << 8) + keycmd[1]; 
						SysInfo.SavedPar.devip = (keycmd[3] << 24) +
									(keycmd[2] << 16) +
									(keycmd[1] << 8) +
									keycmd[0];
						region.sRow = 98;
						region.sCol = 28;
						region.eRow = 121;
						region.eCol = 267;
						region_image.sRow = 98;
						region_image.sCol = 0;
						region_image.eRow = 121;
						region_image.eCol = 23;
						SysInfo.UnsavedInfo.LinkStatus = 0;
						hData = GetDataByInfo(GetWndByIdentity(NETSWND),IMAGE_DATA);
						SetDataContent(hData,(uint) gImage_netunlink);
						UpdataWndData(GetWndByIdentity(NETSWND),hData);
						
						SetWndRegionText(hWnd, region, (tchar *)"Network Restarting..");
						DrawWndRegion(hWnd,region_image,(UINT16 *)gImage_right,0);
						UpdataWndData(hWnd, hData);
		
						UpdateNetCfgWithIPAddr(SysInfo.SavedPar.devip,DEFAULT_DEV_IP_MASK);
						
						ResetWndRegionContent(hWnd, region);
						ResetWndRegionContent(hWnd, region_image);
						break;
					default:
						break;
				}
				CancelKeyChangeWnd(hWnd);
				for(i=0;i<4;i++)
				{
					hData = GetDataByInfo(hWnd,SET_DATA1 + i);
					pSetIntData = GetDataContent(hData);
					*pSetIntData = 0;
				}
				break;
			case CANCEL_KEY_ACTIVE:
				j=0;
				for(i=0;i<4;i++)
				{
					hData = GetDataByInfo(hWnd,SET_DATA1 + i);
					pSetIntData = GetDataContent(hData);
					if(*pSetIntData == 0)
					{
						j++;
					}
					
				}
				if(j == 4)
				{
					CancelKeyChangeWnd(hWnd);
				}
				else
				{
					for(i=0;i<4;i++)
					{
						hData = GetDataByInfo(hWnd,SET_DATA1 + i);
						pSetIntData = GetDataContent(hData);
						*pSetIntData = 0;
						UpdataWndData(hWnd, hData);
					}
				}
				break;
			default:
				break;
		}
	}
	/*
	if(_evtType(curMsg) == EVENT_USER) 
	{
		GetWndIdentity(hWnd, &wndname);
		if((wndname == SET_DEVIP_WND) && (_keyVal(curMsg) == CMD_TYPE_DEV_IP))
		{
			for(i=0; i<4; i++)
			{
				hData = GetDataByInfo(hWnd,CUR_DATA1 + i);
				pCurIntData = GetDataContent(hData);
				
				*pCurIntData = (SysInfo.SavedPar.devip >> (24 - 8*i)) & 0xFF;
				UpdataWndData(hWnd, hData);
			}
		}

	}*/
	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}

int SetPortWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	uint wndname;
	uint *pSetIntData = NULL;
	uint *pCurIntData = NULL;
	REGION region,region_image;
	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		
		keyvalue = GetKeyValue(curMsg);
		hData = GetDataByInfo(hWnd, iFcsAdd & 0xFFFF);
		pSetIntData = GetDataContent(hData);
		switch(keyvalue)
		{
			case NUM0_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10;
				UpdataWndData(hWnd, hData);
				break;
			case NUM1_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+1;
				UpdataWndData(hWnd, hData);
				break;
			case NUM2_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+2;
				UpdataWndData(hWnd, hData);
				break;
			case NUM3_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+3;
				UpdataWndData(hWnd, hData);
				break;
			case NUM4_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+4;
				UpdataWndData(hWnd, hData);
				break;
			case NUM5_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+5;
				UpdataWndData(hWnd, hData);
				break;
			case NUM6_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+6;
				UpdataWndData(hWnd, hData);
				break;
			case NUM7_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+7;
				UpdataWndData(hWnd, hData);
				break;
			case NUM8_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+8;
				UpdataWndData(hWnd, hData);
				break;
			case NUM9_KEY_ACTIVE:
				*pSetIntData = *pSetIntData*10+9;
				UpdataWndData(hWnd, hData);
				break;
			case DOWN_KEY_ACTIVE:
				break;
			case UP_KEY_ACTIVE:
				break;
			case LEFT_KEY_ACTIVE:
				break;
			case RIGHT_KEY_ACTIVE:
				break;
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetIntData = GetDataContent(hData);
				hData = GetDataByInfo(hWnd,CUR_DATA);
				pCurIntData = GetDataContent(hData);
				if(*pCurIntData == *pSetIntData) 
				{
					CancelKeyChangeWnd(hWnd);
					*pSetIntData = 0;
					return 0;//Ƚ
				}
				GetWndIdentity(hWnd,&wndname);
				switch(wndname)
				{
					case SET_DEVPORT_WND:
						SysInfo.SavedPar.devport= *pSetIntData;
						region.sRow = 98;
						region.sCol = 28;
						region.eRow = 121;
						region.eCol = 267;
						region_image.sRow = 98;
						region_image.sCol = 0;
						region_image.eRow = 121;
						region_image.eCol = 23;
						SysInfo.UnsavedInfo.LinkStatus = 0;
						hData = GetDataByInfo(GetWndByIdentity(NETSWND),IMAGE_DATA);
						SetDataContent(hData,(uint) gImage_netunlink);
						UpdataWndData(GetWndByIdentity(NETSWND),hData);
						
						SetWndRegionText(hWnd, region, (tchar *)"Network Restarting..");
						DrawWndRegion(hWnd,region_image,(UINT16 *)gImage_right,0);
						UpdataWndData(hWnd, hData);
						
						SetTcpServPort(htons(SysInfo.SavedPar.devport));
						
						ResetWndRegionContent(hWnd, region);
						ResetWndRegionContent(hWnd, region_image);
						break;
					default:
						break;
				}
				CancelKeyChangeWnd(hWnd);
				*pSetIntData = 0;
				break;
			case CANCEL_KEY_ACTIVE:
				if(*pSetIntData == 0)
				{
					CancelKeyChangeWnd(hWnd);
				}
				else
				{
					*pSetIntData = 0;
				}
				UpdataWndData(hWnd, hData);
				break;
			default:
				break;
		}
		
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}


int SetMacWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	HDAT hData;
	uint i;
	char *pSetChrData = NULL;
	char *pCurChrData = NULL;
	REGION region,region_image;
//	char sTemp[2] = "  ";
	hWnd = (HWND)uWnd;
	if(_evtType(curMsg) == EVENT_KEY)
	{
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		
		keyvalue = GetKeyValue(curMsg);
		hData = GetDataByInfo(hWnd, iFcsAdd & 0xFFFF);
		pSetChrData = GetDataContent(hData);
		switch(keyvalue)
		{
			case NUM0_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '0';
				UpdataWndData(hWnd, hData);
				break;
			case NUM1_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '1';
				UpdataWndData(hWnd, hData);
				break;
			case NUM2_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '2';
				UpdataWndData(hWnd, hData);
				break;
			case NUM3_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '3';
				UpdataWndData(hWnd, hData);
				break;
			case NUM4_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '4';
				UpdataWndData(hWnd, hData);
				break;
			case NUM5_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '5';
				UpdataWndData(hWnd, hData);
				break;
			case NUM6_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '6';
				UpdataWndData(hWnd, hData);
				break;
			case NUM7_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '7';
				UpdataWndData(hWnd, hData);
				break;
			case NUM8_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '8';
				UpdataWndData(hWnd, hData);
				break;
			case NUM9_KEY_ACTIVE:
				*(pSetChrData + (iFcsAdd >> 16)) = '9';
				UpdataWndData(hWnd, hData);
				break;
			
			case UP_KEY_ACTIVE:
				if(*(pSetChrData + (iFcsAdd >> 16)) == '9')
				{
					*(pSetChrData + (iFcsAdd >> 16)) = 'A';
				}
				else if(*(pSetChrData + (iFcsAdd >> 16)) == 'F')	
				{
					*(pSetChrData + (iFcsAdd >> 16)) = '0';
				}
				else	
				{
					*(pSetChrData + (iFcsAdd >> 16)) += 1;
				}
				UpdataWndData(hWnd, hData);
				break;
				
			case DOWN_KEY_ACTIVE:
				if(*(pSetChrData + (iFcsAdd >> 16)) == '0')
				{
					*(pSetChrData + (iFcsAdd >> 16)) = 'F';
				}
				else if(*(pSetChrData + (iFcsAdd >> 16)) == 'A')	
				{
					*(pSetChrData + (iFcsAdd >> 16)) = '9';
				}
				else	
				{
					*(pSetChrData + (iFcsAdd >> 16)) -= 1;
				}
				UpdataWndData(hWnd, hData);
				break;

			case LEFT_KEY_ACTIVE:
				if((iFcsAdd >> 16) > 0)
				{
					SetLastFocus(hWnd);
				}
				else
				{
					CancelKeyChangeWnd(hWnd);
				}
				break;
			case RIGHT_KEY_ACTIVE:
				SetNextFocus(hWnd);
				break;
			case CONFIRM_KEY_ACTIVE:
				//set current value to relative parameter
				hData = GetDataByInfo(hWnd,SET_DATA);
				pSetChrData = GetDataContent(hData);

				hData = GetDataByInfo(hWnd,CUR_DATA);
				pCurChrData = GetDataContent(hData);

				if(datacmp(pCurChrData, pSetChrData, 17) == 0) 
				{
					CancelKeyChangeWnd(hWnd);
					return 0;//Ƚ
				}
				
				for(i=0;i<6;i++)
				{
					SysInfo.SavedPar.devmac[i] = (CharToNum(*(pSetChrData+3*i)) << 4) + CharToNum(*(pSetChrData+3*i+1));
				}
				region.sRow = 98;
				region.sCol = 38;
				region.eRow = 121;
				region.eCol = 277;
				region_image.sRow = 98;
				region_image.sCol = 10;
				region_image.eRow = 121;
				region_image.eCol = 33;
				SysInfo.UnsavedInfo.LinkStatus = 0;
				hData = GetDataByInfo(GetWndByIdentity(NETSWND),IMAGE_DATA);
				SetDataContent(hData,(uint) gImage_netunlink);
				UpdataWndData(GetWndByIdentity(NETSWND),hData);
				
				SetWndRegionText(hWnd, region, (tchar *)"Network Restarting..");
				DrawWndRegion(hWnd,region_image,(UINT16 *)gImage_right,0);
				UpdataWndData(hWnd, hData);
				UpdateNetCfgWithMacAddr(SysInfo.SavedPar.devmac);

				ResetWndRegionContent(hWnd, region);
				ResetWndRegionContent(hWnd, region_image);
				CancelKeyChangeWnd(hWnd);
				break;
			case CANCEL_KEY_ACTIVE:
				CancelKeyChangeWnd(hWnd);
				break;
			default:
				break;
		}
	}
	/*
	if((_evtType(curMsg) == EVENT_USER) && (_keyVal(curMsg) == CMD_TYPE_DEV_MAC))
	{
		hData = GetDataByInfo(hWnd,CUR_DATA);
		pCurChrData = GetDataContent(hData);

		for(i=0;i<6;i++)
		{
			U8ToHexStr(SysInfo.SavedPar.devmac[i], sTemp);
			datacpy(pCurChrData + 3*i, sTemp, 2);
		}
		
		UpdataWndData(hWnd, hData);
	}*/
	if(_evtType(curMsg) == EVENT_PRD)
		{
			drawWndFocus(hWnd);
		}
	return 0;
}


void ChangeWndByFCS(HWND hWnd,uint wndname)
{
	uint   iFcsAdd;
	HWND 	hNextWnd;
	int 	timerID;
		//--------------------------
	hNextWnd = GetWndByIdentity(wndname);
	HideWnd(hNextWnd);
	GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
	switch(iFcsAdd >>16)
	{
		case 1:
			hNextWnd = GetWndByIdentity(OVERTAKEWND);
			break;
		case 2:
			hNextWnd = GetWndByIdentity(BASEWND);
			break;
		case 3:
			hNextWnd = GetWndByIdentity(RADPARWND);
			break;
		case 4:
			hNextWnd = GetWndByIdentity(LOCALPARWND);
			break;
		default:
			break;
	}
	ShowWnd(hNextWnd);
	timerID = GetFirstTimer(hNextWnd);
	if(timerID != -1)
	{
		DisableWndTimer(hNextWnd, timerID);
	}
	SetCurWnd(hWnd);
	eraseWndFocus(hNextWnd);
}
/*void DirKeyChangeWnd(HWND hWnd,bool bFwdir)
{
	uint wndname;
	HWND hNextWnd;

	GetWndIdentity(hWnd, &wndname);
	
	if(bFwdir)
	{
		switch(wndname)
		{
			case STATUSWND1:
				hNextWnd = GetWndByIdentity(STATUSWND2);
				HideWnd(hWnd);
				ShowWnd(hNextWnd);
				break;
			case STATUSWND2:
				hNextWnd = GetWndByIdentity(STATUSWND3);
				HideWnd(hWnd);
				ShowWnd(hNextWnd);
				break;
			case STATUSWND3:
				hNextWnd = GetWndByIdentity(STATUSWND4);
				HideWnd(hWnd);
				ShowWnd(hNextWnd);
				break;
			case STATUSWND4:
				hNextWnd = GetWndByIdentity(STATUSWND5);
				HideWnd(hWnd);
				ShowWnd(hNextWnd);
				break;
			case STATUSWND5:
				hNextWnd = GetWndByIdentity(STATUSWND1);
				HideWnd(hWnd);
				ShowWnd(hNextWnd);
				break;
			default:
				break;
		}
	}
	else
	{
		switch(wndname)
		{
			case STATUSWND1:
				hNextWnd = GetWndByIdentity(STATUSWND5);
				HideWnd(hWnd);
				ShowWnd(hNextWnd);
				break;
			case STATUSWND2:
				hNextWnd = GetWndByIdentity(STATUSWND1);
				HideWnd(hWnd);
				ShowWnd(hNextWnd);
				break;
			case STATUSWND3:
				hNextWnd = GetWndByIdentity(STATUSWND2);
				HideWnd(hWnd);
				ShowWnd(hNextWnd);
				break;
			case STATUSWND4:
				hNextWnd = GetWndByIdentity(STATUSWND3);
				HideWnd(hWnd);
				ShowWnd(hNextWnd);
				break;
			case STATUSWND5:
				hNextWnd = GetWndByIdentity(STATUSWND4);
				HideWnd(hWnd);
				ShowWnd(hNextWnd);
				break;
			default:
				break;
		}
	}
}
*/
void ConfirmKeyChangeWnd(HWND hWnd)
{
	uint   iFcsAdd;
	//PFCSDATA pfcsTemp;
	uint wndname;
	HWND hNextWnd;
	POSITION posLeft,posRight;
	int timerID;
	
	GetWndIdentity(hWnd, &wndname);

	switch(wndname)
	{
		case DEVINIT_WND:
			IncRefreshDelcount();
			hNextWnd = GetWndByIdentity(INFOWND);
			ShowWnd(hNextWnd);
			//HideWnd(hWnd);
			DestroyWnd(hWnd);
			hNextWnd = GetWndByIdentity(LINEWND);
			posLeft.pos_x = 0;
			posLeft.pos_y = 0;
			posRight.pos_x = 399;
			posRight.pos_y = 0;
			ShowWnd(hNextWnd);
			DrawLine(hNextWnd,posLeft,posRight);
			hNextWnd = GetWndByIdentity(NETSWND);
			ShowWnd(hNextWnd);
			hNextWnd = GetWndByIdentity(SAVEPARWND);
			ShowWnd(hNextWnd);
			hNextWnd = GetWndByIdentity(WORKSTATUS);
			ShowWnd(hNextWnd);
			hNextWnd = GetWndByIdentity(OVERTAKEWND);
			ShowWnd(hNextWnd);
			hNextWnd = GetWndByIdentity(MAINSETWINDOW);
			DecRefreshDelcount();
			
			ShowWnd(hNextWnd);
			
			hNextWnd = GetWndByIdentity(OVERTAKEWND);
			timerID = GetFirstTimer(hNextWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hNextWnd, timerID);
			}
			eraseWndFocus(hNextWnd);
			
			hNextWnd = GetWndByIdentity(SAVEPARWND);
			timerID = GetFirstTimer(hNextWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hNextWnd, timerID);
			}
			eraseWndFocus(hNextWnd);

			hNextWnd = GetWndByIdentity(WORKSTATUS);
			timerID = GetFirstTimer(hNextWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hNextWnd, timerID);
			}
			eraseWndFocus(hNextWnd);
			break;
		case MAINSETWINDOW:
			{
				GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
				switch(iFcsAdd >>16)
				{
					case 1:
						hNextWnd = GetWndByIdentity(OVERTAKEWND);
						//HideWnd(hWnd);
						eraseWndFocus(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 2:
						hNextWnd = GetWndByIdentity(BASEWND);
						//HideWnd(hWnd);
						eraseWndFocus(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 3:
						hNextWnd = GetWndByIdentity(RADPARWND);
						//HideWnd(hWnd);
						eraseWndFocus(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 4:
						hNextWnd = GetWndByIdentity(LOCALPARWND);
						//HideWnd(hWnd);
						eraseWndFocus(hWnd);
						ShowWnd(hNextWnd);
						break;
					default:
						break;
				}
			break;
		case OVERTAKEWND:
			{
				GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
				switch(iFcsAdd >>16)
				{
					/*case 4:
						hNextWnd = GetWndByIdentity(SET_FREQ_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;*/
					case 1:
						hNextWnd = GetWndByIdentity(SET_BW_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 2:
						hNextWnd = GetWndByIdentity(SET_SNR_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					/*case 3:
						hNextWnd = GetWndByIdentity(SET_VOLT_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 3:
						hNextWnd = GetWndByIdentity(SET_DOPPLER_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;*/
					case 4:
						hNextWnd = GetWndByIdentity(SET_TESTMODE_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 5:
						hNextWnd = GetWndByIdentity(SET_FILLMODE_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 6:
						hNextWnd = GetWndByIdentity(SET_FILLDATA_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 3:
						hNextWnd = GetWndByIdentity(SET_SENDCOUNT_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					default:
						break;
				}
			}
			break;
		case BASEWND:
			{
				GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
				switch(iFcsAdd >>16)
				{
					case 1:
						hNextWnd = GetWndByIdentity(SET_OVERID_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 2:
						hNextWnd = GetWndByIdentity(SET_BW_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 3:
						hNextWnd = GetWndByIdentity(SET_SNR_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 4:
						hNextWnd = GetWndByIdentity(SET_ADDNOISE_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					/*case 5:
						hNextWnd = GetWndByIdentity(SET_VOLT_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 6:
						hNextWnd = GetWndByIdentity(SET_FREQ_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 5:
						hNextWnd = GetWndByIdentity(SET_DOPPLER_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;*/
					case 5:
						hNextWnd = GetWndByIdentity(SET_TESTMODE_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 6:
						hNextWnd = GetWndByIdentity(SET_OVERCOUNT_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 7:
						hNextWnd = GetWndByIdentity(SET_FILLMODE_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 8:
						hNextWnd = GetWndByIdentity(SET_FILLDATA_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					default:
						break;
				}
			}
			break;
		case RADPARWND:
			{
				GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
				switch(iFcsAdd >>16)
				{
					case 4:
						hNextWnd = GetWndByIdentity(SET_FREQ_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 1:
						hNextWnd = GetWndByIdentity(SET_OUTSWITCH_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 3:
						hNextWnd = GetWndByIdentity(SET_VOLT_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 2:
						hNextWnd = GetWndByIdentity(SET_MSWITCH_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 6:
						hNextWnd = GetWndByIdentity(SET_DOPPLERCHANGE_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 5:
						hNextWnd = GetWndByIdentity(SET_DOPPLER_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 7:
						hNextWnd = GetWndByIdentity(SET_DOPPLERFREQ_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					default:
						break;
				}
			}
			break;
			case LOCALPARWND:
			{
				GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
				switch(iFcsAdd >>16)
				{
					case 1:
						hNextWnd = GetWndByIdentity(SET_DEVIP_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 2:
						hNextWnd = GetWndByIdentity(SET_DEVMAC_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 3:
						hNextWnd = GetWndByIdentity(SET_DEVPORT_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 4:
						hNextWnd = GetWndByIdentity(SET_OFFSETFREQ_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 5:
						hNextWnd = GetWndByIdentity(SET_OFFSETVOLT_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					case 6:
						hNextWnd = GetWndByIdentity(SET_OFFSETSNR_WND);
						//HideWnd(hWnd);
						ShowWnd(hNextWnd);
						break;
					default:
						break;
				}
			}
			break;
			}
		default:
			break;
	}

}

void CancelKeyChangeWnd(HWND hWnd)
{
	uint cur_wndname,next_wndname;
	HWND hNextWnd;
	uint   iFcsAdd;
	int timerID;
	GetWndIdentity(hWnd, &cur_wndname);
	hNextWnd = GetWndByIdentity(MAINSETWINDOW);
	GetFocusData(GetCurrentFocus(hNextWnd), &iFcsAdd);
	switch(iFcsAdd >>16)
	{
		case 1:
			next_wndname = OVERTAKEWND;
			break;
		case 2:
			next_wndname = BASEWND;
			break;
		case 3:
			next_wndname = RADPARWND;
			break;
		case 4:
			next_wndname = LOCALPARWND;
			break;
		default:
			break;
	}
	switch(cur_wndname)
	{
		case MAINSETWINDOW:
			//hNextWnd = GetWndByIdentity(INFOWND);
			//HideWnd(hNextWnd);
			//hNextWnd = GetWndByIdentity(MENUWINDOW);
			//HideWnd(hWnd);
			//ShowWnd(hNextWnd);
			break;
		case OVERTAKEWND://------------------
			hNextWnd = GetWndByIdentity(MAINSETWINDOW);
			//HideWnd(hWnd);
			ShowWnd(hNextWnd);
			eraseWndFocus(hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}
			break;
		case BASEWND://------------------
			hNextWnd = GetWndByIdentity(MAINSETWINDOW);
			//HideWnd(hWnd);
			ShowWnd(hNextWnd);
			eraseWndFocus(hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}
			break;
		case RADPARWND://------------------
			hNextWnd = GetWndByIdentity(MAINSETWINDOW);
			//HideWnd(hWnd);
			ShowWnd(hNextWnd);
			eraseWndFocus(hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}
			break;
		case LOCALPARWND://------------------
			hNextWnd = GetWndByIdentity(MAINSETWINDOW);
			//HideWnd(hWnd);
			ShowWnd(hNextWnd);
			eraseWndFocus(hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}
			break;
		case SAVEMENUWND:
			next_wndname = MAINSETWINDOW;
			HideWnd(hWnd);
			hNextWnd = GetWndByIdentity(next_wndname);
			ShowWnd(hNextWnd);
			break;
		case WORKSTATUS:
			next_wndname = MAINSETWINDOW;
			//HideWnd(hWnd);
			timerID = GetFirstTimer(hWnd);
			if(timerID != -1)
			{
				DisableWndTimer(hWnd, timerID);
			}
			hNextWnd = GetWndByIdentity(next_wndname);
			ShowWnd(hNextWnd);
			eraseWndFocus(hWnd);
			break;
		case SET_OVERID_WND:
		case SET_FREQ_WND:
		case SET_BW_WND:
		case SET_SNR_WND:
		case SET_ADDNOISE_WND:
		case SET_VOLT_WND:
		case SET_OUTSWITCH_WND:
		case SET_MSWITCH_WND:
			
		case SET_SENDCOUNT_WND:
		case SET_OVERCOUNT_WND:
		case SET_DOPPLER_WND:
		case SET_DOPPLERCHANGE_WND:
		case SET_DOPPLERFREQ_WND:
			
		case SET_OFFSETFREQ_WND:
		case SET_OFFSETSNR_WND:
		case SET_OFFSETVOLT_WND:
			
		case SET_DEVIP_WND:
		case SET_DEVMAC_WND:
		case SET_DEVPORT_WND:
		case SET_FILLMODE_WND:
		case SET_TESTMODE_WND:
		case SET_FILLDATA_WND:
			HideWnd(hWnd);
			hNextWnd = GetWndByIdentity(next_wndname);
			ShowWnd(hNextWnd);
			break;
		default:
			break;
	}

}

int _ChangeWnd(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	keyvalue = GetKeyValue(curMsg);
	
	switch(keyvalue)
	{
		case UP_KEY_ACTIVE:
			//display previous Window
			//DirKeyChangeWnd((HWND)uWnd, FALSE);
			break;
		case DOWN_KEY_ACTIVE:
			//display next Window
			//DirKeyChangeWnd((HWND)uWnd, TRUE);
			break;
		case CONFIRM_KEY_ACTIVE:
			//display lower lever Window
			ConfirmKeyChangeWnd((HWND)uWnd);
			break;
		case CANCEL_KEY_ACTIVE:
			//display upper lever Window
			CancelKeyChangeWnd((HWND)uWnd);
			break;
		default:
			break;
	}
	return 1;
}



int MainSetWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint wndname;
	uint   iFcsAdd;
	HWND hNextWnd;
	hWnd = (HWND)uWnd;
	keyvalue = GetKeyValue(curMsg);

	GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
	switch(iFcsAdd >>16)
	{
		case 1:
			wndname = OVERTAKEWND;
			break;
		case 2:
			wndname = BASEWND;
			break;
		case 3:
			wndname = RADPARWND;
			break;
		case 4:
			wndname = LOCALPARWND;
			break;
		default:
			break;
	}
	switch(keyvalue)
	{
		case UP_KEY_ACTIVE:
			if(wndname == OVERTAKEWND)
			{
				hNextWnd = GetWndByIdentity(SAVEPARWND);
				ShowWnd(hNextWnd);
				eraseWndFocus(hWnd);
			}
			else
			{
				SetLastFocus(hWnd);
				ChangeWndByFCS(hWnd,wndname);
			}
			break;
		case DOWN_KEY_ACTIVE:
			if(wndname == LOCALPARWND)
			{
				hNextWnd = GetWndByIdentity(SAVEPARWND);
				ShowWnd(hNextWnd);
				eraseWndFocus(hWnd);
			}
			else
			{
				SetNextFocus(hWnd);
				ChangeWndByFCS(hWnd,wndname);
			}
			break;
		case CONFIRM_KEY_ACTIVE:
			//display lower lever Window
			ConfirmKeyChangeWnd(hWnd);
			stopwork();
			break;
		case LEFT_KEY_ACTIVE:
		case CANCEL_KEY_ACTIVE:
			//display upper lever Window
			//CancelKeyChangeWnd(hWnd);
			break;
		case NETSET_KEY_ACTIVE:
			hNextWnd = GetWndByIdentity(SET_DEVIP_WND);
			ShowWnd(hNextWnd);
			break;
		case FREQ_KEY_ACTIVE:
			hNextWnd = GetWndByIdentity(SET_FREQ_WND);
			ShowWnd(hNextWnd);
			break;
		default:
			break;
	}
	return 0;
}

int SaveParWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	int timerID;
	HWND hNextWnd;
	uint   iFcsAdd;
	hWnd = (HWND)uWnd;
	keyvalue = GetKeyValue(curMsg);
	if(_evtType(curMsg) == EVENT_KEY)
	{
		switch(keyvalue)
		{
			case UP_KEY_ACTIVE:
				hNextWnd = GetWndByIdentity(MAINSETWINDOW);
				GetFocusData(GetCurrentFocus(hNextWnd), &iFcsAdd);
				if((iFcsAdd>>16) == 1)
				{
					SetLastFocus(hNextWnd);
					ChangeWndByFCS(hNextWnd,OVERTAKEWND);
					ShowWnd(hNextWnd);
					eraseWndFocus(hWnd);
					timerID = GetFirstTimer(hWnd);
					if(timerID != -1)
					{
						DisableWndTimer(hWnd, timerID);
					}
				}
				else
				{
					ShowWnd(hNextWnd);
					eraseWndFocus(hWnd);
					timerID = GetFirstTimer(hWnd);
					if(timerID != -1)
					{
						DisableWndTimer(hWnd, timerID);
					}	
				}
				break;
			case DOWN_KEY_ACTIVE:
				hNextWnd = GetWndByIdentity(MAINSETWINDOW);
				GetFocusData(GetCurrentFocus(hNextWnd), &iFcsAdd);
				if((iFcsAdd>>16) == 4)
				{
					SetNextFocus(hNextWnd);
					ChangeWndByFCS(hNextWnd,LOCALPARWND);
					ShowWnd(hNextWnd);
					eraseWndFocus(hWnd);
					timerID = GetFirstTimer(hWnd);
					if(timerID != -1)
					{
						DisableWndTimer(hWnd, timerID);
					}
				}
				else
				{
					ShowWnd(hNextWnd);
					eraseWndFocus(hWnd);
					timerID = GetFirstTimer(hWnd);
					if(timerID != -1)
					{
						DisableWndTimer(hWnd, timerID);
					}	
				}
				break;
			case CONFIRM_KEY_ACTIVE:
				//display lower lever Window
				//ConfirmKeyChangeWnd(hWnd);
				hNextWnd = GetWndByIdentity(SAVEMENUWND);
				ShowWnd(hNextWnd);
				eraseWndFocus(hWnd);
				timerID = GetFirstTimer(hWnd);
				if(timerID != -1)
				{
					DisableWndTimer(hWnd, timerID);
				}
				//SaveSysCfg();
				break;
			case LEFT_KEY_ACTIVE:
			case CANCEL_KEY_ACTIVE:
				break;
			case NETSET_KEY_ACTIVE:
				hNextWnd = GetWndByIdentity(SET_DEVIP_WND);
				ShowWnd(hNextWnd);
				break;
			case FREQ_KEY_ACTIVE:
				hNextWnd = GetWndByIdentity(SET_FREQ_WND);
				ShowWnd(hNextWnd);
				break;
			default:
				break;
		}
	}
	else if(_evtType(curMsg) == EVENT_PRD)
	{
		if(GetCurrentWnd() == hWnd){
			drawWndFocus(hWnd);
		}
	}
	return 0;
}

int WorkStatusWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	int timerID;
	HWND hNextWnd;
	uint   iFcsAdd;
	hWnd = (HWND)uWnd;
	
	keyvalue = GetKeyValue(curMsg);
	if(_evtType(curMsg) == EVENT_KEY)
	{
		switch(keyvalue)
		{
			case UP_KEY_ACTIVE:
				hNextWnd = GetWndByIdentity(MAINSETWINDOW);
				GetFocusData(GetCurrentFocus(hNextWnd), &iFcsAdd);
				if((iFcsAdd>>16) == 1)
				{
					hNextWnd = GetWndByIdentity(OVERTAKEWND);
					GetFocusData(GetCurrentFocus(hNextWnd), &iFcsAdd);
					if((iFcsAdd>>16) == 1)
					{
						SetLastFocus(hNextWnd);
					}
				}
				else if((iFcsAdd>>16) == 2)
				{
					hNextWnd = GetWndByIdentity(BASEWND);
					GetFocusData(GetCurrentFocus(hNextWnd), &iFcsAdd);
					if((iFcsAdd>>16) == 1)
					{
						SetLastFocus(hNextWnd);
					}
				}
				else
				{}
				ShowWnd(hNextWnd);
				eraseWndFocus(hWnd);
				timerID = GetFirstTimer(hWnd);
				if(timerID != -1)
				{
					DisableWndTimer(hWnd, timerID);
				}
				break;
			case DOWN_KEY_ACTIVE:
				hNextWnd = GetWndByIdentity(MAINSETWINDOW);
				GetFocusData(GetCurrentFocus(hNextWnd), &iFcsAdd);
				if((iFcsAdd>>16) == 1)
				{
					hNextWnd = GetWndByIdentity(OVERTAKEWND);
					GetFocusData(GetCurrentFocus(hNextWnd), &iFcsAdd);
					if((iFcsAdd>>16) == 6)
					{
						SetNextFocus(hNextWnd);
					}
				}
				else if((iFcsAdd>>16) == 2)
				{
					hNextWnd = GetWndByIdentity(BASEWND);
					GetFocusData(GetCurrentFocus(hNextWnd), &iFcsAdd);
					if((iFcsAdd>>16) == 8)
					{
						SetNextFocus(hNextWnd);
					}
				}
				else
				{}
				ShowWnd(hNextWnd);
				eraseWndFocus(hWnd);
				timerID = GetFirstTimer(hWnd);
				if(timerID != -1)
				{
					DisableWndTimer(hWnd, timerID);
				}
				break;
			case CONFIRM_KEY_ACTIVE:
				//display lower lever Window
				if(workflag == 1)
				{
					stopwork();
				}
				else
				{
					startwork();
				}
				
				//SaveSysCfg();
				break;
			case LEFT_KEY_ACTIVE:
			case CANCEL_KEY_ACTIVE:
				CancelKeyChangeWnd(hWnd);
				break;
			case NETSET_KEY_ACTIVE:
				hNextWnd = GetWndByIdentity(SET_DEVIP_WND);
				ShowWnd(hNextWnd);
				break;
			case FREQ_KEY_ACTIVE:
				hNextWnd = GetWndByIdentity(SET_FREQ_WND);
				ShowWnd(hNextWnd);
				break;
			default:
				break;
		}
	}
	else if(_evtType(curMsg) == EVENT_PRD)
	{
		if(GetCurrentWnd() == hWnd)
		{
			drawWndFocus(hWnd);
		}
		if(workflag){
			if(GetWorkStatus() == 0)
				stopwork();
		}
	}
	return 0;
}

int SetSaveMenuRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd;
	uint   iFcsAdd;
	hWnd = (HWND)uWnd;

	if(_evtType(curMsg) == EVENT_KEY)
	{
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		keyvalue = GetKeyValue(curMsg);
		
		switch(keyvalue)
		{
			case UP_KEY_ACTIVE:
			case DOWN_KEY_ACTIVE:
			case LEFT_KEY_ACTIVE:
			case RIGHT_KEY_ACTIVE:
				SetNextFocus(hWnd);
				break;
				
			case CONFIRM_KEY_ACTIVE:
				switch(iFcsAdd >>16)
				{
					case 1:
						SaveSysCfg();
					break;
					case 2:
					break;
					default:
					break;
				}
				CancelKeyChangeWnd(hWnd);
				break;
			case CANCEL_KEY_ACTIVE:
				CancelKeyChangeWnd(hWnd);
				break;
			default:
				break;
		}
	}
	if(_evtType(curMsg) == EVENT_PRD)
	{
		if(GetCurrentWnd() == hWnd){
		drawWndFocus(hWnd);
		}
	}
	return 0;
}


int NetStatusWndRoutine(uint uWnd, uint curMsg)
{
	HDAT hData;
	if(_evtType(curMsg) == EVENT_PRD)
	{
		if(SysInfo.UnsavedInfo.LinkStatus != GetEtherLinkStatus())
		{
			SysInfo.UnsavedInfo.LinkStatus = GetEtherLinkStatus();
			hData = GetDataByInfo(GetWndByIdentity(NETSWND),IMAGE_DATA);
			if(SysInfo.UnsavedInfo.LinkStatus == 0)
			{
				SetDataContent(hData,(uint) gImage_netunlink);
			}
			else
			{
				SetDataContent(hData,(uint) gImage_netlink);
			}
			PostMessage(NULL, (MSG_FLG + (EVENT_USER << 16) + CMD_TYPE_LINKS));
			UpdataWndData(GetWndByIdentity(NETSWND),hData);
		}
	}
	return 0;
}


int OvertakeStatusWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd,hNextWnd;
	uint   iFcsAdd;
	int timerID;
	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{
		keyvalue = GetKeyValue(curMsg);
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		switch(keyvalue)
		{
			case UP_KEY_ACTIVE:
				GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
				if((iFcsAdd>>16) == 1)
				{
					hNextWnd = GetWndByIdentity(WORKSTATUS);
					ShowWnd(hNextWnd);
					eraseWndFocus(hWnd);
					timerID = GetFirstTimer(hWnd);
					if(timerID != -1)
					{
						DisableWndTimer(hWnd, timerID);
					}
					
				}
				else
				{
					SetLastFocus(hWnd);
				}
				break;
			case DOWN_KEY_ACTIVE:
				GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
				if((iFcsAdd>>16) == 6)
				{
					hNextWnd = GetWndByIdentity(WORKSTATUS);
					ShowWnd(hNextWnd);
					eraseWndFocus(hWnd);
					timerID = GetFirstTimer(hWnd);
					if(timerID != -1)
					{
						DisableWndTimer(hWnd, timerID);
					}
				}
				else
				{
					SetNextFocus(hWnd);
				}
				break;
			case LEFT_KEY_ACTIVE:
				//select previous item	
				if((iFcsAdd>>16) > 1)
				{
					SetLastFocus(hWnd);
				}
				else
				{
					CancelKeyChangeWnd(hWnd);
				}
				break;
			case RIGHT_KEY_ACTIVE:	
				//select next item
				SetNextFocus(hWnd);
				break;
			case CONFIRM_KEY_ACTIVE:
				ConfirmKeyChangeWnd(hWnd);
				break;
			case CANCEL_KEY_ACTIVE:	
				//select next item
				CancelKeyChangeWnd(hWnd);
				break;	
			case NETSET_KEY_ACTIVE:
				hNextWnd = GetWndByIdentity(SET_DEVIP_WND);
				ShowWnd(hNextWnd);
				break;
			case FREQ_KEY_ACTIVE:
				hNextWnd = GetWndByIdentity(SET_FREQ_WND);
				ShowWnd(hNextWnd);
				break;
			default:
				break;
		}
	}
	if(_evtType(curMsg) == EVENT_USER)
	{
		switch(_keyVal(curMsg))
		{
			/*
			case CMD_TYPE_OVERID:
				UpdateOverIDStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_FREQ:
				UpdateFreqStatus(&StsWndLastSysInfo1,hWnd);
			break;*/
			case CMD_TYPE_BW:
				UpdateBWStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_SNR:
				UpdateSnrStatus(&StsWndLastSysInfo1,hWnd);
			break;
			/*case CMD_TYPE_VOLT:
				UpdateVoltStatus(&StsWndLastSysInfo1,hWnd);
			break;
			
			case CMD_TYPE_FILLDATA:
				UpdateFillDataStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_SENDCOUNT:
				UpdateCycCountStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_FILLMODE:
				UpdateFillModeStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_TESTMODE:
				UpdateTestModeStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_DOPPLER:
				UpdateDopplerStatus(&StsWndLastSysInfo1,hWnd);
			break;*/
			default:
			break;
		}
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
		if(GetCurrentWnd() == hWnd){
			drawWndFocus(hWnd);
		}
		}
	return 0;	
}

int BaseStatusWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd,hNextWnd;
	uint   iFcsAdd;
	int timerID;
	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{
		keyvalue = GetKeyValue(curMsg);
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		switch(keyvalue)
		{
			case UP_KEY_ACTIVE:
				GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
				if((iFcsAdd>>16) == 1)
				{
					hNextWnd = GetWndByIdentity(WORKSTATUS);
					ShowWnd(hNextWnd);
					eraseWndFocus(hWnd);
					timerID = GetFirstTimer(hWnd);
					if(timerID != -1)
					{
						DisableWndTimer(hWnd, timerID);
					}
				}
				else
				{
					SetLastFocus(hWnd);
				}
				break;
			case DOWN_KEY_ACTIVE:
				GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
				if((iFcsAdd>>16) == 8)
				{
					hNextWnd = GetWndByIdentity(WORKSTATUS);
					ShowWnd(hNextWnd);
					eraseWndFocus(hWnd);
					timerID = GetFirstTimer(hWnd);
					if(timerID != -1)
					{
						DisableWndTimer(hWnd, timerID);
					}
				}
				else
				{
					SetNextFocus(hWnd);
				}
				break;
			case LEFT_KEY_ACTIVE:
				//select previous item	
				if((iFcsAdd>>16) > 1)
				{
					SetLastFocus(hWnd);
				}
				else
				{
					CancelKeyChangeWnd(hWnd);
				}
				break;
			case RIGHT_KEY_ACTIVE:	
				//select next item
				SetNextFocus(hWnd);
				break;
			case CONFIRM_KEY_ACTIVE:
				ConfirmKeyChangeWnd(hWnd);
				break;
			case CANCEL_KEY_ACTIVE:	
				//select next item
				CancelKeyChangeWnd(hWnd);
				break;
			case NETSET_KEY_ACTIVE:
				hNextWnd = GetWndByIdentity(SET_DEVIP_WND);
				ShowWnd(hNextWnd);
				break;
			case FREQ_KEY_ACTIVE:
				hNextWnd = GetWndByIdentity(SET_FREQ_WND);
				ShowWnd(hNextWnd);
				break;
			default:
				break;
		}
	}
	if(_evtType(curMsg) == EVENT_USER)
	{
		switch(_keyVal(curMsg))
		{
			/*
			case CMD_TYPE_OVERID:
				UpdateOverIDStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_FREQ:
				UpdateFreqStatus(&StsWndLastSysInfo1,hWnd);
			break;*/
			case CMD_TYPE_BW:
				UpdateBWStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_SNR:
				UpdateSnrStatus(&StsWndLastSysInfo1,hWnd);
			break;
			/*case CMD_TYPE_VOLT:
				UpdateVoltStatus(&StsWndLastSysInfo1,hWnd);
			break;
			
			case CMD_TYPE_FILLDATA:
				UpdateFillDataStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_SENDCOUNT:
				UpdateCycCountStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_FILLMODE:
				UpdateFillModeStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_TESTMODE:
				UpdateTestModeStatus(&StsWndLastSysInfo1,hWnd);
			break;
			*/
			case CMD_TYPE_ADDNOISE:
				UpdateAddNoiseModeStatus(&StsWndLastSysInfo1,hWnd);
				break;
				/*
			case CMD_TYPE_DOPPLER:
				UpdateDopplerStatus(&StsWndLastSysInfo1,hWnd);
			break;*/
			default:
			break;
		}
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
		if(GetCurrentWnd() == hWnd){
			drawWndFocus(hWnd);
			}
		}
	return 0;	
}



int RadParWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd,hNextWnd;
	HFCS hFcs;
	uint   iFcsAdd;

	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{
		keyvalue = GetKeyValue(curMsg);
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		switch(keyvalue)
		{
			case UP_KEY_ACTIVE:
				hFcs = GetCurrentFocus(hWnd);
				hFcs = GetRelatFocus(hFcs,-1);
				SetWndFocus(hFcs);
				break;
			case DOWN_KEY_ACTIVE:
				hFcs = GetCurrentFocus(hWnd);
				hFcs = GetRelatFocus(hFcs,1);
				SetWndFocus(hFcs);
				break;
			case LEFT_KEY_ACTIVE:
				//select previous item	
				if((iFcsAdd>>16) > 1)
				{
					SetLastFocus(hWnd);
				}
				else
				{
					CancelKeyChangeWnd(hWnd);
				}
				break;
			case RIGHT_KEY_ACTIVE:	
				//select next item
				SetNextFocus(hWnd);
				break;
			case CONFIRM_KEY_ACTIVE:
				ConfirmKeyChangeWnd(hWnd);
				break;
			case CANCEL_KEY_ACTIVE:	
				//select next item
				CancelKeyChangeWnd(hWnd);
				break;
			case NETSET_KEY_ACTIVE:
				hNextWnd = GetWndByIdentity(SET_DEVIP_WND);
				ShowWnd(hNextWnd);
				break;
			case FREQ_KEY_ACTIVE:
				hNextWnd = GetWndByIdentity(SET_FREQ_WND);
				ShowWnd(hNextWnd);
				break;
			default:
				break;
		}
	}
	if(_evtType(curMsg) == EVENT_USER)
	{
		switch(_keyVal(curMsg))
		{
			/*
			case CMD_TYPE_OVERID:
				UpdateOverIDStatus(&StsWndLastSysInfo1,hWnd);
			break;*/
			case CMD_TYPE_FREQ:
				UpdateFreqStatus(&StsWndLastSysInfo1,hWnd);
			break;
			/*case CMD_TYPE_BW:
				UpdateBWStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_SNR:
				UpdateSnrStatus(&StsWndLastSysInfo1,hWnd);
			break;*/
			case CMD_TYPE_VOLT:
				UpdateVoltStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_RADMSWITCH:
				UpdateMSwitchStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_RADOUTSWITCH:
				UpdateOutSwitchStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_DOPPLER:
				UpdateDopplerStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_DOPPLERFREQ:
				UpdateDopplerFreqStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_DOPPLERCHANGE:
				UpdateDopplerChangeStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_RADTEMP:
				UpdateRadTempStatus(&StsWndLastSysInfo1,hWnd);
				break;
			default:
			break;
		}
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
		if(GetCurrentWnd() == hWnd){
			drawWndFocus(hWnd);
			}
		}
	return 0;	
}
int LocalStatusWndRoutine(uint uWnd, uint curMsg)
{
	Uint8 keyvalue;
	HWND hWnd,hNextWnd;
	HFCS hFcs;
	uint   iFcsAdd;

	hWnd = (HWND)uWnd;
	
	if(_evtType(curMsg) == EVENT_KEY)
	{
		keyvalue = GetKeyValue(curMsg);
		GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
		switch(keyvalue)
		{
			case UP_KEY_ACTIVE:
				hFcs = GetCurrentFocus(hWnd);
				hFcs = GetRelatFocus(hFcs,-1);
				SetWndFocus(hFcs);
				break;
			case DOWN_KEY_ACTIVE:
				hFcs = GetCurrentFocus(hWnd);
				hFcs = GetRelatFocus(hFcs,1);
				SetWndFocus(hFcs);
				break;
			case LEFT_KEY_ACTIVE:
				//select previous item	
				if((iFcsAdd>>16) > 1)
				{
					SetLastFocus(hWnd);
				}
				else
				{
					CancelKeyChangeWnd(hWnd);
				}
				break;
			case RIGHT_KEY_ACTIVE:	
				//select next item
				SetNextFocus(hWnd);
				break;
			case CONFIRM_KEY_ACTIVE:
				ConfirmKeyChangeWnd(hWnd);
				break;
			case CANCEL_KEY_ACTIVE:	
				//select next item
				CancelKeyChangeWnd(hWnd);
				break;
			case NETSET_KEY_ACTIVE:
				hNextWnd = GetWndByIdentity(SET_DEVIP_WND);
				ShowWnd(hNextWnd);
				break;
			case FREQ_KEY_ACTIVE:
				hNextWnd = GetWndByIdentity(SET_FREQ_WND);
				ShowWnd(hNextWnd);
				break;
			default:
				break;
		}
	}
	if(_evtType(curMsg) == EVENT_USER)
	{
		switch(_keyVal(curMsg))
		{
			/*
			case CMD_TYPE_DEV_IP:
				UpdateDevIPStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_DEV_PORT:
				UpdateDevPortStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_DEV_MAC:
				UpdateDevMacStatus(&StsWndLastSysInfo1,hWnd);
			break;
			*/
			case CMD_TYPE_LINKS:
				UpdateLinkStatus(&StsWndLastSysInfo1,hWnd);
			break;
			case CMD_TYPE_MODE:
				UpdateModeEdtionStatus(&StsWndLastSysInfo1,hWnd);
			break;
			default:
			break;
		}
	}
	if(_evtType(curMsg) == EVENT_PRD)
		{
		if(GetCurrentWnd() == hWnd){
			drawWndFocus(hWnd);
			}
		}
	return 0;	
}

HWND InitOvertakeWnd()//֡
{
	HWND hWnd;
	POSITION pos;
	REGION region;
	
	char strBw[10] 		= " źŴ:";
	char strBwVal[5] 	= "36MHz";//14
	
	char strSnr[10] 		= "   :";
	char strSnrVal[7] 	= "-19.2dB";//16
	
	//char strVolt[10] 	= " ƽ:";
	//char strVoltVal[8] 	= "-10.0dBm";//17

	//char strFreq[10] 	= " زƵ:";
	//char strFreqVal[10] = "1200000kHz";//19

	char strCycTimes[10] = " ѭ:";
	char strCycTimesVal[10] = "1234567890";//10
	
	char strTestMode[10] = " ģʽ:";
	char strTestModeVal[8] = "";//17

	char strFillMode[10] = " ģʽ:";
	char strFillModeVal[8] 	= "̶ģʽ";//13

	char strFillData[10] = " :";
	char strFillDataVal[4] = "0xAA";//11
	
	pos.pos_x = 132;
	pos.pos_y = 32;
	hWnd = CreateWnd(pos, 268, 208, 0xFFFF,0x0a0a, 1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, OVERTAKEWND);
	SetupWndRoutine(hWnd, OvertakeStatusWndRoutine);
	/*
	region.sRow = 2;
	region.sCol = 0;
	region.eRow = 25;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strBw, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 2;
	region.sCol = 120;
	region.eRow = 25;
	region.eCol = 179;
	CreateWndData(hWnd, region, (uint)strBwVal, WDAT_TYPE_STRING, STATUS_BW, 0, 0, 0);//ʼʾ
	*/
	region.sRow = 2+26;
	region.sCol = 0;
	region.eRow = 25+26;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strBw, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼԾ?
	region.sRow = 2+26;
	region.sCol = 120;
	region.eRow = 25+26;
	region.eCol = 179;
	CreateWndData(hWnd, region, (uint)strBwVal, WDAT_TYPE_STRING, STATUS_BW, 0, 0, 0);//ʼʾ

	region.sRow = 28+26;
	region.sCol = 0;
	region.eRow = 51+26;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strSnr, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 28+26;
	region.sCol = 120;
	region.eRow = 51+26;
	region.eCol = 203;
	CreateWndData(hWnd, region, (uint)strSnrVal, WDAT_TYPE_STRING, STATUS_SNR, 0, 0, 0);//ʼʾ

	region.sRow = 80;
	region.sCol = 0;
	region.eRow = 103;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strCycTimes, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 80;
	region.sCol = 120;
	region.eRow = 103;
	region.eCol = 239;
	CreateWndData(hWnd, region, (uint)strCycTimesVal, WDAT_TYPE_STRING, STATUS_CYCTIMES, 0, 0, 0);//ʼʾ

	region.sRow = 106;
	region.sCol = 0;
	region.eRow = 129;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strTestMode, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 106;
	region.sCol = 120;
	region.eRow = 129;
	region.eCol = 215;
	CreateWndData(hWnd, region, (uint)strTestModeVal, WDAT_TYPE_STRING, STATUS_TESTMODE, 0, 0, 0);//ʼʾ

	region.sRow = 132;
	region.sCol = 0;
	region.eRow = 155;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strFillMode, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 132;
	region.sCol = 120;
	region.eRow = 155;
	region.eCol = 215;
	CreateWndData(hWnd, region, (uint)strFillModeVal, WDAT_TYPE_STRING, STATUS_FILLMODE, 0, 0, 0);//ʼʾ

	region.sRow = 158;
	region.sCol = 0;
	region.eRow = 181;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strFillData, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʾ?
	region.sRow = 158;
	region.sCol = 120;
	region.eRow = 181;
	region.eCol = 143+24;
	CreateWndData(hWnd, region, (uint)strFillDataVal, WDAT_TYPE_STRING, STATUS_FILLDATA, 0, 0, 0);//ʼʾ
/*
	region.sRow = 184;
	region.sCol = 0;
	region.eRow = 207;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strFillMode, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ?
	region.sRow = 184;
	region.sCol = 120;
	region.eRow = 207;
	region.eCol = 215;
	CreateWndData(hWnd, region, (uint)strFillModeVal, WDAT_TYPE_STRING, STATUS_FILLMODE, 0, 0, 0);//ʼʾ

	region.sRow = 210;
	region.sCol = 0;
	region.eRow = 233;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strFillData, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 210;
	region.sCol = 120;
	region.eRow = 233;
	region.eCol = 143+24;
	CreateWndData(hWnd, region, (uint)strFillDataVal, WDAT_TYPE_STRING, STATUS_FILLDATA, 0, 0, 0);//ʼʾ
*/
	pos.pos_x = 120;
	pos.pos_y = 28;//bw
	CreateWndFocus(hWnd, pos, 60, 24, (1<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ3
	pos.pos_x = 120;
	pos.pos_y = 54;//snr
	CreateWndFocus(hWnd, pos, 84, 24,  (2<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ4
	/*pos.pos_x = 120;
	pos.pos_y = 54;//volt
	CreateWndFocus(hWnd, pos, 96, 24,   (3<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ5
	pos.pos_x = 120;
	pos.pos_y = 80;//freq
	CreateWndFocus(hWnd, pos, 120, 24, (4<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ1
	
	pos.pos_x = 120;
	pos.pos_y = 54;
	CreateWndFocus(hWnd, pos, 108, 24,  (3<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ6
	*/
	pos.pos_x = 120;
	pos.pos_y = 80;//cyc times
	CreateWndFocus(hWnd, pos, 120, 24, (3<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ2

	pos.pos_x = 120;
	pos.pos_y = 106;//test mode
	CreateWndFocus(hWnd, pos, 96, 24, (4<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ7
	pos.pos_x = 120;
	pos.pos_y = 132;//fill mode
	CreateWndFocus(hWnd, pos, 96, 24, (5<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ8
	pos.pos_x = 120;
	pos.pos_y = 158;//fill data
	CreateWndFocus(hWnd, pos, 48, 24, (6<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ9
		
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	//SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	//UpdateOverIDStatus(&StsWndLastSysInfo1,hWnd);
	//UpdateFreqStatus(&StsWndLastSysInfo1,hWnd);
	UpdateBWStatus(&StsWndLastSysInfo1,hWnd);
	UpdateSnrStatus(&StsWndLastSysInfo1,hWnd);
	//UpdateVoltStatus(&StsWndLastSysInfo1,hWnd);
	UpdateFillDataStatus(&StsWndLastSysInfo1,hWnd);
	UpdateCycCountStatus(&StsWndLastSysInfo1,hWnd);
	UpdateTestModeStatus(&StsWndLastSysInfo1,hWnd);
	//UpdateDopplerStatus(&StsWndLastSysInfo1,hWnd);
	UpdateFillModeStatus(&StsWndLastSysInfo1,hWnd);
	return hWnd;
}


HWND InitBaseWnd()
{
	HWND hWnd;
	POSITION pos;
	REGION region;

	char strOvertakeID[10] = "  ֡ :";
	char strOvtakeIDVal[2] = "AB";//9
	
	char strBw[10] 		= " źŴ:";
	char strBwVal[5] 	= "36MHz";//14
	
	char strSnr[10] 		= "   :";
	char strSnrVal[7] 	= "-19.2dB";//16

	char strAddNoise[10]    = " ģʽ:";
	char strAddNoiseVal[10]  = "ģʽ  ";
	
	//char strVolt[10] 	= " ƽ:";
	//char strVoltVal[8] 	= "-10.0dBm";//17

	//char strFreq[10] 	= " زƵ:";
	//char strFreqVal[10] = "1200000kHz";//19

	char strTestMode[10] 	= " ģʽ:";
	char strTestModeVal[8] = "";//17

	char strOverCount[10] = " ѭ:";
	char strOverCountVal[10] = "1234567890";//12
	
	char strFillMode[10] 	= " ģʽ:";
	char strFillModeVal[8] 	= "̶ģʽ";//13

	char strFillData[10] = " :";
	char strFillDataVal[4] = "0xAA";//11

	pos.pos_x = 132;
	pos.pos_y = 30;
	hWnd = CreateWnd(pos, 268, 210, 0xFFFF,0x0a0a, 1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, BASEWND);
	SetupWndRoutine(hWnd, BaseStatusWndRoutine);

	region.sRow = 2;
	region.sCol = 0;
	region.eRow = 25;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strOvertakeID, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 2;
	region.sCol = 120;
	region.eRow = 25;
	region.eCol = 120+12*2;
	CreateWndData(hWnd, region, (uint)strOvtakeIDVal, WDAT_TYPE_STRING, STATUS_OVERTAKE, 0, 0, 0);//ʼʾ
	
	region.sRow = 28;
	region.sCol = 0;
	region.eRow = 51;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strBw, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 28;
	region.sCol = 120;
	region.eRow = 51;
	region.eCol = 179;
	CreateWndData(hWnd, region, (uint)strBwVal, WDAT_TYPE_STRING, STATUS_BW, 0, 0, 0);//ʼʾ
	
	region.sRow = 54;
	region.sCol = 0;
	region.eRow = 77;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strSnr, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 54;
	region.sCol = 120;
	region.eRow = 77;
	region.eCol = 120+7*12;
	CreateWndData(hWnd, region, (uint)strSnrVal, WDAT_TYPE_STRING, STATUS_SNR, 0, 0, 0);//ʼʾ

	region.sRow = 80;
	region.sCol = 0;
	region.eRow = 103;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strAddNoise, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 80;
	region.sCol = 120;
	region.eRow = 103;
	region.eCol = 120+10*12;
	CreateWndData(hWnd, region, (uint)strAddNoiseVal, WDAT_TYPE_STRING, STATUS_ADDNOISE, 0, 0, 0);//ʼʾ

	region.sRow = 80+26;
	region.sCol = 0;
	region.eRow = 103+26;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strTestMode, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 80+26;
	region.sCol = 120;
	region.eRow = 103+26;
	region.eCol = 120+12*8;
	CreateWndData(hWnd, region, (uint)strTestModeVal, WDAT_TYPE_STRING, STATUS_TESTMODE, 0, 0, 0);//ʼʾ

	region.sRow = 106+26;
	region.sCol = 0;
	region.eRow = 129+26;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strOverCount, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 106+26;
	region.sCol = 120;
	region.eRow = 129+26;
	region.eCol = 239;
	CreateWndData(hWnd, region, (uint)strOverCountVal, WDAT_TYPE_STRING, STATUS_OVERCOUNT, 0, 0, 0);//ʼʾ

	region.sRow = 132+26;
	region.sCol = 0;
	region.eRow = 155+26;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strFillMode, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʾ?
	region.sRow = 132+26;
	region.sCol = 120;
	region.eRow = 155+26;
	region.eCol = 120+8*12;
	CreateWndData(hWnd, region, (uint)strFillModeVal, WDAT_TYPE_STRING, STATUS_FILLMODE, 0, 0, 0);//ʼʾ

	region.sRow = 158+26;
	region.sCol = 0;
	region.eRow = 181+26;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strFillData, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 158+26;
	region.sCol = 120;
	region.eRow = 181+26;
	region.eCol = 120+48;
	CreateWndData(hWnd, region, (uint)strFillDataVal, WDAT_TYPE_STRING, STATUS_FILLDATA, 0, 0, 0);//ʼʾ
/*
	region.sRow = 210+26;
	region.sCol = 0;
	region.eRow = 233+26;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strFillMode, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʾ?
	region.sRow = 210+26;
	region.sCol = 120;
	region.eRow = 233+26;
	region.eCol = 215;
	CreateWndData(hWnd, region, (uint)strFillModeVal, WDAT_TYPE_STRING, STATUS_FILLMODE, 0, 0, 0);//ʼʾ

	region.sRow = 236+26;
	region.sCol = 0;
	region.eRow = 259+26;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strFillData, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 236+26;
	region.sCol = 120;
	region.eRow = 259+26;
	region.eCol = 143+24;
	CreateWndData(hWnd, region, (uint)strFillDataVal, WDAT_TYPE_STRING, STATUS_FILLDATA, 0, 0, 0);//ʼʾ
*/
	pos.pos_x = 120;
	pos.pos_y = 2;//OVERID
	CreateWndFocus(hWnd, pos, 24, 24, (1<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ8
	pos.pos_x = 120;
	pos.pos_y = 28;//bw
	CreateWndFocus(hWnd, pos, 60, 24, (2<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ3
	pos.pos_x = 120;
	pos.pos_y = 54;//snr
	CreateWndFocus(hWnd, pos, 84, 24,  (3<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ4
	pos.pos_x = 120;
	pos.pos_y = 80;//addnoise mode
	CreateWndFocus(hWnd, pos, 120, 24,   (4<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ5
/*
	pos.pos_x = 120;
	pos.pos_y = 80+26;//volt
	CreateWndFocus(hWnd, pos, 96, 24,   (5<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ5
	pos.pos_x = 120;
	pos.pos_y = 106+26;//freq
	CreateWndFocus(hWnd, pos, 120, 24, (6<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ1

	pos.pos_x = 120;
	pos.pos_y = 80+26;//doppler
	CreateWndFocus(hWnd, pos, 108, 24,  (5<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ6
*/
	pos.pos_x = 120;
	pos.pos_y = 80+26;//test mode
	CreateWndFocus(hWnd, pos, 96, 24, (5<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ7

	pos.pos_x = 120;
	pos.pos_y = 106+26;//overcount
	CreateWndFocus(hWnd, pos, 120, 24, (6<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ8
	pos.pos_x = 120;
	pos.pos_y = 132+26;//fill mode
	CreateWndFocus(hWnd, pos, 96, 24, (7<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ9
	pos.pos_x = 120;
	pos.pos_y = 158+26;//fill data
	CreateWndFocus(hWnd, pos, 48, 24, (8<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ2
	
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateOverIDStatus(&StsWndLastSysInfo2,hWnd);
	//UpdateFreqStatus(&StsWndLastSysInfo2,hWnd);
	UpdateBWStatus(&StsWndLastSysInfo2,hWnd);
	UpdateSnrStatus(&StsWndLastSysInfo2,hWnd);
	//UpdateVoltStatus(&StsWndLastSysInfo2,hWnd);
	UpdateOverCountStatus(&StsWndLastSysInfo2,hWnd);
	UpdateAddNoiseModeStatus(&StsWndLastSysInfo2,hWnd);
	//UpdateDopplerStatus(&StsWndLastSysInfo2,hWnd);

	UpdateFillDataStatus(&StsWndLastSysInfo2,hWnd);
	UpdateFillModeStatus(&StsWndLastSysInfo2,hWnd);
	UpdateTestModeStatus(&StsWndLastSysInfo2,hWnd);
	return hWnd;
	
}

HWND InitRadParWnd()
{
	HWND hWnd;
	POSITION pos;
	REGION region;

	char strVolt[10] 		= " ƽ:";
	char strVoltVal[8] 	= "-10.0dBm";

	char strFreq[10] 		= " زƵ:";
	char strFreqVal[10] = "1200000kHz";

	char strOutSwitch[10]	= " :";
	char strOutSwitchVal[2]	= "";

	char strMSwitch[10]		= " ƿ:";
	char strMSwitchVal[2]   = "";

	char strRadTemp[10]		= " Ƶ¶:";
	char strRadTempVal[7]   = "-26.5";

	char strDopplerChange[16]= " ձ任ʽ:";
	char strDopplerChangeVal[6] = " ̶ ";
		
	char strDoppler[10] 	= " ֵ:";
	char strDopplerVal[9] = "-200000Hz";//19

	char strDopplerFreq[16]	= " ձ任:";
	char strDopplerFreqVal[6] = "0.001s";
	
	pos.pos_x = 132;
	pos.pos_y = 30;
	hWnd = CreateWnd(pos, 268, 210, 0xFFFF,0x0a0a, 1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, RADPARWND);
	SetupWndRoutine(hWnd, RadParWndRoutine);

	region.sRow = 2;
	region.sCol = 0;
	region.eRow = 25;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strOutSwitch, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 2;
	region.sCol = 120;
	region.eRow = 25;
	region.eCol = 143;
	CreateWndData(hWnd, region, (uint)strOutSwitchVal, WDAT_TYPE_STRING, STATUS_OUTSWITCH, 0, 0, 0);//ʼʾ
		
	region.sRow = 28;
	region.sCol = 0;
	region.eRow = 51;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strMSwitch, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 28;
	region.sCol = 120;
	region.eRow = 51;
	region.eCol = 143;
	CreateWndData(hWnd, region, (uint)strMSwitchVal, WDAT_TYPE_STRING, STATUS_MSWITCH, 0, 0, 0);//ʼʾ
	
	region.sRow = 54;
	region.sCol = 0;
	region.eRow = 77;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strVolt, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 54;
	region.sCol = 120;
	region.eRow = 77;
	region.eCol = 215;
	CreateWndData(hWnd, region, (uint)strVoltVal, WDAT_TYPE_STRING, STATUS_VOLT, 0, 0, 0);//ʼʾ

	region.sRow = 80;
	region.sCol = 0;
	region.eRow = 103;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strFreq, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 80;
	region.sCol = 120;
	region.eRow = 103;
	region.eCol = 239;
	CreateWndData(hWnd, region, (uint)strFreqVal, WDAT_TYPE_STRING, STATUS_FREQ, 0, 0, 0);//ʼʾ

	region.sRow = 132;
	region.sCol = 0;
	region.eRow = 155;
	region.eCol = 191;
	CreateWndData(hWnd, region, (uint)strDopplerChange, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 132;
	region.sCol = 192;
	region.eRow = 155;
	region.eCol = 263;
	CreateWndData(hWnd, region, (uint)strDopplerChangeVal, WDAT_TYPE_STRING, STATUS_DOPPLERCHANGE, 0, 0, 0);//ʼʾ

	region.sRow = 106;
	region.sCol = 0;
	region.eRow = 129;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strDoppler, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 106;
	region.sCol = 120;
	region.eRow = 129;
	region.eCol = 227;
	CreateWndData(hWnd, region, (uint)strDopplerVal, WDAT_TYPE_STRING, STATUS_DOPPLER, 0, 0, 0);//ʼʾ

	region.sRow = 158;
	region.sCol = 0;
	region.eRow = 181;
	region.eCol = 191;
	CreateWndData(hWnd, region, (uint)strDopplerFreq, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 158;
	region.sCol = 192;
	region.eRow = 181;
	region.eCol = 263;
	CreateWndData(hWnd, region, (uint)strDopplerFreqVal, WDAT_TYPE_STRING, STATUS_DOPPLERFREQ, 0, 0, 0);//ʼʾ

	region.sRow = 184;
	region.sCol = 0;
	region.eRow = 207;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strRadTemp, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 184;
	region.sCol = 120;
	region.eRow = 207;
	region.eCol = 203;
	CreateWndData(hWnd, region, (uint)strRadTempVal, WDAT_TYPE_STRING, STATUS_RADTEMP, 0, 0, 0);//ʼʾ
/*
	region.sRow = 184-24;
	region.sCol = 0;
	region.eRow = 207-24;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strDoppler, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 184-24;
	region.sCol = 120;
	region.eRow = 207-24;
	region.eCol = 239-12;
	CreateWndData(hWnd, region, (uint)strDopplerVal, WDAT_TYPE_STRING, STATUS_DOPPLER, 0, 0, 0);//ʼʾ?
*/
	pos.pos_x = 120;
	pos.pos_y = 2;
	CreateWndFocus(hWnd, pos, 24, 24, (1<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ3
	pos.pos_x = 120;
	pos.pos_y = 28;
	CreateWndFocus(hWnd, pos, 24, 24,   (2<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ5
	pos.pos_x = 120;
	pos.pos_y = 54;
	CreateWndFocus(hWnd, pos, 96, 24,  (3<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ6
	pos.pos_x = 120;
	pos.pos_y = 80;
	CreateWndFocus(hWnd, pos, 120, 24, (4<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ9
	
	pos.pos_x = 120;
	pos.pos_y = 106;
	CreateWndFocus(hWnd, pos, 108, 24, (5<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ9
	pos.pos_x = 192;
	pos.pos_y = 132;
	CreateWndFocus(hWnd, pos, 72, 24, (6<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ9
	pos.pos_x = 192;
	pos.pos_y = 158;
	CreateWndFocus(hWnd, pos, 72, 24, (7<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ9

	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	//SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	//UpdateOverIDStatus(&StsWndLastSysInfo3,hWnd);
	UpdateFreqStatus(&StsWndLastSysInfo3,hWnd);
	//UpdateBWStatus(&StsWndLastSysInfo3,hWnd);
	//UpdateSnrStatus(&StsWndLastSysInfo3,hWnd);
	UpdateVoltStatus(&StsWndLastSysInfo3,hWnd);
	UpdateDopplerStatus(&StsWndLastSysInfo3,hWnd);
	UpdateDopplerChangeStatus(&StsWndLastSysInfo3,hWnd);
	UpdateDopplerFreqStatus(&StsWndLastSysInfo3,hWnd);
	UpdateOutSwitchStatus(&StsWndLastSysInfo3,hWnd);
	UpdateMSwitchStatus(&StsWndLastSysInfo3,hWnd);
	UpdateRadTempStatus(&StsWndLastSysInfo3,hWnd);
	return hWnd;
}

HWND InitLocalParWnd()
{
	HWND hWnd;
	POSITION pos;
	REGION region;

	char strLocalIP[7] 		= "IP:";
	char strLocalIPVal[15] = "192.168.120.130";
	
	//char strHostIP[7] 		= "IP:";
	//char strHostIPVal[15] = "192.168.120.131";
	
	char strLocalMAC[13] 	= " MACַ:";
	char strLcalMACVal[17] = "FF-FF-FF-FF-FF-FF";
	
	//char strHostPort[11] 	= "PC˿:";
	//char strHostPortVal[5] = "96000";
	
	char strLocalPort[10] 	= " ˿:";
	char strLocalPortVal[5] = "96001";
	
	char strSpeed[10] 		= " ٶ:";
	char strSPeedVal[7] = "1Gbps";//100Mbps

	char strLinkState[10] 	= " ״̬:";
	char strLinkStateVal[6] = "δ";

	char strModeEdition[16] = " ֡ģʽ汾:";
	char strModeEditionVal[5] = "XXXXX";

	char strOffsetFreq[11]	= "ƵУ:";
	char strOffsetFreqVal[5] = "2550";

	char strOffsetVolt[11]	= "ƽУ:";
	char strOffsetVoltVal[6] = "-11dBm";

	char strOffsetSnr[13]	= "У:";
	char strOffsetSnrVal[7] = "-10.1dB";
	pos.pos_x = 132;
	pos.pos_y = 30;
	hWnd = CreateWnd(pos, 268, 210, 0xFFFF,0x0a0a, 1);
	if(hWnd == NULL) return hWnd;
	SetupWndRoutine(hWnd,LocalStatusWndRoutine);
	SetWndIdentity(hWnd, LOCALPARWND);

	region.sRow = 4;  
	region.sCol = 0;  
	region.eRow = 27; 
	region.eCol = 83; 
	CreateWndData(hWnd, region, (uint)strLocalIP, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 4;  
	region.sCol = 84; 
	region.eRow = 27; 
	region.eCol = 263;
	CreateWndData(hWnd, region, (uint)strLocalIPVal, WDAT_TYPE_STRING, STATUS_DEVIP, 0, 0, 0);//ʼʾ
    /*                
	region.sRow = 28; 
	region.sCol = 0;  
	region.eRow = 51; 
	region.eCol = 83;
	CreateWndData(hWnd, region, (uint)strHostIP, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 28; 
	region.sCol = 84;
	region.eRow = 51; 
	region.eCol = 263;
	CreateWndData(hWnd, region, (uint)strHostIPVal, WDAT_TYPE_STRING, STATUS_HOSTIP, 0, 0, 0);//ʼʾ
	*/                  
	region.sRow = 34; 
	region.sCol = 0;  
	region.eRow = 57; 
	region.eCol = 157;
	CreateWndData(hWnd, region, (uint)strLocalMAC, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 64; 
	region.sCol = 32;
	region.eRow = 87; 
	region.eCol = 235;
	CreateWndData(hWnd, region, (uint)strLcalMACVal, WDAT_TYPE_STRING, STATUS_DEVMAC, 0, 0, 0);//ʼʾ
                    
	region.sRow = 94; 
	region.sCol = 0;  
	region.eRow = 117;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strLocalPort, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 94; 
	region.sCol = 132;
	region.eRow = 117;
	region.eCol = 191;
	CreateWndData(hWnd, region, (uint)strLocalPortVal, WDAT_TYPE_STRING, STATUS_DEVPORT, 0, 0, 0);//ʼʾ
    /*                
	region.sRow = 106;
	region.sCol = 0;  
	region.eRow = 129;
	region.eCol = 131;
	CreateWndData(hWnd, region, (uint)strHostPort, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 106;
	region.sCol = 132;
	region.eRow = 129;
	region.eCol = 191;
	CreateWndData(hWnd, region, (uint)strHostPortVal, WDAT_TYPE_STRING, STATUS_HOSTPORT, 0, 0, 0);//ʼʾ
       */            
	region.sRow = 124;
	region.sCol = 0;  
	region.eRow = 147;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strSpeed, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 124;
	region.sCol = 132;
	region.eRow = 147;
	region.eCol = 215;
	CreateWndData(hWnd, region, (uint)strSPeedVal, WDAT_TYPE_STRING, STATUS_NETSPEED, 0, 0, 0);//ʼʾ
                    
	region.sRow = 154;
	region.sCol = 0;  
	region.eRow = 177;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)strLinkState, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ?
	region.sRow = 154;
	region.sCol = 132;
	region.eRow = 177;
	region.eCol = 203;
	CreateWndData(hWnd, region, (uint)strLinkStateVal, WDAT_TYPE_STRING, STATUS_LINK, 0, 0, 0);//ʼʾ
                    
	region.sRow = 184;
	region.sCol = 0;  
	region.eRow = 207;
	region.eCol = 191;
	CreateWndData(hWnd, region, (uint)strModeEdition, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 184;
	region.sCol = 192;
	region.eRow = 207;
	region.eCol = 251;
	CreateWndData(hWnd, region, (uint)strModeEditionVal, WDAT_TYPE_STRING, STATUS_MODEEDTION, 0, 0, 0);//ʼʾ

	region.sRow = 214;
	region.sCol = 0;  
	region.eRow = 237;
	region.eCol = 131;
	CreateWndData(hWnd, region, (uint)strOffsetFreq, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 214;
	region.sCol = 132;
	region.eRow = 237;
	region.eCol = 191;
	CreateWndData(hWnd, region, (uint)strOffsetFreqVal, WDAT_TYPE_STRING, STATUS_OFFSETFREQ, 0, 0, 0);//ʼʾ

   	region.sRow = 244;
	region.sCol = 0;  
	region.eRow = 267;
	region.eCol = 131;
	CreateWndData(hWnd, region, (uint)strOffsetVolt, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 244;
	region.sCol = 132;
	region.eRow = 267;
	region.eCol = 203;
	CreateWndData(hWnd, region, (uint)strOffsetVoltVal, WDAT_TYPE_STRING, STATUS_OFFSETVOLT, 0, 0, 0);//ʼʾ

   	region.sRow = 274;
	region.sCol = 0;  
	region.eRow = 297;
	region.eCol = 155;
	CreateWndData(hWnd, region, (uint)strOffsetSnr, WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ
	region.sRow = 274;
	region.sCol = 156;
	region.eRow = 297;
	region.eCol = 239;
	CreateWndData(hWnd, region, (uint)strOffsetSnrVal, WDAT_TYPE_STRING, STATUS_OFFSETSNR, 0, 0, 0);//ʼʾ

	pos.pos_x = 84;
	pos.pos_y = 4;
	CreateWndFocus(hWnd, pos, 180, 24,(1<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ1
	pos.pos_x = 32;
	pos.pos_y = 64;
	CreateWndFocus(hWnd, pos, 204, 24,(2<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ3
	pos.pos_x = 132;
	pos.pos_y = 94;
	CreateWndFocus(hWnd, pos, 60, 24,(3<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ4

	pos.pos_x = 132;
	pos.pos_y = 214;
	CreateWndFocus(hWnd, pos, 60, 24,(4<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ4

	pos.pos_x = 132;
	pos.pos_y = 244;
	CreateWndFocus(hWnd, pos, 72, 24,(5<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ4

	pos.pos_x = 156;
	pos.pos_y = 274;
	CreateWndFocus(hWnd, pos, 84, 24,(6<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ4
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	//SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateDevIPStatus(&StsWndLastSysInfo1,hWnd);
	UpdateDevMacStatus(&StsWndLastSysInfo1,hWnd);
	UpdateDevPortStatus(&StsWndLastSysInfo1,hWnd);
	UpdateLinkStatus(&StsWndLastSysInfo1,hWnd);
	UpdateModeEdtionStatus(&StsWndLastSysInfo1,hWnd);
	UpdateOffsetFreqStatus(&StsWndLastSysInfo1,hWnd);
	UpdateOffsetVoltStatus(&StsWndLastSysInfo1,hWnd);
	UpdateOffsetSnrStatus(&StsWndLastSysInfo1,hWnd);
	return hWnd;
	
}
HWND InitInfoWnd()
{
	HWND hWnd;
	POSITION pos;
	REGION region;

	pos.pos_x = 0;
	pos.pos_y = 4;
	hWnd = CreateWnd(pos, 252, 24, 0xFFFF,0x0a0a, 1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, INFOWND);
	
	region.sRow = 0;
	region.sCol = 0;
	region.eRow = 23;
	region.eCol = 167;
	CreateWndData(hWnd, region, (uint)"㲥ǲ豸", WDAT_TYPE_STRING, INFODATA, 0, 0, 0);//ʼʾ
	return hWnd;	
}
HWND InitNetStatusWnd()
{
	HWND hWnd;
	POSITION pos;
	REGION region;
	pos.pos_x = 374;
	pos.pos_y = 2;
	hWnd = CreateWnd(pos, 24, 24, 0xF800,0x0a0a, 1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, NETSWND);
	SetupWndRoutine(hWnd,NetStatusWndRoutine);
	//SetWndBorder(hWnd,1);

	region.sRow = 0;
	region.sCol = 0;
	region.eRow = 23;
	region.eCol = 23;
	CreateWndData(hWnd, region, (uint)gImage_netunlink, WDAT_TYPE_BITMAP, IMAGE_DATA, 0, 0, 0);//ʼʾ
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	return hWnd;
}
HWND InitWorkStatusWnd()
{
	HWND hWnd;
	POSITION pos;
	REGION region;

	pos.pos_x = 274;
	pos.pos_y = 0;
	hWnd = CreateWnd(pos, 96, 28, 0xF800,0x0a0a, 1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, WORKSTATUS);
	SetupWndRoutine(hWnd,WorkStatusWndRoutine);
	SetWndBorder(hWnd,1);
	
	region.sRow = 2;
	region.sCol = 0;
	region.eRow = 25;
	region.eCol = 95;
	CreateWndData(hWnd, region, (uint)"ʼ", WDAT_TYPE_STRING, WORKSTATUSDATA, 0, 0, 0);//ʼԾ?

	pos.pos_x = 0;
	pos.pos_y = 0;
	CreateWndFocus(hWnd, pos, 96, 28, (1<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	return hWnd;	
}

HWND InitSaveParWnd()
{
	HWND hWnd;
	POSITION pos;
	REGION region;

	pos.pos_x = 172;
	pos.pos_y = 0;
	hWnd = CreateWnd(pos, 96, 28, 0xF800,0x0a0a, 1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SAVEPARWND);
	SetupWndRoutine(hWnd,SaveParWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 2;
	region.sCol = 0;
	region.eRow = 25;
	region.eCol = 95;
	CreateWndData(hWnd, region, (uint)"", WDAT_TYPE_STRING, STATUS_SAVEPAR, 0, 0, 0);//ʼʾ
	pos.pos_x = 0;
	pos.pos_y = 0;
	CreateWndFocus(hWnd, pos, 96, 28, (1<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	return hWnd;
}

HWND InitSaveMenuWnd()
{
	HWND hWnd;
	POSITION pos;
	REGION region;
	
	char strTitle[13] = "浱ǰ?";
	char strYes[4] = "ȷ";
	char strNo[4] = "ȡ";

	pos.pos_x = 156;
	pos.pos_y = 88;
	hWnd = CreateWnd(pos,234,84,0xF800,0X0A0A,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd,SAVEMENUWND);
	SetupWndRoutine(hWnd, SetSaveMenuRoutine);
	SetWndBorder(hWnd,1);
	//SetWndDataBorder(hWnd, 1);
	
	region.sRow = 10;
	region.sCol = 6;
	region.eRow = 73;
	region.eCol = 69;
	CreateWndData(hWnd, region, (uint)gImage_waring64, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 12;
	region.sCol = 76;
	region.eRow = 35;
	region.eCol = 231;
	CreateWndData(hWnd, region,(uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 48;
	region.sCol = 100;
	region.eRow = 71;
	region.eCol = 147;
  	CreateWndData(hWnd, region,(uint)strYes, WDAT_TYPE_STRING, CUR_DATA, 0, 0, 0);//ʾ?
	
	region.sRow = 48;
	region.sCol = 160;
	region.eRow = 71;
	region.eCol = 207;
	CreateWndData(hWnd, region,(uint)strNo, WDAT_TYPE_STRING, SET_DATA, 0, 0, 0);//ʼʾ

	pos.pos_x = 100;
	pos.pos_y = 48;
	CreateWndFocus(hWnd, pos, 48, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1

	pos.pos_x = 160;
	pos.pos_y = 48;
	CreateWndFocus(hWnd, pos, 48, 24, (2<<16) + SET_DATA1, _def_FcsPixel_INV);//ʼ1

	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);

	return hWnd;
}
HWND InitMainSetWnd()
{
	HWND hWnd;
	POSITION pos;
	REGION region;

	pos.pos_x = 4;
	pos.pos_y = 40;
	hWnd = CreateWnd(pos, 128, 206, 0x07C0,0x0A0A, 1);
	if(hWnd == NULL) return hWnd;
	SetWndFontSize(hWnd,DEF_FONT_SIZE32);
	SetWndDataBorder(hWnd,1);
	//SetWndBorder(hWnd,1);
	SetWndIdentity(hWnd, MAINSETWINDOW);
	SetupWndRoutine(hWnd, MainSetWndRoutine);
	
	region.sRow = 6;
	region.sCol = 0;
	region.eRow = 37;
	region.eCol = 127;
	CreateWndData(hWnd, region, (uint)"֡", WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ

	region.sRow = 56;
	region.sCol = 0;
	region.eRow = 87;
	region.eCol = 127;
	CreateWndData(hWnd, region, (uint)"", WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ

	region.sRow = 106;
	region.sCol = 0;
	region.eRow = 137;
	region.eCol = 127;
	CreateWndData(hWnd, region, (uint)"Ƶ", WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ

	region.sRow = 156;
	region.sCol = 0;
	region.eRow = 187;
	region.eCol = 127;
	CreateWndData(hWnd, region, (uint)"", WDAT_TYPE_STRING, STATUS_MENU, 0, 0, 0);//ʼʾ

	pos.pos_x = 0;
	pos.pos_y = 0;
	CreateWndFocus(hWnd, pos, 128, 44, (1<<16) + IMAGE_DATA1, _def_FcsPixel_INV);//ʼ1
	pos.pos_x = 0;
	pos.pos_y = 50;
	CreateWndFocus(hWnd, pos, 128, 44, (2<<16) + IMAGE_DATA2, _def_FcsPixel_INV);//ʼ2
	pos.pos_x = 0;
	pos.pos_y = 100;
	CreateWndFocus(hWnd, pos, 128, 44, (3<<16) + IMAGE_DATA3, _def_FcsPixel_INV);//ʼ3
	pos.pos_x = 0;
	pos.pos_y = 150;
	CreateWndFocus(hWnd, pos, 128, 44, (4<<16) + IMAGE_DATA4, _def_FcsPixel_INV);//ʼ4
	
	return hWnd;
}
HWND InitDevInitWnd()
{
	HWND hWnd;
	REGION region;
	POSITION pos;
	
	pos.pos_x = 24;
	pos.pos_y = 16;
	hWnd = CreateWnd(pos, 352, 176, 0xa0a0,0x0a0a, 1);
	if(hWnd == NULL) return hWnd;
	SetWndFontSize(hWnd,DEF_FONT_SIZE32);
	SetWndIdentity(hWnd, DEVINIT_WND);

	region.sRow = 0;
	region.sCol = 19;
	region.eRow = 63;
	region.eCol = 328;
	CreateWndData(hWnd, region, (uint)gImage_logo, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 96;
	region.sCol = 0;
	region.eRow = 127;
	region.eCol = 351;
	CreateWndData(hWnd, region, (uint)"ӭʹù㲥ǲ豸" , WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ
	
	region.sRow = 144;
	region.sCol = 56;
	region.eRow = 175;
	region.eCol = 343;
	CreateWndData(hWnd, region, (uint)"ϵͳʼ...   ", WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ

	ShowWnd(hWnd);
	return hWnd;
}
HWND InitLineWnd()
{
	HWND hWnd;
	POSITION pos;

	pos.pos_x = 0;
	pos.pos_y = 29;
	hWnd = CreateWnd(pos, 400, 1, 0xF800,0x0a0a, 1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, LINEWND);

	return hWnd;
}
HWND InitSetOverIDWnd()
{
	HWND hWnd;
	POSITION pos;
	REGION region;
	uint uCurData = 55;
	uint uSetData = 0;
	
	char strTitle[10] = "֡";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";

	pos.pos_x = 144;
	pos.pos_y = 80;
	hWnd = CreateWnd(pos,240,130,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd,SET_OVERID_WND);
	SetupWndRoutine(hWnd, SetOverIDWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;
	region.sCol = 68;
	region.eRow = 29;
	region.eCol = 187;
	CreateWndData(hWnd, region,(uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;
	region.sCol = 58;
	region.eRow = 61;
	region.eCol = 141;
	CreateWndData(hWnd, region,(uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ

	region.sRow = 70;
	region.sCol = 58;
	region.eRow = 93;
	region.eCol = 141;
	CreateWndData(hWnd, region,(uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ

	region.sRow = 38;
	region.sCol = 142;
	region.eRow = 61;
	region.eCol = 165;
	CreateWndData(hWnd, region,uCurData, WDAT_TYPE_INTEGER, CUR_DATA, 0, 0, 0);//ʼʾ
	
	region.sRow = 70;
	region.sCol = 142;
	region.eRow = 93;
	region.eCol = 165;
	CreateWndData(hWnd, region,uSetData, WDAT_TYPE_INTEGER, SET_DATA, 0, 0, 0);//ʼʾ

	pos.pos_x = 142;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 24, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1

	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateOverIDStatus(&SetWndLastSysInfo,hWnd);
	return hWnd;

}



HWND InitSetFrqWnd()
{
	HWND hWnd;
	uint uCurData = 1200000;
	uint uSetData = 0;
	
	char strTitle[12] = "زƵ";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";
	char strUint[3] = "kHz";
	
	POSITION pos;
	REGION region;

	pos.pos_x = 144;                              
	pos.pos_y = 80;                               
	hWnd = CreateWnd(pos,240,130,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_FREQ_WND);
	SetupWndRoutine(hWnd, SetFrqWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 68; 
	region.eRow = 29; 
	region.eCol = 68+12*12;
	CreateWndData(hWnd, region,(uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);

	region.sRow = 38;
	region.sCol = 10;
	region.eRow = 61;
	region.eCol = 93;
	CreateWndData(hWnd, region,(uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);

	region.sRow = 38; 
	region.sCol = 178; 
	region.eRow = 61; 
	region.eCol = 213;
	CreateWndData(hWnd, region,(uint)strUint, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);
	
	region.sRow = 70;
	region.sCol = 10;
	region.eRow = 93;
	region.eCol = 93;
	CreateWndData(hWnd, region,(uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA4, 0, 0, 0);

	region.sRow = 70; 
	region.sCol = 178; 
	region.eRow = 93; 
	region.eCol = 213;
	CreateWndData(hWnd, region,(uint)strUint, WDAT_TYPE_STRING, IMAGE_DATA5, 0, 0, 0);
	
	region.sRow = 38; 
	region.sCol = 94; 
	region.eRow = 61; 
	region.eCol = 177;
	CreateWndData(hWnd, region,uCurData, WDAT_TYPE_INTEGER, CUR_DATA, 0, 0, 0);

	region.sRow = 70; 
	region.sCol = 94; 
	region.eRow = 93; 
	region.eCol = 177;
	CreateWndData(hWnd, region,uSetData, WDAT_TYPE_INTEGER, SET_DATA, 0, 0, 0);
	
	pos.pos_x = 94;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 84, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);


	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateFreqStatus(&SetWndLastSysInfo,hWnd);
	
	return hWnd;
}


HWND InitSetBWWnd()
{
	HWND hWnd;
	char sCurData = 36;
	char sSetData = 0;
	POSITION pos;
	REGION region;

	char strTitle[12] = "źŴ";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";
	char strUint[3] = "MHz";

	pos.pos_x = 144;
	pos.pos_y = 80;
	hWnd = CreateWnd(pos,240,130,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_BW_WND);
	SetupWndRoutine(hWnd, SetBWWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 68; 
	region.eRow = 29; 
	region.eCol = 68+12*12;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;
	region.sCol = 58;
	region.eRow = 61;
	region.eCol = 141;
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ
	region.sRow = 70;
	region.sCol = 58;
	region.eRow = 93;
	region.eCol = 141;
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ
	
	region.sRow = 38; 
	region.sCol = 178; 
	region.eRow = 61; 
	region.eCol = 213;
	CreateWndData(hWnd, region, (uint)strUint, WDAT_TYPE_STRING, IMAGE_DATA4, 0, 0, 0);//ʼʾ?
	region.sRow = 70; 
	region.sCol = 178;
	region.eRow = 93; 
	region.eCol = 213;
	CreateWndData(hWnd, region, (uint)strUint, WDAT_TYPE_STRING, IMAGE_DATA5, 0, 0, 0);//ʼʾ
	region.sRow = 38; 
	region.sCol = 142; 
	region.eRow = 61; 
	region.eCol = 165;
	CreateWndData(hWnd, region, sCurData , WDAT_TYPE_INTEGER, CUR_DATA, 0, 0, 0);//ʼʾ
	region.sRow = 70; 
	region.sCol = 142; 
	region.eRow = 93; 
	region.eCol = 165;
	CreateWndData(hWnd, region, sSetData , WDAT_TYPE_INTEGER, SET_DATA, 0, 0, 0);//ʼʾ

	pos.pos_x = 142;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 24, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateBWStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}

HWND InitSetSnrWnd()
{
	HWND hWnd;
	char sCurData[5] = "-11.6";
	char sSetData[5] = "-00.0";
	POSITION pos;
	REGION region;

	char strTitle[10] = "";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";
	char strUint[2] = "dB";

	pos.pos_x = 144;
	pos.pos_y = 60;
	hWnd = CreateWnd(pos,240,156,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_SNR_WND);
	SetupWndRoutine(hWnd, SetSnrWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 68; 
	region.eRow = 29; 
	region.eCol = 187;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;
	region.sCol = 34;
	region.eRow = 61;
	region.eCol = 117;
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ
	region.sRow = 70;
	region.sCol = 34;
	region.eRow = 93;
	region.eCol = 117;
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ
	
	region.sRow = 38;                                                                                  
	region.sCol = 190;                                                                                  
	region.eRow = 61;                                                                                  
	region.eCol = 213;                                                                                 
	CreateWndData(hWnd, region, (uint)strUint, WDAT_TYPE_STRING, IMAGE_DATA4, 0, 0, 0);//ʼʾ
	region.sRow = 70;                                                                                  
	region.sCol = 190;                                                                                 
	region.eRow = 93;                                                                                  
	region.eCol = 213;                                                                                 
	CreateWndData(hWnd, region, (uint)strUint, WDAT_TYPE_STRING, IMAGE_DATA5, 0, 0, 0);//ʼʾ
	region.sRow = 38; 
	region.sCol = 118; 
	region.eRow = 61; 
	region.eCol = 177;
	CreateWndData(hWnd, region, (uint)sCurData , WDAT_TYPE_STRING, CUR_DATA, 0, 0, 0);//ʼʾ
	
	region.sRow = 70; 
	region.sCol = 118; 
	region.eRow = 93; 
	region.eCol = 177;
	CreateWndData(hWnd, region, (uint)sSetData , WDAT_TYPE_STRING, SET_DATA, 0, 0, 0);//ʼʾ

	region.sRow = 100; 
	region.sCol = 12; 
	region.eRow = 123; 
	region.eCol = 227;
	CreateWndData(hWnd, region, (uint)" 20dBΪź!" , WDAT_TYPE_STRING, SET_DATA, 0, 0, 0);//ʼʾ

	region.sRow = 130; 
	region.sCol = 12; 
	region.eRow = 153; 
	region.eCol = 227;
	CreateWndData(hWnd, region, (uint)"С-20dBΪ!" , WDAT_TYPE_STRING, SET_DATA, 0, 0, 0);//ʼʾ

	pos.pos_x = 118;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 60, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateSnrStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}


HWND InitSetAddNoiseModeWnd()
{
	HWND hWnd;
	char sCurData[10] = "ģʽ";
	char sSetData[10] = "ģʽ";
	POSITION pos;
	REGION region;

	char strTitle[12] = "ģʽ";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";

	pos.pos_x = 138;
	pos.pos_y = 80;
	hWnd = CreateWnd(pos,250,130,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_ADDNOISE_WND);
	SetupWndRoutine(hWnd, SetAddNoiseModeWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 54; 
	region.eRow = 29; 
	region.eCol = 54+12*12;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;                                                                                 
	region.sCol = 58-30;                                                                                 
	region.eRow = 61;                                                                                 
	region.eCol = 141-30;                                                                                 
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ
	region.sRow = 70;                                                                                 
	region.sCol = 58-30;                                                                                 
	region.eRow = 93;                                                                                 
	region.eCol = 141-30;                                                                                 
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ

	region.sRow = 38; 
	region.sCol = 152-30; 
	region.eRow = 61; 
	region.eCol = 251;
	CreateWndData(hWnd, region, (uint)sCurData , WDAT_TYPE_STRING, CUR_DATA, 0, 0, 0);//ʼʾ
	region.sRow = 70; 
	region.sCol = 152-30; 
	region.eRow = 93; 
	region.eCol = 251;
	CreateWndData(hWnd, region, (uint)sSetData , WDAT_TYPE_STRING, SET_DATA, 0, 0, 0);//ʼʾ

	pos.pos_x = 152-30;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 120, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateAddNoiseModeStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}

HWND InitSetVoltWnd()
{
	HWND hWnd;
	Uint16 sCurData = 13;
	char sSetSign[1] = "-";
	Uint16 sSetData = 0;
	POSITION pos;
	REGION region;

	char strTitle[12] = "ƽ";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";
	char strUint[3] = "dBm";

	pos.pos_x = 144;
	pos.pos_y = 80;
	hWnd = CreateWnd(pos,240,130,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_VOLT_WND);
	SetupWndRoutine(hWnd, SetVoltWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 68; 
	region.eRow = 29; 
	region.eCol = 68+12*12;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;
	region.sCol = 34;
	region.eRow = 61;
	region.eCol = 117;
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ
	region.sRow = 70;
	region.sCol = 34;
	region.eRow = 93;
	region.eCol = 117;
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ
	
	region.sRow = 38;                                                                                  
	region.sCol = 166;                                                                                  
	region.eRow = 61;                                                                                  
	region.eCol = 201;                                                                                 
	CreateWndData(hWnd, region, (uint)strUint, WDAT_TYPE_STRING, IMAGE_DATA4, 0, 0, 0);//ʼʾ
	region.sRow = 70;                                                                                  
	region.sCol = 166;                                                                                 
	region.eRow = 93;                                                                                  
	region.eCol = 201;                                                                                 
	CreateWndData(hWnd, region, (uint)strUint, WDAT_TYPE_STRING, IMAGE_DATA5, 0, 0, 0);//ʼʾ

	region.sRow = 38; 
	region.sCol = 118; 
	region.eRow = 61; 
	region.eCol = 129;
	CreateWndData(hWnd, region, (uint)sSetSign , WDAT_TYPE_STRING, CUR_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38; 
	region.sCol = 130; 
	region.eRow = 61; 
	region.eCol = 153;
	CreateWndData(hWnd, region, sCurData , WDAT_TYPE_INTEGER, CUR_DATA, 0, 0, 0);//ʼʾ

	region.sRow = 70; 
	region.sCol = 118; 
	region.eRow = 93; 
	region.eCol = 129;
	CreateWndData(hWnd, region, (uint)sSetSign , WDAT_TYPE_STRING, SET_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 70; 
	region.sCol = 130; 
	region.eRow = 93; 
	region.eCol = 153;
	CreateWndData(hWnd, region, sSetData , WDAT_TYPE_INTEGER, SET_DATA, 0, 0, 0);//ʼʾ


	pos.pos_x = 130;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 24, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateVoltStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}


HWND InitSetFillDataWnd()
{
	HWND hWnd;
	char sCurData[4] = "0xFF";
	char sSetData[4] = "0xFF";
	POSITION pos;
	REGION region;

	char strTitle[12] = "";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";

	pos.pos_x = 144;
	pos.pos_y = 80;
	hWnd = CreateWnd(pos,240,130,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_FILLDATA_WND);
	SetupWndRoutine(hWnd, SetFillDataWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 68; 
	region.eRow = 29; 
	region.eCol = 211;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;                                                                                 
	region.sCol = 58;                                                                                 
	region.eRow = 61;                                                                                 
	region.eCol = 141;                                                                                 
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ
	region.sRow = 70;                                                                                 
	region.sCol = 58;                                                                                 
	region.eRow = 93;                                                                                 
	region.eCol = 141;                                                                                 
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ
	
	region.sRow = 38; 
	region.sCol = 142; 
	region.eRow = 61; 
	region.eCol = 165+24;
	CreateWndData(hWnd, region, (uint)sCurData , WDAT_TYPE_STRING, CUR_DATA, 0, 0, 0);//ʼʾ
	region.sRow = 70; 
	region.sCol = 142; 
	region.eRow = 93; 
	region.eCol = 165+24;
	CreateWndData(hWnd, region, (uint)sSetData , WDAT_TYPE_STRING, SET_DATA, 0, 0, 0);//ʼʾ

	pos.pos_x = 142+24;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 12, 24, (0<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	pos.pos_x = 154+24;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 12, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateFillDataStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}


HWND InitSetCycCountWnd()
{
	HWND hWnd;
	uint sCurData = 10000;
	uint sSetData = 0;
	POSITION pos;
	REGION region;

	char strTitle[12] = "ѭ";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";

	pos.pos_x = 144;
	pos.pos_y = 80;
	hWnd = CreateWnd(pos,240,130,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_SENDCOUNT_WND);
	SetupWndRoutine(hWnd, SetCycTimesWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 68; 
	region.eRow = 29; 
	region.eCol = 211;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;                                                                                 
	region.sCol = 24;                                                                                 
	region.eRow = 61;                                                                                 
	region.eCol = 107;                                                                                 
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ
	region.sRow = 70;                                                                                 
	region.sCol = 24;                                                                                 
	region.eRow = 93;                                                                                 
	region.eCol = 107;                                                                                 
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ
	
	region.sRow = 38; 
	region.sCol = 108; 
	region.eRow = 61; 
	region.eCol = 227;
	CreateWndData(hWnd, region, sCurData , WDAT_TYPE_INTEGER, CUR_DATA, 0, 0, 0);//ʼʾ
	region.sRow = 70; 
	region.sCol = 108; 
	region.eRow = 93; 
	region.eCol = 227;
	CreateWndData(hWnd, region, sSetData , WDAT_TYPE_INTEGER, SET_DATA, 0, 0, 0);//ʼʾ?

	pos.pos_x = 108;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 120, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateCycCountStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}

HWND InitSetOverCountWnd()
{
	HWND hWnd;
	uint sCurData = 10000;
	uint sSetData = 0;
	POSITION pos;
	REGION region;

	char strTitle[14] = "ͳ֡";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";

	pos.pos_x = 136;
	pos.pos_y = 80;
	hWnd = CreateWnd(pos,256,130,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_OVERCOUNT_WND);
	SetupWndRoutine(hWnd, SetOverCountWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 68; 
	region.eRow = 29; 
	region.eCol = 235;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;                                                                                 
	region.sCol = 24;                                                                                 
	region.eRow = 61;                                                                                 
	region.eCol = 107;                                                                                 
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ?
	region.sRow = 70;                                                                                 
	region.sCol = 24;                                                                                 
	region.eRow = 93;                                                                                 
	region.eCol = 107;                                                                                 
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ
	
	region.sRow = 38; 
	region.sCol = 108; 
	region.eRow = 61; 
	region.eCol = 227;
	CreateWndData(hWnd, region, sCurData , WDAT_TYPE_INTEGER, CUR_DATA, 0, 0, 0);//ʼʾ?
	region.sRow = 70; 
	region.sCol = 108; 
	region.eRow = 93; 
	region.eCol = 227;
	CreateWndData(hWnd, region, sSetData , WDAT_TYPE_INTEGER, SET_DATA, 0, 0, 0);//ʼʾ

	pos.pos_x = 108;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 120, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateOverCountStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}

HWND InitSetFillModeWnd()
{
	HWND hWnd;
	char sCurData[8] = "̶ģʽ";
	char sSetData[8] = "̶ģʽ";
	POSITION pos;
	REGION region;

	char strTitle[12] = "ģʽ";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";

	pos.pos_x = 142;
	pos.pos_y = 80;
	hWnd = CreateWnd(pos,244,130,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_FILLMODE_WND);
	SetupWndRoutine(hWnd, SetFillModeWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 54; 
	region.eRow = 29; 
	region.eCol = 54+12*12;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;                                                                                 
	region.sCol = 58-24;                                                                                 
	region.eRow = 61;                                                                                 
	region.eCol = 141-24;                                                                                 
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ
	region.sRow = 70;                                                                                 
	region.sCol = 58-24;                                                                                 
	region.eRow = 93;                                                                                 
	region.eCol = 141-24;                                                                                 
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ

	region.sRow = 38; 
	region.sCol = 152-24; 
	region.eRow = 61; 
	region.eCol = 257-24;
	CreateWndData(hWnd, region, (uint)sCurData , WDAT_TYPE_STRING, CUR_DATA, 0, 0, 0);//ʼʾ
	region.sRow = 70; 
	region.sCol = 152-24; 
	region.eRow = 93; 
	region.eCol = 257-24;
	CreateWndData(hWnd, region, (uint)sSetData , WDAT_TYPE_STRING, SET_DATA, 0, 0, 0);//ʼʾ

	pos.pos_x = 152-24;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 96, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateFillModeStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}


HWND InitSetOutSwitchWnd()
{
	HWND hWnd;
	char sCurData[2] = "";
	char sSetData[2] = "";
	POSITION pos;
	REGION region;

	char strTitle[12] = "";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";

	pos.pos_x = 142;
	pos.pos_y = 80;
	hWnd = CreateWnd(pos,244,130,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_OUTSWITCH_WND);
	SetupWndRoutine(hWnd, SetOutSwitchWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 54; 
	region.eRow = 29; 
	region.eCol = 54+12*12;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;                                                                                 
	region.sCol = 58-24;                                                                                 
	region.eRow = 61;                                                                                 
	region.eCol = 141-24;                                                                                 
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ
	region.sRow = 70;                                                                                 
	region.sCol = 58-24;                                                                                 
	region.eRow = 93;                                                                                 
	region.eCol = 141-24;                                                                                 
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ

	region.sRow = 38; 
	region.sCol = 152-24; 
	region.eRow = 61; 
	region.eCol = 152;
	CreateWndData(hWnd, region, (uint)sCurData , WDAT_TYPE_STRING, CUR_DATA, 0, 0, 0);//ʼʾ
	region.sRow = 70; 
	region.sCol = 152-24; 
	region.eRow = 93; 
	region.eCol = 152;
	CreateWndData(hWnd, region, (uint)sSetData , WDAT_TYPE_STRING, SET_DATA, 0, 0, 0);//ʼʾ

	pos.pos_x = 152-24;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 24, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateOutSwitchStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}


HWND InitSetMSwitchWnd()
{
	HWND hWnd;
	char sCurData[2] = "";
	char sSetData[2] = "";
	POSITION pos;
	REGION region;

	char strTitle[12] = "ƿ";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";

	pos.pos_x = 142;
	pos.pos_y = 80;
	hWnd = CreateWnd(pos,244,130,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_MSWITCH_WND);
	SetupWndRoutine(hWnd, SetMSwitchWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 54; 
	region.eRow = 29; 
	region.eCol = 54+12*12;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;                                                                                 
	region.sCol = 58-24;                                                                                 
	region.eRow = 61;                                                                                 
	region.eCol = 141-24;                                                                                 
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ
	region.sRow = 70;                                                                                 
	region.sCol = 58-24;                                                                                 
	region.eRow = 93;                                                                                 
	region.eCol = 141-24;                                                                                 
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ

	region.sRow = 38; 
	region.sCol = 152-24; 
	region.eRow = 61; 
	region.eCol = 152;
	CreateWndData(hWnd, region, (uint)sCurData , WDAT_TYPE_STRING, CUR_DATA, 0, 0, 0);//ʼʾ
	region.sRow = 70; 
	region.sCol = 152-24; 
	region.eRow = 93; 
	region.eCol = 152;
	CreateWndData(hWnd, region, (uint)sSetData , WDAT_TYPE_STRING, SET_DATA, 0, 0, 0);//ʼʾ

	pos.pos_x = 152-24;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 24, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateMSwitchStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}


HWND InitSetTestModeWnd()
{
	HWND hWnd;
	char sCurData[8] = "";
	char sSetData[8] = "";
	POSITION pos;
	REGION region;

	char strTitle[12] = "ģʽ";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";

	pos.pos_x = 142;
	pos.pos_y = 80;
	hWnd = CreateWnd(pos,244,130,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_TESTMODE_WND);
	SetupWndRoutine(hWnd, SetTestModeWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 54; 
	region.eRow = 29; 
	region.eCol = 54+12*12;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;                                                                                 
	region.sCol = 58-24;                                                                                 
	region.eRow = 61;                                                                                 
	region.eCol = 141-24;                                                                                 
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ
	region.sRow = 70;                                                                                 
	region.sCol = 58-24;                                                                                 
	region.eRow = 93;                                                                                 
	region.eCol = 141-24;                                                                                 
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ

	region.sRow = 38; 
	region.sCol = 152-24; 
	region.eRow = 61; 
	region.eCol = 247-24;
	CreateWndData(hWnd, region, (uint)sCurData , WDAT_TYPE_STRING, CUR_DATA, 0, 0, 0);//ʼʾ
	region.sRow = 70; 
	region.sCol = 152-24; 
	region.eRow = 93; 
	region.eCol = 247-24;
	CreateWndData(hWnd, region, (uint)sSetData , WDAT_TYPE_STRING, SET_DATA, 0, 0, 0);//ʼʾ

	pos.pos_x = 152-24;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 96, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateTestModeStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}

HWND InitSetDopplerWnd()
{
	HWND hWnd;
	int sCurData = -100000;
	int sSetData = 0;
	uchar sSetSign[1] = "-";
	POSITION pos;
	REGION region;

	char strTitle[10] = "";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";
	char strUint[2] = "Hz";

	pos.pos_x = 144;
	pos.pos_y = 80;
	hWnd = CreateWnd(pos,240,130,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_DOPPLER_WND);
	SetupWndRoutine(hWnd, SetDopplerWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 68; 
	region.eRow = 29; 
	region.eCol = 187;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;                                                                                 
	region.sCol = 10;                                                                                 
	region.eRow = 61;                                                                                 
	region.eCol = 93;                                                                                 
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ
	region.sRow = 70;                                                                                 
	region.sCol = 10;                                                                                 
	region.eRow = 93;                                                                                 
	region.eCol = 93;                                                                                 
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ
	
	region.sRow = 38;                                                                                  
	region.sCol = 190;                                                                                  
	region.eRow = 61;                                                                                  
	region.eCol = 213;                                                                                 
	CreateWndData(hWnd, region, (uint)strUint, WDAT_TYPE_STRING, IMAGE_DATA4, 0, 0, 0);//ʼʾ
	region.sRow = 70;                                                                                  
	region.sCol = 190;                                                                                 
	region.eRow = 93;                                                                                  
	region.eCol = 213;                                                                                 
	CreateWndData(hWnd, region, (uint)strUint, WDAT_TYPE_STRING, IMAGE_DATA5, 0, 0, 0);//ʼʾ
	region.sRow = 38; 
	region.sCol = 94; 
	region.eRow = 61; 
	region.eCol = 105;
	CreateWndData(hWnd, region, (uint)sSetSign , WDAT_TYPE_STRING, CUR_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38; 
	region.sCol = 106; 
	region.eRow = 61; 
	region.eCol = 189;
	CreateWndData(hWnd, region, sCurData , WDAT_TYPE_INTEGER, CUR_DATA, 0, 0, 0);//ʼʾ
	
	region.sRow = 70; 
	region.sCol = 94; 
	region.eRow = 93; 
	region.eCol = 105;
	CreateWndData(hWnd, region, (uint)sSetSign , WDAT_TYPE_STRING, SET_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 70; 
	region.sCol = 106; 
	region.eRow = 93; 
	region.eCol = 189;
	CreateWndData(hWnd, region, sSetData , WDAT_TYPE_INTEGER, SET_DATA, 0, 0, 0);//ʼʾ

	pos.pos_x = 94;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 84, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateDopplerStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}



HWND InitSetDopplerFreqWnd()
{
	HWND hWnd;
	char uCurData[8] = "1000.000";
	char uSetData[8] = "1000.000";
	
	char strTitle[18] = "ձ任";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";
	char strUint[1] = "s";
	
	POSITION pos;
	REGION region;

	pos.pos_x = 136;                              
	pos.pos_y = 80;                               
	hWnd = CreateWnd(pos,262,130,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_DOPPLERFREQ_WND);
	SetupWndRoutine(hWnd, SetDopplerFreqWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 6;
	region.eRow = 34;
	region.eCol = 37;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 38; 
	region.eRow = 29; 
	region.eCol = 37+12*18;
	CreateWndData(hWnd, region,(uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);

	region.sRow = 38;
	region.sCol = 10;
	region.eRow = 61;
	region.eCol = 93;
	CreateWndData(hWnd, region,(uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);

	region.sRow = 38; 
	region.sCol = 190; 
	region.eRow = 61; 
	region.eCol = 201;
	CreateWndData(hWnd, region,(uint)strUint, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);
	
	region.sRow = 70;
	region.sCol = 10;
	region.eRow = 93;
	region.eCol = 93;
	CreateWndData(hWnd, region,(uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA4, 0, 0, 0);

	region.sRow = 70; 
	region.sCol = 190; 
	region.eRow = 93; 
	region.eCol = 201;
	CreateWndData(hWnd, region,(uint)strUint, WDAT_TYPE_STRING, IMAGE_DATA5, 0, 0, 0);
	
	region.sRow = 38; 
	region.sCol = 94; 
	region.eRow = 61; 
	region.eCol = 189;
	CreateWndData(hWnd, region,(uint)uCurData, WDAT_TYPE_STRING, CUR_DATA, 0, 0, 0);

	region.sRow = 70; 
	region.sCol = 94; 
	region.eRow = 93; 
	region.eCol = 189;
	CreateWndData(hWnd, region,(uint)uSetData, WDAT_TYPE_STRING, SET_DATA, 0, 0, 0);
	
	pos.pos_x = 94;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 96, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);


	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateDopplerFreqStatus(&SetWndLastSysInfo,hWnd);
	
	return hWnd;
}

HWND InitSetDopplerChangeWnd()
{
	HWND hWnd;
	char sCurData[6] = " ̶ ";
	char sSetData[6] = " ̶ ";
	POSITION pos;
	REGION region;

	char strTitle[18] = "ձ任ʽ";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";

	pos.pos_x = 136;
	pos.pos_y = 80;
	hWnd = CreateWnd(pos,262,130,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_DOPPLERCHANGE_WND);
	SetupWndRoutine(hWnd, SetDopplerChangeWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 6;
	region.eRow = 34;
	region.eCol = 37;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 38; 
	region.eRow = 29; 
	region.eCol = 37+12*18;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;                                                                                 
	region.sCol = 58-24;                                                                                 
	region.eRow = 61;                                                                                 
	region.eCol = 141-24;                                                                                 
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ
	region.sRow = 70;                                                                                 
	region.sCol = 58-24;                                                                                 
	region.eRow = 93;                                                                                 
	region.eCol = 141-24;                                                                                 
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ

	region.sRow = 38; 
	region.sCol = 152-24; 
	region.eRow = 61; 
	region.eCol = 257-12;
	CreateWndData(hWnd, region, (uint)sCurData , WDAT_TYPE_STRING, CUR_DATA, 0, 0, 0);//ʼʾ
	region.sRow = 70; 
	region.sCol = 152-24; 
	region.eRow = 93; 
	region.eCol = 257-12;
	CreateWndData(hWnd, region, (uint)sSetData , WDAT_TYPE_STRING, SET_DATA, 0, 0, 0);//ʼʾ

	pos.pos_x = 152-24;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 72, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateDopplerChangeStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}

HWND InitSetDevIPWnd()
{
	HWND hWnd;
	char sCurData[15] = "192.168. 1 . 1 ";
	char sSetData[15] = "   .   .   .   ";
	Uint8 sSetData1 = 0;
	Uint8 sSetData2 = 0;
	Uint8 sSetData3 = 0;
	Uint8 sSetData4 = 0;	
	POSITION pos;
	REGION region;

	char strTitle[10] = "IP";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";

	pos.pos_x = 132;
	pos.pos_y = 80;
	hWnd = CreateWnd(pos,268,124,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_DEVIP_WND);
	SetupWndRoutine(hWnd, SetIPWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 44;
	region.eRow = 34;
	region.eCol = 75;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 92; 
	region.eRow = 29; 
	region.eCol = 211;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;                                                                                 
	region.sCol = 0;                                                                                 
	region.eRow = 61;                                                                                 
	region.eCol = 83;                                                                                 
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ
	region.sRow = 70;                                                                                 
	region.sCol = 0;                                                                                 
	region.eRow = 93;                                                                                 
	region.eCol = 83;                                                                                 
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ
	
	region.sRow = 38; 
	region.sCol = 84; 
	region.eRow = 61; 
	region.eCol = 263;
	CreateWndData(hWnd, region, (uint)sCurData , WDAT_TYPE_STRING, CUR_DATA, 0, 0, 0);//ʼʾ
	region.sRow = 70; 
	region.sCol = 84; 
	region.eRow = 93; 
	region.eCol = 263;
	CreateWndData(hWnd, region, (uint)sSetData , WDAT_TYPE_STRING, SET_DATA, 0, 0, 0);//ʼʾ

	region.sRow = 70;
	region.sCol = 84;
	region.eRow = 93;
	region.eCol = 119;
	CreateWndData(hWnd, region, (uint)sSetData1 , WDAT_TYPE_INTEGER, SET_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 70; 
	region.sCol = 132; 
	region.eRow = 93; 
	region.eCol = 167;
	CreateWndData(hWnd, region, (uint)sSetData2 , WDAT_TYPE_INTEGER, SET_DATA2, 0, 0, 0);//ʼʾ

	region.sRow = 70;
	region.sCol = 180;
	region.eRow = 93;
	region.eCol = 215;
	CreateWndData(hWnd, region, (uint)sSetData3 , WDAT_TYPE_INTEGER, SET_DATA3, 0, 0, 0);//ʾ?

	region.sRow = 70;
	region.sCol = 228;
	region.eRow = 93;
	region.eCol = 263;
	CreateWndData(hWnd, region, (uint)sSetData4 , WDAT_TYPE_INTEGER, SET_DATA4, 0, 0, 0);//ʼʾ

	pos.pos_x = 84;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 36, 24, (1<<16) + SET_DATA1, _def_FcsPixel_INV);//ʼ1

	pos.pos_x = 132;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 36, 24, (2<<16) + SET_DATA2, _def_FcsPixel_INV);//ʼ1

	pos.pos_x = 180;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 36, 24, (3<<16) + SET_DATA3, _def_FcsPixel_INV);//ʼ1

	pos.pos_x = 228;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 36, 24, (4<<16) + SET_DATA4, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateDevIPStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}



HWND InitSetDevPortWnd()
{
	HWND hWnd;
	uint sCurData = 96000;
	uint sSetData = 0;
	POSITION pos;
	REGION region;

	char strTitle[12] = "˿";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";

	pos.pos_x = 144;
	pos.pos_y = 80;
	hWnd = CreateWnd(pos,268,124,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_DEVPORT_WND);
	SetupWndRoutine(hWnd, SetPortWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 68; 
	region.eRow = 29; 
	region.eCol = 223;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;
	region.sCol = 50;
	region.eRow = 61;
	region.eCol = 133;
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ?
	region.sRow = 70;
	region.sCol = 50;
	region.eRow = 93;
	region.eCol = 133;
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ

	region.sRow = 38; 
	region.sCol = 134; 
	region.eRow = 61; 
	region.eCol = 193;
	CreateWndData(hWnd, region, sCurData , WDAT_TYPE_INTEGER, CUR_DATA, 0, 0, 0);//ʼʾ
	region.sRow = 70; 
	region.sCol = 134; 
	region.eRow = 93; 
	region.eCol = 193;
	CreateWndData(hWnd, region, sSetData , WDAT_TYPE_INTEGER, SET_DATA, 0, 0, 0);//ʼʾ

	pos.pos_x = 134;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 60, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateDevPortStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}


HWND InitSetDevMACWnd()
{
	HWND hWnd;
	char sCurData[17] = "FF-FF-FF-FF-FF-FF";
	char sSetData[17] = "  -  -  -  -  -  ";
	POSITION pos;
	REGION region;

	char strTitle[11] = "MAC";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";

	pos.pos_x = 110;                              
	pos.pos_y = 70;                               
	hWnd = CreateWnd(pos,288,124,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_DEVMAC_WND);
	SetupWndRoutine(hWnd, SetMacWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 68;
	region.eRow = 34;
	region.eCol = 99;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 116; 
	region.eRow = 29; 
	region.eCol = 247;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);

	region.sRow = 38;
	region.sCol = 0;
	region.eRow = 61;
	region.eCol = 83;
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);
	region.sRow = 70;
	region.sCol = 0;
	region.eRow = 93;
	region.eCol = 83;
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);
	
	region.sRow = 38;
	region.sCol = 84;
	region.eRow = 61;
	region.eCol = 287;
	CreateWndData(hWnd, region, (uint)sCurData , WDAT_TYPE_STRING, CUR_DATA, 0, 0, 0);
	region.sRow = 70;
	region.sCol = 84;
	region.eRow = 93;
	region.eCol = 287;
	CreateWndData(hWnd, region, (uint)sSetData , WDAT_TYPE_STRING, SET_DATA, 0, 0, 0);

	pos.pos_x = 84;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 12, 24, (0<<16) + SET_DATA, _def_FcsPixel_INV);
	pos.pos_x = 96;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 12, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);
	
	pos.pos_x = 120;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 12, 24, (3<<16) + SET_DATA, _def_FcsPixel_INV);
	pos.pos_x = 132;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 12, 24, (4<<16) + SET_DATA, _def_FcsPixel_INV);
	
	pos.pos_x = 156;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 12, 24, (6<<16) + SET_DATA, _def_FcsPixel_INV);
	pos.pos_x = 168;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 12, 24, (7<<16) + SET_DATA, _def_FcsPixel_INV);
	
	pos.pos_x = 192;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 12, 24, (9<<16) + SET_DATA, _def_FcsPixel_INV);
	pos.pos_x = 204;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 12, 24, (10<<16) + SET_DATA, _def_FcsPixel_INV);
	
	pos.pos_x = 228;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 12, 24, (12<<16) + SET_DATA, _def_FcsPixel_INV);
	pos.pos_x = 240;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 12, 24, (13<<16) + SET_DATA, _def_FcsPixel_INV);
	
	pos.pos_x = 264;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 12, 24, (15<<16) + SET_DATA, _def_FcsPixel_INV);
	pos.pos_x = 276;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 12, 24, (16<<16) + SET_DATA, _def_FcsPixel_INV);
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateDevMacStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}


HWND InitSetOffsetFreqWnd()
{
	HWND hWnd;
	uint sCurData = 2550;
	uint sSetData = 0;
	POSITION pos;
	REGION region;

	char strTitle[14] = "ƵУ";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";

	pos.pos_x = 144;
	pos.pos_y = 80;
	hWnd = CreateWnd(pos,268,124,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_OFFSETFREQ_WND);
	SetupWndRoutine(hWnd, SetOffsetFreqWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 68; 
	region.eRow = 29; 
	region.eCol = 223;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;
	region.sCol = 50;
	region.eRow = 61;
	region.eCol = 133;
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ?
	region.sRow = 70;
	region.sCol = 50;
	region.eRow = 93;
	region.eCol = 133;
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ

	region.sRow = 38; 
	region.sCol = 134; 
	region.eRow = 61; 
	region.eCol = 193;
	CreateWndData(hWnd, region, sCurData , WDAT_TYPE_INTEGER, CUR_DATA, 0, 0, 0);//ʼʾ
	region.sRow = 70; 
	region.sCol = 134; 
	region.eRow = 93; 
	region.eCol = 193;
	CreateWndData(hWnd, region, sSetData , WDAT_TYPE_INTEGER, SET_DATA, 0, 0, 0);//ʼʾ

	pos.pos_x = 134;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 60, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateOffsetFreqStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}

HWND InitSetOffsetVoltWnd()
{
	HWND hWnd;
	Uint16 sCurData = 13;
	char sSetSign[1] = "-";
	Uint16 sSetData = 0;
	POSITION pos;
	REGION region;

	char strTitle[14] = "ƽУ";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";
	char strUint[3] = "dBm";

	pos.pos_x = 144;
	pos.pos_y = 80;
	hWnd = CreateWnd(pos,240,130,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_OFFSETVOLT_WND);
	SetupWndRoutine(hWnd, SetOffsetVoltWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 68; 
	region.eRow = 29; 
	region.eCol = 68+12*12;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;
	region.sCol = 34;
	region.eRow = 61;
	region.eCol = 117;
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ
	region.sRow = 70;
	region.sCol = 34;
	region.eRow = 93;
	region.eCol = 117;
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ
	
	region.sRow = 38;                                                                                  
	region.sCol = 166;                                                                                  
	region.eRow = 61;                                                                                  
	region.eCol = 201;                                                                                 
	CreateWndData(hWnd, region, (uint)strUint, WDAT_TYPE_STRING, IMAGE_DATA4, 0, 0, 0);//ʼʾ
	region.sRow = 70;                                                                                  
	region.sCol = 166;                                                                                 
	region.eRow = 93;                                                                                  
	region.eCol = 201;                                                                                 
	CreateWndData(hWnd, region, (uint)strUint, WDAT_TYPE_STRING, IMAGE_DATA5, 0, 0, 0);//ʼʾ

	region.sRow = 38; 
	region.sCol = 118; 
	region.eRow = 61; 
	region.eCol = 129;
	CreateWndData(hWnd, region, (uint)sSetSign , WDAT_TYPE_STRING, CUR_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38; 
	region.sCol = 130; 
	region.eRow = 61; 
	region.eCol = 153;
	CreateWndData(hWnd, region, sCurData , WDAT_TYPE_INTEGER, CUR_DATA, 0, 0, 0);//ʼʾ

	region.sRow = 70; 
	region.sCol = 118; 
	region.eRow = 93; 
	region.eCol = 129;
	CreateWndData(hWnd, region, (uint)sSetSign , WDAT_TYPE_STRING, SET_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 70; 
	region.sCol = 130; 
	region.eRow = 93; 
	region.eCol = 153;
	CreateWndData(hWnd, region, sSetData , WDAT_TYPE_INTEGER, SET_DATA, 0, 0, 0);//ʼʾ


	pos.pos_x = 130;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 24, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateOffsetVoltStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}

HWND InitSetOffsetSnrWnd()
{
	HWND hWnd;
	char sCurData[5] = "-11.6";
	char sSetData[5] = "-00.0";
	POSITION pos;
	REGION region;

	char strTitle[16] = "У";
	char strCur[7] = "ǰֵ:";
	char strSet[7] = "ֵ:";
	char strUint[2] = "dB";

	pos.pos_x = 144;
	pos.pos_y = 60;
	hWnd = CreateWnd(pos,240,130,0x571d,0x03E0,1);
	if(hWnd == NULL) return hWnd;
	SetWndIdentity(hWnd, SET_OFFSETSNR_WND);
	SetupWndRoutine(hWnd, SetOffsetSnrWndRoutine);
	SetWndBorder(hWnd,1);

	region.sRow = 3;
	region.sCol = 20;
	region.eRow = 34;
	region.eCol = 51;
	CreateWndData(hWnd, region, (uint)gImage_waring, WDAT_TYPE_BITMAP, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 6;  
	region.sCol = 68; 
	region.eRow = 29; 
	region.eCol = 187;
	CreateWndData(hWnd, region, (uint)strTitle, WDAT_TYPE_STRING, IMAGE_DATA1, 0, 0, 0);//ʼʾ

	region.sRow = 38;
	region.sCol = 34;
	region.eRow = 61;
	region.eCol = 117;
	CreateWndData(hWnd, region, (uint)strCur, WDAT_TYPE_STRING, IMAGE_DATA2, 0, 0, 0);//ʼʾ
	region.sRow = 70;
	region.sCol = 34;
	region.eRow = 93;
	region.eCol = 117;
	CreateWndData(hWnd, region, (uint)strSet, WDAT_TYPE_STRING, IMAGE_DATA3, 0, 0, 0);//ʼʾ
	
	region.sRow = 38;                                                                                  
	region.sCol = 190;                                                                                  
	region.eRow = 61;                                                                                  
	region.eCol = 213;                                                                                 
	CreateWndData(hWnd, region, (uint)strUint, WDAT_TYPE_STRING, IMAGE_DATA4, 0, 0, 0);//ʼʾ
	region.sRow = 70;                                                                                  
	region.sCol = 190;                                                                                 
	region.eRow = 93;                                                                                  
	region.eCol = 213;                                                                                 
	CreateWndData(hWnd, region, (uint)strUint, WDAT_TYPE_STRING, IMAGE_DATA5, 0, 0, 0);//ʼʾ
	region.sRow = 38; 
	region.sCol = 118; 
	region.eRow = 61; 
	region.eCol = 177;
	CreateWndData(hWnd, region, (uint)sCurData , WDAT_TYPE_STRING, CUR_DATA, 0, 0, 0);//ʼʾ
	
	region.sRow = 70; 
	region.sCol = 118; 
	region.eRow = 93; 
	region.eCol = 177;
	CreateWndData(hWnd, region, (uint)sSetData , WDAT_TYPE_STRING, SET_DATA, 0, 0, 0);//ʼʾ

	pos.pos_x = 118;
	pos.pos_y = 70;
	CreateWndFocus(hWnd, pos, 60, 24, (1<<16) + SET_DATA, _def_FcsPixel_INV);//ʼ1
	
	CreateWndTimer(hWnd, FOCUS_TICK, 0, 0);
	SetupWndHook(hWnd, Hook_EnterWnd, WHK_Type_show);
	SetupWndHook(hWnd, Hook_ExitWnd, WHK_Type_hide);
	UpdateOffsetSnrStatus(&SetWndLastSysInfo,hWnd);

	return hWnd;
}

HWND InitAllWnd(/*uint resX, uint resY*/)
{
/*	memset(&SysInfo, 0, sizeof(STATUSINFO));
	StsWndLastSysInfo = SysInfo ;
	SetWndLastSysInfo = SysInfo ;*/

	mmzero(&StsWndLastSysInfo1, sizeof(STATUSINFO));
	mmzero(&StsWndLastSysInfo2, sizeof(STATUSINFO));
	mmzero(&StsWndLastSysInfo3, sizeof(STATUSINFO));
	mmzero(&SetWndLastSysInfo, sizeof(STATUSINFO));
	SetupHookRoutine(_ChangeWnd);
	
	InitInfoWnd();
	InitWorkStatusWnd();
	InitLineWnd();
	InitMainSetWnd();
	InitNetStatusWnd();
	
	InitLocalParWnd();
	InitRadParWnd();
	InitBaseWnd();
	InitOvertakeWnd();
	
	InitSaveParWnd();
	InitSaveMenuWnd();
	
	InitSetOverIDWnd();
	InitSetFrqWnd();
	InitSetBWWnd();
	InitSetSnrWnd();
	InitSetAddNoiseModeWnd();
	InitSetVoltWnd();
	InitSetCycCountWnd();
	InitSetOverCountWnd();
	InitSetFillDataWnd();
	InitSetFillModeWnd();
	InitSetTestModeWnd();
	InitSetDopplerWnd();
	InitSetDopplerChangeWnd();
	InitSetDopplerFreqWnd();
	
	InitSetOutSwitchWnd();
	InitSetMSwitchWnd();
	InitSetOffsetFreqWnd();
	InitSetOffsetSnrWnd();
	InitSetOffsetVoltWnd();
	
	InitSetDevIPWnd();
	InitSetDevPortWnd();
	InitSetDevMACWnd();

	InitDevInitWnd();
	bFirstInitWnd = FALSE;
	return 0;
}
