#include <csl_tmr.h>
#include <stdio.h>
#include <csl_intc.h>
#include <soc.h>
#include <csl_intcAux.h>
#include <cslr_dev.h>
#include "typeDefs.h"
/* Handle for the TMR instance */
CSL_TmrHandle         hTmr;

/* NOTE: change the Instance of the timer for different timer instances */
Uint8 IntcInstance = CSL_TMR_1;
UINT8 flaga;
UINT32 *pGPIO_set = (UINT32 *)0x02B00018;
UINT32 *pGPIO_clr = (UINT32 *)0x02B0001C;

CSL_IntcHandle               tmrIntcHandle;
CSL_IntcObj                  tmrIntcObj;
CSL_IntcContext              context;
/*
 * =============================================================================
 *   @func  TimerInterruptHandler
 *  
 *   @arg
 *      event - interrupt event id
 *
 *   @desc
 *      Handler for Timer Interrupt
 *
 *   @return
 *      NONE
 *
 * =============================================================================
 */
void TimerInterruptHandler (
    CSL_IntcEventId *event
)
{
    if(flaga)
    	{
    		*pGPIO_set |= 0x01;
			flaga = 0;
    	}
	else
		{
			*pGPIO_clr |= 0x01;
			flaga = 1;
		}
    CSL_intcEventClear(*event);
}



/*
 * =============================================================================
 *   @func  tmrIntcPrdLoLoadDemo
 *  
 *   @arg
 *      NONE
 *
 *   @desc
 *      This funtion is example for the Period register loading with value.
 *
 *   @return
 *      NONE
 *
 * =============================================================================
 */
void setupTimer (
    void
)
{
    CSL_TmrObj TmrObj;
    CSL_Status intStat, status;
    CSL_TmrHwSetup hwSetup = CSL_TMR_HWSETUP_DEFAULTS;
    CSL_IntcEventHandlerRecord EventRecord;
    CSL_IntcParam vectId;
	CSL_IntcGlobalEnableState state;
  
    Uint32 LoadValue = 50000;


		/* Initialize INTC */
    context.numEvtEntries = 1;
//    context.eventhandlerRecord = record;

    CSL_intcInit(&context);
  
    /* Enable NMIS */
    CSL_intcGlobalNmiEnable();

    /* Enable all interrupts */
    CSL_intcGlobalEnable(&state);
	
    CSL_TmrEnamode TimeCountMode = CSL_TMR_ENAMODE_CONT;

    /* Clear local data structures */
    memset(&TmrObj, 0, sizeof(CSL_TmrObj));
    printf("Running Gp Timer Interrupt DUAL UNCHAINED Low....\n");
    
    /**************************************************************
    * INTC related code                               *
    **************************************************************/
     
    /* Open INTC */
    vectId = CSL_INTC_VECTID_12;

    tmrIntcHandle = CSL_intcOpen(&tmrIntcObj, CSL_INTC_EVENTID_TINTLO0, &vectId, 
                                 &intStat);
    
    /* Bind ISR to Interrupt */
    EventRecord.handler = (CSL_IntcEventHandler)&TimerInterruptHandler;
    EventRecord.arg = (void *)tmrIntcHandle;
    CSL_intcPlugEventHandler(tmrIntcHandle, &EventRecord);
    
    /* Event Enable */
    CSL_intcHwControl(tmrIntcHandle, CSL_INTC_CMD_EVTENABLE, NULL);
       
    /**************************************************************/

    /* Initialize timer CSL module */
    CSL_tmrInit(NULL);
    
    hTmr =  CSL_tmrOpen(&TmrObj, IntcInstance, NULL, &status);

    CSL_tmrHwSetup(hTmr, &hwSetup);

    /* Stop the Timer */
    status = CSL_tmrHwControl(hTmr, CSL_TMR_CMD_RESET_TIMLO, NULL);
    
    /* set the timer mode to unchained dual mode */
    hwSetup.tmrTimerMode = CSL_TMR_TIMMODE_DUAL_UNCHAINED;

    CSL_tmrHwSetup(hTmr, &hwSetup); 

    /* Load the period register */
    CSL_tmrHwControl(hTmr, CSL_TMR_CMD_LOAD_PRDLO, (void *)&LoadValue);

    /* Start the timer with one shot*/
    CSL_tmrHwControl(hTmr, CSL_TMR_CMD_START_TIMLO, (void *)&TimeCountMode);

  
}

