#include "hFiles.h"
#include "chlEnc.h"
/*
const unsigned int bch_Gx[4] = { 0x07289FA8, 0xE1C830DE, 0xDF23A382, 0x000000C4 };
*/

const unsigned int bch_Gx[4] = { 0x00000015, 0xF914E07B, 0x0C138741, 0xC5C4FB23 };

const unsigned char LDPC_HS_ROM_7_8[9*63] = { //7/8 code rate
	1, 0, 0, 0, 1, 0, 1, 0, 0, 13, 0, 55, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 
	0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 104, 109, 25, 0, 8, 107,
	1, 0, 1, 5, 20, 99, 0, 59, 87, 4, 0, 0, 1, 21, 0, 0, 0, 6, 0, 99, 0, 0, 0, 82, 0, 
	0, 30, 0, 0, 109, 0, 0, 111, 0, 0, 57, 0, 0, 40, 0, 0, 70, 0, 0, 35, 0, 0, 
	99, 0, 0, 85, 0, 0, 63, 0, 0, 44, 15, 47, 0, 1, 46, 28, 36, 0, 61, 105, 27, 0, 1,
	77, 56, 110, 0, 81, 0, 0, 14, 0, 0, 0, 1, 0, 98, 0, 0, 0, 1, 0, 58, 0, 0, 76, 0, 
	0, 70, 0, 0, 65, 0, 0, 54, 0, 0, 67, 0, 0, 56, 0, 0, 68, 0, 0, 110, 0, 0, 8, 
	0, 0, 84, 39, 9, 0, 47, 104, 92, 0, 1, 19, 91, 64, 0, 37, 9, 27, 0, 1, 
	0, 20, 0, 0, 49, 0, 0, 51, 0, 0, 1, 0, 83, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 
	1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 6, 45, 0, 1, 18, 20,
	46, 0, 90, 5, 1, 0, 1, 109, 3, 109, 0, 25, 70, 0, 0, 0, 0, 1, 0, 0, 1, 0, 6, 
	0, 0, 76, 0, 0, 98, 0, 0, 9, 0, 0, 74, 0, 0, 52, 0, 0, 42, 0, 0, 20, 0, 0,
	75, 0, 0, 82, 0, 0, 105, 0, 0, 64, 0, 19, 44, 0, 29, 71, 106, 0, 1, 39, 
	85, 28, 0, 23, 93, 67, 0, 1, 31, 0, 0, 1, 71, 0, 0, 90, 0, 0, 0, 49, 0, 0, 
	107, 0, 0, 1, 0, 0, 67, 0, 0, 24, 0, 0, 90, 0, 0, 102, 0, 0, 10, 0, 0, 
	82, 0, 0, 40, 0, 0, 20, 0, 0, 59, 0, 97, 0, 1, 105, 46, 60, 0, 35, 64,
	66, 0, 1, 8, 10, 99, 0, 92, 104, 0, 76, 0, 0, 0, 52, 0, 105, 0, 0, 0, 
	1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 
	0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 9, 0, 54, 20, 95, 0, 1, 53, 71, 97, 0, 43,
	100, 87, 0, 1, 89, 73, 0, 0, 0, 1, 24, 0, 0, 0, 45, 0, 0, 6, 0, 0, 10,
	0, 0, 61, 0, 0, 86, 0, 0, 17, 0, 0, 92, 0, 0, 93, 0, 0, 75, 0, 0, 46, 0, 0, 
	83, 0, 0, 18, 0, 0, 34, 0, 1, 103, 39, 108, 0, 39, 93, 11, 0, 1, 30, 53, 
	81, 0, 43, 100, 8, 0, 0, 69, 0, 0, 29, 0, 0, 0, 1, 0, 0, 1, 0, 40, 0, 0, 
	18, 0, 0, 38, 0, 0, 57, 0, 0, 5, 0, 0, 2, 0, 0, 94, 0, 0, 7, 0, 0, 89, 0,
	0, 6, 0, 0, 71, 0, 104, 87, 104, 0, 1, 19, 62, 28, 0, 9, 11, 65, 0, 1, 95, 3, 37
};
const unsigned char LDPC_HS_ROM_3_4[18*54] = { //3/4 code rate
	1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 1, 0, 0, 70, 0, 44, 0, 0, 28, 0, 16, 0, 0, 46, 0, 81, 0, 0, 
	96, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 75, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 3, 0, 0, 0, 0, 0, 62, 0, 0, 52, 0, 20, 0, 39, 0, 0, 76, 0, 0, 29, 
	0, 0, 1, 0, 22, 0, 0, 0, 0, 0, 0, 1, 0, 108, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	1, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 1, 0, 0, 71, 0, 0, 3, 0, 21, 0, 0, 52, 0, 
	0, 1, 0, 44, 0, 0, 70, 0, 83, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 99, 0, 1, 
	0, 96, 0, 0, 5, 0, 32, 0, 0, 24, 0, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0,
	0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 66, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 62, 
	62, 0, 67, 0, 82, 0, 0, 92, 0, 61, 0, 0, 34, 0, 0, 1, 0, 0, 0, 0, 0, 48, 0, 0, 
	0, 0, 0, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
	0, 68, 0, 66, 0, 1, 89, 0, 0, 0, 1, 27, 0, 0, 1, 0, 95, 0, 0, 11, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 69, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 110, 4, 0, 0, 88, 0, 0, 1, 0, 36, 0, 0, 25, 0, 86, 0, 0, 9, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	0, 0, 0, 0, 0, 72, 0, 0, 0, 0, 1, 55, 39, 0, 0, 91, 0, 12, 0, 0, 76, 0, 0, 
	0, 1, 34, 0, 0, 0, 0, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 26, 16, 3, 0, 0, 107, 0, 0, 0, 1, 
	106, 0, 0, 1, 0, 56, 0, 33, 0, 0, 0, 0, 0, 0, 0, 31, 0, 91, 0, 0, 0, 0, 0, 0, 
	54, 0, 75, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, 0, 110, 0, 20, 0, 0, 
	35, 0, 0, 1, 0, 112, 0, 10, 0, 0, 64, 0, 0, 0, 0, 0, 102, 0, 0, 24, 0, 0, 0,
	30, 0, 0, 0, 0, 67, 0, 0, 0, 57, 65, 0, 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 1, 0, 66, 0, 0, 108, 0, 82, 0, 0, 108, 0, 61, 0, 0, 59, 0, 0, 0, 
	0, 50, 0, 0, 0, 0, 0, 51, 0, 0, 0, 0, 8, 0, 0, 0, 0, 103, 0, 0, 0, 0, 0, 0, 
	96, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 104, 0, 15, 0, 0, 62, 0, 29, 0, 0, 77, 0, 0,
	1, 0, 0, 61, 0, 0, 0, 0, 0, 0, 103, 0, 69, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 
	0, 0, 32, 0, 60, 85, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 0, 92, 0, 0, 43, 0, 
	0, 1, 0, 64, 0, 0, 75, 70, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 
	0, 0, 0, 42, 0, 75, 0, 97, 0, 0, 0, 0, 104, 0, 0, 0, 0, 0, 0, 0, 0, 16, 73, 
	0, 0, 0, 8, 0, 0, 18, 0, 36, 0, 0, 66, 0, 0, 0, 0, 0, 103, 0, 0, 11, 0, 0, 0, 
	0, 0, 0, 106, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 58, 7, 0, 0, 0, 0, 0, 0, 0, 
	67, 0, 0, 33, 0, 0, 48, 110, 0, 0, 0, 36, 0, 19, 0, 0, 109, 0, 0, 38, 71, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 105, 0, 0, 0, 0, 0, 0, 0, 83, 0, 0, 0, 0, 62, 0, 0, 0, 5, 
	0, 0, 0, 0, 0, 0, 108, 0, 0, 30, 0, 0, 61, 0, 39, 0, 0, 110, 0, 10, 0, 0, 
	11, 0, 100, 0, 0, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 79, 0, 0, 0, 58, 59, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 0, 0, 0, 0, 0, 23, 0, 0, 1, 0, 4, 0, 0, 36, 0, 59, 
	0, 0, 100, 0, 52, 0, 0, 0, 0, 0, 51, 0, 0, 0, 0, 0, 0, 1, 20, 0, 0, 0, 0, 14, 
	0, 0, 0, 0, 74, 0, 0, 0, 0, 0, 0, 0, 61, 0, 0, 0, 94, 0, 0, 0, 0, 0, 5, 0, 9, 
	0, 88, 0, 0, 6, 0, 0, 18, 0, 2
};
const unsigned char LDPC_HS_ROM_1_2[36*36] = { //1/2 code rate
	0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69, 0, 0, 0, 0, 0, 0, 8, 0,
	0, 0, 0, 1, 0, 0, 88, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 105, 0, 0, 0, 0, 0, 1, 0, 0, 16, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 103, 0, 0, 0, 0, 0, 98, 0, 0, 0, 0, 92, 0, 0, 0, 0, 0, 0, 0, 
	87, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
	1, 0, 0, 0, 0, 96, 0, 0, 0, 0, 101, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 20, 0, 0, 0, 0, 38, 0, 0, 0, 0, 63, 0, 0, 0,
	0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 0, 52, 0, 0, 0, 
	0, 0, 47, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 109, 0, 0, 20, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 87, 0, 0, 0, 0, 0, 53, 
	0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 54, 0, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 36, 0, 0, 0, 0, 1, 0, 0, 90, 0, 0, 0, 
	12, 0, 0, 0, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 46, 0, 0, 86, 0, 0, 0, 0, 15, 0, 84, 0, 0, 0, 0, 0, 110, 0, 
	0, 0, 0, 0, 0, 82, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 107, 0, 0, 76, 0, 
	0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 82, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 103, 0, 85, 0, 0, 0, 0, 0, 61, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 69, 0, 0, 0, 0, 0, 0, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 
	0, 0, 0, 0, 0, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 48, 0, 0, 0, 1, 0, 0, 0, 3, 0, 0, 0, 0, 111, 0, 0, 0, 0, 
	0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0,
	0, 39, 0, 0, 0, 0, 30, 0, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 105, 0, 0, 63, 0, 0, 0, 0, 50, 0, 74, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 
	0, 0, 57, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 
	0, 28, 0, 0, 0, 0, 0, 85, 0, 0, 0, 27, 0, 0, 26, 0, 0, 0, 0, 0, 0, 0, 0,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 98, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 
	44, 0, 0, 0, 57, 0, 0, 0, 97, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 
	0, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 0, 48, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, 0, 0, 0, 0, 60, 0, 0, 0, 60, 0, 0, 0, 
	0, 73, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 0, 112, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 19, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 39, 0, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, 74, 0, 9, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 46, 0, 0, 0, 1, 0, 1, 0, 0, 0, 74, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	82, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 35, 0, 0, 19, 0, 0, 0, 0, 0, 0, 87, 0, 0, 0, 65, 0, 0, 0, 0, 19, 0, 
	0, 0, 0, 0, 0, 0, 109, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 0, 0, 0, 84, 0, 0, 
	0, 0, 0, 0, 0, 0, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 91, 0, 0, 0, 0, 0, 17, 99, 0, 0, 0, 0, 0, 0, 7, 0, 0, 60, 0, 
	0, 0, 0, 0, 0, 0, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 100, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 
	0, 0, 28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 82, 0, 0, 64, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 70, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 0, 0, 0, 72, 0, 0, 0, 
	0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 78, 0, 0, 0, 0, 0, 0, 0, 26, 0, 0, 0, 0, 
	0, 0, 0, 0, 35, 0, 0, 0, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 52, 0, 0, 0, 
	95, 0, 0, 83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 0, 0, 76, 
	0, 0, 0, 0, 0, 57, 0, 0, 0, 0, 0, 0, 0, 19, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 106, 0, 0, 0, 0, 110, 0, 0, 0, 0, 0, 0, 55, 0, 0, 0, 0, 
	0, 51, 0, 0, 0, 0, 0, 0, 0, 97, 0, 0, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, 0, 0, 
	0, 37, 0, 46, 0, 0, 0, 0, 0, 0, 0, 0, 66, 0
};

/*
#define _BIT_MASK 0x00000001
*/
#define _BIT_MASK 0x00000080
/*
void bch_en(unsigned short *pBuffer, int size)
{
	register int i, j;

	register unsigned int cond, data;
	register unsigned int rPloy_a, rPloy_b, rPloy_c, rPloy_d;

	register unsigned char *pt_rPloy = ((unsigned char *)pBuffer) + size;

	rPloy_a = rPloy_b = rPloy_c = rPloy_d = 0;

	for(i=0; i<size/4; i++) {
		data = pBuffer[2*i]+(pBuffer[2*i+1]<<16);

		for(j=0; j<32; j++)
		{
			cond = (rPloy_a ^ data) & _BIT_MASK;
			
			rPloy_a = rPloy_a >> 1 | rPloy_b << 31; 
			rPloy_b = rPloy_b >> 1 | rPloy_c << 31; 
			rPloy_c = rPloy_c >> 1 | rPloy_d << 31; 
			rPloy_d = rPloy_d >> 1; 

			if(cond) rPloy_a ^= bch_Gx[0]; 
			if(cond) rPloy_b ^= bch_Gx[1]; 
			if(cond) rPloy_c ^= bch_Gx[2]; 
			if(cond) rPloy_d ^= bch_Gx[3]; 

			data >>= 1; 

		}
	}
	{
		data = pBuffer[2*i]+(pBuffer[2*i+1]<<16);

		for(j=0; j<8*(size%4); j++)
		{
			cond = (rPloy_a ^ data) & _BIT_MASK;

			rPloy_a = rPloy_a >> 1 | rPloy_b << 31; 
			rPloy_b = rPloy_b >> 1 | rPloy_c << 31; 
			rPloy_c = rPloy_c >> 1 | rPloy_d << 31; 
			rPloy_d = rPloy_d >> 1; 

			if(cond) rPloy_a ^= bch_Gx[0]; 
			if(cond) rPloy_b ^= bch_Gx[1]; 
			if(cond) rPloy_c ^= bch_Gx[2]; 
			if(cond) rPloy_d ^= bch_Gx[3]; 

			data >>= 1; 

		}
	}

	for(i=0;i<4;i++) *pt_rPloy++ = rPloy_a >> (i*8);
	for(i=0;i<4;i++) *pt_rPloy++ = rPloy_b >> (i*8);
	for(i=0;i<4;i++) *pt_rPloy++ = rPloy_c >> (i*8);
	*pt_rPloy++ = rPloy_d;

}
*/

/*
void bch_en(unsigned char *pBuffer, int size)
{
	register int i, j;

	register unsigned int cond, data;
	register unsigned int rPloy_a, rPloy_b, rPloy_c, rPloy_d;

	register unsigned char *pt_rPloy = pBuffer + size;

	rPloy_a = rPloy_b = rPloy_c = rPloy_d = 0;

	for(i=0; i<size; i++) {
		data = pBuffer[i];

		for(j=0; j<8; j++)
		{
			cond = (rPloy_a ^ data) & _BIT_MASK;
			
			rPloy_a = rPloy_a << 1 | rPloy_b >> 31; 
			rPloy_b = rPloy_b << 1 | rPloy_c >> 31; 
			rPloy_c = rPloy_c << 1 | rPloy_d >> 31; 
			rPloy_d = rPloy_d << 1; 

			if(cond) rPloy_a ^= bch_Gx[0]; 
			if(cond) rPloy_b ^= bch_Gx[1]; 
			if(cond) rPloy_c ^= bch_Gx[2]; 
			if(cond) rPloy_d ^= bch_Gx[3]; 

			data <<= 1; 

		}
	}

	*pt_rPloy++ = rPloy_a;
	for(i=3;i>=0;i--) *pt_rPloy++ = rPloy_b >> (i*8);
	for(i=3;i>=0;i--) *pt_rPloy++ = rPloy_c >> (i*8);
	for(i=3;i>=0;i--) *pt_rPloy++ = rPloy_d >> (i*8);

}
*/

void bch_en(int s, unsigned char *a, unsigned char *b, unsigned char *c, unsigned char *d)
{
	register int i, j, len = s;
	
	register unsigned int cond_a, data_a;
	register unsigned int cond_b, data_b;
	register unsigned int cond_c, data_c;
	register unsigned int cond_d, data_d;

	register unsigned char *pt_data_a = a;
	register unsigned char *pt_data_b = b;
	register unsigned char *pt_data_c = c;
	register unsigned char *pt_data_d = d;

	register unsigned int a_rPloy_a, b_rPloy_a, c_rPloy_a, d_rPloy_a;
	register unsigned int a_rPloy_b, b_rPloy_b, c_rPloy_b, d_rPloy_b;
	register unsigned int a_rPloy_c, b_rPloy_c, c_rPloy_c, d_rPloy_c;
	register unsigned int a_rPloy_d, b_rPloy_d, c_rPloy_d, d_rPloy_d;

	register unsigned char *pt_rPloy_a = (unsigned char *)a + s;
	register unsigned char *pt_rPloy_b = (unsigned char *)b + s;
	register unsigned char *pt_rPloy_c = (unsigned char *)c + s;
	register unsigned char *pt_rPloy_d = (unsigned char *)d + s;

	a_rPloy_a = b_rPloy_a = c_rPloy_a = d_rPloy_a = 0;
	a_rPloy_b = b_rPloy_b = c_rPloy_b = d_rPloy_b = 0;
	a_rPloy_c = b_rPloy_c = c_rPloy_c = d_rPloy_c = 0;
	a_rPloy_d = b_rPloy_d = c_rPloy_d = d_rPloy_d = 0;
	
	for(i=0; i<len; i++) {
		data_a = pt_data_a[i];
		data_b = pt_data_b[i];
		data_c = pt_data_c[i];
		data_d = pt_data_d[i];
		for(j=0; j<8; j++)
		{
			cond_a = (a_rPloy_a ^ data_a) & _BIT_MASK;
			cond_b = (a_rPloy_b ^ data_b) & _BIT_MASK;
			cond_c = (a_rPloy_c ^ data_c) & _BIT_MASK;
			cond_d = (a_rPloy_d ^ data_d) & _BIT_MASK;
			
			a_rPloy_a = a_rPloy_a << 1 | b_rPloy_a >> 31; 
			a_rPloy_b = a_rPloy_b << 1 | b_rPloy_b >> 31;
			a_rPloy_c = a_rPloy_c << 1 | b_rPloy_c >> 31; 
			a_rPloy_d = a_rPloy_d << 1 | b_rPloy_d >> 31;
			
			b_rPloy_a = b_rPloy_a << 1 | c_rPloy_a >> 31; 
			b_rPloy_b = b_rPloy_b << 1 | c_rPloy_b >> 31;
			b_rPloy_c = b_rPloy_c << 1 | c_rPloy_c >> 31; 
			b_rPloy_d = b_rPloy_d << 1 | c_rPloy_d >> 31;
			
			c_rPloy_a = c_rPloy_a << 1 | d_rPloy_a >> 31; 
			c_rPloy_b = c_rPloy_b << 1 | d_rPloy_b >> 31;
			c_rPloy_c = c_rPloy_c << 1 | d_rPloy_c >> 31; 
			c_rPloy_d = c_rPloy_d << 1 | d_rPloy_d >> 31;
			
			d_rPloy_a = d_rPloy_a << 1; 
			d_rPloy_b = d_rPloy_b << 1;
			d_rPloy_c = d_rPloy_c << 1; 
			d_rPloy_d = d_rPloy_d << 1;
			
			if(cond_a) a_rPloy_a ^= bch_Gx[0]; 
			if(cond_b) a_rPloy_b ^= bch_Gx[0];
			if(cond_c) a_rPloy_c ^= bch_Gx[0]; 
			if(cond_d) a_rPloy_d ^= bch_Gx[0];
			
			if(cond_a) b_rPloy_a ^= bch_Gx[1]; 
			if(cond_b) b_rPloy_b ^= bch_Gx[1];
			if(cond_c) b_rPloy_c ^= bch_Gx[1]; 
			if(cond_d) b_rPloy_d ^= bch_Gx[1];
			
			if(cond_a) c_rPloy_a ^= bch_Gx[2]; 
			if(cond_b) c_rPloy_b ^= bch_Gx[2];
			if(cond_c) c_rPloy_c ^= bch_Gx[2]; 
			if(cond_d) c_rPloy_d ^= bch_Gx[2];
			
			if(cond_a) d_rPloy_a ^= bch_Gx[3]; 
			if(cond_b) d_rPloy_b ^= bch_Gx[3];
			if(cond_c) d_rPloy_c ^= bch_Gx[3]; 
			if(cond_d) d_rPloy_d ^= bch_Gx[3];
			
			data_a <<= 1; 
			data_b <<= 1;
			data_c <<= 1; 
			data_d <<= 1;
		}
	}

	*pt_rPloy_a++ = a_rPloy_a;
	for(i=3;i>=0;i--) *pt_rPloy_a++ = b_rPloy_a >> (i*8);
	for(i=3;i>=0;i--) *pt_rPloy_a++ = c_rPloy_a >> (i*8);
	for(i=3;i>=0;i--) *pt_rPloy_a++ = d_rPloy_a >> (i*8);

	*pt_rPloy_b++ = a_rPloy_b;
	for(i=3;i>=0;i--) *pt_rPloy_b++ = b_rPloy_b >> (i*8);
	for(i=3;i>=0;i--) *pt_rPloy_b++ = c_rPloy_b >> (i*8);
	for(i=3;i>=0;i--) *pt_rPloy_b++ = d_rPloy_b >> (i*8);

	*pt_rPloy_c++ = a_rPloy_c;
	for(i=3;i>=0;i--) *pt_rPloy_c++ = b_rPloy_c >> (i*8);
	for(i=3;i>=0;i--) *pt_rPloy_c++ = c_rPloy_c >> (i*8);
	for(i=3;i>=0;i--) *pt_rPloy_c++ = d_rPloy_c >> (i*8);

	*pt_rPloy_d++ = a_rPloy_d;
	for(i=3;i>=0;i--) *pt_rPloy_d++ = b_rPloy_d >> (i*8);
	for(i=3;i>=0;i--) *pt_rPloy_d++ = c_rPloy_d >> (i*8);
	for(i=3;i>=0;i--) *pt_rPloy_d++ = d_rPloy_d >> (i*8);
	
}


void ldpc_en(unsigned short *pBuffer, int size)
{

	unsigned short x_vect[7];

	register unsigned short *pt_s_vect;
	register unsigned short x_bit_vect, *pt_x_vect;
	register unsigned short mb, kb;
	register unsigned char shift_num;
	register unsigned char i, j, t, k, r;

	const unsigned char *pt_hs_rom;
	
	mb = 9; 
	kb = 63; 
	pt_hs_rom = LDPC_HS_ROM_7_8;
	if(size == 378) {
		mb = 18;
		kb = 54;
		pt_hs_rom = LDPC_HS_ROM_3_4;
	}
	if(size == 252) {
		mb = 36;
		kb = 36;
		pt_hs_rom = LDPC_HS_ROM_1_2;
	}

	pt_s_vect = pBuffer;
	pt_x_vect = pBuffer + size;

	for(i=0;i<mb;i++) {
		
		for(t=0;t<7;t++) x_vect[t] = 0;
	
		for(j=0;j<kb;j++) {
			
			shift_num = *pt_hs_rom++;

			k = shift_num / 16;
			r = shift_num % 16;

			for(t=0;t<7;t++) {
				x_vect[t] ^= ((pt_s_vect[j*7+(t-k+7)%7]<<r) | 
					(pt_s_vect[j*7+(t-k+6)%7]>>(16-r)));
			}
			
		}

		for(t=0;t<7;t++) {
			pt_x_vect[i*7+t] = x_vect[t];
		}

	}

	x_bit_vect = pt_x_vect[0] & 0x0001;
	
	for(i=0;i<112;i++) {

		for(j=1;j<mb;j++) {
			pt_x_vect[j*7+i/16] ^= x_bit_vect;
			x_bit_vect = pt_x_vect[j*7+i/16] & (1<<(i%16));
		}
		
		pt_x_vect[i/16] ^= (x_bit_vect << 1);
		x_bit_vect = pt_x_vect[i/16] & (1<<((i+1)%16));

	}

}

