
#include "hFiles.h"

#include "sysCfg.h"
#include "dataHome.h"
#include "sysContext.h"
//#include "exec.h"
#include "edma.h"

#define EDMA_XMIT_CHAIN_NUM 4
#define CELL_NODE_ENTRY_PER_CHAIN 64

static struct
{
	CELL *cell[EDMA_XMIT_CHAIN_NUM][CELL_NODE_ENTRY_PER_CHAIN];
	int arrIndex;
} cellArrayQ;


typedef struct 
{
	int chnlMappedPSetIndex;
	int curPSetOffset;
	int incDir;
} DMAPSETLINK;

static DMAPSETLINK paramSetLnk;

static inline void initDmaPSetLink()
{
	paramSetLnk.chnlMappedPSetIndex = CHNL_MAPPED_PARAMSET;
	paramSetLnk.curPSetOffset = 0;
	paramSetLnk.incDir = (paramSetLnk.chnlMappedPSetIndex < MAX_PARAMSET_NUM/2) ? 1 : (-1);
}

static inline void setupNextDmaPSet(PCELL pc)
{
	int index = paramSetLnk.chnlMappedPSetIndex + \
		paramSetLnk.curPSetOffset * paramSetLnk.incDir;
	
	// make sure the index is in the correct range
	HANDLE hPSet = GetDmaPSetWithDefaultContent(index);

	UINT16 aCnt, bCnt = 0, cCnt = 0;
	UINT32 srcAddr, dstAddr = FPGA_DATA_RECV_FIFO_ADDR;
	if(hPSet)
	{
		// link to the next param set
		SetPSetLink(hPSet, index+paramSetLnk.incDir);
		
		// param val 0 means unchange
		aCnt = (UINT16)pc->len;
		SetPSetCount(hPSet, aCnt, bCnt, cCnt);
		
		// param val 0 means unchange
		srcAddr = (UINT32)pc->buffer;
		SetPSetAddress(hPSet, srcAddr, dstAddr);

		// point to the next param set
		paramSetLnk.curPSetOffset++;
	}

}

static inline void setupLastDmaPSet(PCELL pc)
{
	int index = paramSetLnk.chnlMappedPSetIndex + \
		paramSetLnk.curPSetOffset * paramSetLnk.incDir;
	
	// make sure the index is in the correct range
	HANDLE hPSet = GetDmaPSetWithDefaultContent(index);

	UINT16 aCnt, bCnt = 0, cCnt = 0;
	UINT32 srcAddr, dstAddr = FPGA_DATA_RECV_FIFO_ADDR;
	if(hPSet)
	{
		// enable tcc interrupt and disable tc chain
		SetPSetOption(hPSet, \
				(1<<OPTION_FIELD_TCINT_OFFSET), \
				OPTION_FIELD_TCINT|OPTION_FILED_TCCH);

		// link to the next param set(itself)
		SetPSetLink(hPSet, index);
		
		// param val 0 means unchange
		aCnt = (UINT16)pc->len;
		SetPSetCount(hPSet, aCnt, bCnt, cCnt);
		
		// param val 0 means unchange
		srcAddr = (UINT32)pc->buffer;
		SetPSetAddress(hPSet, srcAddr, dstAddr);
		
		// reset the offset
		paramSetLnk.curPSetOffset = 0;
	}
}

void InitDataFeedModule()
{
	initDmaPSetLink();
	mmzero((void*)&cellArrayQ, sizeof(cellArrayQ));
}

#define INIT_PSEUDO_INTNUM 4

void feedCompleteHook(unsigned int code)
{
	int i;
	static int curArr = 0;

	if(++curArr == EDMA_XMIT_CHAIN_NUM) curArr = 0;
	
	for(i=0;i<CELL_NODE_ENTRY_PER_CHAIN-1;i++)
		setupNextDmaPSet(cellArrayQ.cell[curArr][i]);

	setupLastDmaPSet(cellArrayQ.cell[curArr][i]);

}

#define EnableFeedCompleteInterrupt() EnableSysInterrupt(FEED_COMPLETE_INT)

void FeedServTask()
{
	
	int i, j, size = 0;	
	PCELL pCell = 0;
	HANDLE hEvent = CreateEvent(0);

	volatile unsigned short *pData = 0;

	if(hEvent)
	{
		RegisterServPoint(hEvent, DEFAULT_EDMA3_TCC, feedCompleteHook);
		
		InitDataFeedModule();
		InitDataHomeModule();

		for(;;)
		{
			pCell = GetFilledCell(true);

			size += pCell->len;
			pData = (unsigned short*)pCell->buffer;
			
			for(i=0;i<(pCell->len/2);i++)
			{
				FPGA_DATA_RECV_FIFO = pData[i];
			}

			FreeCell(pCell);

			if(size > ALFULL_DATA_QUANTITY) break;
		}

		for(i=0;i<EDMA_XMIT_CHAIN_NUM;i++)
		{
			for(j=0;j<CELL_NODE_ENTRY_PER_CHAIN;j++)
			{
				cellArrayQ.cell[i][j] = GetFilledCell(true);
			}
		}

		for(cellArrayQ.arrIndex=i=0;i<CELL_NODE_ENTRY_PER_CHAIN-1;i++)
			setupNextDmaPSet(cellArrayQ.cell[cellArrayQ.arrIndex][i]);

		setupLastDmaPSet(cellArrayQ.cell[cellArrayQ.arrIndex][i]);
		
		EnableFeedCompleteInterrupt();
		EnableDmaEvent();

		for(;;)
		{
			
			PendEvent(hEvent, TO_FOREVER);

			for(i=0;i<CELL_NODE_ENTRY_PER_CHAIN;i++)
			{
				FreeCell(cellArrayQ.cell[cellArrayQ.arrIndex][i]);
				cellArrayQ.cell[cellArrayQ.arrIndex][i] = GetFilledCell(true);
			}
			
			if(++cellArrayQ.arrIndex == EDMA_XMIT_CHAIN_NUM) 
				cellArrayQ.arrIndex = 0;

			InsertFilledCell(0, 0); 
			
		}

	}

}


