
#include "dispDriver.h"
#define DISPLY_DDR_ADDR (0xE7000000)
//#include "sysCfg.h"
#ifdef ALLOC_IRAM_DISP_BUFFER
static UINT16 DISPLAY_FRAME_BUFFER[DISPLAY_RESOLUTION_WIDTH*DISPLAY_RESOLUTION_HEIGHT];
UINT16* GetDisplayBuffer() { return DISPLAY_FRAME_BUFFER; }
UINT16* GetDisplayRowBuffer(int iRow) { return &DISPLAY_FRAME_BUFFER[iRow*DISPLAY_RESOLUTION_WIDTH]; }
#else
static UINT16 *DISPLAY_FRAME_BUFFER = (UINT16 *)DISPLY_DDR_ADDR;
UINT16* GetDisplayBuffer() { return DISPLAY_FRAME_BUFFER; }
UINT16* GetDisplayRowBuffer(int iRow) { return (DISPLAY_FRAME_BUFFER + iRow*DISPLAY_RESOLUTION_WIDTH); }
#endif



VOID GetResolution(int *pResX, int *pResY)
{
	if(pResX && pResY) {
		*pResX = DISPLAY_RESOLUTION_WIDTH;
		*pResY = DISPLAY_RESOLUTION_HEIGHT;
	}
}

VOID WriteRowData(int iRow, int sCol, int eCol, UINT16 *pData)
//VOID WriteRowData(int iRow, int sCol, int eCol, uchar *pData)
{
	UINT16 *pbFrm;
	UINT16 *pbBuf = pData;
	//uchar *pbBuf = pData;
	//uint *pdwFrm;
	//uint *pdwBuf;
	uint i,j,len;
	if(iRow>=0 && iRow<DISPLAY_RESOLUTION_HEIGHT &&
		eCol>=0 && sCol<DISPLAY_RESOLUTION_WIDTH &&
		sCol<=eCol &&
		pbBuf) {
		if(sCol<0) pbBuf = pbBuf-sCol;
		i = (sCol>0) ? sCol : 0;
		j = (eCol<DISPLAY_RESOLUTION_WIDTH) ? eCol : (DISPLAY_RESOLUTION_WIDTH-1);
		pbFrm = DISPLAY_FRAME_BUFFER + DISPLAY_RESOLUTION_WIDTH * iRow + i ;
		len = j - i + 1;
		/*
		if(!(((uint)pbFrm)&0x3) && !(((uint)pbBuf)&0x3)) {
			pdwFrm = (uint*)pbFrm;
			pdwBuf = (uint*)pbBuf;

			while(len>3)
			{
				*pdwFrm++ = *pdwBuf++;
				len -= 4;
			}
			if(len)
			{
				pbFrm = (uchar *)pdwFrm;
				pbBuf = (uchar *)pdwBuf;

				while(len--)
					*pbFrm++ = *pbBuf++;
			}
		}
		*/
		//else {
			while(len--) 
				*pbFrm++ = *pbBuf++;
		//}
	}

}

VOID WritePixelData(int iRow, int iCol, UINT16 uColor)
//VOID WritePixelData(int iRow, int iCol, uchar uColor)
{
	if(iRow>=0 && iRow<DISPLAY_RESOLUTION_HEIGHT && 
		iCol>=0 && iCol<DISPLAY_RESOLUTION_WIDTH)
		*(DISPLAY_FRAME_BUFFER + DISPLAY_RESOLUTION_WIDTH * iRow + iCol) = uColor;
}

VOID RefreshDisplayOne()
{
	// Dump the Frame Buffer content to Display

	UINT16 *pAddr;
	UINT16 *blockAddr = (UINT16 *)0xA0000054;
	UINT16 *pDataAddr = (UINT16 *)0xA0004480;
	UINT16 index,blockindex;
	//UINT16 *laseAddr = (UINT16 *)0xE7000000;
//	while(1)
	{
	//*(laseAddr + 240*400-2) = 0x1234;
	for(blockindex=0;blockindex<8;blockindex++)
	{
		pAddr = GetDisplayRowBuffer(blockindex*30);
		*blockAddr = blockindex;
		pDataAddr = (UINT16 *)0xA0004480;
		for(index =0;index<12000;index++)
			{
				*pDataAddr = *pAddr ++;
				pDataAddr += 2;
			}
	}
	}
	return;
}

VOID RefreshDisplayRegion(PREGION pRegion)
{

	UINT16 *pAddr;
	UINT16 *pDataAddr = (UINT16 *)0xA0004480;
	UINT16 *blockAddr = (UINT16 *)0xA0000054;
	UINT16 index;
	UINT8  blockindex_old,blockindex_new;
	UINT16 iRow;
	blockindex_old = 0xFF;
	blockindex_new = 0xFE;
	for(iRow = pRegion->sRow;iRow <= pRegion->eRow;iRow ++)
	{
		
		pAddr = GetDisplayRowBuffer(iRow);
		pAddr += pRegion->sCol;
		blockindex_new = iRow/30;
		if(blockindex_old != blockindex_new)
		{
			blockindex_old = blockindex_new;
			*blockAddr = blockindex_new;
		}
		pDataAddr =  (UINT16 *)(0xA0004480 + ((iRow%30) * 400 + pRegion->sCol)*4);
		for(index = 0;index<=pRegion->eCol-pRegion->sCol;index++)
		{
			*pDataAddr = *pAddr ++;
			pDataAddr += 2;
		}
	}

	return;
}

