
#include "hFiles.h"
#include "edma.h"
#include "sysContext.h"

#include <csl_gpio.h>
#include <cslr_dev.h>

typedef struct {
	CSL_Edma3Handle hEdma3;
	CSL_Edma3Obj edma3Obj;
} EDMA3_Dev;

EDMA3_Dev g_Edma3;

typedef void (*PFXNHOOK)(unsigned int);

typedef struct
{
	HANDLE hEvent;
	unsigned int tcc;
	PFXNHOOK pFxn;
}  SERVPOINT;

SERVPOINT servPoint = { 0, 0, 0 };

//======= Parameter set member setting help macro ================

#define OPT(x,y) \
	{x##.option = (UINT32)y;}
#define SRC(x,y) \
	{x##.srcAddr = (UINT32)y;}
#define DST(x,y) \
	{x##.dstAddr = (UINT32)y;}
#define BIDX(x,y) \
	{x##.srcDstBidx = (UINT32)y;}
#define CIDX(x,y) \
	{x##.srcDstCidx = (UINT32)y;}
#define LINKBCNTRLD(x,y) \
	{x##.linkBcntrld = (UINT32)y;}
#define ABCNT(x,y) \
	{x##.aCntbCnt = (UINT32)y;}
#define CCNT(x,y) \
	{x##.cCnt = (UINT32)y;}

//============== Implementation =====================

#define GetEdmaGlobalPendingInterrupt(lo,hi,hMod) { lo = hMod->regs->IPR; hi = hMod->regs->IPRH; }
#define ClearEdmaGlobalPendingInterrupt(lo,hi,hMod) {hMod->regs->ICR = lo; hMod->regs->ICRH = hi; }

void eventEdmaHandler(void)
{
	CSL_Edma3Handle hModule;
	CSL_BitMask32 maskVal;

	UINT32 tcc;
	UINT32 intr, ipr;
	UINT32 intrh, iprh;
	
	hModule = g_Edma3.hEdma3;

	/* Read the IPR */
	GetEdmaGlobalPendingInterrupt(ipr, iprh, hModule);
	
	while(ipr || iprh) {
		intr  = ipr;
		intrh = iprh;
		tcc = 0;

		while (intr) {
			maskVal = 1 << tcc;
			if (intr & maskVal) {

				if(servPoint.hEvent && servPoint.tcc == tcc) 
				{
					if(servPoint.pFxn) (*(servPoint.pFxn))(tcc);
					PostEvent(servPoint.hEvent);
				}
				intr &= ~maskVal;
			}
			tcc++;      
		}       

		tcc = 0;
		while (intrh) {
			maskVal = 1 << tcc;
			if (intrh & maskVal) {

				if(servPoint.hEvent && servPoint.tcc == (tcc+32)) 
				{
					if(servPoint.pFxn) (*(servPoint.pFxn))(tcc+32);
					PostEvent(servPoint.hEvent);
				}
				intrh &= ~maskVal;
			}
			tcc++;
		}

		ClearEdmaGlobalPendingInterrupt(ipr, iprh, hModule);
		GetEdmaGlobalPendingInterrupt(ipr, iprh, hModule);
	}           
}

void EnableDmaEvent()
{
	CSL_GpioContext context;
	CSL_GpioPinConfig config;
	CSL_GpioHwSetup hwSetup;
	CSL_GpioHandle hGpio;
	CSL_GpioObj gpioObj;
	CSL_Status status;

	/*
	// Unlock the control register 
	CSL_FINST(((CSL_DevRegs*)CSL_DEV_REGS)->PERLOCK, DEV_PERLOCK_LOCKVAL, UNLOCK);
	// Enable the GPIO 
	CSL_FINST(((CSL_DevRegs*)CSL_DEV_REGS)->PERCFG0, DEV_PERCFG0_GPIOCTL, ENABLE);
	while(!CSL_FEXT(((CSL_DevRegs*)CSL_DEV_REGS)->PERSTAT0, DEV_PERSTAT0_GPIOSTAT));
	*/

	// Initialize the GPIO CSL module 
	status = CSL_gpioInit(&context);
	if (status != CSL_SOK) {
		printf("GPIO: Initialization error.\n");
		return;
	}
	// Open the CSL module 
	hGpio = CSL_gpioOpen(&gpioObj, CSL_GPIO, NULL, &status);
	if (status != CSL_SOK) {
		printf("GPIO: Error opening the instance.\n");
		return;
	}

	// Setup hardware parameters 
	hwSetup.extendSetup = NULL;

	// Setup the General Purpose IO 
	CSL_gpioHwSetup(hGpio, &hwSetup);

 	// Configure pin 15 to generate an interrupt on Rising Edge, and configure it as an input.
	config.pinNum = CSL_GPIO_PIN15;
	config.trigger = CSL_GPIO_TRIG_RISING_EDGE;
	config.direction = CSL_GPIO_DIR_INPUT;

	// Enable the bank interrupt 
	CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_BANK_INT_ENABLE, NULL);

	// configure the gpio pin 15 
	CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);
}

void SetupEdma()
{
	CSL_Edma3Context context;
	CSL_Edma3HwSetup hwSetup;
	CSL_Edma3CmdIntr regionIntr;
	CSL_Edma3CmdDrae regionAccess;
	CSL_Edma3ChannelHandle hChannel;
	CSL_Edma3ChannelObj chObj;
	CSL_Edma3ChannelAttr chAttr;
	CSL_Edma3ChannelErr chErrClear = { true,true };
	CSL_Edma3HwDmaChannelSetup dmahwSetup[CSL_EDMA3_NUM_DMACH] = \
	                                      CSL_EDMA3_DMACHANNELSETUP_DEFAULT;

	CSL_Status status;

	UINT32 l32 = (UINT32)(DATA_XMIT_DMA_CH>31 ? 0 : (1 << DATA_XMIT_DMA_CH));
	UINT32 u32 = (UINT32)(DATA_XMIT_DMA_CH>31 ? (1 << (DATA_XMIT_DMA_CH-32)) : 0);
	
	// Module initialization 
	status = CSL_edma3Init(&context);
	if (status != CSL_SOK) {
		printf("Edma module initialization failed!\n");   
		return;
	}

	// Edma module open 
	g_Edma3.hEdma3 = CSL_edma3Open(&g_Edma3.edma3Obj, CSL_EDMA3,NULL, &status);
	if (status != CSL_SOK) {
		printf("Edma module open failed!\n");    
		return;
	}

	// Edma module setup 
	dmahwSetup[DATA_XMIT_DMA_CH].paramNum = CHNL_MAPPED_PARAMSET;
	dmahwSetup[DATA_XMIT_DMA_CH].que = CSL_EDMA3_QUE_0;
	hwSetup.dmaChaSetup = &dmahwSetup[0];
	hwSetup.qdmaChaSetup = NULL;
	status = CSL_edma3HwSetup(g_Edma3.hEdma3, &hwSetup);
	if (status != CSL_SOK) {
		printf("Hardware setup failed!\n");
		CSL_edma3Close (g_Edma3.hEdma3);
		return;
	}

 	// Setup the DRAE masks DRAE enable(Bits) for the shadow region 
	regionAccess.drae = l32;
	regionAccess.draeh = u32;
	regionAccess.region = DATA_XMIT_DMA_REGION;
	CSL_edma3HwControl(g_Edma3.hEdma3, CSL_EDMA3_CMD_DMAREGION_ENABLE, &regionAccess); 

	// Channel open 
	chAttr.chaNum = DATA_XMIT_DMA_CH;
	chAttr.regionNum = DATA_XMIT_DMA_REGION;
	hChannel = CSL_edma3ChannelOpen(&chObj, CSL_EDMA3, &chAttr, &status);   
	if (status != CSL_SOK) {
		printf("Edma channel open failed!\n");
		CSL_edma3Close (g_Edma3.hEdma3);
		return;
	}
	// Disable DMA channel
	CSL_edma3HwChannelControl(hChannel, CSL_EDMA3_CMD_CHANNEL_DISABLE, NULL);
	// Clear DMA channel error
	CSL_edma3HwChannelControl(hChannel, CSL_EDMA3_CMD_CHANNEL_CLEARERR, &chErrClear);
	// Enable DMA channel 
	CSL_edma3HwChannelControl(hChannel, CSL_EDMA3_CMD_CHANNEL_ENABLE, NULL);

	// Enable interrupts 
	regionIntr.intr = l32;
	regionIntr.intrh = u32;
	regionIntr.region = DATA_XMIT_DMA_REGION;
	CSL_edma3HwControl(g_Edma3.hEdma3, CSL_EDMA3_CMD_INTR_ENABLE, &regionIntr);    

	CSL_edma3HwControl(g_Edma3.hEdma3, CSL_EDMA3_CMD_INTRPEND_CLEAR, &regionIntr);   

}

HANDLE GetDmaPSet(int index)
{

	return (HANDLE)&g_Edma3.hEdma3->regs->PARAMSET[index];
}

HANDLE GetDmaPSetWithDefaultContent(int index)
{

	CSL_Edma3ParamSetup *ps;
	ps = (CSL_Edma3ParamSetup*)&g_Edma3.hEdma3->regs->PARAMSET[index];
	
	ps->option = DEFAULT_PARAMSET_OPT;
	ps->srcDstBidx = DEFAULT_PARAMSET_BIDX;
	ps->srcDstCidx = DEFAULT_PARAMSET_BIDX;
	ps->linkBcntrld = DEFAULT_PARAMSET_LINKBCNTRLD;
	ps->aCntbCnt = DEFAULT_PARAMSET_ABCNT;
	ps->cCnt = DEFAULT_PARAMSET_CCNT;
	
	return (HANDLE)ps;
}

void RegisterServPoint(HANDLE hEvent, unsigned int tcc, void (*pFxn)(unsigned int))
{
	if(hEvent && tcc<64)
	{
		servPoint.hEvent = hEvent;
		servPoint.pFxn = pFxn;
		servPoint.tcc = tcc;
	}
}
