
#include <stdio.h>
#include <std.h>

#include <c62.h>
#include <sys.h>
#include <sem.h>
#include <hwi.h>
#include <tsk.h>
#include <mem.h>

#include "sysCfg.h"
#include "hFiles.h"
#include "dataHome.h"
#include "tcpServ.h"


#include "WndMgr.h"
#include "sysContext.h"
#include "serial.h"
#include "keydispose.h"
#include "Dsk6455.h"

#include "exec.h"

UINT8 flag;
void keytest();
void DisposeParaCmd(PARAFRM *pParaCmd);
void DisposeMonitorCmd(PHOSTCMD command);
void DisposeRadCmd(PHOSTCMD command);

/* Locals & Forwards */

#define MAX_CMD_ENTRY 64
static CMD cmdPool[MAX_CMD_ENTRY];

static CMDQ emptyCmdQ;
static CMDQ pendingCmdQ;

NETCONFIG netCfg;
GPIO_Dev g_GPIO_Dev;
BaseRegs *g_pBaseRegs = (BaseRegs *)BaseBandBaseAddr;

//RAD response command
Uint8 RadUartCMD[16] = {0xFE,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFA};

/*calculate verify result*///8λУ
Uint8 calc_Verify(Uint8 *pData, Uint32 length)
{
	Uint32	i;
	Uint8	result;
	result = *pData;
	for(i=1;i<length;i++)
	{
		result ^= *(pData+i);
	}
	return (result);
}


//--------------------------------test
void OEMWriteByte(Uint8 data)
{
	while( (g_pMonitorSerialRegs->SR) & 0x01 );
	g_pMonitorSerialRegs->THR = data; 
}

void OEMOutputDebugString (char * string)
{
	while(*string)
	{
		OEMWriteByte(*string++);
	} 
}
//---------------------------------------
void EnqCmdQ(PCMDQ pQ, PCMD pCmd)
{
	pCmd->pNext = 0;

	sysCritON();

	if(!pQ->count)
	{
		pQ->pHead = pCmd;
		pQ->pTail = pCmd;
		pQ->count++;
	}
	else
	{
		pQ->pTail->pNext = pCmd;
		pQ->pTail = pCmd;
		pQ->count++;
	}

	if(pQ->hEvent) PostEvent(pQ->hEvent);

	sysCritOFF();

}

PCMD DeqCmdQ(PCMDQ pQ, HANDLE hEvent)
{
	PCMD pCmd = NULL;

	sysCritON();
	
	pCmd = pQ->pHead;

	if(pCmd)
	{
		pQ->pHead = pCmd->pNext;
		if(!pQ->pHead)
			pQ->pTail = 0;
		pQ->count--;
		pCmd->pNext = 0;

		sysCritOFF();
	}
	else if(pQ->hEvent)
	{
		sysCritOFF();
		// We must wait until some empty cmd is available.
		while(!pCmd && 
			PendEvent(pQ->hEvent, TO_FOREVER))
		{
			sysCritON();
			if(pCmd = pQ->pHead)
			{
				pQ->pHead = pCmd->pNext;
				if(!pQ->pHead)
					pQ->pTail = 0;
				pQ->count--;
				pCmd->pNext = 0;
			}
			sysCritOFF();
		}
	}
	else if(hEvent && !pQ->hEvent)
	{
		pQ->hEvent = hEvent;
		sysCritOFF();
		// We must wait until some empty cmd is available.
		while(!pCmd && 
			PendEvent(pQ->hEvent, TO_FOREVER))
		{
			sysCritON();
			if(pCmd = pQ->pHead)
			{
				pQ->pHead = pCmd->pNext;
				if(!pQ->pHead)
					pQ->pTail = 0;
				pQ->count--;
				pCmd->pNext = 0;
				pQ->hEvent = NULL;
			}
			sysCritOFF();
		}
		
	}
	else
		sysCritOFF();


	return pCmd;
}

bool InitExecModule()
{
	int i;
	
	mmzero(&emptyCmdQ, sizeof(CMDQ));
	for(i=0;i<MAX_CMD_ENTRY;i++)
	{
		EnqCmdQ(&emptyCmdQ, &cmdPool[i]);
	}

	mmzero(&pendingCmdQ, sizeof(CMDQ));
	pendingCmdQ.hEvent = CreateEvent(0);

	return (pendingCmdQ.hEvent ? true : false);
}

PCMD GetEmptyCMD(HANDLE hEvent)
{
	return DeqCmdQ(&emptyCmdQ, hEvent);
}


void FreeCMD(PCMD pCmd)
{
	if(pCmd)
	{
		EnqCmdQ(&emptyCmdQ, pCmd);
	}
}

void PostCMD(PCMD pCmd)
{
	if(pCmd)
	{
		EnqCmdQ(&pendingCmdQ, pCmd);
	}
}



void ResetCmdBuff(PCMDBUFFER pBuff)
{
	UINT8 i = 0;
	for (; i < HOST_CMD_QUE_DEPTH; i++) {
		pBuff->cmdX[i].count = 0;
	}
	pBuff->wIndex = 0;
	pBuff->rIndex = 0;
}

UINT8 FillContentToBuff(UINT8 *pDat, UINT8 size, PCMDBUFFER pBuff)
{
	UINT8 count = 0;
	UINT8 *pCmd = pDat;
	PHOSTCMD phostCMD = NULL;
	if (!pCmd) return 0;
	while (count < size) {
		if (pBuff->cmdX[pBuff->wIndex].count < HOST_CMD_LENGTH) {
			phostCMD = &pBuff->cmdX[pBuff->wIndex];
			while (count < size && phostCMD->count < HOST_CMD_LENGTH) {
				phostCMD->cmd[phostCMD->count++] = *pCmd++;
				count++;
				if (phostCMD->count == HOST_CMD_LENGTH) {
					pBuff->wIndex++;
					if (pBuff->wIndex == HOST_CMD_QUE_DEPTH) pBuff->wIndex = 0;
					break;
				}
			}
		}
		else {
			break;
		}
	}
	return count;

}

PHOSTCMD GetCMD(PCMDBUFFER pBuff)
{
	PHOSTCMD phostCMD = NULL;
	if (pBuff->cmdX[pBuff->rIndex].count == HOST_CMD_LENGTH) {
		phostCMD = &pBuff->cmdX[pBuff->rIndex];
		pBuff->rIndex++;
		if (pBuff->rIndex == HOST_CMD_QUE_DEPTH) 
		    pBuff->rIndex = 0;
	}
	return phostCMD;
	
}

Bool isValidCMDPointer(PHOSTCMD phostCMD, PCMDBUFFER pBuff)
{
	UINT8 i = 0;
	if (phostCMD) {
		for (; i < HOST_CMD_QUE_DEPTH; i++) {
			if (phostCMD == &pBuff->cmdX[i]) return TRUE;
		}
	}
	return FALSE;
}
void ReleaseCMD(PHOSTCMD phostCMD, PCMDBUFFER pBuff)
{
	if (isValidCMDPointer(phostCMD, pBuff)) {
		phostCMD->count = 0;
	}
}

void GetRadStatusPRD()//ԶȡƵ״̬
{	
	HWND hWnd;
	hWnd = GetWndByIdentity(0x05);//WORKSTATUS
	PostMessage(hWnd, (MSG_FLG + (EVENT_PRD << 16)));
	RadUartCMD[1] = 0x01;
	RadUartCMD[2] = 0x0B;
	RadUartCMD[3] = 0x01;
	SendCommand(RAD_UART,RadUartCMD);
	
}

#define OPER_STAT_SUCCESS 'S'
#define OPER_STAT_FAIL 'F'

extern void DataGenTask();
extern void StackCtrlTask();
extern void FeedServTask();

#define ResetBB() \
	BBREGS.CR |= 2
#define ClearReset()\
	BBREGS.CR = 0
#define StartBB() \
	BBREGS.CR |= 1
void ExecCMDTsk()
{
//	char temp8 = 0x20;
	bool fRet = false;
	unsigned short temp16 = 0x55AA;
	unsigned int temp32;
	int temp_32;
//	unsigned short fs,fn;
	unsigned int uVer, uTime;
	unsigned int saved_sign = 0x87654321;
	PCMD pCmd = NULL;
	HEVENT hEvt = CreateEvent(0);
	if (!g_hRadUartSem) g_hRadUartSem = (void*)SEM_create(0, 0);
	if (!g_hRadUartSem) return;
	ResetCmdBuff(&RadCmdBuff);
	
	WaitFpgaInitComplete();
	
	InitWndMgr();
	XDisplay();
	InitAllWnd();
	
	sDelay(1);
	ResetBB();	// reset baseband
	sDelay(1);
	ClearReset();
	if(!InitSysContext() || !InitExecModule() ||
		!create_task(FeedServTask, "feedTask", PRI_HIGH*2, STK_NORM, 0) ||
		!create_task(StackCtrlTask, "stackTask", PRI_NORM, STK_NORM, 0) ||
		!create_task(DataGenTask, "dataTask", PRI_LOW, STK_NORM, 0)) 
		return;
	
	SetSaveCfg();
	
	sDelay(3);
	StartBB();	// start baseband
	
	//SerialSet(g_pMonitorSerialRegs,SerialDefPar);//
	SerialSet(g_pRadSerialRegs,SerialDefPar);//
	enableKeyInterrupt();
	enableRadInterrupt();
	SetSavedCfg_Rad();
	PostMessage(NULL, (MSG_FLG + (EVENT_KEY << 16) + CONFIRM_KEY));

	for(;;)
	{
		pCmd = DeqCmdQ(&pendingCmdQ, NULL);

		if(pCmd)
		{
			switch(pCmd->id)
			{
			case 0x11://¶
				if(!pCmd->act) // Enquiry...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					temp16 = g_pBaseRegs->FTR;
					mmcopy(&pCmd->paraElem[0].pBuffer[0], (void *)&temp16, pCmd->paraElem[0].len);
				}
				else
				{
					*pCmd->pStat = OPER_STAT_FAIL;
					//˲ֻ
				}
				break;
			case 0x12://Ƿ
				if(!pCmd->act) // Enquiry...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					pCmd->paraElem[0].pBuffer[0] = g_pBaseRegs->SR;//temp8;
				}
				else
				{
					*pCmd->pStat = OPER_STAT_FAIL;
					//˲ֻ
				}
				break;
			case 0x17://ƽ
				if(!pCmd->act) // Enquiry...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					mmcopy(&pCmd->paraElem[0].pBuffer[0], (void *)&SysInfo.SavedPar.volt, pCmd->paraElem[0].len);
				}
				else  // Set...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					mmcopy(&SysInfo.SavedPar.volt, 
						&pCmd->paraElem[0].pBuffer[0], 
						pCmd->paraElem[0].len < sizeof(char) ? pCmd->paraElem[0].len : sizeof(char));
					PostMessage(NULL, (MSG_FLG + (EVENT_USER << 16) + CMD_TYPE_VOLT));
					RadUartCMD[1] = 0x03;
					RadUartCMD[2] = 0x05;
					RadUartCMD[3] = 0x01;
					RadUartCMD[4] = ((SysInfo.SavedPar.volt-SysInfo.SavedPar.offsetvolt)-20) * 4;//???
					SendCommand(RAD_UART, RadUartCMD);
				}
				break;
			case 0x18://
				if(!pCmd->act) // Enquiry...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					mmcopy(&pCmd->paraElem[0].pBuffer[0], (void *)&SysInfo.SavedPar.snr, pCmd->paraElem[0].len);
					pCmd->paraElem[1].pBuffer[0] = SysInfo.SavedPar.signal;
					pCmd->paraElem[2].pBuffer[0] = SysInfo.SavedPar.noise;
				}
				else  // Set...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					mmcopy(&SysInfo.SavedPar.snr, 
						&pCmd->paraElem[0].pBuffer[0], 
						pCmd->paraElem[0].len < sizeof(unsigned short) ? pCmd->paraElem[0].len : sizeof(unsigned short));
					SysInfo.SavedPar.signal = pCmd->paraElem[1].pBuffer[0]&0x01;
					SysInfo.SavedPar.noise = pCmd->paraElem[2].pBuffer[0]&0x01;
					PostMessage(NULL, (MSG_FLG + (EVENT_USER << 16) + CMD_TYPE_SNR));
					PostMessage(NULL, (MSG_FLG + (EVENT_USER << 16) + CMD_TYPE_ADDNOISE));
					SetSnr();
				}
				break;
			case 0x71://û
				if(!pCmd->act) // Enquiry...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					pCmd->paraElem[0].pBuffer[0] = SysInfo.SavedPar.bandwidth;//g_pBaseRegs->BWCR;//temp8;
				}
				else  // Set...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					SysInfo.SavedPar.bandwidth = pCmd->paraElem[0].pBuffer[0];
					g_pBaseRegs->BWCR = SysInfo.SavedPar.bandwidth;
					SetSnr();
					PostMessage(NULL, (MSG_FLG + (EVENT_USER << 16) + CMD_TYPE_BW));
				}
				break;
			
			case 0x72://֡ģʽ
				if(!pCmd->act) // Enquiry...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					GetFrameModeTab(&pCmd->paraElem[0].pBuffer[8], &uVer, &uTime);
					mmcopy(&pCmd->paraElem[0].pBuffer[0], &uTime, 4);
					mmcopy(&pCmd->paraElem[0].pBuffer[4], &uVer, 4);
				}
				else  // Setting...
				{
					
					mmcopy(&uTime, &pCmd->paraElem[0].pBuffer[0], 4);
					mmcopy(&uVer, &pCmd->paraElem[0].pBuffer[4], 4);

					fRet = UpdateFrameModeTab(&pCmd->paraElem[0].pBuffer[8], uVer, uTime);
					SysInfo.SavedPar.uver = uVer;
					PostMessage(NULL, (MSG_FLG + (EVENT_USER << 16) + CMD_TYPE_MODE));
					if(fRet)
					{
						*pCmd->pStat = OPER_STAT_SUCCESS;
						FlashErase(SAVED_TAB_ADDR, MAX_FRAME_NUMBER*sizeof(FRAMEAREA)+12);
						FlashWrite(SAVED_TAB_ADDR, &saved_sign, 4);
						FlashWrite(SAVED_TAB_ADDR+4, (UINT8 *)(&pCmd->paraElem[0].pBuffer[0]), 4);
						FlashWrite(SAVED_TAB_ADDR+8, (UINT8 *)(&pCmd->paraElem[0].pBuffer[4]), 4);
						FlashWrite(SAVED_TAB_ADDR+12, (UINT8 *)(&pCmd->paraElem[0].pBuffer[8]), MAX_FRAME_NUMBER*sizeof(FRAMEAREA));
					}
					else
					{
						*pCmd->pStat = OPER_STAT_FAIL;
					}
					}
				break;
			case 0x73://زƵ
				if(!pCmd->act) // Enquiry...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					temp32 = SysInfo.SavedPar.freq * 1000;
					mmcopy(&pCmd->paraElem[0].pBuffer[0],(void *)&temp32, pCmd->paraElem[0].len);
				}
				else  // Set...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					mmcopy((void *)&SysInfo.SavedPar.freq, 
						&pCmd->paraElem[0].pBuffer[0], 
						pCmd->paraElem[0].len);
					SysInfo.SavedPar.freq = SysInfo.SavedPar.freq /1000;
					if(SysInfo.SavedPar.mswitch)
						temp32 = (SysInfo.SavedPar.freq-100) * 10;
					else
						temp32 = (SysInfo.SavedPar.freq)*10;
					PostMessage(NULL, (MSG_FLG + (EVENT_USER << 16) + CMD_TYPE_FREQ));
					RadUartCMD[1] = 0x03;
					RadUartCMD[2] = 0x07;
					RadUartCMD[3] = 0x04;
					RadUartCMD[7] = temp32>>24 & 0xFF;
					RadUartCMD[6] = temp32>>16 & 0xFF;
					RadUartCMD[5] = temp32>>8  & 0xFF;
					RadUartCMD[4] = temp32 & 0xFF;
					SendCommand(RAD_UART, RadUartCMD);
					calculateDeltaFreq(SysInfo.SavedPar.freq,&temp32);//Ƶƫ
	
					g_pBaseRegs->DFCR = temp32 & 0x7FFF;
					g_pBaseRegs->DFCR = ((temp32 >>15 )& 0x7FFF) | 0x8000;
				}
				break;
			case 0x21://Ƶ¶
				if(!pCmd->act) // Enquiry...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					pCmd->paraElem[0].pBuffer[0] = SysInfo.UnsavedInfo.radtemp;
				}
				else  // Set...
				{
					*pCmd->pStat = OPER_STAT_FAIL;
					//˲ֻ
				}
				break;
			case 0x22://Ƶָʾ
				if(!pCmd->act) // Enquiry...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					pCmd->paraElem[0].pBuffer[0] = SysInfo.UnsavedInfo.lock;
				}
				else  // Set...
				{
					*pCmd->pStat = OPER_STAT_FAIL;
					//˲ֻ
				}
				break;
			case 0x24://ֵ
				if(!pCmd->act) // Enquiry...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					mmcopy(&pCmd->paraElem[0].pBuffer[0], (void *)&SysInfo.SavedPar.doppler, pCmd->paraElem[0].len);
				}
				else  // Set...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					mmcopy((void *)&SysInfo.SavedPar.doppler, 
						&pCmd->paraElem[0].pBuffer[0], 
						pCmd->paraElem[0].len);
					calculateDopplerFreqR(SysInfo.SavedPar.doppler,SysInfo.SavedPar.dcr,&temp_32);
					g_pBaseRegs->DFRR = temp_32 & 0x7FFF;
					if(temp_32 < 0)
						g_pBaseRegs->DFRR = ((temp_32 >>15) & 0x7FFF) | 0xC000;
					else
						g_pBaseRegs->DFRR = ((temp_32 >>15) & 0x7FFF) | 0x8000;
					
					//û
					PostMessage(NULL, (MSG_FLG + (EVENT_USER << 16) + CMD_TYPE_DOPPLER));
				}
				break;
			case 0x25://Ƶʱ任ʽ
				if(!pCmd->act) // Enquiry...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					mmcopy(&pCmd->paraElem[0].pBuffer[0], (void *)&SysInfo.SavedPar.dcr, pCmd->paraElem[0].len);//(void *)&g_pBaseRegs->DCR
				}
				else  // Set...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					mmcopy((void *)&SysInfo.SavedPar.dcr, 
						&pCmd->paraElem[0].pBuffer[0], 
						pCmd->paraElem[0].len);
					g_pBaseRegs->DCR = 0x00;
					delay(10);
					g_pBaseRegs->DCR = SysInfo.SavedPar.dcr;
					calculateDopplerFreqR(SysInfo.SavedPar.doppler,SysInfo.SavedPar.dcr,&temp_32);
					g_pBaseRegs->DFRR = temp_32 & 0x7FFF;
					if(temp_32 < 0)
						g_pBaseRegs->DFRR = ((temp_32 >>15) & 0x7FFF) | 0xC000;
					else
						g_pBaseRegs->DFRR = ((temp_32 >>15) & 0x7FFF) | 0x8000;
					PostMessage(NULL, (MSG_FLG + (EVENT_USER << 16) + CMD_TYPE_DOPPLERCHANGE));
				}
				break;
			case 0x26://Ƶʱ任Ƶ
				if(!pCmd->act) // Enquiry...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					temp32 = SysInfo.SavedPar.dfsr * 1000;
					mmcopy(&pCmd->paraElem[0].pBuffer[0],(void *) &temp32, pCmd->paraElem[0].len);//g_pBaseRegs->DFRR
				}
				else  // Set...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
  					mmcopy((void *)&temp32, 
						&pCmd->paraElem[0].pBuffer[0], 
						pCmd->paraElem[0].len);
					SysInfo.SavedPar.dfsr = temp32/1000.0;
					calculateDopplerCyc(SysInfo.SavedPar.dfsr,&temp32);
					g_pBaseRegs->DFSR = temp32 & 0x7FFF;
					g_pBaseRegs->DFSR = ((temp32 >>15 )& 0x7FFF) | 0x8000;
					PostMessage(NULL, (MSG_FLG + (EVENT_USER << 16) + CMD_TYPE_DOPPLERFREQ));
				}
				break;
			case 0x27://Ƶƿ
				if(!pCmd->act) // Enquiry...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					pCmd->paraElem[0].pBuffer[0] = SysInfo.SavedPar.mswitch;
				}
				else  // Set...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					SysInfo.SavedPar.mswitch = pCmd->paraElem[0].pBuffer[0]&0x01;
					if(SysInfo.SavedPar.mswitch)
						temp32 = (SysInfo.SavedPar.freq-100) * 10;
					else
						temp32 = (SysInfo.SavedPar.freq)*10;
					RadUartCMD[1] = 0x03;//set
					RadUartCMD[2] = 0x07;//Ƶ
					RadUartCMD[3] = 0x04;//
					RadUartCMD[7] = temp32 >> 24 & 0xFF;
					RadUartCMD[6] = temp32 >> 16 & 0xFF;
					RadUartCMD[5] = temp32 >> 8 & 0xFF;
					RadUartCMD[4] = temp32 & 0xFF;
					RadUartCMD[15] = 0xFA;
					SendCommand(RAD_UART, RadUartCMD);
					SetSnr();
					RadUartCMD[1] = 0x03;
					RadUartCMD[2] = 0x20;
					RadUartCMD[3] = 0x01;
					RadUartCMD[4] = SysInfo.SavedPar.mswitch;
					RadUartCMD[7] = 0x00;
					RadUartCMD[6] = 0x00;
					RadUartCMD[5] = 0x00;
					SendCommand(RAD_UART,RadUartCMD);
				}
				break;
			case 0x28://Ƶ
				if(!pCmd->act) // Enquiry...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					pCmd->paraElem[0].pBuffer[0] = SysInfo.SavedPar.outswitch;
				}
				else  // Set...
				{
					*pCmd->pStat = OPER_STAT_SUCCESS;
					SysInfo.SavedPar.outswitch= pCmd->paraElem[0].pBuffer[0]&0x01;
					SetSnr();
					RadUartCMD[1] = 0x03;
					RadUartCMD[2] = 0x02;
					RadUartCMD[3] = 0x01;
					RadUartCMD[4] = SysInfo.SavedPar.outswitch;
					SendCommand(RAD_UART, RadUartCMD);
				}
				break;	
			default:
				break;
			}
		}

		if(pCmd->pOutputQ)
		{
			EnqCmdQ(pCmd->pOutputQ, pCmd);
		}
		else 
		{
			if(pCmd->hEvent) 
				PostEvent(pCmd->hEvent);
			FreeCMD(pCmd);
		}
		
	}
}
/*
void ExecPCUartCmdTsk()
{
	PHOSTCMD pRcvCmd = NULL;
	UINT32 i;
	Uint8 VerifyResult;
	if (!g_hPCUartSem) g_hPCUartSem = (void*)SEM_create(0, 0);
	if (!g_hPCUartSem) return;
	ResetCmdBuff(&cmdBuff);
	
	enableXserialInterrupt();
	while(1)
		{
			SEM_pend((SEM_Handle)g_hPCUartSem, SYS_FOREVER);

			while(pRcvCmd = GetCMD(&cmdBuff)) {	    	    
			if((pRcvCmd->cmd[0] != 0xFE)||(pRcvCmd->cmd[1] != 0x03)||(pRcvCmd->cmd[15] != 0xFA))
			{
				//ClrSerialRcvFIFO(g_pMonitorSerialRegs);
				ResetCmdBuff(&cmdBuff);
				break;
			}

			//memset((Uint8 *)(RespCMD.cmd+2), 0, 9);
			VerifyResult = pRcvCmd->cmd[1];

			for(i=2;i<14;i++)
			{
				VerifyResult ^= pRcvCmd->cmd[i];
			}
			
			if(VerifyResult == pRcvCmd->cmd[14])
			{
				DisposeMonitorCmd(pRcvCmd);
				pRcvCmd->cmd[1] = 0x43;
				SendCommand(MONITOR_UART,pRcvCmd->cmd);
				//SendCommand(RAD_UART,pRcvCmd->cmd);
			}
			ReleaseCMD(pRcvCmd,&cmdBuff);
		}
	}
}
*/

void ExecRadUartCmdTsk()
{
	PHOSTCMD pRcvCmd = NULL;
	UINT32 i;
	Uint8 VerifyResult;
	
	
	
	while(1)
	{
		SEM_pend((SEM_Handle)g_hRadUartSem, SYS_FOREVER);

		while(pRcvCmd = GetCMD(&RadCmdBuff)) {	    	    
		if((pRcvCmd->cmd[0] != 0xFE)||(pRcvCmd->cmd[15] != 0xFA))
		{
			//ClrSerialRcvFIFO(g_pMonitorSerialRegs);
			ResetCmdBuff(&RadCmdBuff);
			break;
		}

		//memset((Uint8 *)(RespCMD.cmd+2), 0, 9);
		VerifyResult = pRcvCmd->cmd[1];

		for(i=2;i<14;i++)
		{
			VerifyResult ^= pRcvCmd->cmd[i];
		}
		
		if(VerifyResult == pRcvCmd->cmd[14])
		{
			DisposeRadCmd(pRcvCmd);
		}
		ReleaseCMD(pRcvCmd,&RadCmdBuff);
		}
	}
}
/*
void DisposeMonitorCmd(PHOSTCMD command)
{
	HWND hNextWnd;
	if(command->cmd[2] == 0xF0){
		
		if(command->cmd[4]<16)
		{
			PostMessage(NULL, (MSG_FLG + (EVENT_KEY << 16) + command->cmd[4]));
		}
		else if(command->cmd[4]==16)
		{
			hNextWnd = GetWndByIdentity(0x3A);
			ShowWnd(hNextWnd);
		}
		else if(command->cmd[4]==17)
		{
			hNextWnd = GetWndByIdentity(0x32);
			ShowWnd(hNextWnd);	
		}
		else
		{
			
		}
	}
}
*/
void DisposeRadCmd(PHOSTCMD command)
{
	if(command->cmd[1] == 0x41)//ѯɹ
	{
		switch (command->cmd[2])
		{
			case CMD_TYPE_FREQ:
			break;
			case CMD_TYPE_DSA:
			break;
			case CMD_TYPE_RADTEMP:
				SysInfo.UnsavedInfo.radtemp = command->cmd[4];
				SysInfo.UnsavedInfo.lock = command->cmd[5];
				g_pBaseRegs->RSR = SysInfo.UnsavedInfo.lock;
				PostMessage(NULL, (MSG_FLG + (EVENT_USER << 16) + CMD_TYPE_RADTEMP));
			break;
			case CMD_TYPE_RADMSWITCH:
			break;
			case CMD_TYPE_RADOUTSWITCH:
			break;
			case CMD_TYPE_PLLLOCK:
			break;
			default:
			break;
		}
	}
	else if(command->cmd[1] == 0x51)//ѯʧ
	{}
	else if(command->cmd[1] == 0x43)//óɹ
	{}
	else if(command->cmd[1] == 0x53)//ʧ
	{}
	else //Ч
	{}
	
}

