
#include <std.h>
#include <stdio.h>

#include "flash.h"
#define FLASH_SIZE    0x800000   // 8MB 
#define ERASE_BLOCKS  64          // Total number of blocks (hiding parameter blocks).


// START: these routines will be replaced by the FMD when it's done.
// TODO - clean these routines up.
Uint8 DetectFlashDevice(Uint32 FlashBaseAddress)
{
    Uint8 nDeviceID = 0;
    volatile Uint8 *pFlash = (volatile Uint8 *)(FlashBaseAddress);

    // Get the flash part ID.
    //
    *pFlash   = 0x90;
    nDeviceID = (*(pFlash + 2) & 0xFFFF);

    // Put the flash part in read array mode.
    //
    *pFlash   = 0xFF;
	
    if (nDeviceID == 0x0017)
    {
        return(nDeviceID);
    }
    return(0);
}

Bool FlashErase(Uint32 FlashStart, Uint32 FlashLength)
{
    Uint32 i,j;
    Uint32 num_blocks;
    volatile Uint8 *pFlash;
    Uint32 status;
    Uint32 BLOCK_SIZE = (FLASH_SIZE / ERASE_BLOCKS);

    // Determine the number of blocks to erase.
    num_blocks = FlashLength / BLOCK_SIZE;
    if (FlashLength % BLOCK_SIZE)
    {
        num_blocks++;
    }

    if (num_blocks < 1)
    {
        num_blocks = 1;
    }

    else if (num_blocks > 64)
    {
        num_blocks = 64;
    }

    pFlash = (volatile Uint8 *)(FlashStart);

    // For J3 FLASH, unlock all blocks at once with one command
    *pFlash = 0x60;
    *pFlash = 0xd0;

    i = 0;
    while ((i & 0x80) != 0x80)
    {
        i = *pFlash;
    }

    if (i != 0x80)
    {
        return(FALSE);
    }
    pFlash = (volatile Uint8 *)(FlashStart);

    // Clear the status register
    *pFlash = 0x50;
   
    // Erase each block.
    for (j = 0; j < num_blocks; j++)
    {
        // Issue erase and confirm command
        *pFlash = 0x20;
        *pFlash = 0xd0;
        while ((*pFlash & 0x80) != 0x80);

        // Check if the flash block erased successfully.
        // Was either block locked?
        status = *pFlash;
        if (status & 0x20)
        {
            return(FALSE);
        }
        pFlash += BLOCK_SIZE ;
    }
    pFlash = (volatile Uint8 *)(FlashStart);

    *pFlash = 0xFF;

    // Flash erase verification.
    for (i = 0; i < FlashLength; i++)
    {
        if (*pFlash++ != 0xFF)
        {
            return(FALSE);
        }
    }

    return(TRUE);
}

Bool FlashRead(Uint32 FlashStart, Uint8 *pDataBuffer, Uint32 DataLength)
{
    if (!pDataBuffer) return(FALSE);

    // TODO - check flash address...
    memcpy((void *)pDataBuffer, (const void *)FlashStart, DataLength);

    return(TRUE);
}

Bool FlashByteWrite(Uint32 FlashAdd, Uint8 Data)
{
    volatile Uint8 *pFlash = (volatile Uint8 *) FlashAdd;
    *pFlash = 0x40;
    *pFlash = Data;
    while ((*pFlash & 0x80) != 0x80);
    *pFlash = 0xFF;
    if(*pFlash != Data) return FALSE;

    return TRUE;	
}

Bool FlashWrite(Uint32 FlashStart, Uint8 *pDataBuffer, Uint32 DataLength)
{
    Uint32 i,j;
    Uint32 sizeFlashCache; // size in bytes of the flash cache
    Uint32 count;
    Uint32 dwLength = DataLength;

    volatile Uint8 *pFlash         = (volatile Uint8 *) FlashStart;
    volatile Uint8 *pBlockAddress  = (volatile Uint8 *) FlashStart;
    volatile Uint8 *pDeviceAddress = (volatile Uint8 *) FlashStart;
    volatile Uint8 *pFlashCache    = (Uint8 *) pDataBuffer;

    volatile Uint8 *pdwFlashStart;
    volatile Uint8 *pdwRamStart;

/*
    if (!FlashErase(FlashStart,DataLength))
    {
        return(FALSE);
    }
*/
    i = FlashStart % 0x20;
    if(i)
    {
        count = 0x20 - i;
        if (DataLength <= count)	count = DataLength;	
		
        // Issue Write to Buffer Command
        *pBlockAddress = 0xE8;

        // Check that the write buffer is available.
        // Read the Extended Status Register and
        // wait for the assertion of XSR[7] before continuing.
        while ( (*pBlockAddress & 0x80) != 0x80)
        {
            *pBlockAddress = 0xE8;
        }

        // Configure the size of the buffer that we will write.
        // Write the word count (device expects a 0 based number)
        *pBlockAddress =  count - 1;

        pdwFlashStart = pDeviceAddress;
        pdwRamStart   = pFlashCache;

        // Write up to "count" DWORD.S into the Flash memory staging area
        for (i = 0; i < count; i++)
        {
            *pDeviceAddress++ = *pFlashCache++;
        }

        // Now program the buffer into Flash
        *pBlockAddress = 0xD0;

        i = 0;
        while ((i & 0x80) != 0x80)
        {
            i = *pBlockAddress;
        }


	 // Read back the segment just written
        *pFlash = 0xFF;
        for (i = 0; i < count; i++)
        {
            if (*pdwFlashStart++ != *pdwRamStart++)
            { 
                return(FALSE);
            }
        }
		
        DataLength -= count;
		
	}
    sizeFlashCache = 32;   // 32 Words per device

    while (DataLength > 0)
    {
        // Calculate the number of DWORDS to program in each iteration based on the size in bytes
        // of the flash cache.
        if (DataLength > sizeFlashCache)
            count = sizeFlashCache;
        else
            count = DataLength;

        // Issue Write to Buffer Command
        *pBlockAddress = 0xE8;

        // Check that the write buffer is available.
        // Read the Extended Status Register and
        // wait for the assertion of XSR[7] before continuing.
        while ( (*pBlockAddress & 0x80) != 0x80)
        {
            *pBlockAddress = 0xE8;
        }

        // Configure the size of the buffer that we will write.
        // Write the word count (device expects a 0 based number)
        *pBlockAddress =  count - 1;

        pdwFlashStart = pDeviceAddress;
        pdwRamStart   = pFlashCache;

        // Write up to "count" DWORD.S into the Flash memory staging area
        for (i = 0; i < count; i++)
        {
            *pDeviceAddress++ = *pFlashCache++;
        }

        // Now program the buffer into Flash
        *pBlockAddress = 0xD0;

        i = 0;
        while ((i & 0x80) != 0x80)
        {
            i = *pBlockAddress;
        }

        DataLength -= count;
//        pBlockAddress += count;//block address should be added count????

        // Read back the segment just written
        *pFlash = 0xFF;
        for (i = 0; i < count; i++)
        {
            if (*pdwFlashStart++ != *pdwRamStart++)
            { 
                return(FALSE);
            }
        }
    }

    // Verify the data written to flash...
    //
    pFlash      = (volatile Uint8 *) FlashStart;
    pFlashCache = (Uint8 *) pDataBuffer;

    // Put Flash into read mode.
    *pFlash = 0xFF;

    for ( j = 0; j < dwLength; j++ )
    {
        if (*pFlash++ != *pFlashCache++)
        {
            return(FALSE);
        }
    }

    return(TRUE);
}

