
#include "serial.h"


SerialRegs  *g_pMonitorSerialRegs = (SerialRegs *) MonSerialBaseAddr;
SerialRegs  *g_pRadSerialRegs = (SerialRegs *) RadSerialBaseAddr;

//IntReg  *g_pSerialIntReg = (IntReg *) SerialIntStatusAddr;

SerialPar SerialDefPar = { 0x04, 0x00 , 0x03 }; //Serial Initial Par:9600,8,1,N

void SerialDisable(SerialRegs  *g_pSerial)
{
    while((g_pSerial->SR) & 0xC0) TSK_sleep(1);//ûнûз
    g_pSerial -> CR = 0x03;  //Disable Serial                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
}

void SerialEnable(SerialRegs  *g_pSerial)
{
    while((g_pSerial->SR) & 0xC0) TSK_sleep(1);//ûнûз
    g_pSerial -> CR = 0x04;   //Enable Serial                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
}

void SerialParSet(
	SerialRegs  *g_pSerial,
	SerialPar  SerPar
)
{
	UINT32 i;
    g_pSerial -> LCR = SerPar.Lcr_Par;
	for(i=0;i<1000;i++)
	{i = i;}
    g_pSerial -> BAUDCR = SerPar.Baud_Par;                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
}

void SerialSet(
	SerialRegs  *g_pSerial,
	SerialPar  SerPar
)
{
    SerialDisable(g_pSerial);
    SerialParSet(g_pSerial, SerPar);
    SerialEnable(g_pSerial);                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
}

void ClrSerialRcvFIFO(
	SerialRegs  *g_pSerial
)
{
    Uint32 i;
    while((g_pSerial->SR) & 0xC0);
    g_pSerial -> CR |= 0x01;	
    for(i=0;i<10;i++) i=i;
    g_pSerial -> CR &= 0x04;	                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
}

void SendCommand(Uint8 port,Uint8  *pcommand)
{
	Uint32 i;
	
	pcommand[14] = pcommand[1];

	for(i=2;i<14;i++)
	{
		pcommand[14] ^= pcommand[i];
	}
	switch (port)
	{
		case MONITOR_UART:
			for(i=0;i<16;i++)
			{
				while((g_pMonitorSerialRegs->SR)&0x1);
				g_pMonitorSerialRegs->THR = pcommand[i];
			}
		break;
		case RAD_UART:
			for(i=0;i<16;i++)
			{
				while((g_pRadSerialRegs->SR)&0x1);
				g_pRadSerialRegs->THR = pcommand[i];
			}
		break;
		default:
		break;
	}

}

