
#include "hFiles.h"

#include <csl_emifa.h>
#include <csl_gpio.h>
#include <csl_ddr2.h>
#include <csl_pllc.h>
#include <cslr_dev.h>

#include "sysCfg.h"
#include "sysInit.h"
void setupSysClk()
{
    CSL_Status status;    
    CSL_PllcObj pllcObj;
    CSL_PllcHwSetup hwSetup;
    CSL_PllcHandle hPllc = NULL;
    CSL_BitMask32 response;   
    CSL_BitMask32 argPllCtrl;  

    /* Initialize the PLLC CSL module */
    if (CSL_SOK != CSL_pllcInit(NULL)) return;

    /* Clear local data structures */
    memset(&pllcObj, 0, sizeof(CSL_PllcObj));

    /* Open the PLLC CSL module */
    hPllc = CSL_pllcOpen(&pllcObj, CSL_PLLC_1, NULL, &status);
    if ((hPllc == NULL) || (status != CSL_SOK)) return;

    /* Setup PLLC hardware parameters */
	hwSetup.pllM    = (Uint32)0x1E/*0x19*/;
    hwSetup.preDiv  = (Uint32)0x01;/*0x03;*/
	hwSetup.pllDiv4 = (Uint32)0x05/*0x03*/;
    hwSetup.pllDiv5 = (Uint32)0x02;
    hwSetup.divEnable = (CSL_BitMask32) CSL_PLLC_DIVEN_PREDIV |
                                        CSL_PLLC_DIVEN_PLLDIV4 |
                                        CSL_PLLC_DIVEN_PLLDIV5;

    status = CSL_pllcHwSetup(hPllc, &hwSetup);
    if (status != CSL_SOK) {
        CSL_pllcClose(hPllc);
        return;
    }
    /* Wait if another GO operation is currently in progress.*/
    do {
        CSL_pllcGetHwStatus(hPllc, CSL_PLLC_QUERY_STATUS, &response);
    } while (response & CSL_PLLC_STATUS_GO);

    /* Set GOSET bit to change/set the dividers */
    argPllCtrl = 0x00010001;   /* value to set the GOSET bit and enable PLL*/ 
    status = CSL_pllcHwControl(hPllc, CSL_PLLC_CMD_PLLCONTROL, &argPllCtrl);
    if (status != CSL_SOK) {
        CSL_pllcClose(hPllc);
        return;
    }

    /* Poll for divide-ratio change and clock alignment to complete */
    do {
        CSL_pllcGetHwStatus(hPllc, CSL_PLLC_QUERY_STATUS, &response);
    } while (response & CSL_PLLC_STATUS_GO);

    //////////////////////////////////////////////////////////////////////////////////////
    /* Clear local data structures */
    memset(&pllcObj, 0, sizeof(CSL_PllcObj));

    /* Open the PLLC CSL module */
    hPllc = CSL_pllcOpen(&pllcObj, CSL_PLLC_2, NULL, &status);
    if ((hPllc == NULL) || (status != CSL_SOK)) return;

    /* Setup PLLC hardware parameters */
#ifdef EMAC_RGMII
    hwSetup.pllDiv1 = (Uint32)0x05;
#else
    hwSetup.pllDiv1 = (Uint32)0x02;
#endif
    hwSetup.divEnable = (CSL_BitMask32)CSL_PLLC_DIVEN_PLLDIV1;

    status = CSL_pllcHwSetup(hPllc, &hwSetup);
    if (status != CSL_SOK) {
        CSL_pllcClose(hPllc);
        return;
    }
    /* Wait if another GO operation is currently in progress.*/
    do {
        CSL_pllcGetHwStatus(hPllc, CSL_PLLC_QUERY_STATUS, &response);
    } while (response & CSL_PLLC_STATUS_GO);

    /* Set GOSET bit to change/set the dividers */
    argPllCtrl = 0x00010001;   /* value to set the GOSET bit and enable PLL*/ 
    status = CSL_pllcHwControl(hPllc, CSL_PLLC_CMD_PLLCONTROL, &argPllCtrl);
    if (status != CSL_SOK) {
        CSL_pllcClose(hPllc);
        return;
    }

    /* Poll for divide-ratio change and clock alignment to complete */
    do {
        CSL_pllcGetHwStatus(hPllc, CSL_PLLC_QUERY_STATUS, &response);
    } while (response & CSL_PLLC_STATUS_GO);

    return;
}
void setupEmifa()
{
    CSL_Status status;
    CSL_EmifaObj emifaObj;
    CSL_EmifaHandle hEmifa;
    CSL_EmifaHwSetup hwSetup ;   

    CSL_EmifaMemType syncVal;
    //CSL_EmifaAsyncWait asyncWait = CSL_EMIFA_ASYNCWAIT_SET; 
    //CSL_EmifaAsync asyncMem = CSL_EMIFA_ASYNCCFG_SET;
	CSL_EmifaSync SyncMem = CSL_EMIFA_SYNCCFG_SET;
    /* Clear local data structures */   
    memset(&emifaObj, 0, sizeof(CSL_EmifaObj));      
    memset(&hwSetup, 0, sizeof(CSL_EmifaHwSetup));

    /* setting for synchronous type */
    syncVal.ssel = EMIFA_MEMTYPE_SYNC;
    syncVal.async = NULL;
    syncVal.sync = &SyncMem;

    /* setup the hardware parameters */
    hwSetup.asyncWait = NULL;//&asyncWait;
    hwSetup.ceCfg[0] = &syncVal;   
    hwSetup.ceCfg[1] = NULL;
    hwSetup.ceCfg[2] = NULL;
    hwSetup.ceCfg[3] = NULL;      
        
    /* Initialize EMIFA CSL module */
    status = CSL_emifaInit(NULL);
    if (status != CSL_SOK) {
        printf("EMIFA: Initialization error.\n");
        printf("\tReason: CSL_emifaInit [status = 0x%x].\n", status);       
        return;
    }

    /* Opening the EMIFA instance */
    hEmifa =  CSL_emifaOpen(&emifaObj, CSL_EMIFA, NULL, &status);
    if ((status != CSL_SOK) || (hEmifa == NULL)) {
		printf("EMIFA: Error opening the instance. [status = 0x%x, hEmifa = 0x%x]\n", status, hEmifa);        
        return;
    }
    
    /* Setting up configuration parameter using HwSetup */
    status =  CSL_emifaHwSetup(hEmifa, &hwSetup);                     
    if (status != CSL_SOK) {
        printf("EMIFA: Error in HW Setup.\n");          
        printf("Init operation fails!\n");
        return;       
    }
}

void PowerUpPhy()
{
	CSL_GpioContext context;
	CSL_GpioPinConfig config;
	CSL_GpioHwSetup hwSetup;
	CSL_GpioPinNum pinNum;
	CSL_GpioHandle hGpio;
	CSL_GpioObj gpioObj;
	CSL_Status status;

	/* Initialize the GPIO CSL module */
	status = CSL_gpioInit(&context);
	if (status != CSL_SOK) {
		printf("GPIO: Initialization error.\n");
		return;
	}
	/* Open the CSL module */
	hGpio = CSL_gpioOpen(&gpioObj, CSL_GPIO, NULL, &status);
	if (status != CSL_SOK) {
		printf("GPIO: Error opening the instance.\n");
		return;
	}

	/* Setup hardware parameters */
	hwSetup.extendSetup = NULL;

	/* Setup the General Purpose IO */
	CSL_gpioHwSetup(hGpio, &hwSetup);

	/* Configure pin 7 to generate an interrupt on Rising Edge, and
	* configure it as an output.
	*/
	config.pinNum = CSL_GPIO_PIN7;
	config.trigger = CSL_GPIO_TRIG_RISING_EDGE;
	config.direction = CSL_GPIO_DIR_OUTPUT;

	/* configure the gpio pin 7 */
	CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);

	/* Set Data High:*/
	pinNum = CSL_GPIO_PIN7;
	//RST PHY
	int i;
	CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_CLEAR_BIT, &pinNum);
	for(i=0;i<1000000;)
		i++;
	CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_SET_BIT, &pinNum);
	//CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_SET_BIT, &pinNum);

}

void enableGpioPER()
{
    Bool gpioEn;
   
    /* Unlock the control register */
    CSL_FINST(((CSL_DevRegs*)CSL_DEV_REGS)->PERLOCK, DEV_PERLOCK_LOCKVAL, UNLOCK);

    /* Enable the GPIO */
    CSL_FINST(((CSL_DevRegs*)CSL_DEV_REGS)->PERCFG0, DEV_PERCFG0_GPIOCTL, ENABLE);

    do {
        gpioEn = (Bool)CSL_FEXT(((CSL_DevRegs*)CSL_DEV_REGS)->PERSTAT0, DEV_PERSTAT0_GPIOSTAT);
    } while (gpioEn != TRUE);
}
void SetupDDR()
{
	CSL_Ddr2Obj         ddr2Obj;
	CSL_Status          status;
	CSL_Ddr2HwSetup     hwSetup ;     
	CSL_Ddr2Handle    hDdr2;
	CSL_Ddr2Timing1     tim1 = {0x23, 0x04, 0x04, 0x04, 0x0B, 0x0F, 0x02, 0x02};
	CSL_Ddr2Timing2     tim2 = {0x02, 0x25, 0xDC, 0x02, 0x04};
	CSL_Ddr2Settings    set  = CSL_DDR2_SETTING_DEFAULTS;    

	/* Enable the ddr2 */
	CSL_FINST(((CSL_DevRegs*)CSL_DEV_REGS)->PERCFG1, DEV_PERCFG1_DDR2CTL, ENABLE);

	/* Clear local data structures */   
	memset(&ddr2Obj, 0, sizeof(CSL_Ddr2Obj));      
	memset(&hwSetup, 0, sizeof(CSL_Ddr2HwSetup));

	/* setup the hardware parameters */
	hwSetup.refreshRate = SDRAM_REFRESH_RATE_DEFAULT;
	hwSetup.timing1Param = &tim1;
	hwSetup.timing2Param = &tim2;
	hwSetup.setParam = &set;    

	/* Initialize DDR2 CSL module */
	status = CSL_ddr2Init(NULL);
	if (status != CSL_SOK) {
		printf("DDR2 EMIF: Initialization error.\n");
		printf("\tReason: CSL_ddr2Init [status = 0x%x].\n", status);        
		return;
	}

	/* Opening the DDR2 instance */
	hDdr2 =  CSL_ddr2Open(&ddr2Obj, CSL_DDR2, NULL, &status);
	if ((status != CSL_SOK) || (hDdr2 == NULL)) {
		printf("DDR2 EMIF: Error opening the instance. [status = 0x%x, hDdr2 = \
		       0x%x]\n", status, hDdr2);        
		return;
	}

	/* Setting up configuration parameter using HwSetup */
	status =  CSL_ddr2HwSetup(hDdr2, &hwSetup);                     
	if (status != CSL_SOK) {
		printf("DDR2 EMIF: Error in HW Setup.\n");        
		printf("Read write operation fails\n");
		return;       
	}
       
}
