
#include <std.h>
#include <stdio.h>
#include <c64.h>
#include <sem.h>
#include <mem.h>
#include "sysCfg.h"
//#include "edmaHelper.h"
//#include "i2c.h"
#include "keydispose.h"
#include "wndMgr.h"
#include "exec.h"
#include "Flash.h"
#include "serial.h"
#include <math.h>
#include "dataHome.h"
//CMDBUFFER cmdBuff;
CMDBUFFER RadCmdBuff;
//void* g_hExecSem = NULL;
//void* g_hPCUartSem = NULL;
void* g_hRadUartSem = NULL;
unsigned char *gImage_back = (unsigned char *)PIC_CONST_DDR_ADDR;
unsigned int tempframeAreaUpdateTime = 0;
unsigned int tempframeAreaVer = 0;
unsigned int tempsaved_sign ;
static FRAMEAREA tempframeArea[MAX_FRAME_NUMBER];
/*
void xSerialRecvHandler(void)
{
    #define xSerial_Status_Offset 0x00048
    #define xSerial_rFIFO_Offset 0x0004c
    #define xSerial_rFIFO_bEmpty (1 << 3)
    UINT8 count = 0;
    UINT8 buffer[16];
    volatile UINT8* prFIFO = (UINT8*)(USER_SPACE_BASE_ADDRESS+xSerial_rFIFO_Offset);
    volatile UINT8* pStatus = (UINT8*)(USER_SPACE_BASE_ADDRESS+xSerial_Status_Offset);
	//for(count = 0;count<16;count++)
	//	buffer[count++] = *prFIFO;
	//return;
     while (!(*pStatus & xSerial_rFIFO_bEmpty)) {
        buffer[count++] = *prFIFO;
        if (count==16)
        {
            if (count != FillContentToBuff(buffer,count,&cmdBuff)) return;
            count = 0;
        }
    }
    if (count != FillContentToBuff(buffer,count,&cmdBuff)) return;
    if (g_hPCUartSem) {
        SEM_post((SEM_Handle)g_hPCUartSem);
    }
}
*/
void RADxSerialRecvHandler(void)
{
    #define xRad_Status_Offset 0x0030
    #define xRad_rFIFO_Offset 0x0034
    #define xRad_rFIFO_bEmpty (1 << 3)
    UINT8 count = 0;
    UINT8 buffer[16];
    volatile UINT8* prFIFO = (UINT8*)(USER_SPACE_BASE_ADDRESS+xRad_rFIFO_Offset);
    volatile UINT8* pStatus = (UINT8*)(USER_SPACE_BASE_ADDRESS+xRad_Status_Offset);
    while (!(*pStatus & xRad_rFIFO_bEmpty)) {
        buffer[count++] = *prFIFO;
        if (count==16)
        {
            if (count != FillContentToBuff(buffer,count,&RadCmdBuff)) return;
            count = 0;
        }
    }
    if (count != FillContentToBuff(buffer,count,&RadCmdBuff)) return;
    if (g_hRadUartSem) {
        SEM_post((SEM_Handle)g_hRadUartSem);
    }
}

void xFPGAKeyHandler()
{
	#define xKey_rFIFO_Offset 0x0018
//	HWND hNextWnd;
	volatile UINT8* prKeyFIFO = (UINT8*)(USER_SPACE_BASE_ADDRESS+xKey_rFIFO_Offset);
	UINT8 KeyValue;
	KeyValue = (*prKeyFIFO) & 0x1F;
	if(KeyValue < 18)
	{
		PostMessage(NULL, (MSG_FLG + (EVENT_KEY << 16) + KeyValue));
	}/*
	else if(KeyValue == 16)//net key
	{
		hNextWnd = GetWndByIdentity(0x3A);
		ShowWnd(hNextWnd);
	}
	else if(KeyValue == 17)//freq key
	{
		hNextWnd = GetWndByIdentity(0x32);
		ShowWnd(hNextWnd);	
	}*/
	else//wrong keyvalue
	{}
}
void CreatDefSysCfg()
{
	//mmcopy(SysInfo.SavedPar.devid,"Gtel0000",8);
	SysInfo.SavedPar.overID = 12;
	SysInfo.SavedPar.freq = 1200000;//khz
	SysInfo.SavedPar.bandwidth = 36;
	SysInfo.SavedPar.snr = -100;
	SysInfo.SavedPar.volt = 20;
	SysInfo.SavedPar.testmode = 0;
	SysInfo.SavedPar.filldata = 0x06;
	SysInfo.SavedPar.fillmode = 0;
	SysInfo.SavedPar.doppler = -1000;
	SysInfo.SavedPar.uver = 0;
	SysInfo.SavedPar.cyctimes = 60000;
	SysInfo.SavedPar.overcount = 50000;
	SysInfo.SavedPar.devip = (UINT32)(198 + (18<<8) + (108<<16) + (18<<24));
	SysInfo.SavedPar.devmac[0] = 0x00;
	SysInfo.SavedPar.devmac[1] = 0x60;
	SysInfo.SavedPar.devmac[2] = 0x4f;
	SysInfo.SavedPar.devmac[3] = 0x1f;
	SysInfo.SavedPar.devmac[4] = 0x4d;
	SysInfo.SavedPar.devmac[5] = 0x30;	
	SysInfo.SavedPar.devport = 10011;
	SysInfo.SavedPar.signal = 1;
	SysInfo.SavedPar.noise = 1;

	SysInfo.SavedPar.offsetfreq = 2550;
	SysInfo.SavedPar.offsetsnr = 0;
	SysInfo.SavedPar.offsetvolt = 0;
	
	SysInfo.SavedPar.mswitch = 1;
	SysInfo.SavedPar.outswitch = 1;
	
	SysInfo.SavedPar.dcr = 0x00;
	SysInfo.SavedPar.dfsr = 1.0;
	//SysInfo.SavedPar.odr 
	SysInfo.SavedPar.saved_sign = 0x87654321;

}

void enableXserialInterrupt()
{
    CSL_GpioPinConfig config;
    CSL_GpioContext pContext;
    CSL_GpioHwSetup hwSetup;
    CSL_Status status;

    enableGpioPER();
	
    /* Initialize the GPIO CSL module */
    status = CSL_gpioInit(&pContext);
    if (status != CSL_SOK) {
        printf("GPIO: Initialization error.\n");
        return;
    }
    /* Open the CSL module */
    g_GPIO_Dev.hGpio = CSL_gpioOpen(&g_GPIO_Dev.gpioObj, CSL_GPIO, NULL, &status);
    if ((g_GPIO_Dev.hGpio == NULL) || (status != CSL_SOK)) {
    	  printf("GPIO: Error opening the instance.\n");
    	  return;
    }
    
    /* Setup hardware parameters */
    hwSetup.extendSetup = NULL;
    
    /* Setup the General Purpose IO */
    status = CSL_gpioHwSetup(g_GPIO_Dev.hGpio, &hwSetup);
    
    /* Configure pin 3 to generate an interrupt on Rising Edge, and
     * configure it as an input.
     */
    config.pinNum = CSL_GPIO_PIN3;
    config.trigger = CSL_GPIO_TRIG_RISING_EDGE;
    config.direction = CSL_GPIO_DIR_INPUT;

    /* Enable the bank interrupt */
    status = CSL_gpioHwControl(g_GPIO_Dev.hGpio, CSL_GPIO_CMD_BANK_INT_ENABLE, NULL);
    if (status != CSL_SOK) {
        printf("GPIO: Command to enable bank interrupt... Failed.\n");
        return;
    }

    /* configure the gpio pin 3 */
    status = CSL_gpioHwControl(g_GPIO_Dev.hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);
    if (status != CSL_SOK) {
        printf("GPIO: GPIO pin configuration error.\n");
        return;
    }

    C64_enableIER(1 << XSER_RECV_INT);
}



void enableRadInterrupt()
{
    CSL_GpioPinConfig config;
    CSL_GpioContext pContext;
    CSL_GpioHwSetup hwSetup;
    CSL_Status status;

    enableGpioPER();
	
    /* Initialize the GPIO CSL module */
    status = CSL_gpioInit(&pContext);
    if (status != CSL_SOK) {
        printf("GPIO: Initialization error.\n");
        return;
    }
    /* Open the CSL module */
    g_GPIO_Dev.hGpio = CSL_gpioOpen(&g_GPIO_Dev.gpioObj, CSL_GPIO, NULL, &status);
    if ((g_GPIO_Dev.hGpio == NULL) || (status != CSL_SOK)) {
    	  printf("GPIO: Error opening the instance.\n");
    	  return;
    }
    
    /* Setup hardware parameters */
    hwSetup.extendSetup = NULL;
    
    /* Setup the General Purpose IO */
    status = CSL_gpioHwSetup(g_GPIO_Dev.hGpio, &hwSetup);
    
    /* Configure pin 5 to generate an interrupt on Rising Edge, and
     * configure it as an input.
     */
    config.pinNum = CSL_GPIO_PIN5;
    config.trigger = CSL_GPIO_TRIG_RISING_EDGE;
    config.direction = CSL_GPIO_DIR_INPUT;

    /* Enable the bank interrupt */
    status = CSL_gpioHwControl(g_GPIO_Dev.hGpio, CSL_GPIO_CMD_BANK_INT_ENABLE, NULL);
    if (status != CSL_SOK) {
        printf("GPIO: Command to enable bank interrupt... Failed.\n");
        return;
    }

    /* configure the gpio pin 5 */
    status = CSL_gpioHwControl(g_GPIO_Dev.hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);
    if (status != CSL_SOK) {
        printf("GPIO: GPIO pin configuration error.\n");
        return;
    }

    C64_enableIER(1 << RAD_DATA_INT);
}


void enableKeyInterrupt()
{
    CSL_GpioPinConfig config;
    CSL_GpioContext pContext;
    CSL_GpioHwSetup hwSetup;
    CSL_Status status;

    enableGpioPER();
	
    /* Initialize the GPIO CSL module */
    status = CSL_gpioInit(&pContext);
    if (status != CSL_SOK) {
        printf("GPIO: Initialization error.\n");
        return;
    }
    /* Open the CSL module */
    g_GPIO_Dev.hGpio = CSL_gpioOpen(&g_GPIO_Dev.gpioObj, CSL_GPIO, NULL, &status);
    if ((g_GPIO_Dev.hGpio == NULL) || (status != CSL_SOK)) {
    	  printf("GPIO: Error opening the instance.\n");
    	  return;
    }
    
    /* Setup hardware parameters */
    hwSetup.extendSetup = NULL;
    
    /* Setup the General Purpose IO */
    status = CSL_gpioHwSetup(g_GPIO_Dev.hGpio, &hwSetup);
    
    /* Configure pin 1 to generate an interrupt on Rising Edge, and
     * configure it as an input.
     */
    config.pinNum = CSL_GPIO_PIN1;
    config.trigger = CSL_GPIO_TRIG_RISING_EDGE;
    config.direction = CSL_GPIO_DIR_INPUT;

    /* Enable the bank interrupt */
    status = CSL_gpioHwControl(g_GPIO_Dev.hGpio, CSL_GPIO_CMD_BANK_INT_ENABLE, NULL);
    if (status != CSL_SOK) {
        printf("GPIO: Command to enable bank interrupt... Failed.\n");
        return;
    }

    /* configure the gpio pin 1 */
    status = CSL_gpioHwControl(g_GPIO_Dev.hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);
    if (status != CSL_SOK) {
        printf("GPIO: GPIO pin configuration error.\n");
        return;
    }

    C64_enableIER(1 << KEY_INT);
}

void disableXserialInterrupt()
{
    volatile Uint32* pClrRisingReg = (Uint32 *)CLR_RIS_TRIG_ADDR;
    *pClrRisingReg &= CSL_GPIO_CLR_RIS_TRIG_CLRRIS3_MASK; 
    C64_disableIER(1 << XSER_RECV_INT);
}
void disableRADXserialInterrupt()
{
    volatile Uint32* pClrRisingReg = (Uint32 *)CLR_RIS_TRIG_ADDR;
    *pClrRisingReg &= CSL_GPIO_CLR_RIS_TRIG_CLRRIS2_MASK; 
    C64_disableIER(1 << RAD_DATA_INT);
}
void disableKeyInterrupt()
{
    volatile Uint32* pClrRisingReg = (Uint32 *)CLR_RIS_TRIG_ADDR;
    *pClrRisingReg &= CSL_GPIO_CLR_RIS_TRIG_CLRRIS1_MASK; 
    C64_disableIER(1 << KEY_INT);
}

UINT32 LoadSysCfg()
{
	UINT32 rtn = FALSE;
	mmzero(&(SysInfo.SavedPar),sizeof(SAVEINFO));
	rtn = FlashRead(SAVED_SET_PAR_ADDR, (UINT8 *)(&(SysInfo.SavedPar)), sizeof(SAVEINFO));
	return rtn;
}
UINT32 LoadSysTabCfg()
{
	mmzero((tempframeArea),MAX_FRAME_NUMBER*sizeof(FRAMEAREA));
	mmzero(&(tempframeAreaUpdateTime),4);
	mmzero(&(tempframeAreaVer),4);
	mmzero(&(tempsaved_sign),4);
	if(!FlashRead(SAVED_TAB_ADDR, (UINT8 *)(&(tempsaved_sign)), 4))
		return FALSE;
	if(!FlashRead(SAVED_TAB_ADDR+4, (UINT8 *)(&(tempframeAreaUpdateTime)), 4))
		return FALSE;
	if(!FlashRead(SAVED_TAB_ADDR+8, (UINT8 *)(&(tempframeAreaVer)), 4))
		return FALSE;
	if(!FlashRead(SAVED_TAB_ADDR+12, (UINT8 *)((tempframeArea)), MAX_FRAME_NUMBER*sizeof(FRAMEAREA)))
		return FALSE;
	return TRUE;
}
UINT32 LoadConstPic()
{
	unsigned int savedsign;
	mmzero(gImage_back,192000);
	if(!FlashRead(SAVED_CONST_PIC_ADDR, (UINT8 *)(&savedsign), 4))
	{
		mmset(gImage_back, 192000, 0x0a);
		return FALSE;
	}
	else
	{
		if(savedsign == 0x87654321)
			FlashRead(SAVED_CONST_PIC_ADDR+4, gImage_back, 192000);
		else
			mmset(gImage_back, 192000, 0x0a);
	}
	return TRUE;
}
UINT32 SaveSysCfg()
{
	UINT32 rtn = FALSE;
//	HWI_disable();				
	rtn = FlashErase(SAVED_SET_PAR_ADDR, sizeof(SAVEINFO));
	if (rtn != TRUE)
	{
		return rtn;
	}
	rtn = FlashWrite(SAVED_SET_PAR_ADDR, (UINT8 *)(&(SysInfo.SavedPar)), sizeof(SAVEINFO));
//	HWI_enable();
	return rtn;
}
void SetSnr()
{
	unsigned short fs,fn;
	if(SysInfo.SavedPar.mswitch == 0 || SysInfo.SavedPar.outswitch == 0)
	{
		g_pBaseRegs->SSR = 0;
		g_pBaseRegs->NSR = 0;
	}
	else
	{
		if(SysInfo.SavedPar.snr > 200)
		{
			g_pBaseRegs->SSR = 28892;
			g_pBaseRegs->NSR = 0;
		}
		else if(SysInfo.SavedPar.snr < -200)
		{
			g_pBaseRegs->SSR = 0;
			switch (SysInfo.SavedPar.bandwidth)
			{
				case 9:
					g_pBaseRegs->NSR = 65054;
					break;
				case 12:
					g_pBaseRegs->NSR = 56338;
					break;
				case 18:
					g_pBaseRegs->NSR = 46000;
					break;
				case 36:
					g_pBaseRegs->NSR = 32711;
					break;
				default:
					break;
			}
			
		}
		else
		{
			calculateSNR((SysInfo.SavedPar.snr+SysInfo.SavedPar.offsetsnr),SysInfo.SavedPar.bandwidth,&fs,&fn);
			if(SysInfo.SavedPar.signal)
				g_pBaseRegs->SSR = fs;
			else
				g_pBaseRegs->SSR = 0;
			if(SysInfo.SavedPar.noise)
				g_pBaseRegs->NSR = fn;
			else
				g_pBaseRegs->NSR = 0;
		}
	}
}

void SetSaveCfg()
{

	unsigned int temp_u32;
	int temp_32;
	
	SetSnr();
	switch(SysInfo.SavedPar.bandwidth)
	{
		case 36:
			g_pBaseRegs->BWCR = BANDWIDTH_36MHZ;
			break;
		case 18:
			g_pBaseRegs->BWCR = BANDWIDTH_18MHZ;
			break;
		case 12:
			g_pBaseRegs->BWCR = BANDWIDTH_12MHZ;
			break;
		case 9:
			g_pBaseRegs->BWCR = BANDWIDTH_9MHZ;
			break;
		default:
			break;
	}
	g_pBaseRegs->DCR = SysInfo.SavedPar.dcr;
	calculateDeltaFreq(SysInfo.SavedPar.freq,&temp_u32);//Ƶƫ
	
	g_pBaseRegs->DFCR = temp_u32 & 0x7FFF;
	g_pBaseRegs->DFCR = ((temp_u32 >>15 )& 0x7FFF) | 0x8000;
	
	calculateDopplerCyc(SysInfo.SavedPar.dfsr,&temp_u32);
	g_pBaseRegs->DFSR = temp_u32 & 0x7FFF;
	g_pBaseRegs->DFSR = ((temp_u32 >>15 )& 0x7FFF) | 0x8000;
	
	calculateDopplerFreqR(SysInfo.SavedPar.doppler,SysInfo.SavedPar.dcr,&temp_32);
	g_pBaseRegs->DFRR = temp_32 & 0x7FFF;
	if(temp_32 < 0)
		g_pBaseRegs->DFRR = ((temp_32 >>15) & 0x7FFF) | 0xC000;
	else
		g_pBaseRegs->DFRR = ((temp_32 >>15) & 0x7FFF) | 0x8000;
	//g_pBaseRegs->DFCR = SysInfo.SavedPar.doppler & 0x7FFF;
	SetSnr();
	
	
}
void SetSavedCfg_Rad()
{
	Uint8 InitCMD[16];
	Uint32 temp32;
	//Ƶ
	
	memset((Uint8 *)InitCMD, 0, 16);
	InitCMD[0] = 0xFE;
	InitCMD[1] = 0x03;//set
	InitCMD[2] = 0x05;//˥
	InitCMD[3] = 0x01;//
	InitCMD[4] = ((SysInfo.SavedPar.volt-SysInfo.SavedPar.offsetvolt)-20) * 4;//???
	InitCMD[15] = 0xFA;
	SendCommand(RAD_UART, InitCMD);
	delay(100);
	//
	memset((Uint8 *)InitCMD, 0, 16);
	InitCMD[0] = 0xFE;
	InitCMD[1] = 0x03;//set
	InitCMD[2] = 0x02;//
	InitCMD[3] = 0x01;//
	InitCMD[4] = SysInfo.SavedPar.outswitch;
	InitCMD[15] = 0xFA;
	SendCommand(RAD_UART, InitCMD);
	delay(100);
	memset((Uint8 *)InitCMD, 0, 16);
	InitCMD[0] = 0xFE;
	InitCMD[1] = 0x03;//set
	InitCMD[2] = 0x20;//ƿ
	InitCMD[3] = 0x01;//
	InitCMD[4] = SysInfo.SavedPar.mswitch;
	InitCMD[15] = 0xFA;
	SendCommand(RAD_UART, InitCMD);
	delay(100);
	memset((Uint8 *)InitCMD,0,16);
	InitCMD[0] = 0xFE;
	InitCMD[1] = 0x61;//set
	InitCMD[2] = 0x61;//ƿ
	InitCMD[3] = 0x02;//
	InitCMD[4] = SysInfo.SavedPar.offsetfreq&0xFF;
	InitCMD[5] = (SysInfo.SavedPar.offsetfreq>>8) & 0xFF;
	InitCMD[15] = 0xFA;
	SendCommand(RAD_UART, InitCMD);
	delay(100);
	if(SysInfo.SavedPar.mswitch)
		temp32 = (SysInfo.SavedPar.freq-100) * 10;
	else
		temp32 = (SysInfo.SavedPar.freq)*10;
	memset((Uint8 *)InitCMD, 0, 16);
	InitCMD[0] = 0xFE;
	InitCMD[1] = 0x03;//set
	InitCMD[2] = 0x07;//Ƶ
	InitCMD[3] = 0x04;//
	InitCMD[7] = temp32 >> 24 & 0xFF;
	InitCMD[6] = temp32 >> 16 & 0xFF;
	InitCMD[5] = temp32 >> 8 & 0xFF;
	InitCMD[4] = temp32 & 0xFF;
	InitCMD[15] = 0xFA;
	SendCommand(RAD_UART, InitCMD);
}
void WaitFpgaInitComplete()
{
 	UINT16 *CodeAddr = (UINT16 *) 0xA0001074;
	while( *CodeAddr != 0x5678);
	if(LoadSysCfg() == FALSE)
	{
		CreatDefSysCfg();
		
		GetFramVer(&SysInfo.SavedPar.uver);		
		mmzero(&netCfg,sizeof(NETCONFIG));
		SysInfo.UnsavedInfo.LinkStatus = 0;
		SysInfo.UnsavedInfo.lock = 0;
		SysInfo.UnsavedInfo.radtemp = (-25.5+40)*2;
		netCfg.TcpPort = htons (SysInfo.SavedPar.devport);
		netCfg.IPAddr = SysInfo.SavedPar.devip;
		netCfg.IPMask = DEFAULT_DEV_IP_MASK;
		netCfg.destIPAddr = 0;
		netCfg.destIPMask = 0;
		netCfg.IPGway = DEFAULT_DEV_IP_GATEWAY;
		netCfg.IPDNS = DEFAULT_DEV_IP_DNS;
		strCopy(netCfg.DomainName, DEFAULT_DEV_DOMAIN_NAME);
		strCopy(netCfg.HostName, DEFAULT_DEV_HOST_NAME);
		netCfg.MacAddr[0] = SysInfo.SavedPar.devmac[0];
		netCfg.MacAddr[1] = SysInfo.SavedPar.devmac[1];
		netCfg.MacAddr[2] = SysInfo.SavedPar.devmac[2];
		netCfg.MacAddr[3] = SysInfo.SavedPar.devmac[3];
		netCfg.MacAddr[4] = SysInfo.SavedPar.devmac[4];
		netCfg.MacAddr[5] = SysInfo.SavedPar.devmac[5];
		netCfg.MagicNumber = NET_MAGIC_NUMBER;
		//if((SysInfo.freq<LOWER_LIMIT_FREQ)||(SysInfo.freq>UPPER_LIMIT_FREQ))	SysInfo.freq = 1200000;
	}
	else
	{
		if(SysInfo.SavedPar.saved_sign != 0x87654321) 
			CreatDefSysCfg();
		
		mmzero(&netCfg,sizeof(NETCONFIG));
		SysInfo.UnsavedInfo.LinkStatus = 0;
		SysInfo.UnsavedInfo.lock = 0;
		SysInfo.UnsavedInfo.radtemp = (-25.5+40)*2;
		netCfg.TcpPort = htons (SysInfo.SavedPar.devport);
		netCfg.IPAddr = SysInfo.SavedPar.devip;
		netCfg.IPMask = DEFAULT_DEV_IP_MASK;
		netCfg.destIPAddr = 0;
		netCfg.destIPMask = 0;
		netCfg.IPGway = DEFAULT_DEV_IP_GATEWAY;
		netCfg.IPDNS = DEFAULT_DEV_IP_DNS;
		strCopy(netCfg.DomainName, DEFAULT_DEV_DOMAIN_NAME);
		strCopy(netCfg.HostName, DEFAULT_DEV_HOST_NAME);
		netCfg.MacAddr[0] = SysInfo.SavedPar.devmac[0];
		netCfg.MacAddr[1] = SysInfo.SavedPar.devmac[1];
		netCfg.MacAddr[2] = SysInfo.SavedPar.devmac[2];
		netCfg.MacAddr[3] = SysInfo.SavedPar.devmac[3];
		netCfg.MacAddr[4] = SysInfo.SavedPar.devmac[4];
		netCfg.MacAddr[5] = SysInfo.SavedPar.devmac[5];
		netCfg.MagicNumber = NET_MAGIC_NUMBER;
	}
	if(LoadSysTabCfg() && tempsaved_sign == 0x87654321)
	{
		UpdateFrameModeTab(&tempframeArea,tempframeAreaVer,tempframeAreaUpdateTime);
		GetFramVer(&SysInfo.SavedPar.uver);
	}
	LoadConstPic();
	//SetSaveCfg();
	//PostMessage(NULL, (MSG_FLG + (EVENT_KEY << 16) + CONFIRM_KEY));
}
//---------------------------------------------
//˵:ͨȼźŹʺ
//:snrźŹfsָfn
//:
//fs*(32767/28969)+fn = 32767*2
//SNRset = (32767/28969) *(fs/fn)
//SNRset = pow(10,snr/10)
//ϵ:pow(10,((snr+20)*1.3/40*20))
//----------------------------------------------
void calculateSNR(const float snr,const UINT8 bw,UINT16 * fs,UINT16 * fn)
{
	UINT32 kn;
	float c1;
	double c2;
	float c3;
	UINT16 temp_fs,temp_fn;
	float temp = snr/100.0;
	float SNR = pow(10,temp);
	float exponent;
	exponent = 0.001625*(snr/10.0)+0.0325;
	switch (bw)
	{
		case 9:
			kn = 46000;
			break;
		case 12:
			kn = 39837;
			break;
		case 18:
			kn = 32526;
			break;
		case 36:
			kn = 23130;
			break;
		default:
			break;
	}
	c3 = 20430.0/kn;
	c1 = pow(c3,2);
	c2 = 2*(pow(kn,2));
	temp_fn = pow(c2/(1+SNR),0.5);
	temp_fs = pow(c1*pow(temp_fn,2)*SNR,0.5);
	*fn = temp_fn * pow(10,exponent);
	*fs = temp_fs * pow(10,exponent);
	//*fn = sqrt(2/(SNR + 2)) * 32768;
	//*fs = sqrt(SNR/(SNR + 2)) * 32768;
}
//---------------------------------------------
//˵:
//:mode = 0Ϊ̶ʽ
//:
//
//----------------------------------------------
void calculateDopplerFreqR(Int32 infreq,uchar mode,Int32 *outfreq)
{
	const float temp = 32.21225472;
	if(mode>>1)
	{
		*outfreq = fabs(infreq) * 2 * temp;
	}
	else
	{
		*outfreq = infreq * temp;
	}
}

void calculateDopplerCyc(float cyc,UINT32 *outcyc)
{
	const double temp = 2111062.32532992;
	*outcyc = temp / cyc;
}
void calculateDeltaFreq(UINT32 freq,UINT32 *outfreq)
{
	const float temp = 32.21225472;
	UINT32 delta_freq;
	delta_freq = (freq % 100 + 100)*1000;
	*outfreq = delta_freq * temp;
}
