
#include "hFiles.h" 

#include <netmain.h>
#include <_stack.h>

#include "sysCfg.h"
#include "sysContext.h"
//#include "keydispose.h"
//#include "wndMgr.h"

#include "dataHome.h"
#include "tcpServ.h"
#include "exec.h"

// Our NETCTRL callback functions
static void   NetworkOpen();
static void   NetworkClose();
static void   NetworkIPAddr(IPN IPAddr, uint IfIdx, uint fAdd);

// Fun reporting function
static void   ServiceReport(uint Item, uint Status, uint Report, HANDLE hCfgEntry);

//---------------------------------------------------------------------------
// Title String
//
char *VerStr = "\nTCP/IP Stack Application\n\n";



HANDLE hNetConfig = NULL;
SOCKET sMother = INVALID_SOCKET;

static bool fTcpServRun = true;
static bool fNetCfgChanged;

void tcpServTask();
void udpXmitTask();

void makeDefaultNetCfg()
{
	mmzero(&netCfg,sizeof(NETCONFIG));
	netCfg.TcpPort = DEFAULT_TCP_SERV_PORT;
	netCfg.IPAddr = DEFAULT_DEV_IP_ADDR;
	netCfg.IPMask = DEFAULT_DEV_IP_MASK;
	netCfg.destIPAddr = 0;
	netCfg.destIPMask = 0;
	netCfg.IPGway = DEFAULT_DEV_IP_GATEWAY;
	netCfg.IPDNS = DEFAULT_DEV_IP_DNS;
	strCopy(netCfg.DomainName, DEFAULT_DEV_DOMAIN_NAME);
	strCopy(netCfg.HostName, DEFAULT_DEV_HOST_NAME);
	netCfg.MacAddr[0] = 0x00;
	netCfg.MacAddr[1] = 0x60;
	netCfg.MacAddr[2] = 0x4F;
	netCfg.MacAddr[3] = 0x1F;
	netCfg.MacAddr[4] = 0x4D;
	netCfg.MacAddr[5] = 0x30;
	
	netCfg.MagicNumber = NET_MAGIC_NUMBER;
	
}

//
// Main Thread
//
void StackCtrlTask()
{
	int rc = 0;

	if (netCfg.MagicNumber != NET_MAGIC_NUMBER) {
		makeDefaultNetCfg();
	}
	//
	// THIS MUST BE THE ABSOLUTE FIRST THING DONE IN AN APPLICATION!!
	//
	rc = NC_SystemOpen( NC_PRIORITY_LOW/*NC_PRIORITY_HIGH*/, NC_OPMODE_INTERRUPT );
	if (rc)
	{
		printf("NC_SystemOpen Failed (%d)\n",rc);
		for(;;);
	}

	// Print out our banner
	printf(VerStr);

	//
	// Create and build the system configuration from scratch.
	//

	// Create a new configuration
	hNetConfig = CfgNew();
	if (!hNetConfig)
	{
		printf("Unable to create configuration\n");
		goto net_ctrl_exit;
	}

	// We better validate the length of the supplied names
	if (strlen(netCfg.DomainName) >= CFG_DOMAIN_MAX ||
		strlen(netCfg.HostName) >= CFG_HOSTNAME_MAX)
	{
		printf("Names too long\n");
		goto net_ctrl_exit;
	}

	// Add our global hostname to hCfg (to be claimed in all connected domains)
	CfgAddEntry(hNetConfig, CFGTAG_SYSINFO, CFGITEM_DHCP_HOSTNAME, 0, strlen(netCfg.HostName), (UINT8 *)(netCfg.HostName), 0);

	// If the IP address is specified, manually configure IP and Gateway
	if (netCfg.IPAddr)
	{
		CI_IPNET NA;
		CI_ROUTE RT;

		// Setup manual IP address
		bzero(&NA, sizeof(NA));
		NA.IPAddr  = netCfg.IPAddr;
		NA.IPMask  = netCfg.IPMask;
		strcpy(NA.Domain, netCfg.DomainName);
		NA.NetType = 0;

		// Add the address to interface 1
		CfgAddEntry(hNetConfig, CFGTAG_IPNET, 1, 0, sizeof(CI_IPNET), (UINT8 *)&NA, 0);

		// Add the default gateway. Since it is the default, the
		// destination address and mask are both zero (we go ahead
		// and show the assignment for clarity).
		bzero(&RT, sizeof(RT));
		RT.IPDestAddr = netCfg.destIPAddr;
		RT.IPDestMask = netCfg.destIPMask;
		RT.IPGateAddr = netCfg.IPGway;

		// Add the route
		CfgAddEntry(hNetConfig, CFGTAG_ROUTE, 0, 0, sizeof(CI_ROUTE), (UINT8 *)&RT, 0);

		// Manually add the DNS server when specified
		if (netCfg.IPDNS)
			CfgAddEntry(hNetConfig, 
					        CFGTAG_SYSINFO,
					        CFGITEM_DHCP_DOMAINNAMESERVER, 
					        0,
					        sizeof(netCfg.IPDNS),
					        (UINT8 *)&netCfg.IPDNS, 
					        0);
	}
	// Else we specify DHCP
	else
	{
		CI_SERVICE_DHCPC dhcpc;

		// Specify DHCP Service on IF-1
		bzero(&dhcpc, sizeof(dhcpc));
		dhcpc.cisargs.Mode   = CIS_FLG_IFIDXVALID;
		dhcpc.cisargs.IfIdx  = 1;
		dhcpc.cisargs.pCbSrv = &ServiceReport;
		CfgAddEntry(hNetConfig, 
				        CFGTAG_SERVICE, 
				        CFGITEM_SERVICE_DHCPCLIENT,
				        0, 
				        sizeof(dhcpc), 
				        (UINT8 *)&dhcpc, 
				        0);
	}
	//
	// Configure IPStack/OS Options
	//

	// We don't want to see debug messages less than WARNINGS
	rc = DBG_WARN;
	CfgAddEntry(hNetConfig, CFGTAG_OS, CFGITEM_OS_DBGPRINTLEVEL, CFG_ADDMODE_UNIQUE, sizeof(uint), (UINT8 *)&rc, 0);

	//
	// Boot the system using this configuration
	//
	// We keep booting until the function returns 0. This allows
	// us to have a "reboot" command.
	//
	do
	{
		rc = NC_NetStart(hNetConfig, NetworkOpen, NetworkClose, NetworkIPAddr);
	} while(rc > 0);

	// Delete Configuration
	CfgFree(hNetConfig);
	hNetConfig = NULL;

	// Close the OS
net_ctrl_exit:
	NC_SystemClose();

}

//
// NetworkOpen
//
// This function is called after the configuration has booted
//
static void NetworkOpen()
{
	fTcpServRun = true;
	TaskCreate(tcpServTask, "tcpServTask", OS_TASKPRILOW, OS_TASKSTKNORM, 0, 0, 0);
}

//
// NetworkClose
//
// This function is called when the network is shutting down,
// or when it no longer has any IP addresses assigned to it.
//
static void NetworkClose()
{

}

//
// NetworkIPAddr
//
// This function is called whenever an IP address binding is
// added or removed from the system.
//
static void NetworkIPAddr( IPN IPAddr, uint IfIdx, uint fAdd )
{
	if (fAdd)
		printf("Network Added: ");
	else
		printf("Network Removed: ");

	// Print a message
	printf("If-%d:%d.%d.%d.%d\n", IfIdx,
	        (UINT8)(ntohl(IPAddr)>>24)&0xFF, (UINT8)(ntohl(IPAddr)>>16)&0xFF,
	        (UINT8)(ntohl(IPAddr)>>8)&0xFF, (UINT8)ntohl(IPAddr)&0xFF);
}

//
// Service Status Reports
//
// Here's a quick example of using service status updates
//
static char *TaskName[] = { "Telnet","HTTP","NAT","DHCPS","DHCPC","DNS" };
static char *ReportStr[] = { "","Running","Updated","Complete","Fault" };
static char *StatusStr[] = { "Disabled","Waiting","IPTerm","Failed","Enabled" };
static void ServiceReport( uint Item, uint Status, uint Report, HANDLE h )
{
	printf( "Service Status: %-9s: %-9s: %-9s: %03d\n",
	        TaskName[Item-1], StatusStr[Status],
	        ReportStr[Report/256], Report&0xFF );

	//
	// Example of adding to the DHCP configuration space
	//
	// When using the DHCP client, the client has full control over access
	// to the first 256 entries in the CFGTAG_SYSINFO space.
	//
	// Note that the DHCP client will erase all CFGTAG_SYSINFO tags except
	// CFGITEM_DHCP_HOSTNAME. If the application needs to keep manual
	// entries in the DHCP tag range, then the code to maintain them should
	// be placed here.
	//
	// Here, we want to manually add a DNS server to the configuration, but
	// we can only do it once DHCP has finished its programming.
	//
	if (Item == CFGITEM_SERVICE_DHCPCLIENT &&
		Status == CIS_SRV_STATUS_ENABLED &&
		(Report == (NETTOOLS_STAT_RUNNING|DHCPCODE_IPADD) ||
		Report == (NETTOOLS_STAT_RUNNING|DHCPCODE_IPRENEW)))
	{
		// Manually add the DNS server when specified
		if (netCfg.IPDNS)
			CfgAddEntry(0, 
					CFGTAG_SYSINFO, 
					CFGITEM_DHCP_DOMAINNAMESERVER,
					0, 
					sizeof(netCfg.IPDNS),
					(UINT8 *)&netCfg.IPDNS, 
					0);
	}
}

void updateStackWithNetCfg()
{

	if(netCfg.MagicNumber != NET_MAGIC_NUMBER) return;

	// Add our global hostname to hCfg (to be claimed in all connected domains)
	CfgAddEntry(hNetConfig, CFGTAG_SYSINFO, CFGITEM_DHCP_HOSTNAME, CFG_ADDMODE_UNIQUE, strlen(netCfg.HostName), (UINT8 *)(netCfg.HostName), 0);

	// If the IP address is specified, manually configure IP and Gateway
	if(netCfg.IPAddr)
	{
		CI_IPNET NA;
		CI_ROUTE RT;

		// Setup manual IP address
		bzero(&NA, sizeof(NA));
		NA.IPAddr  = netCfg.IPAddr;
		NA.IPMask  = netCfg.IPMask;
		strcpy(NA.Domain, netCfg.DomainName);
		NA.NetType = 0;

		// Add the address to interface 1
		CfgAddEntry(hNetConfig, CFGTAG_IPNET, 1, CFG_ADDMODE_UNIQUE, sizeof(CI_IPNET), (UINT8 *)&NA, 0);

		// Add the default gateway. Since it is the default, the
		// destination address and mask are both zero (we go ahead
		// and show the assignment for clarity).
		bzero(&RT, sizeof(RT));
		RT.IPDestAddr = netCfg.destIPAddr;
		RT.IPDestMask = netCfg.destIPMask;
		RT.IPGateAddr = netCfg.IPGway;

		// Add the route
		CfgAddEntry(hNetConfig, CFGTAG_ROUTE, 0, CFG_ADDMODE_UNIQUE, sizeof(CI_ROUTE), (UINT8 *)&RT, 0);

		// Manually add the DNS server when specified
		if(netCfg.IPDNS)
			CfgAddEntry(hNetConfig, 
					CFGTAG_SYSINFO,
					CFGITEM_DHCP_DOMAINNAMESERVER, 
					CFG_ADDMODE_UNIQUE,
					sizeof(netCfg.IPDNS),
					(UINT8 *)&netCfg.IPDNS, 
					0);
	}
}

int isValidMacAddr(UINT8 *pMacAddr)
{
	if (!pMacAddr) return 0;
	if ((pMacAddr[0] & 1) || 
		(pMacAddr[0]|pMacAddr[1]|pMacAddr[2]|\
		pMacAddr[3]|pMacAddr[4]|pMacAddr[5]) == 0)
		return 0;
	return 1;
}

bool SetTcpServPort(UINT16 tcpPort)
{
	if(netCfg.MagicNumber != NET_MAGIC_NUMBER) 
		return false;
	netCfg.TcpPort = tcpPort;

	if(sMother != INVALID_SOCKET)
	{
		fdClose(sMother);
		sMother = INVALID_SOCKET;
	}
	TaskSleep(8000);

	return true;
}

bool UpdateNetCfgWithIPAddr(UINT32 IPAddr, UINT32 IPMask)
{
	if(netCfg.MagicNumber != NET_MAGIC_NUMBER) 
		return false;
	netCfg.IPAddr = IPAddr;
	netCfg.IPMask = IPMask;
	
	fNetCfgChanged = true;
	if(sMother != INVALID_SOCKET)
	{
		fdClose(sMother);
		sMother = INVALID_SOCKET;
	}
	TaskSleep(8000);

	return true;
}

bool UpdateNetCfgWithDestIPAddr(UINT32 IPAddr, UINT32 IPMask, UINT32 IPGateway)
{
	if(netCfg.MagicNumber != NET_MAGIC_NUMBER) 
		return false;
	netCfg.destIPAddr = IPAddr;
	netCfg.destIPMask = IPMask;
	netCfg.IPGway = IPGateway;
	
	fNetCfgChanged = true;
	if(sMother != INVALID_SOCKET)
	{
		fdClose(sMother);
		sMother = INVALID_SOCKET;
	}
	TaskSleep(8000);

	return true;
}

bool UpdateNetCfgWithDNS(UINT32 IPDns)
{
	if(netCfg.MagicNumber != NET_MAGIC_NUMBER) 
		return false;
	netCfg.IPDNS = IPDns;

	fNetCfgChanged = true;
	if(sMother != INVALID_SOCKET)
	{
		fdClose(sMother);
		sMother = INVALID_SOCKET;
	}
	TaskSleep(8000);

	return true;
}

bool UpdateNetCfgWithMacAddr(UINT8 *pMacAddr)
{

	if(netCfg.MagicNumber != NET_MAGIC_NUMBER ||
		!pMacAddr || !isValidMacAddr(pMacAddr)) 
		return false;
	mmcopy(netCfg.MacAddr,pMacAddr,sizeof(netCfg.MacAddr));
	
	fTcpServRun = false;
	if(sMother != INVALID_SOCKET)
	{
		fdClose(sMother);
		sMother = INVALID_SOCKET;
	}
	
	TaskSleep(8000);
	NC_NetStop(1);

	return true;
}

typedef enum {
	sFinding_Ver = 0,
	sGetting_Type,
	sVerify_Len,
	sProcess_Data
} ctrlState;

struct {
	unsigned char ver;
	unsigned char type;
	unsigned short len;
	unsigned char buffer[2048];
} ansBuffer;

#define CMD_ENQUIRY 'r'
#define CMD_SETTING 'w'
#define CMD_ENQUIRY_RESP 'R'
#define CMD_SETTING_RESP 'W'
void tcpServTask()
{
	int count, size;
	
	HANDLE hBuffer;
	unsigned char *pBuff;
	
	SOCKET sChild = INVALID_SOCKET;

	struct   sockaddr_in sin;
	struct   timeval timeout; 

	PCELL pCell = NULL;
	PCMD pCmd = NULL;
	ctrlState state = sFinding_Ver;
	
	unsigned char type;
	unsigned short uLen;
	int s, curPos, iPos = 0;

	int i, j, k = 0;
	unsigned char cAct = 0;
	unsigned char cCnt = 0;
	unsigned char frameNum, cellArea, rsv;
	
	HANDLE hEvent = CreateEvent(0);
	if(!hEvent) goto task_exit;
	
	// Allocate the file descriptor environment for this task
	fdOpenSession((HANDLE)TSK_self());

lbl_serv_restart:
	// Create the main TCP listen socket
	sMother = socket(AF_INET, SOCK_STREAMNC, IPPROTO_TCP);
	if(sMother == INVALID_SOCKET)
		goto leave;

	bzero(&sin, sizeof(struct sockaddr_in));
	sin.sin_family = AF_INET;
	sin.sin_len = sizeof(sin);
	sin.sin_addr.s_addr = netCfg.IPAddr;
	sin.sin_port = netCfg.TcpPort;

	// Bind socket
	if(bind(sMother, (PSA) &sin, sizeof(sin)) < 0)
		goto leave;

	// Start listening
	if(listen(sMother, 1) < 0)
		goto leave;
	
	// Configure our timeout to be 5 seconds
	timeout.tv_sec  = 5;
	timeout.tv_usec = 0;
	setsockopt(sMother, SOL_SOCKET, SO_SNDTIMEO, &timeout, sizeof(timeout));
	setsockopt(sMother, SOL_SOCKET, SO_RCVTIMEO, &timeout, sizeof(timeout));
	
	// Get the accept socket
	size = sizeof(sin);
	for(;;)
	{
		if(sMother == INVALID_SOCKET || 
			(sChild=accept(sMother, (PSA)&sin, &size)) == INVALID_SOCKET) 
			break;

		state = sFinding_Ver;
		for(;;)
		{
			count = (int)recvnc(sChild, (void**)&pBuff, 0, &hBuffer);
			if(count > 0)
			{
				// Process the received data...
				curPos = 0;
				
				switch(state)
				{
				case sFinding_Ver:
lbl_finding:
					s = 0;
					iPos = 0; 
					type = 0; 
					uLen = 0; 
					
					for(; curPos<count; )
					{
						if(pBuff[curPos++] == TCP_SERV_VER) {
							state = sGetting_Type;
							break;
						}
					}
					if(curPos == count) break;
				case sGetting_Type:
					switch(type = pBuff[curPos++])
					{
					case 0xC1:
						state = sVerify_Len;
						break;
					case 0xD1:
						pCell = NULL;
						frameNum = cellArea = rsv = 0;
						state = sVerify_Len;
						break;
					case 0xE1:
						state = sVerify_Len;
						break;
					default:
						state = sFinding_Ver;
						goto lbl_finding;
					}
					if(curPos == count) break;
				case sVerify_Len:
lbl_verify:
					if(uLen & 0x8000)
					{
						uLen += (pBuff[curPos++]<<8);
						uLen &= (~(1<<15));
						if(((type==0xD1) && (uLen<28 || uLen>897))||
							((type == 0xC1 || type == 0xE1)&&(uLen>2048)))
						{
							state = sFinding_Ver;
							goto lbl_finding;
						}
						else
						{
							state = sProcess_Data;
						}
					}
					else
					{
						uLen = 0x8000 | pBuff[curPos++];
						if(curPos == count) break;
						goto lbl_verify;
					}
					if(curPos == count) break;
				case sProcess_Data:
					switch(type)
					{
					case 0xE1:
					case 0xC1:
						if((count-curPos)>=(uLen-iPos))
						{
							mmcopy(&ansBuffer.buffer[iPos], &pBuff[curPos], uLen-iPos);
							curPos += uLen - iPos;

							ansBuffer.ver = TCP_SERV_VER;
							ansBuffer.type = type;
							ansBuffer.len = uLen/*htons(uLen)*/;

							k = cAct = cCnt = 0;
							if(ansBuffer.buffer[++k] == CMD_SETTING)
							{
								ansBuffer.buffer[k] = CMD_SETTING_RESP;
								cAct++;
							}
							else if(ansBuffer.buffer[k] == CMD_ENQUIRY)
							{
								ansBuffer.buffer[k] = CMD_ENQUIRY_RESP;
							}

							cCnt = ansBuffer.buffer[++k];

							for(i=0; i<cCnt; i++)
							{
								while(!(pCmd=GetEmptyCMD(NULL))) TaskSleep(8);
								
								pCmd->pOutputQ = NULL;
								pCmd->hEvent = hEvent;
								pCmd->act = cAct;
								pCmd->id = ansBuffer.buffer[++k];
								pCmd->pStat = &ansBuffer.buffer[++k];
								pCmd->num = ansBuffer.buffer[++k];
								for(j=0; j<pCmd->num; j++)
								{
									pCmd->paraElem[j].type = ansBuffer.buffer[++k];
									pCmd->paraElem[j].len = ansBuffer.buffer[++k];
									if(pCmd->paraElem[j].type & 0x80)
									{
										pCmd->paraElem[j].len += pCmd->paraElem[j].type<<8;
										pCmd->paraElem[j].len &= ~(1<<15);
										pCmd->paraElem[j].type = 0xFF; // invalid type
									}
						
									pCmd->paraElem[j].pBuffer = &ansBuffer.buffer[++k];
									k += pCmd->paraElem[j].len - 1;
								}

								PostCMD(pCmd);
							}

							for(i=0; i<cCnt; i++)
							{
								PendEvent(hEvent, TO_FOREVER);
							}

							if(send(sChild, &ansBuffer, uLen+4, 0 ) < 0)
							{
								recvncfree(hBuffer);
								goto lbl_close_cur_sock;
							}
							state = sFinding_Ver;
							goto lbl_finding;
						}
						else
						{
							mmcopy(&ansBuffer.buffer[iPos], &pBuff[curPos],count-curPos);
							iPos += count - curPos;
							curPos = count;
						}
						break;
					case 0xD1:
						switch(s)
						{
						case 0:
							s++;
							curPos++;
							if(curPos == count) break;
						case 1:
							s++;
							frameNum = pBuff[curPos++];
							if(--frameNum > 63)
							{
								state = sFinding_Ver;
								goto lbl_finding;
							}
							if(curPos == count) break;
						case 2:
							s++;
							cellArea = pBuff[curPos++];
							if(!cellArea)
								cellArea = CELL_TYPE_XAREA;
							else
								cellArea = CELL_TYPE_YAREA;
							if(curPos == count) break;
						case 3:
							if((count-curPos)>=(25-rsv))
							{
								s++;
								curPos += 25 - rsv;
								while(!(pCell = GetCell(hEvent))) TaskSleep(8);
								uLen -= 28;
							}
							else
							{
								rsv += count - curPos;
								curPos = count;
								break;
							}
						case 4:
							if((count-curPos)>=(uLen-iPos))
							{
								mmcopy(&pCell->buffer[pCell->len],&pBuff[curPos],uLen-iPos);
								pCell->len += uLen-iPos;
								curPos += uLen - iPos;

								pCell->type = (frameNum<<FRAME_NUMBER_FIELD_OFFSET)|cellArea|CELL_TYPE_DATA;

								while(!InsertFilledCell(pCell,true)) TaskSleep(8);

								state = sFinding_Ver;
								goto lbl_finding;
							}
							else
							{
								iPos += count - curPos;
								mmcopy(&pCell->buffer[pCell->len],&pBuff[curPos],count-curPos);
								pCell->len += count-curPos;
								curPos = count;
								break;
							}
						}
						break;
					}
					if(curPos == count) break;
				default:
					state = sFinding_Ver;
					goto lbl_finding;
						
				}
				recvncfree(hBuffer);
			}
			else
			{
lbl_close_cur_sock:
				fdClose(sChild);
				sChild = INVALID_SOCKET;
				break;
			}
		}
	}
	
leave:
	// We only get here on an error - close the sockets
	if(sMother != INVALID_SOCKET)
	{
		fdClose(sMother);
		sMother = INVALID_SOCKET;
	}

	// If coming here because of the changed netCfg, we will restart...
	if(fTcpServRun) 
	{
		if(fNetCfgChanged) 
			updateStackWithNetCfg();
		goto lbl_serv_restart;
	}
	
	// Free the file descriptor environment for this task
	fdCloseSession((HANDLE)TSK_self());
task_exit:
	if(hEvent) DeleteEvent(hEvent);
	TaskExit();
}

// MDIO phy access functions
uint MDIO_phyRegWrite(uint, uint, UINT16);
uint MDIO_phyRegRead(uint, uint, UINT16*);

// This string array corresponds to link state as defined in c6455_mdio.h
static char *LinkStr[] = { "No Link",
                           "10Mb/s Half Duplex",
                           "10Mb/s Full Duplex",
                           "100Mb/s Half Duplex",
                           "100Mb/s Full Duplex",
                           "1000Mb/s Full Duplex" };
static unsigned char iLinkStatus = 0;

unsigned char GetEtherLinkStatus() { return iLinkStatus; }
//
// C6455EMAC_getConfig()
//
// This is a callback from the Ethernet driver. This function
// is used by the driver to get its 6 byte MAC address, and
// to determine which DSP interrupt the EMAC should be mapped to.
//
void C6455EMAC_getConfig(UINT8 *pMacAddr, uint *pIntVector)
{
 
	printf("Using MAC Address: %02x-%02x-%02x-%02x-%02x-%02x\n",
		netCfg.MacAddr[0], netCfg.MacAddr[1], netCfg.MacAddr[2],
		netCfg.MacAddr[3], netCfg.MacAddr[4], netCfg.MacAddr[5]);

	// We fill in the two pointers here. We'll use int 5 for EMAC
	mmCopy(pMacAddr, netCfg.MacAddr, sizeof(netCfg.MacAddr));
	*pIntVector = EMAC_MDIO_INT;

}

//
// C6455EMAC_linkStatus()
//
// This is a callback from the Ethernet driver. This function
// is called whenever there is a change in link state. The
// current PHY and current link state are passed as parameters.
//
void C6455EMAC_linkStatus(uint phy, uint linkStatus)
{
	UINT16 data; 
	printf("Link Status: %s on PHY %d\n",LinkStr[iLinkStatus=linkStatus],phy);

	MDIO_phyRegRead(phy, 0x2, &data);
/*
	// Program the LEDs for the marvell phy
	if (data == 0x141)
		MDIO_phyRegWrite(phy, 0x18, 0x4143);
		//MDIO_phyRegWrite(phy, 0x14, 0xd5d0);

	// Program the LEDs for the Broadcom phy 
	if (data == 0x20)
		MDIO_phyRegWrite(phy, 0x1C, 0xa418);*/
}

