
#include "hFiles.h"
#include "charLib.h"
#include "sysContext.h"
#include "dispDriver.h"
#include "wndMgr.h"


#include "listHelper.h"

#define _max(x,y) ((x>y) ? x : y)
#define _min(x,y) ((x<y) ? x : y)

static int uDisplay_Resolution_x = 400;
static int uDisplay_Resolution_y = 240;

static int iRefreshing = 0;

#ifdef REFRESH_DIRECTLY
static int iRefreshDelayCnt = 0;
#endif

static uchar g_nOpened = 0;

static PWNDRT g_fpHook = NULL;

#define MAINSETWINDOW		0x03
#define OVERTAKEWND			0x06
#define BASEWND				0x07
#define RADPARWND			0x08
#define LOCALPARWND			0x09

// XWND message
#define MSG_DEPTH 32
#define MSGQ_MAGIC 0x78563412

typedef struct _MSGQ {
	uint magic;
	uintx msg[MSG_DEPTH];
	int ip;
	int op;
	HEVENT hEvt;
} MSGQ;

typedef struct _WTimer {
	struct _WTimer *pNext;
	HWND hOwner;
	uint prdTicks;
	uint trgTicks;
	uint state;
	uint used;
	uint info;
} WTimer, *PWTimer;

#define TIMER_DEPTH 40
WTimer timer[TIMER_DEPTH];
static uint g_timerTicks;
static PWTimer pFirstTimer;
extern unsigned char *gImage_back;
static void _TimerListInsert(PWTimer pTimer);
static void _TimerListRemove(PWTimer pTimer);
void _InitTimerQueue()
{
	mmset((PVOID)timer,TIMER_DEPTH*sizeof(WTimer),0);
	g_timerTicks = 0;
	pFirstTimer = 0;
}

typedef struct _WDAT {
	struct _WDAT *pNext;
	HWND hOwner;
	REGION region;
	uint content;
	uint uXyz;
	uint uInfo;
	uint uType;
	void (*pFxnDisplay)(uint);
	void (*pFxnCreate)(uint);
	void (*pFxnDelete)(uint);
} WDAT, *PWDAT;

typedef struct _WFCS {
	NODE node;
	HWND hOwner;
	AREA area;
	uint data;
	void (*pFxnPixel)(uint,int,int,UINT16*);
} WFCS, *PWFCS;

typedef struct _XWND {
	NODE node;
	PREGION pReg;
	POSITION pos,offset_pos;
	PWDAT pDat;
	PWFCS pFcs;
	uint timer;
	int cx;
	int cy;
	uchar f_visible;
	uchar f_border;
	uchar f_databorder;//LJP
	uchar uType;
	UINT16 uColor;
	UINT16 uBackColor;
	uint font_type;
	uint font_size;
	uint uIdentity;
	int (*pWndRoutine)(uint,uint);
	void (*pFxn_showHk)(uint);
	void (*pFxn_hideHk)(uint);
	UINT16 *pFrame;
	//uchar *pFrame;
} XWND, *PXWND;

static inline VOID keep_relevant_databorder(PXWND pWnd, PREGION pRegion,uchar rowOff,uchar colOff);
#define s_wnd_row(pWnd) (((PXWND)pWnd)->pos.pos_y)
#define e_wnd_row(pWnd) (((PXWND)pWnd)->pos.pos_y+((PXWND)pWnd)->cy-1)

#define s_wnd_col(pWnd) (((PXWND)pWnd)->pos.pos_x)
#define e_wnd_col(pWnd) (((PXWND)pWnd)->pos.pos_x+((PXWND)pWnd)->cx-1)

#define init_invalid_region(pRegion) do { \
	((PREGION)pRegion)->sRow = ((PREGION)pRegion)->eRow; \
	((PREGION)pRegion)->sCol = ((PREGION)pRegion)->eCol; \
	((PREGION)pRegion)->sRow++; \
	((PREGION)pRegion)->sCol++; \
} while(0)

#define area_to_region(pArea,  pRegion) do { \
	((PREGION)pRegion)->sRow = ((PAREA)pArea)->pos.pos_y; \
	((PREGION)pRegion)->sCol = ((PAREA)pArea)->pos.pos_x; \
	((PREGION)pRegion)->eRow = ((PAREA)pArea)->pos.pos_y+((PAREA)pArea)->cy-1; \
	((PREGION)pRegion)->eCol = ((PAREA)pArea)->pos.pos_x+((PAREA)pArea)->cx-1; \
} while(0)

#define getWndRegion(pWnd, pRegion) do { \
	((PREGION)pRegion)->sRow = 0; \
	((PREGION)pRegion)->sCol = 0; \
	((PREGION)pRegion)->eRow = ((PXWND)pWnd)->cy-1; \
	((PREGION)pRegion)->eCol = ((PXWND)pWnd)->cx-1; \
} while(0)

#define getDisplayRegion(pWnd, pRegion) do { \
	((PREGION)pRegion)->sRow = ((PXWND)pWnd)->pos.pos_y; \
	((PREGION)pRegion)->sCol = ((PXWND)pWnd)->pos.pos_x; \
	((PREGION)pRegion)->eRow = ((PXWND)pWnd)->pos.pos_y + ((PXWND)pWnd)->cy-1; \
	((PREGION)pRegion)->eCol = ((PXWND)pWnd)->pos.pos_x + ((PXWND)pWnd)->cx-1; \
} while(0)

#define wndRegion_to_displayRegion(pWnd, pRegX, pRegY) do { \
	((PREGION)pRegY)->sRow = ((PREGION)pRegX)->sRow + ((PXWND)pWnd)->pos.pos_y; \
	((PREGION)pRegY)->eRow = ((PREGION)pRegX)->eRow + ((PXWND)pWnd)->pos.pos_y; \
	((PREGION)pRegY)->sCol = ((PREGION)pRegX)->sCol + ((PXWND)pWnd)->pos.pos_x; \
	((PREGION)pRegY)->eCol = ((PREGION)pRegX)->eCol + ((PXWND)pWnd)->pos.pos_x; \
} while(0)

#define displayRegion_to_wndRegion(pWnd, pRegX, pRegY) do { \
	((PREGION)pRegY)->sRow = ((PREGION)pRegX)->sRow - ((PXWND)pWnd)->pos.pos_y; \
	((PREGION)pRegY)->eRow = ((PREGION)pRegX)->eRow - ((PXWND)pWnd)->pos.pos_y; \
	((PREGION)pRegY)->sCol = ((PREGION)pRegX)->sCol - ((PXWND)pWnd)->pos.pos_x; \
	((PREGION)pRegY)->eCol = ((PREGION)pRegX)->eCol - ((PXWND)pWnd)->pos.pos_x; \
} while(0)

#define f_inWndRegion(pWnd, pRegion) ( \
	((PREGION)pRegion)->sRow>=0 && ((PREGION)pRegion)->sCol>=0 && \
	((PREGION)pRegion)->eRow<((PXWND)pWnd)->cy && ((PREGION)pRegion)->eCol<((PXWND)pWnd)->cx)

#define f_onWndRegion(pWnd, pRegion) ( \
	((PREGION)pRegion)->sRow<((PXWND)pWnd)->cy && ((PREGION)pRegion)->eRow>=0 && \
	((PREGION)pRegion)->sCol<((PXWND)pWnd)->cx && ((PREGION)pRegion)->eCol>=0)

static inline bool isOverlapped(PREGION pRegion, PREGION pOverRegion)
{
	if((pOverRegion->eCol<pRegion->sCol || pOverRegion->sCol>pRegion->eCol) ||
		(pOverRegion->eRow<pRegion->sRow || pOverRegion->sRow>pRegion->eRow))
		return false;
	else
		return true;
}

static inline void getDataRealRegion(PWDAT pDat, PREGION pRegion)
{
	PXWND pWnd = (PXWND)pDat->hOwner;
	pRegion->sRow= pDat->region.sRow + pWnd->offset_pos.pos_y;
	pRegion->eRow = pDat->region.eRow + pWnd->offset_pos.pos_y;
	pRegion->sCol = pDat->region.sCol + pWnd->offset_pos.pos_x;
	pRegion->eCol = pDat->region.eCol + pWnd->offset_pos.pos_x;
}

static inline void getFocusRealRegion(PWFCS pFcs, PREGION pRegion)
{
	PXWND pWnd = (PXWND)pFcs->hOwner;
	pRegion->sRow= pWnd->offset_pos.pos_y + pFcs->area.pos.pos_y;
	pRegion->sCol = pWnd->offset_pos.pos_x + pFcs->area.pos.pos_x;
	pRegion->eRow = pWnd->offset_pos.pos_y + pFcs->area.pos.pos_y + pFcs->area.cy - 1;
	pRegion->eCol = pWnd->offset_pos.pos_x + pFcs->area.pos.pos_x + pFcs->area.cx - 1;
}

static inline void getOverlayRegion(PREGION pRegion, PREGION pOverRegion)
{
	int i,j,m,n;
	
	if(!pRegion || !pOverRegion) return;

	if((pOverRegion->eCol<pRegion->sCol || pOverRegion->sCol>pRegion->eCol) ||
		(pOverRegion->eRow<pRegion->sRow || pOverRegion->sRow>pRegion->eRow)) {
		init_invalid_region(pOverRegion);
	} 
	else {
		i = (pRegion->sCol>pOverRegion->sCol) ? pRegion->sCol : pOverRegion->sCol;//max
		j = (pRegion->eCol<pOverRegion->eCol) ? pRegion->eCol : pOverRegion->eCol;//min
		m = (pRegion->sRow>pOverRegion->sRow) ? pRegion->sRow : pOverRegion->sRow;//max
		n = (pRegion->eRow<pOverRegion->eRow) ? pRegion->eRow : pOverRegion->eRow;//min

		pOverRegion->sCol = i;
		pOverRegion->eCol = j;
		pOverRegion->sRow = m;
		pOverRegion->eRow = n;
	}
}

static inline void getWndOverlayRegion(PXWND pWnd, PXWND pOverWnd, PREGION pRegion)
{
	int i,j,m,n;
	
	if(!pWnd || !pOverWnd || !pRegion) return;

	init_invalid_region(pRegion);
	
	if((pOverWnd->pos.pos_x+pOverWnd->cx)<=pWnd->pos.pos_x ||
		pOverWnd->pos.pos_x>=(pWnd->pos.pos_x+pWnd->cx)) return;

	if((pOverWnd->pos.pos_y+pOverWnd->cy)<=pWnd->pos.pos_y ||
		pOverWnd->pos.pos_y>=(pWnd->pos.pos_y+pWnd->cy)) return;

	i = (pWnd->pos.pos_x > pOverWnd->pos.pos_x) ? pWnd->pos.pos_x : pOverWnd->pos.pos_x;
	j = ((pWnd->pos.pos_x+pWnd->cx) < (pOverWnd->pos.pos_x+pOverWnd->cx)) ? (pWnd->pos.pos_x+pWnd->cx) : (pOverWnd->pos.pos_x+pOverWnd->cx);
	j--;

	m = (pWnd->pos.pos_y > pOverWnd->pos.pos_y) ? pWnd->pos.pos_y : pOverWnd->pos.pos_y;
	n = ((pWnd->pos.pos_y+pWnd->cy) < (pOverWnd->pos.pos_y+pOverWnd->cy)) ? (pWnd->pos.pos_y+pWnd->cy) : (pOverWnd->pos.pos_y+pOverWnd->cy);	
	n--;

	pRegion->sRow = m - pOverWnd->pos.pos_y;
	pRegion->eRow = n - pOverWnd->pos.pos_y;
	pRegion->sCol = i - pOverWnd->pos.pos_x;
	pRegion->eCol = j - pOverWnd->pos.pos_x;

	return;
}
static inline UINT16* _GetWndRowBuffer(PXWND pWnd, int iRow, uint *pInfo)
//static inline uchar* _GetWndRowBuffer(PXWND pWnd, int iRow, uint *pInfo)
{
	int i,j,k;
	//uchar *pBuffer = NULL;
	UINT16 *pBuffer = NULL;
	if(pWnd && 
		iRow>=0 && iRow<pWnd->cy) {
		if(pWnd->uType==WND_Type_AllocBuffer) {
			pBuffer = &pWnd->pFrame[iRow*pWnd->cx];
			if(pInfo) *pInfo = pWnd->cx<<16;
		}
		else if(pWnd->f_visible) {
			if((s_wnd_row(pWnd)+iRow)>=0 && (s_wnd_row(pWnd)+iRow)<uDisplay_Resolution_y &&
				e_wnd_col(pWnd)>=0 && s_wnd_col(pWnd)<uDisplay_Resolution_x) {
				i = s_wnd_col(pWnd)>0 ? s_wnd_col(pWnd) : 0;
				j = e_wnd_col(pWnd)<(uDisplay_Resolution_x-1) ? e_wnd_col(pWnd) : (uDisplay_Resolution_x-1);
				k = s_wnd_col(pWnd)<0 ? s_wnd_col(pWnd) : 0;
				k = -k;
				pBuffer = GetDisplayBuffer() + 
					(s_wnd_row(pWnd)+iRow)*uDisplay_Resolution_x +
					i;
				if(pInfo) *pInfo = ((j-i+1)<<16)+k;
			}
		}
	}
	return pBuffer;
}

static inline void _WriteWndPixel(PXWND pWnd, int iRow, int iCol, UINT16 uColor)
//static inline void _WriteWndPixel(PXWND pWnd, int iRow, int iCol, uchar uColor)
{
	//uchar *pBuffer;
	UINT16 *pBuffer;
	if(pWnd &&
		iRow>=0 && iRow<pWnd->cy &&
		iCol>=0 && iCol<pWnd->cx) {
		if(pWnd->pReg) {
			if(iRow<pWnd->pReg->sRow || iRow>pWnd->pReg->eRow ||
				iCol<pWnd->pReg->sCol || iCol>pWnd->pReg->eCol) 
				return;
			if(pWnd->uType==WND_Type_AllocBuffer) {
				pWnd->pFrame[iRow*pWnd->cx+iCol] = _Tbl(uColor);
			}
			else if(pWnd->f_visible) {
				if((s_wnd_row(pWnd)+iRow)>=0 && (s_wnd_row(pWnd)+iRow)<uDisplay_Resolution_y &&
					(s_wnd_col(pWnd)+iCol)>=0 && (s_wnd_col(pWnd)+iCol)<uDisplay_Resolution_x) {
					pBuffer = GetDisplayBuffer() +
						(s_wnd_row(pWnd)+iRow)*uDisplay_Resolution_x +
						(s_wnd_col(pWnd)+iCol);
					*pBuffer = _Tbl(uColor);
				}
			}
		}
	}
}

//static inline void _WriteWndRowData(PXWND pWnd, int iRow, int sCol, int eCol, uchar *pData)
static inline void _WriteWndRowData(PXWND pWnd, int iRow, int sCol, int eCol, UINT16 *pData)
{
	//uchar *pBuffer;
	UINT16 *pBuffer;
	PREGION pRegion;
	int i,j,k,m,n,r,s,t;
	
	if(pWnd && pData &&
		iRow>=0 && iRow<pWnd->cy &&
		(eCol>=0 || sCol<pWnd->cx) &&
		sCol<=eCol) {
		k = 0;
		k -= sCol<0 ? sCol : 0;//min
		i = sCol>0 ? sCol : 0;  //max
		j = eCol<(pWnd->cx-1) ? eCol : (pWnd->cx-1);
		if(pRegion=pWnd->pReg) {
			if(iRow>=pRegion->sRow && iRow<=pRegion->eRow) {
				k += pRegion->sCol>i ? (pRegion->sCol-i) : 0;
				i = pRegion->sCol>i ? pRegion->sCol : i;
				j = pRegion->eCol<j ? pRegion->eCol : j;
				if(i<=j) {
					if(pWnd->uType==WND_Type_AllocBuffer) {
						mmcopy(&pWnd->pFrame[iRow*pWnd->cx+i],pData+k,j-i+1);
					}
					else if(pWnd->f_visible) {
						r = s_wnd_row(pWnd)+iRow;
						s = s_wnd_col(pWnd)+i;
						t = s_wnd_col(pWnd)+j;
						if(r>=0 && r<uDisplay_Resolution_y &&
							t>=0 && s<uDisplay_Resolution_x) {
							k -= s<0 ? s : 0;
							m = s>0 ? s : 0;
							n = t<(uDisplay_Resolution_x-1) ? t : (uDisplay_Resolution_x-1);
							if(m<=n) {
								pBuffer = GetDisplayBuffer() + 
									r*uDisplay_Resolution_x +
									m;
								mmcopy(pBuffer,pData+k,(n-m+1)*2);
							}
						}
					}
				}
			}
		}
	}
}

static inline void _ResetWndRegion(PXWND pWnd, PREGION pRegion)
{
	int i,j,m,n,r;
	REGION region;
	//uchar *pBuffer;
	UINT16 *pBuffer;
	if(pWnd && pRegion) {
		region = *pRegion;
		
		if(pWnd->pReg) {
			getOverlayRegion(pWnd->pReg, &region);
			i = region.sCol>0 ? region.sCol : 0;//max
			j = region.eCol<(pWnd->cx-1) ? region.eCol : (pWnd->cx-1);//min
			m = region.sRow>0 ? region.sRow : 0;
			n = region.eRow<(pWnd->cy-1) ? region.eRow : (pWnd->cy-1);

			if(i<=j && m<=n) {
				if(pWnd->uType==WND_Type_AllocBuffer) {
					for(r=m;r<=n;r++) {
						pBuffer = &pWnd->pFrame[r*pWnd->cx+i];
						//mmset(pBuffer,j-i+1,_Tbl(0x00));
						//mmset_16(pBuffer,(j-i+1),_Tbl(pWnd->uBackColor));
						mmcopy((PVOID)pBuffer,gImage_back+(r*pWnd->cx+i)*2,(j-i+1)*2);
					}
				}
				else if(pWnd->f_visible) {
					if((s_wnd_row(pWnd)+n)>=0 && (s_wnd_row(pWnd)+m)<uDisplay_Resolution_y &&
						(s_wnd_col(pWnd)+j)>=0 && (s_wnd_col(pWnd)+i)<uDisplay_Resolution_x) {
						i = (s_wnd_col(pWnd)+i)>0 ? (s_wnd_col(pWnd)+i) : 0;
						j = (s_wnd_col(pWnd)+j)<(uDisplay_Resolution_x-1) ? (s_wnd_col(pWnd)+j) : (uDisplay_Resolution_x-1);
						for(r=m;r<=n;r++) {
							if((s_wnd_row(pWnd)+r)>=0 && (s_wnd_row(pWnd)+r)<uDisplay_Resolution_y) {
								pBuffer = GetDisplayBuffer() +
									(s_wnd_row(pWnd)+r)*uDisplay_Resolution_x +	i;
								//mmset_16(pBuffer,(j-i+1),_Tbl(pWnd->uBackColor));//BackColor
								mmcopy((PVOID)pBuffer,gImage_back+((s_wnd_row(pWnd)+r)*uDisplay_Resolution_x +i)*2,(j-i+1)*2);
								//mmset(pBuffer,j-i+1,_Tbl(0x00));
							}
						}
					}
				}
			}
		}
	}
}

static inline void _ResetWnd(PXWND pWnd)
{
	REGION region;
	if(pWnd) {
		getWndRegion(pWnd,&region);
		_ResetWndRegion(pWnd,&region);
	}
}

static inline bool allocFrameBuffer(PXWND pWnd)
{
	if(pWnd) {
		if(pWnd->uType == WND_Type_AllocBuffer) {
			pWnd->pFrame = (UINT16*)alloc_mem(pWnd->cx*pWnd->cy,4);
			//pWnd->pFrame = (uchar*)alloc_mem(pWnd->cx*pWnd->cy,4);
			if(pWnd->pFrame != Mem_NULL) {
				mmset((PVOID)pWnd->pFrame,pWnd->cx*pWnd->cy*2,_Tbl(0x00));
				return true;
			}
		}
		else {
			pWnd->pFrame = NULL;
			return true;
		}
	}

	return false;
}

static inline void freeFrameBuffer(PXWND pWnd)
{
	if(pWnd && pWnd->pFrame)
		free_mem((PVOID)pWnd->pFrame,pWnd->cx*pWnd->cy);
}

static inline PREGION setWndFrameRegion(PXWND pWnd, PREGION pRegion)
{
	PREGION pReg = pWnd->pReg;

	if(!pWnd->pReg) pWnd->pReg = pRegion;
		
	return pReg;
}

static inline VOID resetWndFrameRegion(PXWND pWnd, PREGION pRegion)
{
	pWnd->pReg = pRegion;
}

static XWND theONE;

static PXWND pCurWnd = NULL;

static MSGQ msgq;
extern unsigned char *gImage_back;
int _BWndRoutine(uint, uint);
VOID _wndmgrTsk();
VOID _InitObjects();

void _defaultDataDisplay(uint);
void _defaultDataCreate(uint);
void _defaultDataDelete(uint);

void _defaultFocusPixel_img(uint,int,int,UINT16*);
void _defaultFocusPixel_inv(uint,int,int,UINT16*);
void _defaultFocusPixel_rsv(uint,int,int,UINT16*);
//void _defaultFocusPixel_img(uint,int,int,uchar*);
//void _defaultFocusPixel_inv(uint,int,int,uchar*);
//void _defaultFocusPixel_rsv(uint,int,int,uchar*);

#define VAL_OPENED 1
#define VAL_UNDERLYING_ERR -1
#define VAL_MEM_ERR -2

int InitWndMgr(/*int resX, int resY*/)
{
	if(g_nOpened > 0) return (VAL_OPENED);

	//if(!InitSysContext() || !InitDispDriver()) {
	if(!InitSysContext()) {
		return (VAL_UNDERLYING_ERR);
	}
	/*
	if(resX > 0) uDisplay_Resolution_x = resX;
	if(resY > 0) uDisplay_Resolution_y = resY;
	*/
	GetResolution(&uDisplay_Resolution_x,&uDisplay_Resolution_y);
	
	//theONE.pFrame = (uchar*)alloc_mem(uDisplay_Resolution_x*uDisplay_Resolution_y,4);
	theONE.pFrame = (UINT16*)alloc_mem(uDisplay_Resolution_x*uDisplay_Resolution_y*2,4);
	if(theONE.pFrame == Mem_NULL) {
		return (VAL_MEM_ERR);
	}
	//mmset_16((PVOID)theONE.pFrame,uDisplay_Resolution_x*uDisplay_Resolution_y,_Tbl(DEF_BWND_BACKCOLOR));//BackColor
	mmcopy((PVOID)theONE.pFrame,gImage_back,uDisplay_Resolution_x*uDisplay_Resolution_y*2);
 	//mmset((PVOID)theONE.pFrame,uDisplay_Resolution_x*uDisplay_Resolution_y,_Tbl(0x00));
	theONE.pos.pos_x = 0;
	theONE.pos.pos_y = 0;
	theONE.cx = uDisplay_Resolution_x;
	theONE.cy = uDisplay_Resolution_y;

	theONE.offset_pos.pos_x = 0;
	theONE.offset_pos.pos_y = 0;

	theONE.f_visible = 1;
	theONE.f_border = 0;

	theONE.uType = WND_Type_AllocBuffer;
	theONE.uColor = DEF_BWND_COLOR;

	theONE.font_type = DEF_FONT_TYPE;
	theONE.font_size = DEF_FONT_SIZE;

	theONE.pWndRoutine = _BWndRoutine;
	theONE.pFxn_showHk = NULL;
	theONE.pFxn_hideHk = NULL;
	theONE.uIdentity = 0;
	theONE.pDat = NULL;
	theONE.pFcs = NULL;
	theONE.timer = 0;

	theONE.pReg = NULL;
	
	_init_list_head(&theONE.node);

	_InitObjects();

	create_task(_wndmgrTsk,"WndMgrTsk",PRI_LOW,STK_HIGH,0);
	
	g_nOpened++;
	
	return 0;
}

HWND GetBottomWnd()
{
	HWND hWnd = NULL;

	if(g_nOpened) {
		hWnd = (HWND)&theONE;
	}
	return hWnd;
}

HWND GetTopWnd()
{

	HWND hWnd = NULL;

	if(g_nOpened) {
		sysCritON();
		hWnd = (HWND)list_entry(theONE.node.prev,XWND,node);
		sysCritOFF();
	}
	
	return hWnd;
}

static inline bool isValidWnd(PXWND pWnd)//Ƿ
{
	PNODE pNod;

	if(pWnd) {
		list_for_each(pNod,&theONE.node) 
//#define list_for_each(pos, head) \
//	for (pos = (head)->next; pos != (head); pos = pos->next)			
		{
			if(pWnd == list_entry(pNod,XWND,node)) return true;
			//#define list_entry(ptr, type, member) \
			//((type *)((char *)(ptr)-(unsigned long)(&((type *)0)->member)))
		}
	}
	
	return false;
}


static inline bool isValidWndData(PXWND pWnd, PWDAT pDat)
{
	PWDAT pDatX;

	if(pWnd) {
		if(pDatX=pWnd->pDat) {
			for(;pDatX && pDatX != pDat; 
				pDatX = pDatX->pNext);
			if(pDatX) return true;
		}
	}
	
	return false;
}

static inline bool isValidWndFocus(PXWND pWnd, PWFCS pFcs)
{
	PWFCS pFcsX;

	if(pWnd) {
		if(pFcsX=pWnd->pFcs) {
			do
			{
				if(pFcsX==pFcs) return true;
				pFcsX = list_entry(pFcsX->node.next,WFCS,node);
			} while(pFcsX != pWnd->pFcs);
		}
	}
	
	return false;
}

#ifdef REFRESH_DIRECTLY
void IncRefreshDelcount() { iRefreshDelayCnt++; }
void DecRefreshDelcount() { iRefreshDelayCnt--; }
#endif

VOID updateRelevantDisplayRegion(PXWND pWnd, PREGION pRegion);
VOID redrawRelevantDisplayRegion(PXWND pWnd, PREGION pRegion);

VOID refreshRegion(PXWND pWnd, PREGION pRegion)
{
	PXWND pOverWnd = pWnd;
	REGION regionX;
	REGION regionY;

	if(iRefreshing>0) return;
	
	if(pWnd->f_visible) { 
		iRefreshing++; // Prevent reentrance

		getWndRegion(pWnd,&regionX);
		getOverlayRegion(pRegion,&regionX);
		updateRelevantDisplayRegion(pWnd,&regionX);
		
		wndRegion_to_displayRegion(pWnd,&regionX,&regionX);
		
		list_for_each_entry_continue(pOverWnd,&theONE.node,XWND,node) 
		{
			if(pOverWnd->f_visible) {
				getDisplayRegion(pOverWnd,&regionY);
				getOverlayRegion(&regionX,&regionY);
				displayRegion_to_wndRegion(pOverWnd,&regionY,&regionY);
				redrawRelevantDisplayRegion(pOverWnd,&regionY);
			}
		}
	
		iRefreshing--;
		
#ifdef REFRESH_DIRECTLY
		if(iRefreshDelayCnt==0) RefreshDisplayRegion(&regionX);
#endif
	} 
}

VOID refreshX(PXWND pWnd, bool bQuietly)
{
	PXWND pOverWnd = pWnd;
	REGION region;

	if(iRefreshing>0) return;
	
	iRefreshing++; // Prevent reentrance
	
	if(!pWnd) {
		getWndRegion(&theONE,&region);
		redrawRelevantDisplayRegion(&theONE,&region);
		list_for_each_entry(pOverWnd,&theONE.node,XWND,node) 
		{
			if(pOverWnd->f_visible) {
				getWndRegion(pOverWnd,&region);
				redrawRelevantDisplayRegion(pOverWnd,&region);
			}
		}
	} 
	else {
		if(pWnd->f_visible) { 
			// show XWND
			if(bQuietly) {
				getWndRegion(pWnd,&region);
				redrawRelevantDisplayRegion(pWnd,&region);
				list_for_each_entry_continue(pOverWnd,&theONE.node,XWND,node) 
				{
					if(pOverWnd->f_visible) {
						getWndOverlayRegion(pWnd,pOverWnd,&region);
						redrawRelevantDisplayRegion(pOverWnd,&region);
					}
				}
			} 
			else {
				list_move_tail(&pWnd->node,&theONE.node);
				getWndRegion(pWnd,&region);
				redrawRelevantDisplayRegion(pWnd,&region);
			}

		} 
		else { 
			// hide XWND
			if(!bQuietly) list_move(&pWnd->node,&theONE.node);

			getWndOverlayRegion(pWnd,&theONE,&region);
			redrawRelevantDisplayRegion(&theONE,&region);
			list_for_each_entry(pOverWnd,&theONE.node,XWND,node)
			{
				if(pOverWnd->f_visible) {
					getWndOverlayRegion(pWnd,pOverWnd,&region);
					redrawRelevantDisplayRegion(pOverWnd,&region);
				}
			}
		}
	}
	
	iRefreshing--;
	
#ifdef REFRESH_DIRECTLY
	if(iRefreshDelayCnt==0) RefreshDisplayOne();
#endif
}

VOID redrawAnyWndData(PWDAT pDat)
{
	REGION region,*pReg;
	PWDAT pDatX;

	if(pDat) {
		if(isValidWndData((PXWND)pDat->hOwner,pDat)) {
			iRefreshing++;
			getDataRealRegion(pDat,&region);
			pReg = setWndFrameRegion((PXWND)pDat->hOwner,&region);
			(*(pDat->pFxnDisplay))((uint)pDat);
			for(pDatX=pDat->pNext;pDatX;pDatX=pDatX->pNext) {
				if(isOverlapped(&pDat->region,&pDatX->region)) {
					(*(pDatX->pFxnDisplay))((uint)pDatX);
				}
			}
			resetWndFrameRegion((PXWND)pDat->hOwner,pReg);
			iRefreshing--;
		}
	}
}

VOID redrawAllWndData(PXWND pWnd)
{
	REGION region,*pReg;
	PWDAT pDatX;

	if(pWnd) {

		if(pDatX = pWnd->pDat) {
			iRefreshing++; // Disable refreshing operation
			getWndRegion(pWnd,&region);
			pReg = setWndFrameRegion(pWnd, &region);
			while(pDatX) {
				if(pDatX->pFxnDisplay) (*(pDatX->pFxnDisplay))((uint)pDatX);
				pDatX = pDatX->pNext;
			}
			resetWndFrameRegion(pWnd, pReg);
			iRefreshing--; // Enable refreshing operation
		}
	}
}

VOID redrawWndRegionData(PXWND pWnd, PREGION pRegion)
{
	REGION region,*pReg;
	PWDAT pDatX;
	if(pWnd && pRegion) {
		iRefreshing++;
		pReg = setWndFrameRegion(pWnd,pRegion);
		for(pDatX=pWnd->pDat;pDatX;pDatX=pDatX->pNext) {
			getDataRealRegion(pDatX,&region);
			if(isOverlapped(pRegion,&region)) {
				(*(pDatX->pFxnDisplay))((uint)pDatX);
				//-----------------------------------
				if(pWnd->f_databorder)
					{
						keep_relevant_databorder(pWnd,&region,6,0);	
					}
				//-----------------------------------
			}
		}
		resetWndFrameRegion(pWnd,pReg);
		iRefreshing--;
	}
}

VOID redrawWndRegion(PXWND pWnd, PREGION pRegion)
{
	PREGION pReg;
	
	if(pWnd && pRegion) {
		pReg = setWndFrameRegion(pWnd, pRegion);
		_ResetWndRegion(pWnd,pRegion);
		resetWndFrameRegion(pWnd, pReg);
		
		redrawWndRegionData(pWnd, pRegion);
	}
}

VOID redrawWnd(PXWND pWnd)
{
	REGION region,*pReg;
	
	if(pWnd) {
		getWndRegion(pWnd, &region);
		pReg = setWndFrameRegion(pWnd, &region);
		_ResetWnd(pWnd);
		resetWndFrameRegion(pWnd, pReg);
		
		redrawAllWndData(pWnd);
	}
}

static inline VOID flushWndRegion(PXWND pWnd, PREGION pRegion)
{
	int i;
	UINT16 *pBuffer = NULL;
	//uchar *pBuffer = NULL;
	for(i=pRegion->sRow;i<=pRegion->eRow;i++) {
		if(pBuffer=_GetWndRowBuffer(pWnd,i,0)) {
			WriteRowData(
				s_wnd_row(pWnd)+i,
				s_wnd_col(pWnd)+pRegion->sCol,
				s_wnd_col(pWnd)+pRegion->eCol,
				pBuffer+pRegion->sCol);
		}
	}
}

static inline VOID keep_relevant_border(PXWND pWnd, PREGION pRegion)
{
	int i;

	if(pWnd->f_border) {
		if(pRegion->sRow==0) {
			for(i=pRegion->sCol;i<=pRegion->eCol;i++) 
				WritePixelData(
					s_wnd_row(pWnd),
					s_wnd_col(pWnd)+i,
					_Tbl(pWnd->uColor));
		}
		if(pRegion->eRow==(pWnd->cy-1)) {
			for(i=pRegion->sCol;i<=pRegion->eCol;i++) 
				WritePixelData(
					e_wnd_row(pWnd),
					s_wnd_col(pWnd)+i,
					_Tbl(pWnd->uColor));
		}
		if(pRegion->sCol==0) {
			for(i=pRegion->sRow;i<=pRegion->eRow;i++)
				WritePixelData(
					s_wnd_row(pWnd)+i,
					s_wnd_col(pWnd),
					_Tbl(pWnd->uColor));
		}
		if(pRegion->eCol==(pWnd->cx-1)) {
			for(i=pRegion->sRow;i<=pRegion->eRow;i++)
				WritePixelData(
					s_wnd_row(pWnd)+i,
					e_wnd_col(pWnd),
					_Tbl(pWnd->uColor));
		}
	}
}

static inline VOID keep_relevant_focus(PXWND pWnd, PREGION pRegion)
{
	int i,j;
	UINT16 uColor,*pBuffer;
	//uchar uColor,*pBuffer;
	REGION region;
	PWFCS pFcs;
	if(pFcs=pWnd->pFcs) {
		getFocusRealRegion(pFcs, &region);
		getOverlayRegion(pRegion, &region);
		if((s_wnd_row(pWnd)+region.eRow)>=0 && (s_wnd_row(pWnd)+region.sRow)<uDisplay_Resolution_y &&
			(s_wnd_col(pWnd)+region.eCol)>=0 && (s_wnd_col(pWnd)+region.sCol)<uDisplay_Resolution_x) {
			for(i=region.sRow;i<=region.eRow;i++) {
				if((s_wnd_row(pWnd)+i)>=0 && (s_wnd_row(pWnd)+i)<uDisplay_Resolution_y) {
					pBuffer = GetDisplayRowBuffer(s_wnd_row(pWnd)+i);
					for(j=region.sCol;j<=region.eCol;j++) {
						if((s_wnd_col(pWnd)+j)>=0 && (s_wnd_col(pWnd)+j)<uDisplay_Resolution_x) {
							uColor = *(pBuffer+s_wnd_col(pWnd)+j);
							(*(pFcs->pFxnPixel))(
								(uint)pFcs,
								j-(((PXWND)pFcs->hOwner)->offset_pos.pos_x+pFcs->area.pos.pos_x),
								i-(((PXWND)pFcs->hOwner)->offset_pos.pos_y+pFcs->area.pos.pos_y),
								&uColor);
							WritePixelData(
								s_wnd_row(pWnd)+i,
								s_wnd_col(pWnd)+j,
								uColor);
						}
					}
				}
			}
		}
	}

}

//-------------------------------------------------------------------------
//ڻWNDݵı߿
//:pWndǰ
//				pregion Ҫݵregionָ
//    			rowOff Ʊ߿ʱƫ(൱ݵλϱƶrowOffУϱƶrowOff)
//				colOff  Ʊ߿ʱƫ(൱ݵλƶcolOffУұƶcolOff)
//:
//޸ļ¼:
//------------------------------------------------------------------------------
static inline VOID keep_relevant_databorder(PXWND pWnd, PREGION pRegion,uchar rowOff,uchar colOff)
{
	int i;

	if(pWnd->f_databorder) {
		if((s_wnd_row(pWnd)+pRegion->sRow-rowOff)>=0 && (s_wnd_row(pWnd)+pRegion->eRow+rowOff)<uDisplay_Resolution_y &&
			(s_wnd_col(pWnd)+pRegion->sCol-colOff)>=0 && (s_wnd_col(pWnd)+pRegion->eCol+colOff)<uDisplay_Resolution_x)
			{
			for(i=pRegion->sCol-colOff;i<=pRegion->eCol+colOff;i++) 
				WritePixelData(
					s_wnd_row(pWnd)+pRegion->sRow-rowOff,
					s_wnd_col(pWnd)+i,
					_Tbl(pWnd->uColor));

			for(i=pRegion->sCol-colOff;i<=pRegion->eCol-colOff;i++) 
				WritePixelData(
					s_wnd_row(pWnd)+pRegion->eRow+rowOff,
					s_wnd_col(pWnd)+i,
					_Tbl(pWnd->uColor));

			for(i=pRegion->sRow-rowOff;i<=pRegion->eRow+rowOff;i++)
				WritePixelData(
					s_wnd_row(pWnd)+i,
					s_wnd_col(pWnd)+pRegion->sCol-colOff,
					_Tbl(pWnd->uColor));
			
			for(i=pRegion->sRow-rowOff;i<=pRegion->eRow+rowOff;i++)
				WritePixelData(
					s_wnd_row(pWnd)+i,
					s_wnd_col(pWnd)+pRegion->eCol+colOff,
					_Tbl(pWnd->uColor));
			}
	}
}
//--------------------------------------------------------------------------------
VOID eraseWndRegionFocus(PXWND pWnd, PREGION pRegion)
{
	PXWND pOverWnd = pWnd;
	REGION regionX;
	REGION regionY;

	// The easy way is to redraw the region, because we dont 
	// know whether some focus BEEN in this region
	if(iRefreshing>0) 
		return;
	
	if(pWnd->f_visible) { 
		iRefreshing++;
		
		getWndRegion(pWnd,&regionX);
		getOverlayRegion(pRegion,&regionX);
		redrawRelevantDisplayRegion(pWnd,&regionX);
		
		wndRegion_to_displayRegion(pWnd,&regionX,&regionX);

		list_for_each_entry_continue(pOverWnd,&theONE.node,XWND,node) 
		{
			if(pOverWnd->f_visible) {
				getDisplayRegion(pOverWnd,&regionY);
				getOverlayRegion(&regionX,&regionY);
				displayRegion_to_wndRegion(pOverWnd,&regionY,&regionY);
				redrawRelevantDisplayRegion(pOverWnd,&regionY);
			}
		}
	
		iRefreshing--;
		
#ifdef REFRESH_DIRECTLY
		if(iRefreshDelayCnt==0) RefreshDisplayRegion(&regionX);
#endif
	} 
}

VOID drawWndRegionFocus(PXWND pWnd, PREGION pRegion)
{
	PXWND pOverWnd = pWnd;
	REGION regionX;
	REGION regionY;

	if(iRefreshing>0) 
		return;
	
	if(pWnd->f_visible) { 
		iRefreshing++;

		getWndRegion(pWnd,&regionX);
		getOverlayRegion(pRegion,&regionX);
		keep_relevant_focus(pWnd,&regionX);
		
		wndRegion_to_displayRegion(pWnd,&regionX,&regionX);

		list_for_each_entry_continue(pOverWnd,&theONE.node,XWND,node) 
		{
			if(pOverWnd->f_visible) {
				getDisplayRegion(pOverWnd,&regionY);
				getOverlayRegion(&regionX,&regionY);
				displayRegion_to_wndRegion(pOverWnd,&regionY,&regionY);
				redrawRelevantDisplayRegion(pOverWnd,&regionY);
			}
		}
	
		iRefreshing--;
		
#ifdef REFRESH_DIRECTLY
		if(iRefreshDelayCnt==0) RefreshDisplayRegion(&regionX);
#endif
	} 	
}

VOID updateRelevantDisplayRegion(PXWND pWnd, PREGION pRegion)
{
	
	if(!pWnd || !pRegion) return;

	if(pRegion->sRow>pRegion->eRow || pRegion->sCol>pRegion->eCol || 
		pRegion->sRow<0 || pRegion->eRow>=pWnd->cy ||
		pRegion->sCol<0 || pRegion->eCol>=pWnd->cx) 
		return;
	
	if(pWnd->uType == WND_Type_AllocBuffer) 
		flushWndRegion(pWnd, pRegion);

	// Focus override any Data in the XWND
	keep_relevant_focus(pWnd, pRegion);
	// Border override any Focus or Data in the XWND
	keep_relevant_border(pWnd, pRegion);
	
}


VOID redrawRelevantDisplayRegion(PXWND pWnd, PREGION pRegion)
{

	if(!pWnd || !pRegion) return;

	if(pRegion->sRow>pRegion->eRow || pRegion->sCol>pRegion->eCol || 
		pRegion->sRow<0 || pRegion->eRow>=pWnd->cy ||
		pRegion->sCol<0 || pRegion->eCol>=pWnd->cx) 
		return;
	
	if(pWnd->uType == WND_Type_AllocBuffer) {
		flushWndRegion(pWnd, pRegion);
	}
	else {
		redrawWndRegion(pWnd, pRegion);
	}

	// Focus override any Data in the XWND
	if(pCurWnd == pWnd)
	{
		keep_relevant_focus(pWnd, pRegion);
	}
	// Border override any Focus or Data in the XWND
	keep_relevant_border(pWnd, pRegion);
	
}

bool IsVisible(HWND hWnd)
{
	bool f_visible = false;
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			if(pWnd->f_visible) f_visible = true;
		}
		sysCritOFF();
	}

	return f_visible;
}

VOID SetWndBorder(HWND hWnd, bool f_border)
{
	PXWND pWnd = (PXWND)hWnd;
	
	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			pWnd->f_border = (f_border ? 1 : 0);
		//	refreshX(pWnd, true);
		}
		sysCritOFF();
	}
}

VOID SetWndDataBorder(HWND hWnd, bool f_databorder)
//VOID SetWndColor(HWND hWnd, uchar uColor)
{
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			pWnd->f_databorder= (f_databorder?1:0);
		}
		sysCritOFF();
	}
}
//----------------------------------------------------------

VOID ShowWnd(HWND hWnd)
{
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened) {
		sysCritON();
		if((pWnd != &theONE) && isValidWnd(pWnd)) {
			
			if(pCurWnd != pWnd) pCurWnd = pWnd;
			pWnd->f_visible = true;
			refreshX(pWnd, false);
			
			if(pWnd->pFxn_showHk) 
				(*(pWnd->pFxn_showHk))((uint)pWnd);
			
		}
		sysCritOFF();
	}
}

VOID HideWnd(HWND hWnd)
{
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened) {
		sysCritON();
		if((pWnd != &theONE) && isValidWnd(pWnd)) {
			pWnd->f_visible = false; 
			refreshX(pWnd, false);
			
			if(pWnd->pFxn_hideHk)
				(*(pWnd->pFxn_hideHk))((uint)pWnd);
			if(pCurWnd == pWnd) {
				pCurWnd = NULL;
				list_for_each_entry_continue_prev(pWnd,&theONE.node,XWND,node)
				{
					if(pWnd->f_visible) {
						pCurWnd = pWnd;
						break;
					}
				}
			}
			
		}
		sysCritOFF();
	}
}

VOID MoveWnd(HWND hWnd, int deltX, int deltY)
{
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened && (deltX |deltY)) {
		sysCritON();
		if((pWnd != &theONE) && isValidWnd(pWnd)) {
			if(pWnd->f_visible) {
				pWnd->f_visible = false; 
				#ifdef REFRESH_DIRECTLY
				iRefreshDelayCnt++;
				#endif
				refreshX(pWnd, true);
				#ifdef REFRESH_DIRECTLY
				iRefreshDelayCnt--;
				#endif
				
				pWnd->pos.pos_x += deltX;
				pWnd->pos.pos_y += deltY;

				pWnd->f_visible = true; 
				refreshX(pWnd, true);
			} else {
				pWnd->pos.pos_x += deltX;
				pWnd->pos.pos_y += deltY;
			}
		}
		sysCritOFF();
	}
}

VOID RefreshWnd(HWND hWnd, bool f_show)
{
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened) {
		sysCritON();
		if(!pWnd || (pWnd==&theONE)) {
			refreshX(NULL, true);
		}
		else if(isValidWnd(pWnd)) {
			refreshX(pWnd, true);
			if(pWnd->f_visible=(f_show ? 1 : 0)) {
				if(pCurWnd != pWnd) {
					pCurWnd = pWnd;
					list_for_each_entry_continue(pWnd,&theONE.node,XWND,node)
					{
						if(pWnd->f_visible) pCurWnd = pWnd;
					}
				}
			}
			else {
				if(pCurWnd == pWnd) {
					pCurWnd = NULL;
					list_for_each_entry_continue_prev(pWnd,&theONE.node,XWND,node)
					{
						if(pWnd->f_visible) {
							pCurWnd = pWnd;
							break;
						}
					}
				}
			}
		}
		sysCritOFF();
	}
}

VOID ScrollWnd(HWND hWnd, int deltX, int deltY)
{
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened && (deltX |deltY)) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			pWnd->offset_pos.pos_x += deltX;
			pWnd->offset_pos.pos_y += deltY;
			
			redrawWnd(pWnd);
			refreshX(pWnd, true);
			
		}
		sysCritOFF();
	}
}

HWND GetCurrentWnd()
{
	HWND hWnd = NULL;

	if(g_nOpened) {
		hWnd = (HWND)((pCurWnd) ? pCurWnd : &theONE);
	}

	return hWnd;
}


VOID SetWndText(HWND hWnd, tchar *pText, POSITION iPos)
{
	int x,y,i,j,k,l,m,n,w;
	tchar pixel,*pData,*pTxt = pText;
	PXWND pWnd = (PXWND)hWnd;
	REGION region,*pReg;
	UINT16 tempdata;
	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd) && pTxt) {
			getWndRegion(pWnd,&region);
			pReg = setWndFrameRegion(pWnd, &region);
			
			x = (iPos.pos_x > 0) ? iPos.pos_x : 0;
			y = (iPos.pos_y > 0) ? iPos.pos_y : 0;
			n = 0;
			while(*pTxt != '\0') {
				k = l = w = 0;
				if(GetPixels_ENG24(pTxt,pWnd->font_size,&pData,&n) > 0) 
					w = 1;
				else if(GetPixels_CHN24(pTxt,pWnd->font_size,&pData,&n) > 0)
					w = 2;
				
				if(w > 0) {
					if((x+n)>pWnd->cx) {
						x = 0;
						y += pWnd->font_size;
						if(y>=pWnd->cy) break;
					}
					m = n*(pWnd->font_size)/8;
					for(i=0;i<m;i++) {
						pixel = *pData;
						for(j=0;j<8;j++) {
							if(0x80 & pixel) {
								_WriteWndPixel(pWnd, y+l, x+k, pWnd->uColor);
							}
							else {
								tempdata = *(gImage_back+((s_wnd_row(pWnd)+y+l)*uDisplay_Resolution_x +(s_wnd_col(pWnd)+x+k))*2+1);
								tempdata = tempdata<<8| *(gImage_back+((s_wnd_row(pWnd)+y+l)*uDisplay_Resolution_x +(s_wnd_col(pWnd)+x+k))*2);
								_WriteWndPixel(pWnd, y+l, x+k, tempdata/*pWnd->uBackColor*/);
							}
							k++;
							if(k==n) {
								k = 0;
								l++;
								if(l==(pWnd->font_size)) l = 0;
							}
							pixel = pixel << 1;
						}
						pData++;
					}
					x += n;
				}

				pTxt = pTxt + ((w>1) ? w : 1);
				
			}
			
			resetWndFrameRegion(pWnd, pReg);
			
			region.sRow = (iPos.pos_y > 0) ? iPos.pos_y : 0;
			region.eRow = ((y+pWnd->font_size)>=pWnd->cy) ? (pWnd->cy-1) : (y+pWnd->font_size-1);
			region.sCol = (y>iPos.pos_y) ? 0 : ((iPos.pos_x > 0) ? iPos.pos_x : 0);
			region.eCol = (y>iPos.pos_y) ? (pWnd->cx-1) : (x-1);
			refreshRegion(pWnd,&region);
		}
		sysCritOFF();
	}
	
}

VOID SetWndRegionText(HWND hWnd, REGION region, tchar *pText)
{
	int x,y,i,j,k,l,m,n,w;
	tchar pixel,*pData,*pTxt = pText;
	PXWND pWnd = (PXWND)hWnd;
	PREGION pReg;
	UINT16 tempdata;
	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd) && pTxt) {
			if(region.sCol<=region.eCol && region.sRow<=region.eRow) 
			{
				pReg = setWndFrameRegion(pWnd,&region);
				
				x = region.sCol;
				y = region.sRow;
				n = 0;
				while(*pTxt != '\0') {
					k = l = w = 0;
					if(pWnd->font_size == DEF_FONT_SIZE){
						if(GetPixels_ENG24(pTxt,pWnd->font_size,&pData,&n) > 0)
							w = 1;
						else if(GetPixels_CHN24(pTxt,pWnd->font_size,&pData,&n) > 0)
							w = 2;
						}
					else{
						if(GetPixels_ENG32(pTxt,pWnd->font_size,&pData,&n) > 0)
							w = 1;
						else if(GetPixels_CHN32(pTxt,pWnd->font_size,&pData,&n) > 0)
							w = 2;
						}
					if(w > 0) {
						if((x+n)>(region.eCol+1)) {
							x = region.sCol;
							y += pWnd->font_size;
							if(y>region.eRow) break;
						}
						m = n*(pWnd->font_size)/8;
						for(i=0;i<m;i++) {
							pixel = *pData;
							for(j=0;j<8;j++) {
								if(0x80 & pixel) {
									if((y+l)<=region.eRow && (x+k)<=region.eCol) _WriteWndPixel(pWnd, y+l, x+k, pWnd->uColor);
								}
								else {
									if((y+l)<=region.eRow && (x+k)<=region.eCol) 
									{
										tempdata = *(gImage_back+((s_wnd_row(pWnd)+y+l)*uDisplay_Resolution_x +(s_wnd_col(pWnd)+x+k))*2+1);
										tempdata = tempdata <<8 | *(gImage_back+((s_wnd_row(pWnd)+y+l)*uDisplay_Resolution_x +(s_wnd_col(pWnd)+x+k))*2);
										_WriteWndPixel(pWnd, y+l, x+k,  tempdata/*pWnd->uBackColor*/);
									}
								}
								k++;
								if(k==n) {
									k = 0;
									l++;
									if(l==(pWnd->font_size)) l = 0;
								}
								pixel = pixel << 1;
							}
							pData++;
						}
						x += n;
					}

					pTxt = pTxt + ((w>1) ? w : 1);
					
				}
				resetWndFrameRegion(pWnd,pReg);
				
				refreshRegion(pWnd,&region);
			}
		}
		sysCritOFF();
	}
}

VOID DrawPoint(HWND hWnd, int px, int py)
{
	PXWND pWnd = (PXWND)hWnd;
	REGION region,*pReg;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd) &&
			(px>=0 && px<(pWnd->cx)) && 
			(py>=0 && py<(pWnd->cy))) {
			getWndRegion(pWnd,&region);
			pReg = setWndFrameRegion(pWnd,&region);
			_WriteWndPixel(pWnd, py, px, pWnd->uColor);
			resetWndFrameRegion(pWnd,pReg);
			
			region.sRow = region.eRow = py;
			region.sCol = region.eCol = px;
			refreshRegion(pWnd,&region);
		}
		sysCritOFF();
	}
}

VOID DrawLine(HWND hWnd, POSITION posLeft, POSITION posRight)
{
	int i,j,k,m,n;
	PXWND pWnd = (PXWND)hWnd;
	REGION region,*pReg;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {

			getWndRegion(pWnd,&region);
			pReg = setWndFrameRegion(pWnd,&region);
			
		 	if(posLeft.pos_x == posRight.pos_x && posLeft.pos_y == posRight.pos_y) {
				_WriteWndPixel(pWnd, posLeft.pos_y, posLeft.pos_x, pWnd->uColor);
			} 
			else if(posLeft.pos_x == posRight.pos_x) {
				i = (posLeft.pos_y>posRight.pos_y) ? posRight.pos_y : posLeft.pos_y;
				j = (posLeft.pos_y<posRight.pos_y) ? posRight.pos_y : posLeft.pos_y;
				for(;i<=j;i++) {
					_WriteWndPixel(pWnd, i, posLeft.pos_x, pWnd->uColor);
				}
			} 
			else if(posLeft.pos_y == posRight.pos_y) {
				i = (posLeft.pos_x>posRight.pos_x) ? posRight.pos_x : posLeft.pos_x;
				j = (posLeft.pos_x<posRight.pos_x) ? posRight.pos_x : posLeft.pos_x;
				for(;i<=j;i++) {
					_WriteWndPixel(pWnd, posLeft.pos_y, i, pWnd->uColor);
				}
			} 
			else {
				i = (posLeft.pos_x>posRight.pos_x) ? (posLeft.pos_x-posRight.pos_x) : (posRight.pos_x-posLeft.pos_x);
				j = (posLeft.pos_y>posRight.pos_y) ? (posLeft.pos_y-posRight.pos_y) : (posRight.pos_y-posLeft.pos_y);
				if(i>=j) {
					m = i;
					if(posLeft.pos_x<posRight.pos_x) {
						i = posLeft.pos_x;
						k = posLeft.pos_y;
						n = posRight.pos_y-posLeft.pos_y;
					} 
					else {
						i = posRight.pos_x;
						k = posRight.pos_y;
						n = posLeft.pos_y-posRight.pos_y;
					}
					for(j=0;j<=m;j++) {
						_WriteWndPixel(pWnd, k+(j*n/m), i+j, pWnd->uColor);
					}
				} 
				else {
					m = j;
					if(posLeft.pos_y<posRight.pos_y) {
						i = posLeft.pos_y;
						k = posLeft.pos_x;
						n = posRight.pos_x-posLeft.pos_x;
					} 
					else {
						i = posRight.pos_y;
						k = posRight.pos_x;
						n = posLeft.pos_x-posRight.pos_x;
					}
					for(j=0;j<=m;j++) {
						_WriteWndPixel(pWnd, i+j, k+(j*n/m), pWnd->uColor);
					}
				}
			}
			resetWndFrameRegion(pWnd,pReg);
			
			region.sRow = (posLeft.pos_y<posRight.pos_y) ? posLeft.pos_y : posRight.pos_y;
			region.eRow = (posLeft.pos_y>posRight.pos_y) ? posLeft.pos_y : posRight.pos_y;
			region.sCol = (posLeft.pos_x<posRight.pos_x) ? posLeft.pos_x : posRight.pos_x;
			region.eCol = (posLeft.pos_x>posRight.pos_x) ? posLeft.pos_x : posRight.pos_x;
			refreshRegion(pWnd,&region);
		}
		sysCritOFF();
	}
}

VOID DrawWndRegion(HWND hWnd, REGION region, UINT16 *pBuffer, uint uType)
//VOID DrawWndRegion(HWND hWnd, REGION region, uchar *pBuffer, uint uType)
{
	PXWND pWnd = (PXWND)hWnd;
	UINT16 *pData = pBuffer;
	//uchar *pData = pBuffer;
	PREGION pReg;
	int i, j;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd) && (region.sCol<=region.eCol && region.sRow<=region.eRow)) 
		{
			pReg = setWndFrameRegion(pWnd, &region);
			if(uType == DRAW_Type_ROW) {
				for(i=region.sRow,j=region.eCol-region.sCol+1;i<=region.eRow;i++) {
					_WriteWndRowData(pWnd, i, region.sCol, region.eCol, pData);
					pData = pData + j;
				}
			}
			else if(uType == DRAW_Type_COL) {
				for(i=region.sCol;i<=region.eCol;i++) {
					for(j=region.sRow;j<=region.eRow;j++) {
						_WriteWndPixel(pWnd, j, i, pData[(i-region.sCol)*(region.eRow-region.sRow+1)+j-region.sRow]);
					}
				}
			}
			resetWndFrameRegion(pWnd, pReg);
			refreshRegion(pWnd, &region);
		}
		sysCritOFF();
	}
}

VOID ResetWndContent(HWND hWnd)
{
	PXWND pWnd = (PXWND)hWnd;
	REGION region,*pReg;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			getWndRegion(pWnd, &region);
			pReg = setWndFrameRegion(pWnd, &region);
			_ResetWnd(pWnd);
			resetWndFrameRegion(pWnd, pReg);
			refreshX(pWnd, true);
		}
		sysCritOFF();
	}
}

VOID ResetWndRegionContent(HWND hWnd, REGION region)
{
	PXWND pWnd = (PXWND)hWnd;
	PREGION pReg;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd) && (region.sCol<=region.eCol && region.sRow<=region.eRow)) 
		{
			pReg = setWndFrameRegion(pWnd, &region);
			_ResetWndRegion(pWnd, &region);
			resetWndFrameRegion(pWnd, pReg);
			refreshRegion(pWnd, &region);
		}
		sysCritOFF();
	}
}

VOID SetWndColor(HWND hWnd, UINT16 uColor)
//VOID SetWndColor(HWND hWnd, uchar uColor)
{
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			pWnd->uColor = uColor;
		}
		sysCritOFF();
	}
}

//--------------------------------------------------------
VOID SetWndFontSize(HWND hWnd, UINT16 size)
//VOID SetWndColor(HWND hWnd, uchar uColor)
{
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			pWnd->font_size = size;
		}
		sysCritOFF();
	}
}

VOID SetCurWnd(HWND hWnd)
{
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			pCurWnd = hWnd;
		}
		sysCritOFF();
	}
}
VOID SetupWndRoutine(HWND hWnd, PWNDRT pWndRt)
{
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened) {
		sysCritON();
		if((pWnd != &theONE) && isValidWnd(pWnd)) {
			pWnd->pWndRoutine = pWndRt;
		}
		sysCritOFF();
	}
}

VOID SetupWndHook(HWND hWnd, void (*pFxnHk)(uint), uint uType)
{
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened) {
		sysCritON();
		if((pWnd != &theONE) && isValidWnd(pWnd)) {
			switch(uType)
			{
			case WHK_Type_show:
				pWnd->pFxn_showHk = pFxnHk;
				break;
			case WHK_Type_hide:
				pWnd->pFxn_hideHk = pFxnHk;
				break;
			default:
				break;
			}
		}
		sysCritOFF();
	}
}

PWNDRT SetupHookRoutine(PWNDRT pWndHk)
{
	PWNDRT fpRoutine = NULL;
	
	if(g_nOpened) {
		sysCritON();
		fpRoutine = g_fpHook;
		g_fpHook = pWndHk;
		sysCritOFF();
	}

	return fpRoutine;
}

POSITION GetWndPosition(HWND hWnd)
{
	POSITION pos;
	PXWND pWnd = (PXWND)hWnd;

	pos.pos_x = uDisplay_Resolution_x;
	pos.pos_y = uDisplay_Resolution_y;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) pos = pWnd->pos;
		sysCritOFF();
	}
	return pos;
}

VOID GetDisplayResolution(int *pResX, int *pResY)
{
	if(!pResX || !pResY) return;
	
	if(g_nOpened) {
		*pResX = uDisplay_Resolution_x;
		*pResY = uDisplay_Resolution_y;
	}
}
//
//λãڴСߣҶȣbuffer
HWND CreateWnd(POSITION pos, int w, int h, UINT16 uColor,UINT16 uBackColor, uchar uType)
//HWND CreateWnd(POSITION pos, int w, int h, uchar uColor, uchar uType)
{
	PXWND pWnd = NULL;

	if(g_nOpened==0 ||
		/*
		(pos.pos_x<0 || pos.pos_x>=uDisplay_Resolution_x) ||
		(pos.pos_y<0 || pos.pos_y>=uDisplay_Resolution_y) ||
		*/
		(w>uDisplay_Resolution_x) ||
		(h>uDisplay_Resolution_y)) 
		return NULL;

	pWnd = (PXWND)alloc_mem(sizeof(XWND),4);
	if(pWnd == Mem_NULL) 
		return NULL;

	pWnd->pos = pos;
	pWnd->cx = w;
	pWnd->cy = h;
	pWnd->offset_pos.pos_x = 0;
	pWnd->offset_pos.pos_y = 0;
	pWnd->uColor = uColor;
	pWnd->uBackColor = uBackColor;
	pWnd->uType = uType;
	pWnd->f_border = 0;
	pWnd->f_visible = 0;
	pWnd->f_databorder = 0;
	pWnd->font_type = DEF_FONT_TYPE;//0
	pWnd->font_size = DEF_FONT_SIZE;//
	pWnd->pWndRoutine = NULL;
	pWnd->pFxn_showHk = NULL;
	pWnd->pFxn_hideHk = NULL;
	pWnd->uIdentity = 0;
	pWnd->pFcs = NULL;
	pWnd->pDat = NULL;
	pWnd->timer = 0;

	pWnd->pReg = NULL;

	if(!allocFrameBuffer(pWnd)) {
		free_mem((PVOID)pWnd,sizeof(XWND));
		return NULL;
	}
	
	sysCritON();
	list_add(&pWnd->node,&theONE.node);
	sysCritOFF();

	return (HWND)pWnd;
}

VOID DestroyWnd(HWND hWnd)
{
	PWFCS pFcsX;
	PWFCS pFcsY;
	PWDAT pDatX;
	PWDAT pDatY;
	PXWND pWnd = (PXWND)hWnd;
	PWTimer pTimer = timer;

	if(g_nOpened==0 || 
		!pWnd || pWnd==&theONE) return;

	sysCritON();

	// If it is the current XWND, then change it
	if(pWnd==pCurWnd) {
		pCurWnd = NULL;
		list_for_each_entry_continue_prev(pWnd,&theONE.node,XWND,node)
		{
			if(pWnd->f_visible) {
				pCurWnd = pWnd;
				break;
			}
		}
	}
	pWnd = (PXWND)hWnd;
	// Delete all timers of the XWND
	while(pWnd->timer) {
		if(pWnd->timer&1) {
			if(pTimer->state>0) 
				_TimerListRemove(pTimer);
			pTimer->used = 0;
		}
		pWnd->timer = pWnd->timer>>1;
		pTimer++;
	}
	// Free memory allocated for WDATs of the XWND
	if(pDatX = pWnd->pDat) {
		do {
			pDatY = pDatX;
			pDatX = pDatX->pNext;
			if(pDatY->pFxnDelete) (*(pDatY->pFxnDelete))((uint)pDatY);
			free_mem((PVOID)pDatY,sizeof(WDAT));
		} while(pDatX);
	}
	// Free memory allocated for WFCSs of the XWND
	if(pFcsX = pWnd->pFcs) {
		do{
			pFcsY = pFcsX;
			pFcsX = list_entry(pFcsX->node.next,WFCS,node);
			free_mem((PVOID)pFcsY,sizeof(WFCS));
		} while(pFcsX != pWnd->pFcs);
	}
	// Delete it from XWND link
	list_del(&pWnd->node);
	// Release Frame buffer and XWND
	freeFrameBuffer(pWnd);
	free_mem((PVOID)pWnd,sizeof(XWND));

	refreshX(NULL,true);
	sysCritOFF();
	
}


bool SetWndIdentity(HWND hWnd, uint uIdentity)
{
	bool bResult = false;
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			pWnd->uIdentity = uIdentity;
			bResult = true;
		}
		sysCritOFF();
	}

	return bResult;
}

bool GetWndIdentity(HWND hWnd, uint *pIdentity)
{
	bool bResult = false;
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd) && pIdentity) {
			*pIdentity = pWnd->uIdentity;
			bResult = true;
		}
		sysCritOFF();
	}

	return bResult;
}

HWND GetWndByIdentity(uint uIdentity)
{
	HWND hWnd = NULL;
	PXWND pWnd;

	if(g_nOpened) {
		sysCritON();
		list_for_each_entry(pWnd,&theONE.node,XWND,node)
		{
			if(uIdentity==pWnd->uIdentity) {
				hWnd = (HWND)pWnd;
				break;
			}
		}
		sysCritOFF();
	}

	return hWnd;
}

HDAT CreateWndData(HWND hWnd, REGION region, uint content, uint uType, uint uInfo, void (*pFxnDisplay)(uint), void (*pFxnCreate)(uint), void (*pFxnDelete)(uint))
{

	PWDAT pDatX = NULL;
	PWDAT pDatY = NULL;
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			if(region.sCol<=region.eCol && region.sRow<=region.eRow) {
				pDatX = (PWDAT)alloc_mem(sizeof(WDAT),4);
				if(pDatX != Mem_NULL) {
					pDatX->hOwner = (HWND)pWnd;
					pDatX->region = region;
					pDatX->content = content;
					pDatX->uType = uType;
					pDatX->uInfo = uInfo;
					pDatX->uXyz = 0;
					pDatX->pFxnDisplay = pFxnDisplay ? pFxnDisplay : _defaultDataDisplay;
					pDatX->pFxnCreate = pFxnCreate ? pFxnCreate : _defaultDataCreate;
					pDatX->pFxnDelete = pFxnDelete ? pFxnDelete : _defaultDataDelete;

					pDatX->pNext = NULL;

					(*(pDatX->pFxnCreate))((uint)pDatX);

					if(pDatY=pWnd->pDat) {
						for(; pDatY->pNext; pDatY=pDatY->pNext);
						pDatY->pNext = pDatX;
					} 
					else {
						pWnd->pDat = pDatX;
					}

					(*(pDatX->pFxnDisplay))((uint)pDatX);
				}
			}
		}
		sysCritOFF();
	}
	return ((HDAT)pDatX);
}

VOID DeleteWndData(HDAT hDat)
{
	PWDAT pDatX, pDatY, pDatZ = (PWDAT)hDat;
	PXWND pWnd = NULL;
	REGION region;

	if(pDatZ) pWnd = (PXWND)pDatZ->hOwner;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			if(pDatX=pWnd->pDat) {
				for(pDatY=pDatX; 
					pDatX && pDatX != pDatZ; 
					pDatY=pDatX,pDatX=pDatX->pNext);
				if(pDatX) {
					getDataRealRegion(pDatX,&region);

					if(pDatY==pDatX) {
						pWnd->pDat = pDatX->pNext;
					}
					else {
						pDatY->pNext = pDatX->pNext;
					}
					
					if(pDatX->pFxnDelete) (*(pDatX->pFxnDelete))((uint)pDatX);
					free_mem((PVOID)pDatX,sizeof(WDAT));

					redrawWndRegion(pWnd,&region);
					refreshRegion(pWnd,&region);
				}
			}
		}
		sysCritOFF();
	}
}

PVOID GetDataContent(HDAT hDat)
{
	PVOID pContent = NULL;

	PWDAT pDat = (PWDAT)hDat;

	if(g_nOpened) {
		sysCritON();
		if(pDat && 
			isValidWnd((PXWND)pDat->hOwner) && 
			isValidWndData((PXWND)pDat->hOwner,pDat)) {
			switch(pDat->uType & 0xFFFF)
			{
			case WDAT_TYPE_INTEGER:
				pContent = (PVOID)&pDat->content;
				break;
			case WDAT_TYPE_BITMAP://///////////////2011-10-11
				//pContent = (PVOID)&pDat->content;
				//break;////////////////////////////////////////
			case WDAT_TYPE_STRING:
			case WDAT_TYPE_USER:
				pContent = (PVOID)pDat->content;
				break;
			default:
				break;
			}
			
		}
		sysCritOFF();
	}

	return pContent;
}

void SetDataContent(HDAT hDat,uint content)
{
	//PVOID pContent = NULL;

	PWDAT pDat = (PWDAT)hDat;

	if(g_nOpened) {
		sysCritON();
		if(content && 
			pDat && 
			isValidWnd((PXWND)pDat->hOwner) && 
			isValidWndData((PXWND)pDat->hOwner,pDat)) {
			pDat->content = content;
			}	
		}
		sysCritOFF();
}

bool GetDataType(HDAT hDat, uint *pType)
{
	bool bResult = false;

	PWDAT pDat = (PWDAT)hDat;

	if(g_nOpened) {
		sysCritON();
		if(pDat && pType && 
			isValidWnd((PXWND)pDat->hOwner) && 
			isValidWndData((PXWND)pDat->hOwner,pDat)) {
			*pType = pDat->uType;
			bResult = true;
		}
		sysCritOFF();
	}

	return bResult;
}

bool GetDataInfo(HDAT hDat, uint *pInfo)
{
	bool bResult = false;

	PWDAT pDat = (PWDAT)hDat;

	if(g_nOpened) {
		sysCritON();
		if(pDat && pInfo && 
			isValidWnd((PXWND)pDat->hOwner) && 
			isValidWndData((PXWND)pDat->hOwner,pDat)) {
			*pInfo = pDat->uInfo;
			bResult = true;
		}
		sysCritOFF();
	}

	return bResult;
}

bool SetDataInfo(HDAT hDat, uint uInfo)
{
	bool bResult = false;

	PWDAT pDat = (PWDAT)hDat;

	if(g_nOpened) {
		sysCritON();
		if(pDat && 
			isValidWnd((PXWND)pDat->hOwner) && 
			isValidWndData((PXWND)pDat->hOwner,pDat)) {
			pDat->uInfo = uInfo;
			bResult = true;
		}
		sysCritOFF();
	}

	return bResult;
}

HDAT GetFirstData(HWND hWnd)
{
	HDAT hDat = NULL;
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			hDat = (HDAT)pWnd->pDat;
		}
		sysCritOFF();
	}

	return hDat;
}

HDAT GetNextData(HDAT hDat)
{
	PWDAT pDat = (PWDAT)hDat;

	if(g_nOpened) {
		sysCritON();
		if(pDat && 
			isValidWnd((PXWND)pDat->hOwner) && 
			isValidWndData((PXWND)pDat->hOwner,pDat)) {
			pDat = pDat->pNext;
		}
		sysCritOFF();
	}

	return (HDAT)pDat;
}

VOID UpdataWndData(HWND hWnd, HDAT hDat)
{
	PXWND pWnd = (PXWND)hWnd;
	PWDAT pDat = (PWDAT)hDat;
	REGION region;
	
	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			if(!pDat) {
				redrawAllWndData(pWnd);
				getWndRegion(pWnd,&region);
				refreshRegion(pWnd,&region);
			} 
			else if(isValidWndData(pWnd,pDat)) {
				redrawAnyWndData(pDat);
				getDataRealRegion(pDat,&region);
				refreshRegion(pWnd,&region);
			}
		}
		sysCritOFF();
	}
}

HFCS CreateWndFocus(HWND hWnd, POSITION pos, uint cx, uint cy, uint data, void (*pFxnPixel)(uint,int,int,UINT16*))
{
	PWFCS pFcsX = NULL;
	PWFCS pFcsY = NULL;
	PXWND pWnd = (PXWND)hWnd;
	REGION region;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			if(cx>0 && cy>0) {
				pFcsX = (PWFCS)alloc_mem(sizeof(WFCS),4);
				if(pFcsX != Mem_NULL) {
					pFcsX->hOwner = (HWND)pWnd;
					pFcsX->area.pos = pos;
					pFcsX->area.cx = cx;
					pFcsX->area.cy = cy;
					pFcsX->data = data;
					if(pFxnPixel) {
						switch(((uint)pFxnPixel)&3)
						{
						case _FcsPixel_INV:
							pFcsX->pFxnPixel = _defaultFocusPixel_inv;
							break;
						case _FcsPixel_IMG:
							pFcsX->pFxnPixel = _defaultFocusPixel_img;
							break;
						case _FcsPixel_RSV:
							pFcsX->pFxnPixel = _defaultFocusPixel_rsv;
							break;
						default:
							pFcsX->pFxnPixel = pFxnPixel;
							break;
						}
					}
					else {
						pFcsX->pFxnPixel = _defaultFocusPixel_inv;
					}

					if(pFcsY=pWnd->pFcs) {
						list_add_tail(&pFcsX->node,&pFcsY->node);
					} 
					else {
						pWnd->pFcs = pFcsX;
						_init_list_head(&pFcsX->node);
						getFocusRealRegion(pFcsX,&region);
						drawWndRegionFocus(pWnd,&region);
					}
				}
			}
		}
		sysCritOFF();
	}
	return ((HFCS)pFcsX);
}

VOID DeleteWndFocus(HFCS hFcs)
{
	PWFCS pFcsX, pFcsY = (PWFCS)hFcs;
	PXWND pWnd = NULL;
	REGION region;

	if(pFcsY) pWnd = (PXWND)pFcsY->hOwner;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			if(pFcsX=pWnd->pFcs) {
				do
				{
					if(pFcsX==pFcsY) break;
					pFcsX = list_entry(pFcsX->node.next,WFCS,node);
				} while(pFcsX != pWnd->pFcs);
				if(pFcsX==pFcsY) {
					if(pFcsX==pWnd->pFcs) {
						if(list_empty(&pFcsX->node)) {
							pWnd->pFcs = NULL;
							getFocusRealRegion(pFcsX,&region);
							eraseWndRegionFocus(pWnd,&region);
						} 
						else {
							pWnd->pFcs = list_entry(pFcsX->node.next,WFCS,node);
							list_del(&pFcsX->node);
							getFocusRealRegion(pFcsX,&region);
							eraseWndRegionFocus(pWnd,&region);
							getFocusRealRegion(pWnd->pFcs,&region);
							drawWndRegionFocus(pWnd,&region);
						}
					}
					else {
						list_del(&pFcsX->node);
					}
					free_mem((PVOID)pFcsX,sizeof(WFCS));
				}
			}
		}
		sysCritOFF();
	}
}

bool GetFocusData(HFCS hFcs, uint *pData)
{
	bool bResult = false;
	PWFCS pFcs = (PWFCS)hFcs;
	
	if(g_nOpened) {
		sysCritON();
		if(pFcs && pData && 
			isValidWnd((PXWND)pFcs->hOwner) && 
			isValidWndFocus((PXWND)pFcs->hOwner,pFcs)) {
			*pData = pFcs->data;
			bResult = true;
		}
		sysCritOFF();
	}

	return bResult;
}

HFCS GetCurrentFocus(HWND hWnd)
{
	HFCS hFcs = NULL;
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) 
			hFcs = (HFCS)pWnd->pFcs;
		sysCritOFF();
	}

	return hFcs;
}

HFCS GetRelatFocus(HFCS hFcs, int n)
{
	int i;
	PWFCS pFcs = (PWFCS)hFcs;

	if(g_nOpened && n) {
		sysCritON();
		if(pFcs && 
			isValidWnd((PXWND)pFcs->hOwner) && 
			isValidWndFocus((PXWND)pFcs->hOwner,pFcs)) {
			if(n>0)
				for(i=0;i<n;i++) 
					pFcs = list_entry(pFcs->node.next,WFCS,node);
			else 
				for(i=0;i>n;i--)
					pFcs = list_entry(pFcs->node.prev,WFCS,node);
			
		}
		sysCritOFF();
	}

	return (HFCS)pFcs;
}

HFCS GetNextFocus(HFCS hFcs)
{
	PWFCS pFcs = (PWFCS)hFcs;

	if(g_nOpened) {
		sysCritON();
		if(pFcs && 
			isValidWnd((PXWND)pFcs->hOwner) && 
			isValidWndFocus((PXWND)pFcs->hOwner,pFcs)) {
			pFcs = list_entry(pFcs->node.next,WFCS,node);
		}
		sysCritOFF();
	}

	return (HFCS)pFcs;
}

HFCS GetLastFocus(HFCS hFcs)
{
	PWFCS pFcs = (PWFCS)hFcs;

	if(g_nOpened) {
		sysCritON();
		if(pFcs && 
			isValidWnd((PXWND)pFcs->hOwner) && 
			isValidWndFocus((PXWND)pFcs->hOwner,pFcs)) {
			pFcs = list_entry(pFcs->node.prev,WFCS,node);
		}
		sysCritOFF();
	}

	return (HFCS)pFcs;
}
void eraseWndFocus(HWND hWnd)
{
	PXWND pWnd = (PXWND)hWnd;
	REGION region;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			if(pWnd->pFcs) {
				getFocusRealRegion(pWnd->pFcs,&region);
				if(f_onWndRegion(pWnd,&region))
					eraseWndRegionFocus(pWnd,&region);
			}
		}
		sysCritOFF();
	}
}

void drawWndFocus(HWND hWnd)
{
	PXWND pWnd = (PXWND)hWnd;
	//PWFCS pFcs = NULL;
	REGION region;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			if(pWnd->pFcs) {
				getFocusRealRegion(pWnd->pFcs,&region);

				if(f_inWndRegion(pWnd,&region)) 
				{
					drawWndRegionFocus(pWnd,&region);
				}
			}
		}
		sysCritOFF();
	}
}
VOID SetNextFocus(HWND hWnd)
{
	PXWND pWnd = (PXWND)hWnd;
	PWFCS pFcs = NULL;
	REGION region;
	int x,y;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			if(pFcs=pWnd->pFcs) {
				pWnd->pFcs = list_entry(pFcs->node.next,WFCS,node);
				
				getFocusRealRegion(pWnd->pFcs,&region);

				if(f_inWndRegion(pWnd,&region)) 
				{
					drawWndRegionFocus(pWnd,&region);
					getFocusRealRegion(pFcs,&region);
					if(f_onWndRegion(pWnd,&region))
						eraseWndRegionFocus(pWnd,&region);
				}
				else 
				{
					x = y = 0;
					if((region.sRow<pWnd->cy && region.sRow>=0 && 
						region.eRow>=pWnd->cy) ||
						region.sRow>=pWnd->cy) 
						y = pWnd->cy-region.eRow-1;
					else if(region.sRow<0) 
						y = -region.sRow;
					
					if((region.sCol<pWnd->cx && region.sCol>=0 && 
						region.eCol>=pWnd->cx) ||
						region.sCol>=pWnd->cx) 
						x = pWnd->cx-region.eCol-1;
					else if(region.sCol<0) 
						x = -region.sCol;

					pWnd->offset_pos.pos_x += x;
					pWnd->offset_pos.pos_y += y;

					redrawWnd(pWnd);
					refreshX(pWnd,true);
					
				}	
			}
		}
		sysCritOFF();
	}
}

VOID SetLastFocus(HWND hWnd)
{
	PXWND pWnd = (PXWND)hWnd;
	PWFCS pFcs = NULL;
	REGION region;
	int x,y;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			if(pFcs=pWnd->pFcs) {
				pWnd->pFcs = list_entry(pFcs->node.prev,WFCS,node);

				getFocusRealRegion(pWnd->pFcs,&region);

				if(f_inWndRegion(pWnd,&region)) 
				{
					drawWndRegionFocus(pWnd,&region);
					getFocusRealRegion(pFcs,&region);
					if(f_onWndRegion(pWnd,&region))
						eraseWndRegionFocus(pWnd,&region);
				}
				else 
				{
					x = y = 0;
					if((region.sRow<pWnd->cy && region.sRow>=0 && 
						region.eRow>=pWnd->cy) ||
						region.sRow>=pWnd->cy) 
						y = pWnd->cy-region.eRow-1;
					else if(region.sRow<0) 
						y = -region.sRow;
					
					if((region.sCol<pWnd->cx && region.sCol>=0 && 
						region.eCol>=pWnd->cx) ||
						region.sCol>=pWnd->cx) 
						x = pWnd->cx-region.eCol-1;
					else if(region.sCol<0) 
						x = -region.sCol;

					pWnd->offset_pos.pos_x += x;
					pWnd->offset_pos.pos_y += y;

					redrawWnd(pWnd);
					refreshX(pWnd,true);
					
				}	

			}
		}
		sysCritOFF();
	}
}

VOID SetWndFocus(HFCS hFcs)
{
	PXWND pWnd = NULL;
	PWFCS pFcs = (PWFCS)hFcs;
	REGION region;
	int x,y;

	if(!pFcs) return;
	if(g_nOpened) {
		sysCritON();
		pWnd = (PXWND)pFcs->hOwner;
		if(isValidWnd(pWnd) && isValidWndFocus(pWnd,pFcs)) {
			getFocusRealRegion(pFcs,&region);

			if(pWnd->pFcs != pFcs) {
				pFcs = pWnd->pFcs;
				pWnd->pFcs = (PWFCS)hFcs;
			}

			if(pWnd->pFcs != pFcs &&
				f_inWndRegion(pWnd,&region)) 
			{
				drawWndRegionFocus(pWnd,&region);
				getFocusRealRegion(pFcs,&region);
				if(f_onWndRegion(pWnd,&region))
					eraseWndRegionFocus(pWnd,&region);
			}
			else 
			{
				x = y = 0;
				if((region.sRow<pWnd->cy && region.sRow>=0 && 
					region.eRow>=pWnd->cy) ||
					region.sRow>=pWnd->cy) 
					y = pWnd->cy-region.eRow-1;
				else if(region.sRow<0) 
					y = -region.sRow;
				
				if((region.sCol<pWnd->cx && region.sCol>=0 && 
					region.eCol>=pWnd->cx) ||
					region.sCol>=pWnd->cx) 
					x = pWnd->cx-region.eCol-1;
				else if(region.sCol<0) 
					x = -region.sCol;

				pWnd->offset_pos.pos_x += x;
				pWnd->offset_pos.pos_y += y;

				if(x|y) {
					redrawWnd(pWnd);
					refreshX(pWnd,true);
				}
				
			}

		}
		sysCritOFF();
	}

}

VOID XDisplay()
{
	if(g_nOpened) {
		sysCritON();
		refreshX(NULL,true);
		sysCritOFF();
	}
}

static inline bool isWndPoint(PXWND pWnd, uchar Px, uchar Py)
{
	int px,py;
	if(pWnd && pWnd->f_visible) {
		px = Px - pWnd->pos.pos_x;
		py = Py - pWnd->pos.pos_y;
		if(px>=0 && px<pWnd->cx && 
			py>=0 && py<pWnd->cy) 
			return true;
	}
	return false;
}

PXWND _GetWndByPoint(uchar Px, uchar Py)
{
	PXWND pWnd = NULL;

	if(isWndPoint(pCurWnd,Px,Py)) {
		return pCurWnd;
	}
	else {
		if(pCurWnd) {
			pWnd = pCurWnd;
			list_for_each_entry_continue_prev(pWnd,&theONE.node,XWND,node)
			{
				if(pWnd->f_visible)
					if(isWndPoint(pWnd,Px,Py)) 
						return pWnd;
			}
		}
		return (&theONE);
	}

}

VOID _InitMsgQueue()
{
	mmzero((PVOID)&msgq, sizeof(MSGQ));
	
	msgq.hEvt = CreateEvent(0);
	msgq.magic = MSGQ_MAGIC;
}

bool PostMessage(HWND hWnd, uint info)
{

	bool bResult = false;

	if(g_nOpened) {
		_llEnter();
		
		if(msgq.magic == MSGQ_MAGIC) {
			if((msgq.msg[msgq.ip].x_l & MSG_FLG) == 0) {
				msgq.msg[msgq.ip].x_h = (uint)hWnd;
				msgq.msg[msgq.ip].x_l = info;
				msgq.msg[msgq.ip].x_l |= MSG_FLG;
				if(++msgq.ip == MSG_DEPTH) 
					msgq.ip = 0;
				if(msgq.hEvt) PostEvent(msgq.hEvt);
				bResult = true;
			}
		}
		
		_llExit();
	}

	return bResult;
}

void _PreparseMessage(uintx *pMsg)
{
	PXWND pWnd;
	uint info,wndname;
	uchar Px,Py;
	HWND hWnd;
	uint   iFcsAdd;
	if(pMsg) {
		pWnd = (PXWND)pMsg->x_h;
		info = pMsg->x_l;
		if(!pWnd) {
			switch(_evtType(info)) 
			{
			case EVENT_TCH:
				Px = _pointX(info);
				Py = _pointY(info);
				if(isWndPoint(pCurWnd,Px,Py)) {
					pWnd = pCurWnd;
					Px = Px - pCurWnd->pos.pos_x;
					Py = Py - pCurWnd->pos.pos_y;
					info = (info & 0xFFFF0000) | ((Py<<8) | Px);
				}
				else {
					pWnd = &theONE;
				}
				break;
			case EVENT_HWI:
			case EVENT_KEY:
				pWnd = pCurWnd ? pCurWnd : &theONE;
				break;
			case EVENT_PRD:
				pWnd = &theONE;
				break;
			//----------------------------------
			case EVENT_USER:
				pWnd = pCurWnd ? pCurWnd : &theONE;
				GetWndIdentity((HWND)pWnd,&wndname);
				if(wndname == MAINSETWINDOW)
				{
					hWnd = (HWND) pWnd;
					GetFocusData(GetCurrentFocus(hWnd), &iFcsAdd);
					switch(iFcsAdd >> 16)
					{
						case 1:
							pWnd = (PXWND)GetWndByIdentity(OVERTAKEWND);
						break;
						case 2:
							pWnd = (PXWND)GetWndByIdentity(BASEWND);
						break;
						case 3:
							pWnd = (PXWND)GetWndByIdentity(RADPARWND);
						break;
						case 4:
							pWnd = (PXWND)GetWndByIdentity(LOCALPARWND);
						break;
						default:
						break;
					}
				}
				break;
			//----------------------------------
			default:
				pWnd = pCurWnd ? pCurWnd : &theONE;
				break;
			}
			pMsg->x_h = (uint)pWnd;
			pMsg->x_l = info;
		}
	}
	
}

uintx _GetMessage()
{
	uintx msg;
	msg.x_h = msg.x_l = 0;

	if(msgq.magic == MSGQ_MAGIC) {
		if(msgq.hEvt) {
			while(PendEvent(msgq.hEvt, TO_FOREVER)) {

				if(msgq.msg[msgq.op].x_l & MSG_FLG) {
					msg = msgq.msg[msgq.op];
					msgq.msg[msgq.op].x_l &= (~MSG_FLG);
					if(++msgq.op == MSG_DEPTH) 
						msgq.op = 0;
					break;
				}
			}
		}
	}

	return msg;
}

VOID _InitObjects()
{
	_InitMsgQueue();
	_InitTimerQueue();
}

VOID _wndmgrTsk()
{
	uintx msg;
	PXWND pWnd;
	PWNDRT pRt;

	while(true) {
		pRt = NULL;
		
		msg = _GetMessage();
		
		sysCritON();
		_PreparseMessage(&msg);
		pWnd = (PXWND)msg.x_h;
		if(isValidWnd(pWnd)) pRt = pWnd->pWndRoutine;
		sysCritOFF();

		if(pRt) {
			if((*pRt)(msg.x_h,msg.x_l)) _BWndRoutine(msg.x_h,msg.x_l);
		}
		else {
			_BWndRoutine(msg.x_h,msg.x_l);
		}
	}
}

int _BWndRoutine(uint x, uint y)
{
	PXWND pWnd = (PXWND)x;
	uint info = y;
	if(g_fpHook && ((*g_fpHook)(x,y)==0)) return 0;

	/* Code here for default operation */
	if(pWnd == &theONE) {
		switch(_evtType(info))
		{
		case EVENT_TCH:
			pWnd = _GetWndByPoint(_pointX(info),_pointY(info));
			ShowWnd((HWND)pWnd);
			break;
		case EVENT_HWI:
			break;
		case EVENT_KEY:
			switch(_keyVal(info))
			{
			case KEY_FY:
				break;
			case KEY_FN:
				break;
			case KEY_FU:
				break;
			case KEY_FD:
				break;
			case KEY_FL:
				break;
			case KEY_FR:
				break;
			default:
				break;
			}
			break;
		case EVENT_PRD:
			break;
		default:
			break;

		}
	}

	return 0;
}

void _defaultDataDisplay(uint uParam)
{
	PWDAT pDat = (PWDAT)uParam;
	REGION region;
	tchar sNumber[16];
	uint info;
	int i, j, k, l, p, q, f, data;

	if(pDat) {
		getDataRealRegion(pDat, &region);
		switch(pDat->uType & 0xFFFF)
		{

		case WDAT_TYPE_STRING:
			ResetWndRegionContent(pDat->hOwner, region);
			SetWndRegionText(pDat->hOwner, region, (tchar*)pDat->content);
			break;
		case WDAT_TYPE_INTEGER:
			i = 0; info = pDat->uType >> 16;
			data = (int)pDat->content;
			if(info==0) {
				if(data==0)
				{
					sNumber[i++] = '0';
				} 
				else {
					if(data<0) {
						data = -data;
						sNumber[i++] = '-';
					}
					for(f=0,j=9;j>=0;j--) {
						for(p=1,l=0;l<j;l++) p = p*10;
						k = data/p;
						if(k>0 || f>0) {
							data = data - k*p;
							sNumber[i++] = '0' + k;
							f++;
						}
					}
				}
				sNumber[i] = '\0';
			} 
			else if(info>0 && info<10) {
				if(data<0) {
					data = -data;
					info--;
					sNumber[i++] = '-';
				}
				if(info>0) {
					for(p=1,l=0;l<info;l++) p = p*10;
					q = (data<p) ? 0 : 1;
					data = data%p;
					if(data==0) {
						for(j=0;j<(info-1);j++) sNumber[i++] = (q>0) ? '0' : ' ';
						sNumber[i++] = '0';
					} 
					else {
						for(f=0,j=info-1;j>=0;j--) {
							for(p=1,l=0;l<j;l++) p = p*10;
							k = data/p;
							if(k>0 || f>0) {
								data = data - k*p;
								sNumber[i++] = '0' + k;
								f++;
							}
							else {
								sNumber[i++] = (q>0) ? '0' : ' ';
							}
						}
					}
				}
				sNumber[i] = '\0';
			}

			ResetWndRegionContent(pDat->hOwner, region);
			SetWndRegionText(pDat->hOwner, region, sNumber);
			break;
		case WDAT_TYPE_BITMAP:
			info = pDat->uType >> 16;
			DrawWndRegion(pDat->hOwner, region, (UINT16*)pDat->content, info);
			break;
		case WDAT_TYPE_USER:
		default:
			break;
		}
	}
}

void _defaultDataCreate(uint uParam)
{
	PWDAT pDat = (PWDAT)uParam;
	uchar *pBuffer;
	int i;

	if(pDat) {
		switch(pDat->uType & 0xFFFF)
		{
		case WDAT_TYPE_STRING:
			i = 0;
			pBuffer = (uchar*)pDat->content;
			while(*pBuffer != '\0') {
				pBuffer++;
				i++;
			}
			if(i>0) {
				pBuffer = (uchar*)alloc_mem(i+1,1);
				if(pBuffer != Mem_NULL) {
					mmcopy((PVOID)pBuffer, (PVOID)pDat->content, i);
					pBuffer[i] = '\0';
					pDat->content = (uint)pBuffer;
					pDat->uType = (pDat->uType & 0xFFFF) | ((i+1)<<16);
				}
			}
			break;
		case WDAT_TYPE_INTEGER:
			break;
		case WDAT_TYPE_BITMAP:
			break;
		case WDAT_TYPE_USER:
			i = pDat->uType >> 16;
			if(i>0) {
				pBuffer = (uchar*)alloc_mem(i,i);
				if(pBuffer != Mem_NULL) {
					mmcopy((PVOID)pBuffer, (PVOID)pDat->content, i);
					pDat->content = (uint)pBuffer;
				} 
				else {
					pDat->uType &= 0xFFFF;
				}
			}
			break;
		default:
			break;
		}
	}
}

void _defaultDataDelete(uint uParam)
{

	PWDAT pDat = (PWDAT)uParam;
	uint info;

	if(pDat) {
		switch(pDat->uType & 0xFFFF)
		{
		case WDAT_TYPE_INTEGER:
			break;
		case WDAT_TYPE_BITMAP:
			break;
		case WDAT_TYPE_STRING:
		case WDAT_TYPE_USER:
			info = pDat->uType >> 16;
			if(info>0) {
				free_mem((PVOID)pDat->content,info);
			}
			break;
		default:
			break;
		}
	}
}

void _defaultFocusPixel_img(uint uParam, int px, int py, UINT16* pPixel)
//void _defaultFocusPixel_img(uint uParam, int px, int py, uchar* pPixel)
{
	PWFCS pFcs = (PWFCS)uParam;
	UINT16 uColor,*pTemp;
	//uchar uColor,*pTemp;
	uint *pData;

	if(pFcs && pPixel) {
		pData = (uint*)pFcs->data;
		pTemp = (UINT16*)(*pData);
		//pTemp = (uchar*)(*pData);
		if(pTemp) {
			uColor = pTemp[py*pFcs->area.cx+px];
			if((uColor-_Tbl(0x0000))>0) *pPixel = uColor;
		}
	}
}

void _defaultFocusPixel_inv(uint uParam, int px, int py, UINT16* pPixel)
//void _defaultFocusPixel_inv(uint uParam, int px, int py, uchar* pPixel)
{
	(void)uParam;
	px=px;
	py=py;
	//if(pPixel) *pPixel = 0xFFFF-*pPixel;
	*pPixel = ~*pPixel;
}

void _defaultFocusPixel_rsv(uint uParam, int px, int py, UINT16* pPixel)
{
	return;
}

int CreateWndTimer(HWND hWnd, uint prdTicks, uint info, uint state/*, void (*pTimerRt)(uint,uint)*/)
{
	int i, timerID = -1;
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd) && prdTicks>0) {
			for(i=0;i<TIMER_DEPTH;i++) {
				if(timer[i].used==0) break;
			}
			if(i!=TIMER_DEPTH) {
				timer[i].hOwner = hWnd;
				timer[i].prdTicks = prdTicks;
				timer[i].state = state;
				timer[i].pNext = NULL;
				timer[i].used = 1;
				timer[i].info = info;
				if(timer[i].state>0) 
					_TimerListInsert(&timer[i]);
				
				pWnd->timer |= (1<<i);
				timerID = i;
			}
		}
		sysCritOFF();
	}

	return timerID;
}

VOID DeleteWndTimer(HWND hWnd, int timerID)
{
	PXWND pWnd = (PXWND)hWnd;
	PWTimer pTimer;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd) &&
			timerID>=0 && timerID<TIMER_DEPTH) {
			if(pWnd->timer & (1<<timerID)) {
				pWnd->timer &= (~(1<<timerID));
				pTimer = &timer[timerID];
				if(pTimer->state>0)
					_TimerListRemove(pTimer);
				
				pTimer->used = 0;
			}
		}
		sysCritOFF();
	}
}

bool EnableWndTimer(HWND hWnd, int timerID)
{
	bool bResult = false;
	PXWND pWnd = (PXWND)hWnd;
	PWTimer pTimer;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd) &&
			timerID>=0 && timerID<TIMER_DEPTH) {
			if(pWnd->timer & (1<<timerID)) {
				pTimer = &timer[timerID];
				if(pTimer->state==0) {
					_TimerListInsert(pTimer);
					pTimer->state = 1;
				}
				bResult = true;
			}
		}
		sysCritOFF();
	}

	return bResult;
}

bool DisableWndTimer(HWND hWnd, int timerID)
{
	bool bResult = false;
	PXWND pWnd = (PXWND)hWnd;
	PWTimer pTimer;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd) &&
			timerID>=0 && timerID<TIMER_DEPTH) {
			if(pWnd->timer & (1<<timerID)) {
				pTimer = &timer[timerID];
				if(pTimer->state>0) {
					_TimerListRemove(pTimer);
					pTimer->state = 0;
				}
				bResult = true;
			}
		}
		sysCritOFF();
	}

	return bResult;
}

int GetFirstTimer(HWND hWnd)
{
	int i, iTimer = -1;
	PXWND pWnd = (PXWND)hWnd;

	if(g_nOpened) {
		sysCritON();
		if(isValidWnd(pWnd)) {
			if(pWnd->timer) {
				for(i=0;i<TIMER_DEPTH;i++) {
					if((pWnd->timer>>i)&1) {
						iTimer = i;
						break;
					}
				}
			}
		}
		sysCritOFF();
	}

	return iTimer;
}

int GetNextTimer(int timerID)
{
	int i, iTimer = -1;
	PXWND pWnd;

	if(g_nOpened) {
		sysCritON();
		if(timerID>=0 && timerID<TIMER_DEPTH) {
			pWnd = (PXWND)timer[timerID].hOwner;
			if(isValidWnd(pWnd)) {
				if(pWnd->timer & (1<<timerID)) {
					for(i=timerID+1;i<TIMER_DEPTH;i++) {
						if((pWnd->timer>>i)&1) {
							iTimer = i;
							break;
						}
					}
				}
			}
		}
		sysCritOFF();
	}

	return iTimer;
}

VOID timerTick()
{
	PWTimer pTimer;
	uint info;

	// Bump the master tick count
	g_timerTicks++;
	//printf("g_timerTicks = %d\n",g_timerTicks);
	// The timeout list is pre-sorted by time. Continue triggering
	// timers until we get ONE that isn't ready.

	while((pTimer=pFirstTimer) && (pTimer->trgTicks==g_timerTicks))
	{
		// Go to next timer
		pFirstTimer = pTimer->pNext;

		// Put TIMER back in list
		_TimerListInsert(pTimer);

		// Post task message
		info = (EVENT_PRD<<16)|((pTimer-timer)/sizeof(WTimer));
		PostMessage(pTimer->hOwner, info);
	}
}


static void _TimerListInsert(PWTimer pTimer)
{
	PWTimer pTimerX;

	pTimer->trgTicks = pTimer->prdTicks+ g_timerTicks;

	// Check the easy case - being first
	if( !pFirstTimer
		|| (pFirstTimer->trgTicks-g_timerTicks) >= (pTimer->trgTicks-g_timerTicks) )
	{
		// What we point to next
		pTimer->pNext = pFirstTimer;
		// Before us...pointing to us
		pFirstTimer = pTimer;
	}
	else
	{
		// Find an entry we expire AFTER
		pTimerX = pFirstTimer;
		while(pTimerX->pNext && 
			(pTimerX->pNext->trgTicks-g_timerTicks)<(pTimer->trgTicks-g_timerTicks))
			pTimerX = pTimerX->pNext;

		// What we point to next (can be NULL)
		pTimer->pNext = pTimerX->pNext;
		// Before us...pointing to us (can be overwiting a NULL)
		pTimerX->pNext = pTimer;
	}
}

static void _TimerListRemove(PWTimer pTimer)
{
	PWTimer pTimerX;

	// Check to see if we're the head of the list
	if(pTimer == pFirstTimer)
		pFirstTimer = pTimer->pNext;
 	else {
		// Look for us
		pTimerX = pFirstTimer;
		while(pTimerX && pTimerX->pNext != pTimer)
			pTimerX = pTimerX->pNext;

		// Patch entry which points to us (if any)
		if(pTimerX)
			pTimerX->pNext = pTimer->pNext;
	}
}

