#ifndef _CSLR__DMA_1_H_
#define _CSLR__DMA_1_H_

#include <cslr.h>

/* Minimum unit = 2 bytes */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint16 DMA0EVT0;
    volatile Uint16 DMA0EVT1;
    volatile Uint16 DMA1EVT0;
    volatile Uint16 DMA1EVT1;
    volatile Uint16 RSVD0[18];
    volatile Uint16 DMAIFR;
    volatile Uint16 DMAINTEN;
    volatile Uint16 RSVD1[4];
    volatile Uint16 DMA2EVT0;
    volatile Uint16 DMA2EVT1;
    volatile Uint16 DMA3EVT0;
    volatile Uint16 DMA3EVT1;
} CSL_DmaEvtRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* DMA0EVT0 */


#define CSL_DMA_DMA0EVT0_CH1EVENT_MASK (0x0F00u)
#define CSL_DMA_DMA0EVT0_CH1EVENT_SHIFT (0x0008u)
#define CSL_DMA_DMA0EVT0_CH1EVENT_RESETVAL (0x0000u)


#define CSL_DMA_DMA0EVT0_CH0EVENT_MASK (0x000Fu)
#define CSL_DMA_DMA0EVT0_CH0EVENT_SHIFT (0x0000u)
#define CSL_DMA_DMA0EVT0_CH0EVENT_RESETVAL (0x0000u)

#define CSL_DMA_DMA0EVT0_RESETVAL (0x0000u)

/* DMA0EVT1 */


#define CSL_DMA_DMA0EVT1_CH3EVENT_MASK (0x0F00u)
#define CSL_DMA_DMA0EVT1_CH3EVENT_SHIFT (0x0008u)
#define CSL_DMA_DMA0EVT1_CH3EVENT_RESETVAL (0x0000u)


#define CSL_DMA_DMA0EVT1_CH2EVENT_MASK (0x000Fu)
#define CSL_DMA_DMA0EVT1_CH2EVENT_SHIFT (0x0000u)
#define CSL_DMA_DMA0EVT1_CH2EVENT_RESETVAL (0x0000u)

#define CSL_DMA_DMA0EVT1_RESETVAL (0x0000u)

/* DMA1EVT0 */


#define CSL_DMA_DMA1EVT0_CH1EVENT_MASK (0x0F00u)
#define CSL_DMA_DMA1EVT0_CH1EVENT_SHIFT (0x0008u)
#define CSL_DMA_DMA1EVT0_CH1EVENT_RESETVAL (0x0000u)


#define CSL_DMA_DMA1EVT0_CH0EVENT_MASK (0x000Fu)
#define CSL_DMA_DMA1EVT0_CH0EVENT_SHIFT (0x0000u)
#define CSL_DMA_DMA1EVT0_CH0EVENT_RESETVAL (0x0000u)

#define CSL_DMA_DMA1EVT0_RESETVAL (0x0000u)

/* DMA1EVT1 */


#define CSL_DMA_DMA1EVT1_CH3EVENT_MASK (0x0F00u)
#define CSL_DMA_DMA1EVT1_CH3EVENT_SHIFT (0x0008u)
#define CSL_DMA_DMA1EVT1_CH3EVENT_RESETVAL (0x0000u)


#define CSL_DMA_DMA1EVT1_CH2EVENT_MASK (0x000Fu)
#define CSL_DMA_DMA1EVT1_CH2EVENT_SHIFT (0x0000u)
#define CSL_DMA_DMA1EVT1_CH2EVENT_RESETVAL (0x0000u)

#define CSL_DMA_DMA1EVT1_RESETVAL (0x0000u)

/* DMAIFR */

#define CSL_DMA_DMAIFR_DMA3CH3INT_MASK (0x8000u)
#define CSL_DMA_DMAIFR_DMA3CH3INT_SHIFT (0x000Fu)
#define CSL_DMA_DMAIFR_DMA3CH3INT_RESETVAL (0x0000u)

#define CSL_DMA_DMAIFR_DMA3CH2INT_MASK (0x4000u)
#define CSL_DMA_DMAIFR_DMA3CH2INT_SHIFT (0x000Eu)
#define CSL_DMA_DMAIFR_DMA3CH2INT_RESETVAL (0x0000u)

#define CSL_DMA_DMAIFR_DMA3CH1INT_MASK (0x2000u)
#define CSL_DMA_DMAIFR_DMA3CH1INT_SHIFT (0x000Du)
#define CSL_DMA_DMAIFR_DMA3CH1INT_RESETVAL (0x0000u)

#define CSL_DMA_DMAIFR_DMA3CH0INT_MASK (0x1000u)
#define CSL_DMA_DMAIFR_DMA3CH0INT_SHIFT (0x000Cu)
#define CSL_DMA_DMAIFR_DMA3CH0INT_RESETVAL (0x0000u)

#define CSL_DMA_DMAIFR_DMA2CH3INT_MASK (0x0800u)
#define CSL_DMA_DMAIFR_DMA2CH3INT_SHIFT (0x000Bu)
#define CSL_DMA_DMAIFR_DMA2CH3INT_RESETVAL (0x0000u)

#define CSL_DMA_DMAIFR_DMA2CH2INT_MASK (0x0400u)
#define CSL_DMA_DMAIFR_DMA2CH2INT_SHIFT (0x000Au)
#define CSL_DMA_DMAIFR_DMA2CH2INT_RESETVAL (0x0000u)

#define CSL_DMA_DMAIFR_DMA2CH1INT_MASK (0x0200u)
#define CSL_DMA_DMAIFR_DMA2CH1INT_SHIFT (0x0009u)
#define CSL_DMA_DMAIFR_DMA2CH1INT_RESETVAL (0x0000u)

#define CSL_DMA_DMAIFR_DMA2CH0INT_MASK (0x0100u)
#define CSL_DMA_DMAIFR_DMA2CH0INT_SHIFT (0x0008u)
#define CSL_DMA_DMAIFR_DMA2CH0INT_RESETVAL (0x0000u)

#define CSL_DMA_DMAIFR_DMA1CH3INT_MASK (0x0080u)
#define CSL_DMA_DMAIFR_DMA1CH3INT_SHIFT (0x0007u)
#define CSL_DMA_DMAIFR_DMA1CH3INT_RESETVAL (0x0000u)

#define CSL_DMA_DMAIFR_DMA1CH2INT_MASK (0x0040u)
#define CSL_DMA_DMAIFR_DMA1CH2INT_SHIFT (0x0006u)
#define CSL_DMA_DMAIFR_DMA1CH2INT_RESETVAL (0x0000u)

#define CSL_DMA_DMAIFR_DMA1CH1INT_MASK (0x0020u)
#define CSL_DMA_DMAIFR_DMA1CH1INT_SHIFT (0x0005u)
#define CSL_DMA_DMAIFR_DMA1CH1INT_RESETVAL (0x0000u)

#define CSL_DMA_DMAIFR_DMA1CH0INT_MASK (0x0010u)
#define CSL_DMA_DMAIFR_DMA1CH0INT_SHIFT (0x0004u)
#define CSL_DMA_DMAIFR_DMA1CH0INT_RESETVAL (0x0000u)

#define CSL_DMA_DMAIFR_DMA0CH3INT_MASK (0x0008u)
#define CSL_DMA_DMAIFR_DMA0CH3INT_SHIFT (0x0003u)
#define CSL_DMA_DMAIFR_DMA0CH3INT_RESETVAL (0x0000u)

#define CSL_DMA_DMAIFR_DMA0CH2INT_MASK (0x0004u)
#define CSL_DMA_DMAIFR_DMA0CH2INT_SHIFT (0x0002u)
#define CSL_DMA_DMAIFR_DMA0CH2INT_RESETVAL (0x0000u)

#define CSL_DMA_DMAIFR_DMA0CH1INT_MASK (0x0002u)
#define CSL_DMA_DMAIFR_DMA0CH1INT_SHIFT (0x0001u)
#define CSL_DMA_DMAIFR_DMA0CH1INT_RESETVAL (0x0000u)

#define CSL_DMA_DMAIFR_DMA0CH0INT_MASK (0x0001u)
#define CSL_DMA_DMAIFR_DMA0CH0INT_SHIFT (0x0000u)
#define CSL_DMA_DMAIFR_DMA0CH0INT_RESETVAL (0x0000u)

#define CSL_DMA_DMAIFR_RESETVAL (0x0000u)

/* DMAINTEN */

#define CSL_DMA_DMAINTEN_DMA3CH3INTEN_MASK (0x8000u)
#define CSL_DMA_DMAINTEN_DMA3CH3INTEN_SHIFT (0x000Fu)
#define CSL_DMA_DMAINTEN_DMA3CH3INTEN_RESETVAL (0x0000u)

#define CSL_DMA_DMAINTEN_DMA3CH2INTEN_MASK (0x4000u)
#define CSL_DMA_DMAINTEN_DMA3CH2INTEN_SHIFT (0x000Eu)
#define CSL_DMA_DMAINTEN_DMA3CH2INTEN_RESETVAL (0x0000u)

#define CSL_DMA_DMAINTEN_DMA3CH1INTEN_MASK (0x2000u)
#define CSL_DMA_DMAINTEN_DMA3CH1INTEN_SHIFT (0x000Du)
#define CSL_DMA_DMAINTEN_DMA3CH1INTEN_RESETVAL (0x0000u)

#define CSL_DMA_DMAINTEN_DMA3CH0INTEN_MASK (0x1000u)
#define CSL_DMA_DMAINTEN_DMA3CH0INTEN_SHIFT (0x000Cu)
#define CSL_DMA_DMAINTEN_DMA3CH0INTEN_RESETVAL (0x0000u)

#define CSL_DMA_DMAINTEN_DMA2CH3INTEN_MASK (0x0800u)
#define CSL_DMA_DMAINTEN_DMA2CH3INTEN_SHIFT (0x000Bu)
#define CSL_DMA_DMAINTEN_DMA2CH3INTEN_RESETVAL (0x0000u)

#define CSL_DMA_DMAINTEN_DMA2CH2INTEN_MASK (0x0400u)
#define CSL_DMA_DMAINTEN_DMA2CH2INTEN_SHIFT (0x000Au)
#define CSL_DMA_DMAINTEN_DMA2CH2INTEN_RESETVAL (0x0000u)

#define CSL_DMA_DMAINTEN_DMA2CH1INTEN_MASK (0x0200u)
#define CSL_DMA_DMAINTEN_DMA2CH1INTEN_SHIFT (0x0009u)
#define CSL_DMA_DMAINTEN_DMA2CH1INTEN_RESETVAL (0x0000u)

#define CSL_DMA_DMAINTEN_DMA2CH0INTEN_MASK (0x0100u)
#define CSL_DMA_DMAINTEN_DMA2CH0INTEN_SHIFT (0x0008u)
#define CSL_DMA_DMAINTEN_DMA2CH0INTEN_RESETVAL (0x0000u)

#define CSL_DMA_DMAINTEN_DMA1CH3INTEN_MASK (0x0080u)
#define CSL_DMA_DMAINTEN_DMA1CH3INTEN_SHIFT (0x0007u)
#define CSL_DMA_DMAINTEN_DMA1CH3INTEN_RESETVAL (0x0000u)

#define CSL_DMA_DMAINTEN_DMA1CH2INTEN_MASK (0x0040u)
#define CSL_DMA_DMAINTEN_DMA1CH2INTEN_SHIFT (0x0006u)
#define CSL_DMA_DMAINTEN_DMA1CH2INTEN_RESETVAL (0x0000u)

#define CSL_DMA_DMAINTEN_DMA1CH1INTEN_MASK (0x0020u)
#define CSL_DMA_DMAINTEN_DMA1CH1INTEN_SHIFT (0x0005u)
#define CSL_DMA_DMAINTEN_DMA1CH1INTEN_RESETVAL (0x0000u)

#define CSL_DMA_DMAINTEN_DMA1CH0INTEN_MASK (0x0010u)
#define CSL_DMA_DMAINTEN_DMA1CH0INTEN_SHIFT (0x0004u)
#define CSL_DMA_DMAINTEN_DMA1CH0INTEN_RESETVAL (0x0000u)

#define CSL_DMA_DMAINTEN_DMA0CH3INTEN_MASK (0x0008u)
#define CSL_DMA_DMAINTEN_DMA0CH3INTEN_SHIFT (0x0003u)
#define CSL_DMA_DMAINTEN_DMA0CH3INTEN_RESETVAL (0x0000u)

#define CSL_DMA_DMAINTEN_DMA0CH2INTEN_MASK (0x0004u)
#define CSL_DMA_DMAINTEN_DMA0CH2INTEN_SHIFT (0x0002u)
#define CSL_DMA_DMAINTEN_DMA0CH2INTEN_RESETVAL (0x0000u)

#define CSL_DMA_DMAINTEN_DMA0CH1INTEN_MASK (0x0002u)
#define CSL_DMA_DMAINTEN_DMA0CH1INTEN_SHIFT (0x0001u)
#define CSL_DMA_DMAINTEN_DMA0CH1INTEN_RESETVAL (0x0000u)

#define CSL_DMA_DMAINTEN_DMA0CH0INTEN_MASK (0x0001u)
#define CSL_DMA_DMAINTEN_DMA0CH0INTEN_SHIFT (0x0000u)
#define CSL_DMA_DMAINTEN_DMA0CH0INTEN_RESETVAL (0x0000u)

#define CSL_DMA_DMAINTEN_RESETVAL (0x0000u)

/* DMA2EVT0 */


#define CSL_DMA_DMA2EVT0_CH1EVENT_MASK (0x0F00u)
#define CSL_DMA_DMA2EVT0_CH1EVENT_SHIFT (0x0008u)
#define CSL_DMA_DMA2EVT0_CH1EVENT_RESETVAL (0x0000u)


#define CSL_DMA_DMA2EVT0_CH0EVENT_MASK (0x000Fu)
#define CSL_DMA_DMA2EVT0_CH0EVENT_SHIFT (0x0000u)
#define CSL_DMA_DMA2EVT0_CH0EVENT_RESETVAL (0x0000u)

#define CSL_DMA_DMA2EVT0_RESETVAL (0x0000u)

/* DMA2EVT1 */


#define CSL_DMA_DMA2EVT1_CH3EVENT_MASK (0x0F00u)
#define CSL_DMA_DMA2EVT1_CH3EVENT_SHIFT (0x0008u)
#define CSL_DMA_DMA2EVT1_CH3EVENT_RESETVAL (0x0000u)


#define CSL_DMA_DMA2EVT1_CH2EVENT_MASK (0x000Fu)
#define CSL_DMA_DMA2EVT1_CH2EVENT_SHIFT (0x0000u)
#define CSL_DMA_DMA2EVT1_CH2EVENT_RESETVAL (0x0000u)

#define CSL_DMA_DMA2EVT1_RESETVAL (0x0000u)

/* DMA3EVT0 */


#define CSL_DMA_DMA3EVT0_CH1EVENT_MASK (0x0F00u)
#define CSL_DMA_DMA3EVT0_CH1EVENT_SHIFT (0x0008u)
#define CSL_DMA_DMA3EVT0_CH1EVENT_RESETVAL (0x0000u)


#define CSL_DMA_DMA3EVT0_CH0EVENT_MASK (0x000Fu)
#define CSL_DMA_DMA3EVT0_CH0EVENT_SHIFT (0x0000u)
#define CSL_DMA_DMA3EVT0_CH0EVENT_RESETVAL (0x0000u)

#define CSL_DMA_DMA3EVT0_RESETVAL (0x0000u)

/* DMA3EVT1 */


#define CSL_DMA_DMA3EVT1_CH3EVENT_MASK (0x0F00u)
#define CSL_DMA_DMA3EVT1_CH3EVENT_SHIFT (0x0008u)
#define CSL_DMA_DMA3EVT1_CH3EVENT_RESETVAL (0x0000u)


#define CSL_DMA_DMA3EVT1_CH2EVENT_MASK (0x000Fu)
#define CSL_DMA_DMA3EVT1_CH2EVENT_SHIFT (0x0000u)
#define CSL_DMA_DMA3EVT1_CH2EVENT_RESETVAL (0x0000u)

#define CSL_DMA_DMA3EVT1_RESETVAL (0x0000u)

#endif



