/********************************************************************
* Copyright (C) 2003-2008 Texas Instruments Incorporated.
* All Rights Reserved
*********************************************************************
* file: cslr_emif.h
*
* Brief: This file contains the Register Description for emif
*
*********************************************************************/
#ifndef _CSLR_EMIF_H_
#define _CSLR_EMIF_H_

#include <cslr.h>

#include <tistdtypes.h>
#include <csl_general.h>


/* Minimum unit = 2 bytes */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint16 REV;
    volatile Uint16 STATUS;
    volatile Uint16 RSVD0[2];
    volatile Uint16 AWCCR1;
    volatile Uint16 AWCCR2;
    volatile Uint16 RSVD1[2];
    volatile Uint16 SDCR1;
    volatile Uint16 SDCR2;
    volatile Uint16 RSVD2[2];
    volatile Uint16 SDRCR;
    volatile Uint16 RSVD3[3];
    volatile Uint16 ACS2CR1;
    volatile Uint16 ACS2CR2;
    volatile Uint16 RSVD4[2];
    volatile Uint16 ACS3CR1;
    volatile Uint16 ACS3CR2;
    volatile Uint16 RSVD5[2];
    volatile Uint16 ACS4CR1;
    volatile Uint16 ACS4CR2;
    volatile Uint16 RSVD6[2];
    volatile Uint16 ACS5CR1;
    volatile Uint16 ACS5CR2;
    volatile Uint16 RSVD7[2];
    volatile Uint16 SDTIMR1;
    volatile Uint16 RSVD8[27];
    volatile Uint16 SDSRETR;
    volatile Uint16 RSVD9[3];
    volatile Uint16 EIRR;
    volatile Uint16 RSVD10[3];
    volatile Uint16 EIMR;
    volatile Uint16 RSVD11[3];
    volatile Uint16 EIMSR;
    volatile Uint16 RSVD12[3];
    volatile Uint16 EIMCR;
    volatile Uint16 RSVD13[19];
    volatile Uint16 NANDFCR;
    volatile Uint16 RSVD14[3];
    volatile Uint16 NANDFSR1;
    volatile Uint16 NANDFSR2;
    volatile Uint16 RSVD15[2];
    volatile Uint16 PAGEMODCTRL1;
    volatile Uint16 PAGEMODCTRL2;
    volatile Uint16 RSVD16[6];
    volatile Uint16 NCS2ECC1;
    volatile Uint16 NCS2ECC2;
    volatile Uint16 RSVD17[2];
    volatile Uint16 NCS3ECC1;
    volatile Uint16 NCS3ECC2;
    volatile Uint16 RSVD18[2];
    volatile Uint16 NCS4ECC1;
    volatile Uint16 NCS4ECC2;
    volatile Uint16 RSVD19[2];
    volatile Uint16 NCS5ECC1;
    volatile Uint16 NCS5ECC2;
    volatile Uint16 RSVD20[62];
    volatile Uint16 NAND4BITECCLOAD;
    volatile Uint16 RSVD21[3];
    volatile Uint16 NAND4BITECC1;
    volatile Uint16 NAND4BITECC2;
    volatile Uint16 RSVD22[2];
    volatile Uint16 NAND4BITECC3;
    volatile Uint16 NAND4BITECC4;
    volatile Uint16 RSVD23[2];
    volatile Uint16 NAND4BITECC5;
    volatile Uint16 NAND4BITECC6;
    volatile Uint16 RSVD24[2];
    volatile Uint16 NAND4BITECC7;
    volatile Uint16 NAND4BITECC8;
    volatile Uint16 RSVD25[2];
    volatile Uint16 NANDERRADD1;
    volatile Uint16 NANDERRADD2;
    volatile Uint16 RSVD26[2];
    volatile Uint16 NANDERRADD3;
    volatile Uint16 NANDERRADD4;
    volatile Uint16 RSVD27[2];
    volatile Uint16 NANDERRVAL1;
    volatile Uint16 NANDERRVAL2;
    volatile Uint16 RSVD28[2];
    volatile Uint16 NANDERRVAL3;
    volatile Uint16 NANDERRVAL4;
} CSL_EmifRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REV */

#define CSL_EMIF_REV_MAJOR_REVISION_MASK (0xFF00u)
#define CSL_EMIF_REV_MAJOR_REVISION_SHIFT (0x0008u)
#define CSL_EMIF_REV_MAJOR_REVISION_RESETVAL (0x0002u)

#define CSL_EMIF_REV_MINOR_REVISION_MASK (0x00FFu)
#define CSL_EMIF_REV_MINOR_REVISION_SHIFT (0x0000u)
#define CSL_EMIF_REV_MINOR_REVISION_RESETVAL (0x0005u)

#define CSL_EMIF_REV_RESETVAL            (0x0205u)

/* STATUS */

#if (defined(CHIP_C5505_C5515) || defined(CHIP_C5504_C5514))

#define CSL_EMIF_STATUS_BIGENDIAN_MASK   (0x8000u)
#define CSL_EMIF_STATUS_BIGENDIAN_SHIFT  (0x000Fu)
#define CSL_EMIF_STATUS_BIGENDIAN_RESETVAL (0x0001u)
/*----BIGENDIAN Tokens----*/
#define CSL_EMIF_STATUS_BIGENDIAN_LITTLE (0x0000u)
#define CSL_EMIF_STATUS_BIGENDIAN_BIG    (0x0001u)

#endif

#define CSL_EMIF_STATUS_FULLRATE_MASK    (0x4000u)
#define CSL_EMIF_STATUS_FULLRATE_SHIFT   (0x000Eu)
#define CSL_EMIF_STATUS_FULLRATE_RESETVAL (0x0001u)
/*----FULLRATE Tokens----*/
#define CSL_EMIF_STATUS_FULLRATE_HALFRATE (0x0000u)
#define CSL_EMIF_STATUS_FULLRATE_FULLRATE (0x0001u)

#define CSL_EMIF_STATUS_MODULE_ID_MASK   (0x3FFFu)
#define CSL_EMIF_STATUS_MODULE_ID_SHIFT  (0x0000u)
#define CSL_EMIF_STATUS_MODULE_ID_RESETVAL (0x0000u)

#if (defined(CHIP_C5505_C5515) || defined(CHIP_C5504_C5514))

#define CSL_EMIF_STATUS_RESETVAL         (0xC000u)

#else

#define CSL_EMIF_STATUS_RESETVAL         (0x4000u)

#endif

/* AWCCR1 */


#define CSL_EMIF_AWCCR1_MEWC_MASK        (0x00FFu)
#define CSL_EMIF_AWCCR1_MEWC_SHIFT       (0x0000u)
#define CSL_EMIF_AWCCR1_MEWC_RESETVAL    (0x0040u)

#define CSL_EMIF_AWCCR1_RESETVAL         (0x0040u)

/* AWCCR2 */

#define CSL_EMIF_AWCCR2_WP3_MASK         (0x8000u)
#define CSL_EMIF_AWCCR2_WP3_SHIFT        (0x000Fu)
#define CSL_EMIF_AWCCR2_WP3_RESETVAL     (0x0001u)
/*----WP3 Tokens----*/
#define CSL_EMIF_AWCCR2_WP3_LOW          (0x0000u)
#define CSL_EMIF_AWCCR2_WP3_HIGH         (0x0001u)

#define CSL_EMIF_AWCCR2_WP2_MASK         (0x4000u)
#define CSL_EMIF_AWCCR2_WP2_SHIFT        (0x000Eu)
#define CSL_EMIF_AWCCR2_WP2_RESETVAL     (0x0001u)
/*----WP2 Tokens----*/
#define CSL_EMIF_AWCCR2_WP2_LOW          (0x0000u)
#define CSL_EMIF_AWCCR2_WP2_HIGH         (0x0001u)

#define CSL_EMIF_AWCCR2_WP1_MASK         (0x2000u)
#define CSL_EMIF_AWCCR2_WP1_SHIFT        (0x000Du)
#define CSL_EMIF_AWCCR2_WP1_RESETVAL     (0x0001u)
/*----WP1 Tokens----*/
#define CSL_EMIF_AWCCR2_WP1_LOW          (0x0000u)
#define CSL_EMIF_AWCCR2_WP1_HIGH         (0x0001u)

#define CSL_EMIF_AWCCR2_WP0_MASK         (0x1000u)
#define CSL_EMIF_AWCCR2_WP0_SHIFT        (0x000Cu)
#define CSL_EMIF_AWCCR2_WP0_RESETVAL     (0x0001u)
/*----WP0 Tokens----*/
#define CSL_EMIF_AWCCR2_WP0_LOW          (0x0000u)
#define CSL_EMIF_AWCCR2_WP0_HIGH         (0x0001u)


#define CSL_EMIF_AWCCR2_CS5_WAIT_MASK    (0x00C0u)
#define CSL_EMIF_AWCCR2_CS5_WAIT_SHIFT   (0x0006u)
#define CSL_EMIF_AWCCR2_CS5_WAIT_RESETVAL (0x0003u)
/*----CS5_WAIT Tokens----*/
#define CSL_EMIF_AWCCR2_CS5_WAIT_WAIT0   (0x0000u)
#define CSL_EMIF_AWCCR2_CS5_WAIT_WAIT1   (0x0001u)
#define CSL_EMIF_AWCCR2_CS5_WAIT_WAIT2   (0x0002u)
#define CSL_EMIF_AWCCR2_CS5_WAIT_WAIT3   (0x0003u)

#define CSL_EMIF_AWCCR2_CS4_WAIT_MASK    (0x0030u)
#define CSL_EMIF_AWCCR2_CS4_WAIT_SHIFT   (0x0004u)
#define CSL_EMIF_AWCCR2_CS4_WAIT_RESETVAL (0x0002u)
/*----CS4_WAIT Tokens----*/
#define CSL_EMIF_AWCCR2_CS4_WAIT_WAIT0   (0x0000u)
#define CSL_EMIF_AWCCR2_CS4_WAIT_WAIT1   (0x0001u)
#define CSL_EMIF_AWCCR2_CS4_WAIT_WAIT2   (0x0002u)
#define CSL_EMIF_AWCCR2_CS4_WAIT_WAIT3   (0x0003u)

#define CSL_EMIF_AWCCR2_CS3_WAIT_MASK    (0x000Cu)
#define CSL_EMIF_AWCCR2_CS3_WAIT_SHIFT   (0x0002u)
#define CSL_EMIF_AWCCR2_CS3_WAIT_RESETVAL (0x0001u)
/*----CS3_WAIT Tokens----*/
#define CSL_EMIF_AWCCR2_CS3_WAIT_WAIT0   (0x0000u)
#define CSL_EMIF_AWCCR2_CS3_WAIT_WAIT1   (0x0001u)
#define CSL_EMIF_AWCCR2_CS3_WAIT_WAIT2   (0x0002u)
#define CSL_EMIF_AWCCR2_CS3_WAIT_WAIT3   (0x0003u)

#define CSL_EMIF_AWCCR2_CS2_WAIT_MASK    (0x0003u)
#define CSL_EMIF_AWCCR2_CS2_WAIT_SHIFT   (0x0000u)
#define CSL_EMIF_AWCCR2_CS2_WAIT_RESETVAL (0x0000u)
/*----CS2_WAIT Tokens----*/
#define CSL_EMIF_AWCCR2_CS2_WAIT_WAIT0   (0x0000u)
#define CSL_EMIF_AWCCR2_CS2_WAIT_WAIT1   (0x0001u)
#define CSL_EMIF_AWCCR2_CS2_WAIT_WAIT2   (0x0002u)
#define CSL_EMIF_AWCCR2_CS2_WAIT_WAIT3   (0x0003u)

#define CSL_EMIF_AWCCR2_RESETVAL         (0xF0E4u)

/* SDCR1 */


#define CSL_EMIF_SDCR1_NM_MASK           (0x4000u)
#define CSL_EMIF_SDCR1_NM_SHIFT          (0x000Eu)
#define CSL_EMIF_SDCR1_NM_RESETVAL       (0x0000u)


#define CSL_EMIF_SDCR1_CL_MASK           (0x0E00u)
#define CSL_EMIF_SDCR1_CL_SHIFT          (0x0009u)
#define CSL_EMIF_SDCR1_CL_RESETVAL       (0x0003u)
/*----CL Tokens----*/
#define CSL_EMIF_SDCR1_CL_RSV0           (0x0000u)
#define CSL_EMIF_SDCR1_CL_RSV1           (0x0001u)
#define CSL_EMIF_SDCR1_CL_TWO            (0x0002u)
#define CSL_EMIF_SDCR1_CL_THREE          (0x0003u)
#define CSL_EMIF_SDCR1_CL_RSV4           (0x0004u)
#define CSL_EMIF_SDCR1_CL_RSV5           (0x0005u)
#define CSL_EMIF_SDCR1_CL_RSV6           (0x0006u)
#define CSL_EMIF_SDCR1_CL_RSV7           (0x0007u)

#define CSL_EMIF_SDCR1_BIT_11_9_LOCK_MASK (0x0100u)
#define CSL_EMIF_SDCR1_BIT_11_9_LOCK_SHIFT (0x0008u)
#define CSL_EMIF_SDCR1_BIT_11_9_LOCK_RESETVAL (0x0000u)
/*----BIT_11_9_LOCK Tokens----*/
#define CSL_EMIF_SDCR1_BIT_11_9_LOCK_NOWRITES (0x0000u)
#define CSL_EMIF_SDCR1_BIT_11_9_LOCK_WRITES (0x0001u)


#define CSL_EMIF_SDCR1_IBANK_MASK        (0x0070u)
#define CSL_EMIF_SDCR1_IBANK_SHIFT       (0x0004u)
#define CSL_EMIF_SDCR1_IBANK_RESETVAL    (0x0002u)
/*----IBANK Tokens----*/
#define CSL_EMIF_SDCR1_IBANK_ONE         (0x0000u)
#define CSL_EMIF_SDCR1_IBANK_TWO         (0x0001u)
#define CSL_EMIF_SDCR1_IBANK_FOUR        (0x0002u)
#define CSL_EMIF_SDCR1_IBANK_RSV3        (0x0003u)
#define CSL_EMIF_SDCR1_IBANK_RSV4        (0x0004u)
#define CSL_EMIF_SDCR1_IBANK_RSV5        (0x0005u)
#define CSL_EMIF_SDCR1_IBANK_RSV6        (0x0006u)
#define CSL_EMIF_SDCR1_IBANK_RSV7        (0x0007u)

#define CSL_EMIF_SDCR1_EBANK_MASK        (0x0008u)
#define CSL_EMIF_SDCR1_EBANK_SHIFT       (0x0003u)
#define CSL_EMIF_SDCR1_EBANK_RESETVAL    (0x0000u)
/*----EBANK Tokens----*/
#define CSL_EMIF_SDCR1_EBANK_ONE         (0x0000u)
#define CSL_EMIF_SDCR1_EBANK_TWO         (0x0001u)

#define CSL_EMIF_SDCR1_PAGESIZE_MASK     (0x0007u)
#define CSL_EMIF_SDCR1_PAGESIZE_SHIFT    (0x0000u)
#define CSL_EMIF_SDCR1_PAGESIZE_RESETVAL (0x0000u)
/*----PAGESIZE Tokens----*/
#define CSL_EMIF_SDCR1_PAGESIZE_EIGHT    (0x0000u)
#define CSL_EMIF_SDCR1_PAGESIZE_NINE     (0x0001u)
#define CSL_EMIF_SDCR1_PAGESIZE_TEN      (0x0002u)
#define CSL_EMIF_SDCR1_PAGESIZE_ELEVEN   (0x0003u)
#define CSL_EMIF_SDCR1_PAGESIZE_RSV4     (0x0004u)
#define CSL_EMIF_SDCR1_PAGESIZE_RSV5     (0x0005u)
#define CSL_EMIF_SDCR1_PAGESIZE_RSV6     (0x0006u)
#define CSL_EMIF_SDCR1_PAGESIZE_RSV7     (0x0007u)

#define CSL_EMIF_SDCR1_RESETVAL          (0x0620u)

/* SDCR2 */

#define CSL_EMIF_SDCR2_SR_MASK           (0x8000u)
#define CSL_EMIF_SDCR2_SR_SHIFT          (0x000Fu)
#define CSL_EMIF_SDCR2_SR_RESETVAL       (0x0000u)
/*----SR Tokens----*/
#define CSL_EMIF_SDCR2_SR_EXIT           (0x0000u)
#define CSL_EMIF_SDCR2_SR_ENTER          (0x0001u)

#define CSL_EMIF_SDCR2_PD_MASK           (0x4000u)
#define CSL_EMIF_SDCR2_PD_SHIFT          (0x000Eu)
#define CSL_EMIF_SDCR2_PD_RESETVAL       (0x0000u)
/*----PD Tokens----*/
#define CSL_EMIF_SDCR2_PD_EXIT           (0x0000u)
#define CSL_EMIF_SDCR2_PD_ENTER          (0x0001u)

#define CSL_EMIF_SDCR2_PDWR_MASK         (0x2000u)
#define CSL_EMIF_SDCR2_PDWR_SHIFT        (0x000Du)
#define CSL_EMIF_SDCR2_PDWR_RESETVAL     (0x0000u)
/*----PDWR Tokens----*/
#define CSL_EMIF_SDCR2_PDWR_NOREFR       (0x0000u)
#define CSL_EMIF_SDCR2_PDWR_REFR         (0x0001u)


#define CSL_EMIF_SDCR2_PASR_MASK         (0x0380u)
#define CSL_EMIF_SDCR2_PASR_SHIFT        (0x0007u)
#define CSL_EMIF_SDCR2_PASR_RESETVAL     (0x0000u)
/*----PASR Tokens----*/
#define CSL_EMIF_SDCR2_PASR_FOUR         (0x0000u)
#define CSL_EMIF_SDCR2_PASR_TWO          (0x0001u)
#define CSL_EMIF_SDCR2_PASR_ONE          (0x0002u)
#define CSL_EMIF_SDCR2_PASR_RSV3         (0x0003u)
#define CSL_EMIF_SDCR2_PASR_RSV4         (0x0004u)
#define CSL_EMIF_SDCR2_PASR_HALF         (0x0005u)
#define CSL_EMIF_SDCR2_PASR_QUARTER      (0x0006u)
#define CSL_EMIF_SDCR2_PASR_RSV7         (0x0007u)

#define CSL_EMIF_SDCR2_ROWSIZE_MASK      (0x0070u)
#define CSL_EMIF_SDCR2_ROWSIZE_SHIFT     (0x0004u)
#define CSL_EMIF_SDCR2_ROWSIZE_RESETVAL  (0x0000u)
/*----ROWSIZE Tokens----*/
#define CSL_EMIF_SDCR2_ROWSIZE_NINE      (0x0000u)
#define CSL_EMIF_SDCR2_ROWSIZE_TEN       (0x0001u)
#define CSL_EMIF_SDCR2_ROWSIZE_ELEVEN    (0x0002u)
#define CSL_EMIF_SDCR2_ROWSIZE_TWELVE    (0x0003u)
#define CSL_EMIF_SDCR2_ROWSIZE_THIRTEEN  (0x0004u)
#define CSL_EMIF_SDCR2_ROWSIZE_FOURTEEN  (0x0005u)
#define CSL_EMIF_SDCR2_ROWSIZE_RSV6      (0x0006u)
#define CSL_EMIF_SDCR2_ROWSIZE_RSV7      (0x0007u)

#define CSL_EMIF_SDCR2_IBANK_POS_MASK    (0x0008u)
#define CSL_EMIF_SDCR2_IBANK_POS_SHIFT   (0x0003u)
#define CSL_EMIF_SDCR2_IBANK_POS_RESETVAL (0x0000u)

#define CSL_EMIF_SDCR2_SDRAM_DRIVE_MASK  (0x0006u)
#define CSL_EMIF_SDCR2_SDRAM_DRIVE_SHIFT (0x0001u)
#define CSL_EMIF_SDCR2_SDRAM_DRIVE_RESETVAL (0x0000u)
/*----SDRAM_DRIVE Tokens----*/
#define CSL_EMIF_SDCR2_SDRAM_DRIVE_FULL  (0x0000u)
#define CSL_EMIF_SDCR2_SDRAM_DRIVE_HALF  (0x0001u)
#define CSL_EMIF_SDCR2_SDRAM_DRIVE_QUARTER (0x0002u)
#define CSL_EMIF_SDCR2_SDRAM_DRIVE_EIGTH (0x0003u)

#define CSL_EMIF_SDCR2_BIT_9_1_LOCK_MASK (0x0001u)
#define CSL_EMIF_SDCR2_BIT_9_1_LOCK_SHIFT (0x0000u)
#define CSL_EMIF_SDCR2_BIT_9_1_LOCK_RESETVAL (0x0000u)
/*----BIT_9_1_LOCK Tokens----*/
#define CSL_EMIF_SDCR2_BIT_9_1_LOCK_NOWRITES (0x0000u)
#define CSL_EMIF_SDCR2_BIT_9_1_LOCK_WRITES (0x0001u)

#define CSL_EMIF_SDCR2_RESETVAL          (0x0000u)

/* SDRCR */


#define CSL_EMIF_SDRCR_REFRATE_MASK      (0x1FFFu)
#define CSL_EMIF_SDRCR_REFRATE_SHIFT     (0x0000u)
#define CSL_EMIF_SDRCR_REFRATE_RESETVAL  (0x007Du)

#define CSL_EMIF_SDRCR_RESETVAL          (0x007Du)

/* ACS2CR1 */

#define CSL_EMIF_ACS2CR1_RSETUPLSB_MASK  (0xE000u)
#define CSL_EMIF_ACS2CR1_RSETUPLSB_SHIFT (0x000Du)
#define CSL_EMIF_ACS2CR1_RSETUPLSB_RESETVAL (0x0003u)

#define CSL_EMIF_ACS2CR1_RSTROBE_MASK    (0x1F80u)
#define CSL_EMIF_ACS2CR1_RSTROBE_SHIFT   (0x0007u)
#define CSL_EMIF_ACS2CR1_RSTROBE_RESETVAL (0x003Fu)

#define CSL_EMIF_ACS2CR1_RHOLD_MASK      (0x0070u)
#define CSL_EMIF_ACS2CR1_RHOLD_SHIFT     (0x0004u)
#define CSL_EMIF_ACS2CR1_RHOLD_RESETVAL  (0x0007u)

#define CSL_EMIF_ACS2CR1_TA_MASK         (0x000Cu)
#define CSL_EMIF_ACS2CR1_TA_SHIFT        (0x0002u)
#define CSL_EMIF_ACS2CR1_TA_RESETVAL     (0x0003u)

#define CSL_EMIF_ACS2CR1_ASIZE_MASK      (0x0003u)
#define CSL_EMIF_ACS2CR1_ASIZE_SHIFT     (0x0000u)
#define CSL_EMIF_ACS2CR1_ASIZE_RESETVAL  (0x0000u)
/*----ASIZE Tokens----*/
#define CSL_EMIF_ACS2CR1_ASIZE_EIGHTBIT  (0x0000u)
#define CSL_EMIF_ACS2CR1_ASIZE_SIXTEENBIT (0x0001u)
#define CSL_EMIF_ACS2CR1_ASIZE_RSV2      (0x0002u)
#define CSL_EMIF_ACS2CR1_ASIZE_RSV3      (0x0003u)

#define CSL_EMIF_ACS2CR1_RESETVAL        (0x7FFCu)

/* ACS2CR2 */

#define CSL_EMIF_ACS2CR2_SS_MASK         (0x8000u)
#define CSL_EMIF_ACS2CR2_SS_SHIFT        (0x000Fu)
#define CSL_EMIF_ACS2CR2_SS_RESETVAL     (0x0000u)
/*----SS Tokens----*/
#define CSL_EMIF_ACS2CR2_SS_ENABLED      (0x0001u)
#define CSL_EMIF_ACS2CR2_SS_DISABLED     (0x0000u)

#define CSL_EMIF_ACS2CR2_EW_MASK         (0x4000u)
#define CSL_EMIF_ACS2CR2_EW_SHIFT        (0x000Eu)
#define CSL_EMIF_ACS2CR2_EW_RESETVAL     (0x0000u)
/*----EW Tokens----*/
#define CSL_EMIF_ACS2CR2_EW_DISABLED     (0x0000u)
#define CSL_EMIF_ACS2CR2_EW_ENABLED      (0x0001u)

#define CSL_EMIF_ACS2CR2_WSETUP_MASK     (0x3C00u)
#define CSL_EMIF_ACS2CR2_WSETUP_SHIFT    (0x000Au)
#define CSL_EMIF_ACS2CR2_WSETUP_RESETVAL (0x000Fu)

#define CSL_EMIF_ACS2CR2_WSTROBE_MASK    (0x03F0u)
#define CSL_EMIF_ACS2CR2_WSTROBE_SHIFT   (0x0004u)
#define CSL_EMIF_ACS2CR2_WSTROBE_RESETVAL (0x003Fu)

#define CSL_EMIF_ACS2CR2_WHOLD_MASK      (0x000Eu)
#define CSL_EMIF_ACS2CR2_WHOLD_SHIFT     (0x0001u)
#define CSL_EMIF_ACS2CR2_WHOLD_RESETVAL  (0x0007u)

#define CSL_EMIF_ACS2CR2_RSETUPMSB_MASK  (0x0001u)
#define CSL_EMIF_ACS2CR2_RSETUPMSB_SHIFT (0x0000u)
#define CSL_EMIF_ACS2CR2_RSETUPMSB_RESETVAL (0x0001u)

#define CSL_EMIF_ACS2CR2_RESETVAL        (0x3FFFu)

/* ACS3CR1 */

#define CSL_EMIF_ACS3CR1_RSETUPLSB_MASK  (0xE000u)
#define CSL_EMIF_ACS3CR1_RSETUPLSB_SHIFT (0x000Du)
#define CSL_EMIF_ACS3CR1_RSETUPLSB_RESETVAL (0x0003u)

#define CSL_EMIF_ACS3CR1_RSTROBE_MASK    (0x1F80u)
#define CSL_EMIF_ACS3CR1_RSTROBE_SHIFT   (0x0007u)
#define CSL_EMIF_ACS3CR1_RSTROBE_RESETVAL (0x003Fu)

#define CSL_EMIF_ACS3CR1_RHOLD_MASK      (0x0070u)
#define CSL_EMIF_ACS3CR1_RHOLD_SHIFT     (0x0004u)
#define CSL_EMIF_ACS3CR1_RHOLD_RESETVAL  (0x0007u)

#define CSL_EMIF_ACS3CR1_TA_MASK         (0x000Cu)
#define CSL_EMIF_ACS3CR1_TA_SHIFT        (0x0002u)
#define CSL_EMIF_ACS3CR1_TA_RESETVAL     (0x0003u)

#define CSL_EMIF_ACS3CR1_ASIZE_MASK      (0x0003u)
#define CSL_EMIF_ACS3CR1_ASIZE_SHIFT     (0x0000u)
#define CSL_EMIF_ACS3CR1_ASIZE_RESETVAL  (0x0001u)
/*----ASIZE Tokens----*/
#define CSL_EMIF_ACS3CR1_ASIZE_EIGHTBIT  (0x0000u)
#define CSL_EMIF_ACS3CR1_ASIZE_SIXTEENBIT (0x0001u)
#define CSL_EMIF_ACS3CR1_ASIZE_RSV2      (0x0002u)
#define CSL_EMIF_ACS3CR1_ASIZE_RSV3      (0x0003u)

#define CSL_EMIF_ACS3CR1_RESETVAL        (0x7FFDu)

/* ACS3CR2 */

#define CSL_EMIF_ACS3CR2_SS_MASK         (0x8000u)
#define CSL_EMIF_ACS3CR2_SS_SHIFT        (0x000Fu)
#define CSL_EMIF_ACS3CR2_SS_RESETVAL     (0x0000u)
/*----SS Tokens----*/
#define CSL_EMIF_ACS3CR2_SS_ENABLED      (0x0001u)
#define CSL_EMIF_ACS3CR2_SS_DISABLED     (0x0000u)

#define CSL_EMIF_ACS3CR2_EW_MASK         (0x4000u)
#define CSL_EMIF_ACS3CR2_EW_SHIFT        (0x000Eu)
#define CSL_EMIF_ACS3CR2_EW_RESETVAL     (0x0000u)
/*----EW Tokens----*/
#define CSL_EMIF_ACS3CR2_EW_DISABLED     (0x0000u)
#define CSL_EMIF_ACS3CR2_EW_ENABLED      (0x0001u)

#define CSL_EMIF_ACS3CR2_WSETUP_MASK     (0x3C00u)
#define CSL_EMIF_ACS3CR2_WSETUP_SHIFT    (0x000Au)
#define CSL_EMIF_ACS3CR2_WSETUP_RESETVAL (0x000Fu)

#define CSL_EMIF_ACS3CR2_WSTROBE_MASK    (0x03F0u)
#define CSL_EMIF_ACS3CR2_WSTROBE_SHIFT   (0x0004u)
#define CSL_EMIF_ACS3CR2_WSTROBE_RESETVAL (0x003Fu)

#define CSL_EMIF_ACS3CR2_WHOLD_MASK      (0x000Eu)
#define CSL_EMIF_ACS3CR2_WHOLD_SHIFT     (0x0001u)
#define CSL_EMIF_ACS3CR2_WHOLD_RESETVAL  (0x0007u)

#define CSL_EMIF_ACS3CR2_RSETUPMSB_MASK  (0x0001u)
#define CSL_EMIF_ACS3CR2_RSETUPMSB_SHIFT (0x0000u)
#define CSL_EMIF_ACS3CR2_RSETUPMSB_RESETVAL (0x0001u)

#define CSL_EMIF_ACS3CR2_RESETVAL        (0x3FFFu)

/* ACS4CR1 */

#define CSL_EMIF_ACS4CR1_RSETUPLSB_MASK  (0xE000u)
#define CSL_EMIF_ACS4CR1_RSETUPLSB_SHIFT (0x000Du)
#define CSL_EMIF_ACS4CR1_RSETUPLSB_RESETVAL (0x0003u)

#define CSL_EMIF_ACS4CR1_RSTROBE_MASK    (0x1F80u)
#define CSL_EMIF_ACS4CR1_RSTROBE_SHIFT   (0x0007u)
#define CSL_EMIF_ACS4CR1_RSTROBE_RESETVAL (0x003Fu)

#define CSL_EMIF_ACS4CR1_RHOLD_MASK      (0x0070u)
#define CSL_EMIF_ACS4CR1_RHOLD_SHIFT     (0x0004u)
#define CSL_EMIF_ACS4CR1_RHOLD_RESETVAL  (0x0007u)

#define CSL_EMIF_ACS4CR1_TA_MASK         (0x000Cu)
#define CSL_EMIF_ACS4CR1_TA_SHIFT        (0x0002u)
#define CSL_EMIF_ACS4CR1_TA_RESETVAL     (0x0003u)

#define CSL_EMIF_ACS4CR1_ASIZE_MASK      (0x0003u)
#define CSL_EMIF_ACS4CR1_ASIZE_SHIFT     (0x0000u)
#define CSL_EMIF_ACS4CR1_ASIZE_RESETVAL  (0x0000u)
/*----ASIZE Tokens----*/
#define CSL_EMIF_ACS4CR1_ASIZE_EIGHTBIT  (0x0000u)
#define CSL_EMIF_ACS4CR1_ASIZE_SIXTEENBIT (0x0001u)
#define CSL_EMIF_ACS4CR1_ASIZE_RSV2      (0x0002u)
#define CSL_EMIF_ACS4CR1_ASIZE_RSV3      (0x0003u)

#define CSL_EMIF_ACS4CR1_RESETVAL        (0x7FFCu)

/* ACS4CR2 */

#define CSL_EMIF_ACS4CR2_SS_MASK         (0x8000u)
#define CSL_EMIF_ACS4CR2_SS_SHIFT        (0x000Fu)
#define CSL_EMIF_ACS4CR2_SS_RESETVAL     (0x0000u)
/*----SS Tokens----*/
#define CSL_EMIF_ACS4CR2_SS_ENABLED      (0x0001u)
#define CSL_EMIF_ACS4CR2_SS_DISABLED     (0x0000u)

#define CSL_EMIF_ACS4CR2_EW_MASK         (0x4000u)
#define CSL_EMIF_ACS4CR2_EW_SHIFT        (0x000Eu)
#define CSL_EMIF_ACS4CR2_EW_RESETVAL     (0x0000u)
/*----EW Tokens----*/
#define CSL_EMIF_ACS4CR2_EW_DISABLED     (0x0000u)
#define CSL_EMIF_ACS4CR2_EW_ENABLED      (0x0001u)

#define CSL_EMIF_ACS4CR2_WSETUP_MASK     (0x3C00u)
#define CSL_EMIF_ACS4CR2_WSETUP_SHIFT    (0x000Au)
#define CSL_EMIF_ACS4CR2_WSETUP_RESETVAL (0x000Fu)

#define CSL_EMIF_ACS4CR2_WSTROBE_MASK    (0x03F0u)
#define CSL_EMIF_ACS4CR2_WSTROBE_SHIFT   (0x0004u)
#define CSL_EMIF_ACS4CR2_WSTROBE_RESETVAL (0x003Fu)

#define CSL_EMIF_ACS4CR2_WHOLD_MASK      (0x000Eu)
#define CSL_EMIF_ACS4CR2_WHOLD_SHIFT     (0x0001u)
#define CSL_EMIF_ACS4CR2_WHOLD_RESETVAL  (0x0007u)

#define CSL_EMIF_ACS4CR2_RSETUPMSB_MASK  (0x0001u)
#define CSL_EMIF_ACS4CR2_RSETUPMSB_SHIFT (0x0000u)
#define CSL_EMIF_ACS4CR2_RSETUPMSB_RESETVAL (0x0001u)

#define CSL_EMIF_ACS4CR2_RESETVAL        (0x3FFFu)

/* ACS5CR1 */

#define CSL_EMIF_ACS5CR1_RSETUPLSB_MASK  (0xE000u)
#define CSL_EMIF_ACS5CR1_RSETUPLSB_SHIFT (0x000Du)
#define CSL_EMIF_ACS5CR1_RSETUPLSB_RESETVAL (0x0003u)

#define CSL_EMIF_ACS5CR1_RSTROBE_MASK    (0x1F80u)
#define CSL_EMIF_ACS5CR1_RSTROBE_SHIFT   (0x0007u)
#define CSL_EMIF_ACS5CR1_RSTROBE_RESETVAL (0x003Fu)

#define CSL_EMIF_ACS5CR1_RHOLD_MASK      (0x0070u)
#define CSL_EMIF_ACS5CR1_RHOLD_SHIFT     (0x0004u)
#define CSL_EMIF_ACS5CR1_RHOLD_RESETVAL  (0x0007u)

#define CSL_EMIF_ACS5CR1_TA_MASK         (0x000Cu)
#define CSL_EMIF_ACS5CR1_TA_SHIFT        (0x0002u)
#define CSL_EMIF_ACS5CR1_TA_RESETVAL     (0x0003u)

#define CSL_EMIF_ACS5CR1_ASIZE_MASK      (0x0003u)
#define CSL_EMIF_ACS5CR1_ASIZE_SHIFT     (0x0000u)
#define CSL_EMIF_ACS5CR1_ASIZE_RESETVAL  (0x0001u)
/*----ASIZE Tokens----*/
#define CSL_EMIF_ACS5CR1_ASIZE_EIGHTBIT  (0x0000u)
#define CSL_EMIF_ACS5CR1_ASIZE_SIXTEENBIT (0x0001u)
#define CSL_EMIF_ACS5CR1_ASIZE_RSV2      (0x0002u)
#define CSL_EMIF_ACS5CR1_ASIZE_RSV3      (0x0003u)

#define CSL_EMIF_ACS5CR1_RESETVAL        (0x7FFDu)

/* ACS5CR2 */

#define CSL_EMIF_ACS5CR2_SS_MASK         (0x8000u)
#define CSL_EMIF_ACS5CR2_SS_SHIFT        (0x000Fu)
#define CSL_EMIF_ACS5CR2_SS_RESETVAL     (0x0000u)
/*----SS Tokens----*/
#define CSL_EMIF_ACS5CR2_SS_ENABLED      (0x0001u)
#define CSL_EMIF_ACS5CR2_SS_DISABLED     (0x0000u)

#define CSL_EMIF_ACS5CR2_EW_MASK         (0x4000u)
#define CSL_EMIF_ACS5CR2_EW_SHIFT        (0x000Eu)
#define CSL_EMIF_ACS5CR2_EW_RESETVAL     (0x0000u)
/*----EW Tokens----*/
#define CSL_EMIF_ACS5CR2_EW_DISABLED     (0x0000u)
#define CSL_EMIF_ACS5CR2_EW_ENABLED      (0x0001u)

#define CSL_EMIF_ACS5CR2_WSETUP_MASK     (0x3C00u)
#define CSL_EMIF_ACS5CR2_WSETUP_SHIFT    (0x000Au)
#define CSL_EMIF_ACS5CR2_WSETUP_RESETVAL (0x000Fu)

#define CSL_EMIF_ACS5CR2_WSTROBE_MASK    (0x03F0u)
#define CSL_EMIF_ACS5CR2_WSTROBE_SHIFT   (0x0004u)
#define CSL_EMIF_ACS5CR2_WSTROBE_RESETVAL (0x003Fu)

#define CSL_EMIF_ACS5CR2_WHOLD_MASK      (0x000Eu)
#define CSL_EMIF_ACS5CR2_WHOLD_SHIFT     (0x0001u)
#define CSL_EMIF_ACS5CR2_WHOLD_RESETVAL  (0x0007u)

#define CSL_EMIF_ACS5CR2_RSETUPMSB_MASK  (0x0001u)
#define CSL_EMIF_ACS5CR2_RSETUPMSB_SHIFT (0x0000u)
#define CSL_EMIF_ACS5CR2_RSETUPMSB_RESETVAL (0x0001u)

#define CSL_EMIF_ACS5CR2_RESETVAL        (0x3FFFu)

/* SDTIMR1 */

#define CSL_EMIF_SDTIMR1_TRAS_MASK       (0xF000u)
#define CSL_EMIF_SDTIMR1_TRAS_SHIFT      (0x000Cu)
#define CSL_EMIF_SDTIMR1_TRAS_RESETVAL   (0x0005u)

#define CSL_EMIF_SDTIMR1_TRC_MASK        (0x0F00u)
#define CSL_EMIF_SDTIMR1_TRC_SHIFT       (0x0008u)
#define CSL_EMIF_SDTIMR1_TRC_RESETVAL    (0x0008u)


#define CSL_EMIF_SDTIMR1_TRRD_MASK       (0x0070u)
#define CSL_EMIF_SDTIMR1_TRRD_SHIFT      (0x0004u)
#define CSL_EMIF_SDTIMR1_TRRD_RESETVAL   (0x0002u)


#define CSL_EMIF_SDTIMR1_RESETVAL        (0x5820u)

/* SDSRETR */


#define CSL_EMIF_SDSRETR_TXS_MASK        (0x001Fu)
#define CSL_EMIF_SDSRETR_TXS_SHIFT       (0x0000u)
#define CSL_EMIF_SDSRETR_TXS_RESETVAL    (0x0005u)

#define CSL_EMIF_SDSRETR_RESETVAL        (0x0005u)

/* EIRR */


#define CSL_EMIF_EIRR_WR_MASK            (0x003Cu)
#define CSL_EMIF_EIRR_WR_SHIFT           (0x0002u)
#define CSL_EMIF_EIRR_WR_RESETVAL        (0x0000u)

#define CSL_EMIF_EIRR_LT_MASK            (0x0002u)
#define CSL_EMIF_EIRR_LT_SHIFT           (0x0001u)
#define CSL_EMIF_EIRR_LT_RESETVAL        (0x0000u)

#define CSL_EMIF_EIRR_AT_MASK            (0x0001u)
#define CSL_EMIF_EIRR_AT_SHIFT           (0x0000u)
#define CSL_EMIF_EIRR_AT_RESETVAL        (0x0000u)

#define CSL_EMIF_EIRR_RESETVAL           (0x0000u)

/* EIMR */


#define CSL_EMIF_EIMR_WRMASKED_MASK      (0x003Cu)
#define CSL_EMIF_EIMR_WRMASKED_SHIFT     (0x0002u)
#define CSL_EMIF_EIMR_WRMASKED_RESETVAL  (0x0000u)

#define CSL_EMIF_EIMR_LTMASKED_MASK      (0x0002u)
#define CSL_EMIF_EIMR_LTMASKED_SHIFT     (0x0001u)
#define CSL_EMIF_EIMR_LTMASKED_RESETVAL  (0x0000u)

#define CSL_EMIF_EIMR_ATMASKED_MASK      (0x0001u)
#define CSL_EMIF_EIMR_ATMASKED_SHIFT     (0x0000u)
#define CSL_EMIF_EIMR_ATMASKED_RESETVAL  (0x0000u)

#define CSL_EMIF_EIMR_RESETVAL           (0x0000u)

/* EIMSR */


#define CSL_EMIF_EIMSR_WRMASKSET_MASK    (0x003Cu)
#define CSL_EMIF_EIMSR_WRMASKSET_SHIFT   (0x0002u)
#define CSL_EMIF_EIMSR_WRMASKSET_RESETVAL (0x0000u)

#define CSL_EMIF_EIMSR_LTMASKSET_MASK    (0x0002u)
#define CSL_EMIF_EIMSR_LTMASKSET_SHIFT   (0x0001u)
#define CSL_EMIF_EIMSR_LTMASKSET_RESETVAL (0x0000u)

#define CSL_EMIF_EIMSR_ATMASKSET_MASK    (0x0001u)
#define CSL_EMIF_EIMSR_ATMASKSET_SHIFT   (0x0000u)
#define CSL_EMIF_EIMSR_ATMASKSET_RESETVAL (0x0000u)

#define CSL_EMIF_EIMSR_RESETVAL          (0x0000u)

/* EIMCR */


#define CSL_EMIF_EIMCR_WRMASKCLR_MASK    (0x003Cu)
#define CSL_EMIF_EIMCR_WRMASKCLR_SHIFT   (0x0002u)
#define CSL_EMIF_EIMCR_WRMASKCLR_RESETVAL (0x0000u)

#define CSL_EMIF_EIMCR_LTMASKCLR_MASK    (0x0002u)
#define CSL_EMIF_EIMCR_LTMASKCLR_SHIFT   (0x0001u)
#define CSL_EMIF_EIMCR_LTMASKCLR_RESETVAL (0x0000u)

#define CSL_EMIF_EIMCR_ATMASKCLR_MASK    (0x0001u)
#define CSL_EMIF_EIMCR_ATMASKCLR_SHIFT   (0x0000u)
#define CSL_EMIF_EIMCR_ATMASKCLR_RESETVAL (0x0000u)

#define CSL_EMIF_EIMCR_RESETVAL          (0x0000u)

/* NANDFCR */


#define CSL_EMIF_NANDFCR_ADDR_CALC_ST_MASK (0x2000u)
#define CSL_EMIF_NANDFCR_ADDR_CALC_ST_SHIFT (0x000Du)
#define CSL_EMIF_NANDFCR_ADDR_CALC_ST_RESETVAL (0x0000u)

#define CSL_EMIF_NANDFCR_4BIT_ECC_START_MASK (0x1000u)
#define CSL_EMIF_NANDFCR_4BIT_ECC_START_SHIFT (0x000Cu)
#define CSL_EMIF_NANDFCR_4BIT_ECC_START_RESETVAL (0x0000u)

#define CSL_EMIF_NANDFCR_CS5_ECC_START_MASK (0x0800u)
#define CSL_EMIF_NANDFCR_CS5_ECC_START_SHIFT (0x000Bu)
#define CSL_EMIF_NANDFCR_CS5_ECC_START_RESETVAL (0x0000u)

#define CSL_EMIF_NANDFCR_CS4_ECC_START_MASK (0x0400u)
#define CSL_EMIF_NANDFCR_CS4_ECC_START_SHIFT (0x000Au)
#define CSL_EMIF_NANDFCR_CS4_ECC_START_RESETVAL (0x0000u)

#define CSL_EMIF_NANDFCR_CS3_ECC_START_MASK (0x0200u)
#define CSL_EMIF_NANDFCR_CS3_ECC_START_SHIFT (0x0009u)
#define CSL_EMIF_NANDFCR_CS3_ECC_START_RESETVAL (0x0000u)

#define CSL_EMIF_NANDFCR_CS2_ECC_START_MASK (0x0100u)
#define CSL_EMIF_NANDFCR_CS2_ECC_START_SHIFT (0x0008u)
#define CSL_EMIF_NANDFCR_CS2_ECC_START_RESETVAL (0x0000u)


#define CSL_EMIF_NANDFCR_4BIT_ECC_SEL_MASK (0x0030u)
#define CSL_EMIF_NANDFCR_4BIT_ECC_SEL_SHIFT (0x0004u)
#define CSL_EMIF_NANDFCR_4BIT_ECC_SEL_RESETVAL (0x0000u)
/*----4BIT_ECC_SEL Tokens----*/
#define CSL_EMIF_NANDFCR_4BIT_ECC_SEL_CS2 (0x0000u)
#define CSL_EMIF_NANDFCR_4BIT_ECC_SEL_CS3 (0x0001u)
#define CSL_EMIF_NANDFCR_4BIT_ECC_SEL_CS4 (0x0002u)
#define CSL_EMIF_NANDFCR_4BIT_ECC_SEL_CS5 (0x0003u)

#define CSL_EMIF_NANDFCR_CS5_USE_NAND_MASK (0x0008u)
#define CSL_EMIF_NANDFCR_CS5_USE_NAND_SHIFT (0x0003u)
#define CSL_EMIF_NANDFCR_CS5_USE_NAND_RESETVAL (0x0000u)
/*----CS5_USE_NAND Tokens----*/
#define CSL_EMIF_NANDFCR_CS5_USE_NAND_NONAND (0x0000u)
#define CSL_EMIF_NANDFCR_CS5_USE_NAND_NAND (0x0001u)

#define CSL_EMIF_NANDFCR_CS4_USE_NAND_MASK (0x0004u)
#define CSL_EMIF_NANDFCR_CS4_USE_NAND_SHIFT (0x0002u)
#define CSL_EMIF_NANDFCR_CS4_USE_NAND_RESETVAL (0x0000u)
/*----CS4_USE_NAND Tokens----*/
#define CSL_EMIF_NANDFCR_CS4_USE_NAND_NONAND (0x0000u)
#define CSL_EMIF_NANDFCR_CS4_USE_NAND_NAND (0x0001u)

#define CSL_EMIF_NANDFCR_CS3_USE_NAND_MASK (0x0002u)
#define CSL_EMIF_NANDFCR_CS3_USE_NAND_SHIFT (0x0001u)
#define CSL_EMIF_NANDFCR_CS3_USE_NAND_RESETVAL (0x0000u)
/*----CS3_USE_NAND Tokens----*/
#define CSL_EMIF_NANDFCR_CS3_USE_NAND_NONAND (0x0000u)
#define CSL_EMIF_NANDFCR_CS3_USE_NAND_NAND (0x0001u)

#define CSL_EMIF_NANDFCR_CS2_USE_NAND_MASK (0x0001u)
#define CSL_EMIF_NANDFCR_CS2_USE_NAND_SHIFT (0x0000u)
#define CSL_EMIF_NANDFCR_CS2_USE_NAND_RESETVAL (0x0001u)
/*----CS2_USE_NAND Tokens----*/
#define CSL_EMIF_NANDFCR_CS2_USE_NAND_NONAND (0x0000u)
#define CSL_EMIF_NANDFCR_CS2_USE_NAND_NAND (0x0001u)

#define CSL_EMIF_NANDFCR_RESETVAL        (0x0001u)

/* NANDFSR1 */


#define CSL_EMIF_NANDFSR1_CORRSTATE_MASK (0x0F00u)
#define CSL_EMIF_NANDFSR1_CORRSTATE_SHIFT (0x0008u)
#define CSL_EMIF_NANDFSR1_CORRSTATE_RESETVAL (0x0000u)
/*----CORRSTATE Tokens----*/
#define CSL_EMIF_NANDFSR1_CORRSTATE_NOERR (0x0000u)
#define CSL_EMIF_NANDFSR1_CORRSTATE_ERROR (0x0001u)
#define CSL_EMIF_NANDFSR1_CORRSTATE_COMP89 (0x0002u)
#define CSL_EMIF_NANDFSR1_CORRSTATE_COMP (0x0003u)
#define CSL_EMIF_NANDFSR1_CORRSTATE_RSV4 (0x0004u)
#define CSL_EMIF_NANDFSR1_CORRSTATE_CALCNUMERR (0x0005u)
#define CSL_EMIF_NANDFSR1_CORRSTATE_PREP (0x0006u)
#define CSL_EMIF_NANDFSR1_CORRSTATE_PREP2 (0x0007u)
#define CSL_EMIF_NANDFSR1_CORRSTATE_SEARCH (0x0008u)
#define CSL_EMIF_NANDFSR1_CORRSTATE_RSV9 (0x0009u)
#define CSL_EMIF_NANDFSR1_CORRSTATE_RSV10 (0x000au)
#define CSL_EMIF_NANDFSR1_CORRSTATE_RSV11 (0x000bu)
#define CSL_EMIF_NANDFSR1_CORRSTATE_CALCERR (0x000cu)
#define CSL_EMIF_NANDFSR1_CORRSTATE_CALCERR2 (0x000du)
#define CSL_EMIF_NANDFSR1_CORRSTATE_CALCERR3 (0x000eu)
#define CSL_EMIF_NANDFSR1_CORRSTATE_CALCERR4 (0x000fu)


#define CSL_EMIF_NANDFSR1_WAITSTAT_MASK  (0x000Fu)
#define CSL_EMIF_NANDFSR1_WAITSTAT_SHIFT (0x0000u)
#define CSL_EMIF_NANDFSR1_WAITSTAT_RESETVAL (0x0000u)

#define CSL_EMIF_NANDFSR1_RESETVAL       (0x0000u)

/* NANDFSR2 */


#define CSL_EMIF_NANDFSR2_ERRNUM_MASK    (0x0003u)
#define CSL_EMIF_NANDFSR2_ERRNUM_SHIFT   (0x0000u)
#define CSL_EMIF_NANDFSR2_ERRNUM_RESETVAL (0x0000u)
/*----ERRNUM Tokens----*/
#define CSL_EMIF_NANDFSR2_ERRNUM_ERR1    (0x0000u)
#define CSL_EMIF_NANDFSR2_ERRNUM_ERR2    (0x0001u)
#define CSL_EMIF_NANDFSR2_ERRNUM_ERR3    (0x0002u)
#define CSL_EMIF_NANDFSR2_ERRNUM_ERR4    (0x0003u)

#define CSL_EMIF_NANDFSR2_RESETVAL       (0x0000u)

/* PAGEMODCTRL1 */

#define CSL_EMIF_PAGEMODCTRL1_CS3_PAGE_DELAY_MASK (0xFC00u)
#define CSL_EMIF_PAGEMODCTRL1_CS3_PAGE_DELAY_SHIFT (0x000Au)
#define CSL_EMIF_PAGEMODCTRL1_CS3_PAGE_DELAY_RESETVAL (0x003Fu)

#define CSL_EMIF_PAGEMODCTRL1_CS3_PAGE_SIZE_MASK (0x0200u)
#define CSL_EMIF_PAGEMODCTRL1_CS3_PAGE_SIZE_SHIFT (0x0009u)
#define CSL_EMIF_PAGEMODCTRL1_CS3_PAGE_SIZE_RESETVAL (0x0000u)
/*----CS3_PAGE_SIZE Tokens----*/
#define CSL_EMIF_PAGEMODCTRL1_CS3_PAGE_SIZE_FOUR (0x0000u)
#define CSL_EMIF_PAGEMODCTRL1_CS3_PAGE_SIZE_EIGHT (0x0001u)

#define CSL_EMIF_PAGEMODCTRL1_CS3_PAGEMOD_EN_MASK (0x0100u)
#define CSL_EMIF_PAGEMODCTRL1_CS3_PAGEMOD_EN_SHIFT (0x0008u)
#define CSL_EMIF_PAGEMODCTRL1_CS3_PAGEMOD_EN_RESETVAL (0x0000u)
/*----CS3_PAGEMOD_EN Tokens----*/
#define CSL_EMIF_PAGEMODCTRL1_CS3_PAGEMOD_EN_DISABLE (0x0000u)
#define CSL_EMIF_PAGEMODCTRL1_CS3_PAGEMOD_EN_ENABLE (0x0001u)

#define CSL_EMIF_PAGEMODCTRL1_CS2_PAGE_DELAY_MASK (0x00FCu)
#define CSL_EMIF_PAGEMODCTRL1_CS2_PAGE_DELAY_SHIFT (0x0002u)
#define CSL_EMIF_PAGEMODCTRL1_CS2_PAGE_DELAY_RESETVAL (0x003Fu)

#define CSL_EMIF_PAGEMODCTRL1_CS2_PAGE_SIZE_MASK (0x0002u)
#define CSL_EMIF_PAGEMODCTRL1_CS2_PAGE_SIZE_SHIFT (0x0001u)
#define CSL_EMIF_PAGEMODCTRL1_CS2_PAGE_SIZE_RESETVAL (0x0001u)
/*----CS2_PAGE_SIZE Tokens----*/
#define CSL_EMIF_PAGEMODCTRL1_CS2_PAGE_SIZE_FOUR (0x0000u)
#define CSL_EMIF_PAGEMODCTRL1_CS2_PAGE_SIZE_EIGHT (0x0001u)

#define CSL_EMIF_PAGEMODCTRL1_CS2_PAGEMOD_EN_MASK (0x0001u)
#define CSL_EMIF_PAGEMODCTRL1_CS2_PAGEMOD_EN_SHIFT (0x0000u)
#define CSL_EMIF_PAGEMODCTRL1_CS2_PAGEMOD_EN_RESETVAL (0x0000u)
/*----CS2_PAGEMOD_EN Tokens----*/
#define CSL_EMIF_PAGEMODCTRL1_CS2_PAGEMOD_EN_DISABLE (0x0000u)
#define CSL_EMIF_PAGEMODCTRL1_CS2_PAGEMOD_EN_ENABLE (0x0001u)

#define CSL_EMIF_PAGEMODCTRL1_RESETVAL   (0xFCFEu)

/* PAGEMODCTRL2 */

#define CSL_EMIF_PAGEMODCTRL2_CS5_PAGE_DELAY_MASK (0xFC00u)
#define CSL_EMIF_PAGEMODCTRL2_CS5_PAGE_DELAY_SHIFT (0x000Au)
#define CSL_EMIF_PAGEMODCTRL2_CS5_PAGE_DELAY_RESETVAL (0x003Fu)

#define CSL_EMIF_PAGEMODCTRL2_CS5_PAGE_SIZE_MASK (0x0200u)
#define CSL_EMIF_PAGEMODCTRL2_CS5_PAGE_SIZE_SHIFT (0x0009u)
#define CSL_EMIF_PAGEMODCTRL2_CS5_PAGE_SIZE_RESETVAL (0x0000u)
/*----CS5_PAGE_SIZE Tokens----*/
#define CSL_EMIF_PAGEMODCTRL2_CS5_PAGE_SIZE_FOUR (0x0000u)
#define CSL_EMIF_PAGEMODCTRL2_CS5_PAGE_SIZE_EIGHT (0x0001u)

#define CSL_EMIF_PAGEMODCTRL2_CS5_PAGEMOD_EN_MASK (0x0100u)
#define CSL_EMIF_PAGEMODCTRL2_CS5_PAGEMOD_EN_SHIFT (0x0008u)
#define CSL_EMIF_PAGEMODCTRL2_CS5_PAGEMOD_EN_RESETVAL (0x0000u)
/*----CS5_PAGEMOD_EN Tokens----*/
#define CSL_EMIF_PAGEMODCTRL2_CS5_PAGEMOD_EN_DISABLE (0x0000u)
#define CSL_EMIF_PAGEMODCTRL2_CS5_PAGEMOD_EN_ENABLE (0x0001u)

#define CSL_EMIF_PAGEMODCTRL2_CS4_PAGE_DELAY_MASK (0x00FCu)
#define CSL_EMIF_PAGEMODCTRL2_CS4_PAGE_DELAY_SHIFT (0x0002u)
#define CSL_EMIF_PAGEMODCTRL2_CS4_PAGE_DELAY_RESETVAL (0x003Fu)

#define CSL_EMIF_PAGEMODCTRL2_CS4_PAGE_SIZE_MASK (0x0002u)
#define CSL_EMIF_PAGEMODCTRL2_CS4_PAGE_SIZE_SHIFT (0x0001u)
#define CSL_EMIF_PAGEMODCTRL2_CS4_PAGE_SIZE_RESETVAL (0x0000u)
/*----CS4_PAGE_SIZE Tokens----*/
#define CSL_EMIF_PAGEMODCTRL2_CS4_PAGE_SIZE_FOUR (0x0000u)
#define CSL_EMIF_PAGEMODCTRL2_CS4_PAGE_SIZE_EIGHT (0x0001u)

#define CSL_EMIF_PAGEMODCTRL2_CS4_PAGEMOD_EN_MASK (0x0001u)
#define CSL_EMIF_PAGEMODCTRL2_CS4_PAGEMOD_EN_SHIFT (0x0000u)
#define CSL_EMIF_PAGEMODCTRL2_CS4_PAGEMOD_EN_RESETVAL (0x0000u)
/*----CS4_PAGEMOD_EN Tokens----*/
#define CSL_EMIF_PAGEMODCTRL2_CS4_PAGEMOD_EN_DISABLE (0x0000u)
#define CSL_EMIF_PAGEMODCTRL2_CS4_PAGEMOD_EN_ENABLE (0x0001u)

#define CSL_EMIF_PAGEMODCTRL2_RESETVAL   (0xFCFCu)

/* NCS2ECC1 */


#define CSL_EMIF_NCS2ECC1_P2048E_MASK    (0x0800u)
#define CSL_EMIF_NCS2ECC1_P2048E_SHIFT   (0x000Bu)
#define CSL_EMIF_NCS2ECC1_P2048E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS2ECC1_P1024E_MASK    (0x0400u)
#define CSL_EMIF_NCS2ECC1_P1024E_SHIFT   (0x000Au)
#define CSL_EMIF_NCS2ECC1_P1024E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS2ECC1_P512E_MASK     (0x0200u)
#define CSL_EMIF_NCS2ECC1_P512E_SHIFT    (0x0009u)
#define CSL_EMIF_NCS2ECC1_P512E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS2ECC1_P256E_MASK     (0x0100u)
#define CSL_EMIF_NCS2ECC1_P256E_SHIFT    (0x0008u)
#define CSL_EMIF_NCS2ECC1_P256E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS2ECC1_P128E_MASK     (0x0080u)
#define CSL_EMIF_NCS2ECC1_P128E_SHIFT    (0x0007u)
#define CSL_EMIF_NCS2ECC1_P128E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS2ECC1_P64E_MASK      (0x0040u)
#define CSL_EMIF_NCS2ECC1_P64E_SHIFT     (0x0006u)
#define CSL_EMIF_NCS2ECC1_P64E_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS2ECC1_P32E_MASK      (0x0020u)
#define CSL_EMIF_NCS2ECC1_P32E_SHIFT     (0x0005u)
#define CSL_EMIF_NCS2ECC1_P32E_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS2ECC1_P16E_MASK      (0x0010u)
#define CSL_EMIF_NCS2ECC1_P16E_SHIFT     (0x0004u)
#define CSL_EMIF_NCS2ECC1_P16E_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS2ECC1_P8E_MASK       (0x0008u)
#define CSL_EMIF_NCS2ECC1_P8E_SHIFT      (0x0003u)
#define CSL_EMIF_NCS2ECC1_P8E_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS2ECC1_P4E_MASK       (0x0004u)
#define CSL_EMIF_NCS2ECC1_P4E_SHIFT      (0x0002u)
#define CSL_EMIF_NCS2ECC1_P4E_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS2ECC1_P2E_MASK       (0x0002u)
#define CSL_EMIF_NCS2ECC1_P2E_SHIFT      (0x0001u)
#define CSL_EMIF_NCS2ECC1_P2E_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS2ECC1_P1E_MASK       (0x0001u)
#define CSL_EMIF_NCS2ECC1_P1E_SHIFT      (0x0000u)
#define CSL_EMIF_NCS2ECC1_P1E_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS2ECC1_RESETVAL       (0x0000u)

/* NCS2ECC2 */


#define CSL_EMIF_NCS2ECC2_P2048O_MASK    (0x0800u)
#define CSL_EMIF_NCS2ECC2_P2048O_SHIFT   (0x000Bu)
#define CSL_EMIF_NCS2ECC2_P2048O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS2ECC2_P1024O_MASK    (0x0400u)
#define CSL_EMIF_NCS2ECC2_P1024O_SHIFT   (0x000Au)
#define CSL_EMIF_NCS2ECC2_P1024O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS2ECC2_P512O_MASK     (0x0200u)
#define CSL_EMIF_NCS2ECC2_P512O_SHIFT    (0x0009u)
#define CSL_EMIF_NCS2ECC2_P512O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS2ECC2_P256O_MASK     (0x0100u)
#define CSL_EMIF_NCS2ECC2_P256O_SHIFT    (0x0008u)
#define CSL_EMIF_NCS2ECC2_P256O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS2ECC2_P128O_MASK     (0x0080u)
#define CSL_EMIF_NCS2ECC2_P128O_SHIFT    (0x0007u)
#define CSL_EMIF_NCS2ECC2_P128O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS2ECC2_P64O_MASK      (0x0040u)
#define CSL_EMIF_NCS2ECC2_P64O_SHIFT     (0x0006u)
#define CSL_EMIF_NCS2ECC2_P64O_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS2ECC2_P32O_MASK      (0x0020u)
#define CSL_EMIF_NCS2ECC2_P32O_SHIFT     (0x0005u)
#define CSL_EMIF_NCS2ECC2_P32O_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS2ECC2_P16O_MASK      (0x0010u)
#define CSL_EMIF_NCS2ECC2_P16O_SHIFT     (0x0004u)
#define CSL_EMIF_NCS2ECC2_P16O_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS2ECC2_P8O_MASK       (0x0008u)
#define CSL_EMIF_NCS2ECC2_P8O_SHIFT      (0x0003u)
#define CSL_EMIF_NCS2ECC2_P8O_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS2ECC2_P4O_MASK       (0x0004u)
#define CSL_EMIF_NCS2ECC2_P4O_SHIFT      (0x0002u)
#define CSL_EMIF_NCS2ECC2_P4O_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS2ECC2_P2O_MASK       (0x0002u)
#define CSL_EMIF_NCS2ECC2_P2O_SHIFT      (0x0001u)
#define CSL_EMIF_NCS2ECC2_P2O_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS2ECC2_P1O_MASK       (0x0001u)
#define CSL_EMIF_NCS2ECC2_P1O_SHIFT      (0x0000u)
#define CSL_EMIF_NCS2ECC2_P1O_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS2ECC2_RESETVAL       (0x0000u)

/* NCS3ECC1 */


#define CSL_EMIF_NCS3ECC1_P2048E_MASK    (0x0800u)
#define CSL_EMIF_NCS3ECC1_P2048E_SHIFT   (0x000Bu)
#define CSL_EMIF_NCS3ECC1_P2048E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS3ECC1_P1024E_MASK    (0x0400u)
#define CSL_EMIF_NCS3ECC1_P1024E_SHIFT   (0x000Au)
#define CSL_EMIF_NCS3ECC1_P1024E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS3ECC1_P512E_MASK     (0x0200u)
#define CSL_EMIF_NCS3ECC1_P512E_SHIFT    (0x0009u)
#define CSL_EMIF_NCS3ECC1_P512E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS3ECC1_P256E_MASK     (0x0100u)
#define CSL_EMIF_NCS3ECC1_P256E_SHIFT    (0x0008u)
#define CSL_EMIF_NCS3ECC1_P256E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS3ECC1_P128E_MASK     (0x0080u)
#define CSL_EMIF_NCS3ECC1_P128E_SHIFT    (0x0007u)
#define CSL_EMIF_NCS3ECC1_P128E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS3ECC1_P64E_MASK      (0x0040u)
#define CSL_EMIF_NCS3ECC1_P64E_SHIFT     (0x0006u)
#define CSL_EMIF_NCS3ECC1_P64E_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS3ECC1_P32E_MASK      (0x0020u)
#define CSL_EMIF_NCS3ECC1_P32E_SHIFT     (0x0005u)
#define CSL_EMIF_NCS3ECC1_P32E_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS3ECC1_P16E_MASK      (0x0010u)
#define CSL_EMIF_NCS3ECC1_P16E_SHIFT     (0x0004u)
#define CSL_EMIF_NCS3ECC1_P16E_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS3ECC1_P8E_MASK       (0x0008u)
#define CSL_EMIF_NCS3ECC1_P8E_SHIFT      (0x0003u)
#define CSL_EMIF_NCS3ECC1_P8E_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS3ECC1_P4E_MASK       (0x0004u)
#define CSL_EMIF_NCS3ECC1_P4E_SHIFT      (0x0002u)
#define CSL_EMIF_NCS3ECC1_P4E_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS3ECC1_P2E_MASK       (0x0002u)
#define CSL_EMIF_NCS3ECC1_P2E_SHIFT      (0x0001u)
#define CSL_EMIF_NCS3ECC1_P2E_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS3ECC1_P1E_MASK       (0x0001u)
#define CSL_EMIF_NCS3ECC1_P1E_SHIFT      (0x0000u)
#define CSL_EMIF_NCS3ECC1_P1E_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS3ECC1_RESETVAL       (0x0000u)

/* NCS3ECC2 */


#define CSL_EMIF_NCS3ECC2_P2048O_MASK    (0x0800u)
#define CSL_EMIF_NCS3ECC2_P2048O_SHIFT   (0x000Bu)
#define CSL_EMIF_NCS3ECC2_P2048O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS3ECC2_P1024O_MASK    (0x0400u)
#define CSL_EMIF_NCS3ECC2_P1024O_SHIFT   (0x000Au)
#define CSL_EMIF_NCS3ECC2_P1024O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS3ECC2_P512O_MASK     (0x0200u)
#define CSL_EMIF_NCS3ECC2_P512O_SHIFT    (0x0009u)
#define CSL_EMIF_NCS3ECC2_P512O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS3ECC2_P256O_MASK     (0x0100u)
#define CSL_EMIF_NCS3ECC2_P256O_SHIFT    (0x0008u)
#define CSL_EMIF_NCS3ECC2_P256O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS3ECC2_P128O_MASK     (0x0080u)
#define CSL_EMIF_NCS3ECC2_P128O_SHIFT    (0x0007u)
#define CSL_EMIF_NCS3ECC2_P128O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS3ECC2_P64O_MASK      (0x0040u)
#define CSL_EMIF_NCS3ECC2_P64O_SHIFT     (0x0006u)
#define CSL_EMIF_NCS3ECC2_P64O_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS3ECC2_P32O_MASK      (0x0020u)
#define CSL_EMIF_NCS3ECC2_P32O_SHIFT     (0x0005u)
#define CSL_EMIF_NCS3ECC2_P32O_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS3ECC2_P16O_MASK      (0x0010u)
#define CSL_EMIF_NCS3ECC2_P16O_SHIFT     (0x0004u)
#define CSL_EMIF_NCS3ECC2_P16O_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS3ECC2_P8O_MASK       (0x0008u)
#define CSL_EMIF_NCS3ECC2_P8O_SHIFT      (0x0003u)
#define CSL_EMIF_NCS3ECC2_P8O_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS3ECC2_P4O_MASK       (0x0004u)
#define CSL_EMIF_NCS3ECC2_P4O_SHIFT      (0x0002u)
#define CSL_EMIF_NCS3ECC2_P4O_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS3ECC2_P2O_MASK       (0x0002u)
#define CSL_EMIF_NCS3ECC2_P2O_SHIFT      (0x0001u)
#define CSL_EMIF_NCS3ECC2_P2O_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS3ECC2_P1O_MASK       (0x0001u)
#define CSL_EMIF_NCS3ECC2_P1O_SHIFT      (0x0000u)
#define CSL_EMIF_NCS3ECC2_P1O_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS3ECC2_RESETVAL       (0x0000u)

/* NCS4ECC1 */


#define CSL_EMIF_NCS4ECC1_P2048E_MASK    (0x0800u)
#define CSL_EMIF_NCS4ECC1_P2048E_SHIFT   (0x000Bu)
#define CSL_EMIF_NCS4ECC1_P2048E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS4ECC1_P1024E_MASK    (0x0400u)
#define CSL_EMIF_NCS4ECC1_P1024E_SHIFT   (0x000Au)
#define CSL_EMIF_NCS4ECC1_P1024E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS4ECC1_P512E_MASK     (0x0200u)
#define CSL_EMIF_NCS4ECC1_P512E_SHIFT    (0x0009u)
#define CSL_EMIF_NCS4ECC1_P512E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS4ECC1_P256E_MASK     (0x0100u)
#define CSL_EMIF_NCS4ECC1_P256E_SHIFT    (0x0008u)
#define CSL_EMIF_NCS4ECC1_P256E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS4ECC1_P128E_MASK     (0x0080u)
#define CSL_EMIF_NCS4ECC1_P128E_SHIFT    (0x0007u)
#define CSL_EMIF_NCS4ECC1_P128E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS4ECC1_P64E_MASK      (0x0040u)
#define CSL_EMIF_NCS4ECC1_P64E_SHIFT     (0x0006u)
#define CSL_EMIF_NCS4ECC1_P64E_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS4ECC1_P32E_MASK      (0x0020u)
#define CSL_EMIF_NCS4ECC1_P32E_SHIFT     (0x0005u)
#define CSL_EMIF_NCS4ECC1_P32E_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS4ECC1_P16E_MASK      (0x0010u)
#define CSL_EMIF_NCS4ECC1_P16E_SHIFT     (0x0004u)
#define CSL_EMIF_NCS4ECC1_P16E_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS4ECC1_P8E_MASK       (0x0008u)
#define CSL_EMIF_NCS4ECC1_P8E_SHIFT      (0x0003u)
#define CSL_EMIF_NCS4ECC1_P8E_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS4ECC1_P4E_MASK       (0x0004u)
#define CSL_EMIF_NCS4ECC1_P4E_SHIFT      (0x0002u)
#define CSL_EMIF_NCS4ECC1_P4E_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS4ECC1_P2E_MASK       (0x0002u)
#define CSL_EMIF_NCS4ECC1_P2E_SHIFT      (0x0001u)
#define CSL_EMIF_NCS4ECC1_P2E_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS4ECC1_P1E_MASK       (0x0001u)
#define CSL_EMIF_NCS4ECC1_P1E_SHIFT      (0x0000u)
#define CSL_EMIF_NCS4ECC1_P1E_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS4ECC1_RESETVAL       (0x0000u)

/* NCS4ECC2 */


#define CSL_EMIF_NCS4ECC2_P2048O_MASK    (0x0800u)
#define CSL_EMIF_NCS4ECC2_P2048O_SHIFT   (0x000Bu)
#define CSL_EMIF_NCS4ECC2_P2048O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS4ECC2_P1024O_MASK    (0x0400u)
#define CSL_EMIF_NCS4ECC2_P1024O_SHIFT   (0x000Au)
#define CSL_EMIF_NCS4ECC2_P1024O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS4ECC2_P512O_MASK     (0x0200u)
#define CSL_EMIF_NCS4ECC2_P512O_SHIFT    (0x0009u)
#define CSL_EMIF_NCS4ECC2_P512O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS4ECC2_P256O_MASK     (0x0100u)
#define CSL_EMIF_NCS4ECC2_P256O_SHIFT    (0x0008u)
#define CSL_EMIF_NCS4ECC2_P256O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS4ECC2_P128O_MASK     (0x0080u)
#define CSL_EMIF_NCS4ECC2_P128O_SHIFT    (0x0007u)
#define CSL_EMIF_NCS4ECC2_P128O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS4ECC2_P64O_MASK      (0x0040u)
#define CSL_EMIF_NCS4ECC2_P64O_SHIFT     (0x0006u)
#define CSL_EMIF_NCS4ECC2_P64O_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS4ECC2_P32O_MASK      (0x0020u)
#define CSL_EMIF_NCS4ECC2_P32O_SHIFT     (0x0005u)
#define CSL_EMIF_NCS4ECC2_P32O_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS4ECC2_P16O_MASK      (0x0010u)
#define CSL_EMIF_NCS4ECC2_P16O_SHIFT     (0x0004u)
#define CSL_EMIF_NCS4ECC2_P16O_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS4ECC2_P8O_MASK       (0x0008u)
#define CSL_EMIF_NCS4ECC2_P8O_SHIFT      (0x0003u)
#define CSL_EMIF_NCS4ECC2_P8O_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS4ECC2_P4O_MASK       (0x0004u)
#define CSL_EMIF_NCS4ECC2_P4O_SHIFT      (0x0002u)
#define CSL_EMIF_NCS4ECC2_P4O_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS4ECC2_P2O_MASK       (0x0002u)
#define CSL_EMIF_NCS4ECC2_P2O_SHIFT      (0x0001u)
#define CSL_EMIF_NCS4ECC2_P2O_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS4ECC2_P1O_MASK       (0x0001u)
#define CSL_EMIF_NCS4ECC2_P1O_SHIFT      (0x0000u)
#define CSL_EMIF_NCS4ECC2_P1O_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS4ECC2_RESETVAL       (0x0000u)

/* NCS5ECC1 */


#define CSL_EMIF_NCS5ECC1_P2048E_MASK    (0x0800u)
#define CSL_EMIF_NCS5ECC1_P2048E_SHIFT   (0x000Bu)
#define CSL_EMIF_NCS5ECC1_P2048E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS5ECC1_P1024E_MASK    (0x0400u)
#define CSL_EMIF_NCS5ECC1_P1024E_SHIFT   (0x000Au)
#define CSL_EMIF_NCS5ECC1_P1024E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS5ECC1_P512E_MASK     (0x0200u)
#define CSL_EMIF_NCS5ECC1_P512E_SHIFT    (0x0009u)
#define CSL_EMIF_NCS5ECC1_P512E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS5ECC1_P256E_MASK     (0x0100u)
#define CSL_EMIF_NCS5ECC1_P256E_SHIFT    (0x0008u)
#define CSL_EMIF_NCS5ECC1_P256E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS5ECC1_P128E_MASK     (0x0080u)
#define CSL_EMIF_NCS5ECC1_P128E_SHIFT    (0x0007u)
#define CSL_EMIF_NCS5ECC1_P128E_RESETVAL (0x0000u)

#define CSL_EMIF_NCS5ECC1_P64E_MASK      (0x0040u)
#define CSL_EMIF_NCS5ECC1_P64E_SHIFT     (0x0006u)
#define CSL_EMIF_NCS5ECC1_P64E_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS5ECC1_P32E_MASK      (0x0020u)
#define CSL_EMIF_NCS5ECC1_P32E_SHIFT     (0x0005u)
#define CSL_EMIF_NCS5ECC1_P32E_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS5ECC1_P16E_MASK      (0x0010u)
#define CSL_EMIF_NCS5ECC1_P16E_SHIFT     (0x0004u)
#define CSL_EMIF_NCS5ECC1_P16E_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS5ECC1_P8E_MASK       (0x0008u)
#define CSL_EMIF_NCS5ECC1_P8E_SHIFT      (0x0003u)
#define CSL_EMIF_NCS5ECC1_P8E_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS5ECC1_P4E_MASK       (0x0004u)
#define CSL_EMIF_NCS5ECC1_P4E_SHIFT      (0x0002u)
#define CSL_EMIF_NCS5ECC1_P4E_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS5ECC1_P2E_MASK       (0x0002u)
#define CSL_EMIF_NCS5ECC1_P2E_SHIFT      (0x0001u)
#define CSL_EMIF_NCS5ECC1_P2E_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS5ECC1_P1E_MASK       (0x0001u)
#define CSL_EMIF_NCS5ECC1_P1E_SHIFT      (0x0000u)
#define CSL_EMIF_NCS5ECC1_P1E_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS5ECC1_RESETVAL       (0x0000u)

/* NCS5ECC2 */


#define CSL_EMIF_NCS5ECC2_P2048O_MASK    (0x0800u)
#define CSL_EMIF_NCS5ECC2_P2048O_SHIFT   (0x000Bu)
#define CSL_EMIF_NCS5ECC2_P2048O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS5ECC2_P1024O_MASK    (0x0400u)
#define CSL_EMIF_NCS5ECC2_P1024O_SHIFT   (0x000Au)
#define CSL_EMIF_NCS5ECC2_P1024O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS5ECC2_P512O_MASK     (0x0200u)
#define CSL_EMIF_NCS5ECC2_P512O_SHIFT    (0x0009u)
#define CSL_EMIF_NCS5ECC2_P512O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS5ECC2_P256O_MASK     (0x0100u)
#define CSL_EMIF_NCS5ECC2_P256O_SHIFT    (0x0008u)
#define CSL_EMIF_NCS5ECC2_P256O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS5ECC2_P128O_MASK     (0x0080u)
#define CSL_EMIF_NCS5ECC2_P128O_SHIFT    (0x0007u)
#define CSL_EMIF_NCS5ECC2_P128O_RESETVAL (0x0000u)

#define CSL_EMIF_NCS5ECC2_P64O_MASK      (0x0040u)
#define CSL_EMIF_NCS5ECC2_P64O_SHIFT     (0x0006u)
#define CSL_EMIF_NCS5ECC2_P64O_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS5ECC2_P32O_MASK      (0x0020u)
#define CSL_EMIF_NCS5ECC2_P32O_SHIFT     (0x0005u)
#define CSL_EMIF_NCS5ECC2_P32O_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS5ECC2_P16O_MASK      (0x0010u)
#define CSL_EMIF_NCS5ECC2_P16O_SHIFT     (0x0004u)
#define CSL_EMIF_NCS5ECC2_P16O_RESETVAL  (0x0000u)

#define CSL_EMIF_NCS5ECC2_P8O_MASK       (0x0008u)
#define CSL_EMIF_NCS5ECC2_P8O_SHIFT      (0x0003u)
#define CSL_EMIF_NCS5ECC2_P8O_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS5ECC2_P4O_MASK       (0x0004u)
#define CSL_EMIF_NCS5ECC2_P4O_SHIFT      (0x0002u)
#define CSL_EMIF_NCS5ECC2_P4O_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS5ECC2_P2O_MASK       (0x0002u)
#define CSL_EMIF_NCS5ECC2_P2O_SHIFT      (0x0001u)
#define CSL_EMIF_NCS5ECC2_P2O_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS5ECC2_P1O_MASK       (0x0001u)
#define CSL_EMIF_NCS5ECC2_P1O_SHIFT      (0x0000u)
#define CSL_EMIF_NCS5ECC2_P1O_RESETVAL   (0x0000u)

#define CSL_EMIF_NCS5ECC2_RESETVAL       (0x0000u)

/* NAND4BITECCLOAD */


#define CSL_EMIF_NAND4BITECCLOAD_4BIT_ECC_LOAD_MASK (0x03FFu)
#define CSL_EMIF_NAND4BITECCLOAD_4BIT_ECC_LOAD_SHIFT (0x0000u)
#define CSL_EMIF_NAND4BITECCLOAD_4BIT_ECC_LOAD_RESETVAL (0x0000u)

#define CSL_EMIF_NAND4BITECCLOAD_RESETVAL (0x0000u)

/* NAND4BITECC1 */


#define CSL_EMIF_NAND4BITECC1_4BIT_ECC_VAL1_MASK (0x03FFu)
#define CSL_EMIF_NAND4BITECC1_4BIT_ECC_VAL1_SHIFT (0x0000u)
#define CSL_EMIF_NAND4BITECC1_4BIT_ECC_VAL1_RESETVAL (0x0000u)

#define CSL_EMIF_NAND4BITECC1_RESETVAL   (0x0000u)

/* NAND4BITECC2 */


#define CSL_EMIF_NAND4BITECC2_4BIT_ECC_VAL2_MASK (0x03FFu)
#define CSL_EMIF_NAND4BITECC2_4BIT_ECC_VAL2_SHIFT (0x0000u)
#define CSL_EMIF_NAND4BITECC2_4BIT_ECC_VAL2_RESETVAL (0x0000u)

#define CSL_EMIF_NAND4BITECC2_RESETVAL   (0x0000u)

/* NAND4BITECC3 */


#define CSL_EMIF_NAND4BITECC3_4BIT_ECC_VAL3_MASK (0x03FFu)
#define CSL_EMIF_NAND4BITECC3_4BIT_ECC_VAL3_SHIFT (0x0000u)
#define CSL_EMIF_NAND4BITECC3_4BIT_ECC_VAL3_RESETVAL (0x0000u)

#define CSL_EMIF_NAND4BITECC3_RESETVAL   (0x0000u)

/* NAND4BITECC4 */


#define CSL_EMIF_NAND4BITECC4_4BIT_ECC_VAL4_MASK (0x03FFu)
#define CSL_EMIF_NAND4BITECC4_4BIT_ECC_VAL4_SHIFT (0x0000u)
#define CSL_EMIF_NAND4BITECC4_4BIT_ECC_VAL4_RESETVAL (0x0000u)

#define CSL_EMIF_NAND4BITECC4_RESETVAL   (0x0000u)

/* NAND4BITECC5 */


#define CSL_EMIF_NAND4BITECC5_4BIT_ECC_VAL5_MASK (0x03FFu)
#define CSL_EMIF_NAND4BITECC5_4BIT_ECC_VAL5_SHIFT (0x0000u)
#define CSL_EMIF_NAND4BITECC5_4BIT_ECC_VAL5_RESETVAL (0x0000u)

#define CSL_EMIF_NAND4BITECC5_RESETVAL   (0x0000u)

/* NAND4BITECC6 */


#define CSL_EMIF_NAND4BITECC6_4BIT_ECC_VAL6_MASK (0x03FFu)
#define CSL_EMIF_NAND4BITECC6_4BIT_ECC_VAL6_SHIFT (0x0000u)
#define CSL_EMIF_NAND4BITECC6_4BIT_ECC_VAL6_RESETVAL (0x0000u)

#define CSL_EMIF_NAND4BITECC6_RESETVAL   (0x0000u)

/* NAND4BITECC7 */


#define CSL_EMIF_NAND4BITECC7_4BIT_ECC_VAL7_MASK (0x03FFu)
#define CSL_EMIF_NAND4BITECC7_4BIT_ECC_VAL7_SHIFT (0x0000u)
#define CSL_EMIF_NAND4BITECC7_4BIT_ECC_VAL7_RESETVAL (0x0000u)

#define CSL_EMIF_NAND4BITECC7_RESETVAL   (0x0000u)

/* NAND4BITECC8 */


#define CSL_EMIF_NAND4BITECC8_4BIT_ECC_VAL8_MASK (0x03FFu)
#define CSL_EMIF_NAND4BITECC8_4BIT_ECC_VAL8_SHIFT (0x0000u)
#define CSL_EMIF_NAND4BITECC8_4BIT_ECC_VAL8_RESETVAL (0x0000u)

#define CSL_EMIF_NAND4BITECC8_RESETVAL   (0x0000u)

/* NANDERRADD1 */


#define CSL_EMIF_NANDERRADD1_ERR_ADDR1_MASK (0x03FFu)
#define CSL_EMIF_NANDERRADD1_ERR_ADDR1_SHIFT (0x0000u)
#define CSL_EMIF_NANDERRADD1_ERR_ADDR1_RESETVAL (0x0000u)

#define CSL_EMIF_NANDERRADD1_RESETVAL    (0x0000u)

/* NANDERRADD2 */


#define CSL_EMIF_NANDERRADD2_ERR_ADDR2_MASK (0x03FFu)
#define CSL_EMIF_NANDERRADD2_ERR_ADDR2_SHIFT (0x0000u)
#define CSL_EMIF_NANDERRADD2_ERR_ADDR2_RESETVAL (0x0000u)

#define CSL_EMIF_NANDERRADD2_RESETVAL    (0x0000u)

/* NANDERRADD3 */


#define CSL_EMIF_NANDERRADD3_ERR_ADDR3_MASK (0x03FFu)
#define CSL_EMIF_NANDERRADD3_ERR_ADDR3_SHIFT (0x0000u)
#define CSL_EMIF_NANDERRADD3_ERR_ADDR3_RESETVAL (0x0000u)

#define CSL_EMIF_NANDERRADD3_RESETVAL    (0x0000u)

/* NANDERRADD4 */


#define CSL_EMIF_NANDERRADD4_ERR_ADDR4_MASK (0x03FFu)
#define CSL_EMIF_NANDERRADD4_ERR_ADDR4_SHIFT (0x0000u)
#define CSL_EMIF_NANDERRADD4_ERR_ADDR4_RESETVAL (0x0000u)

#define CSL_EMIF_NANDERRADD4_RESETVAL    (0x0000u)

/* NANDERRVAL1 */


#define CSL_EMIF_NANDERRVAL1_ERR_VALUE1_MASK (0x03FFu)
#define CSL_EMIF_NANDERRVAL1_ERR_VALUE1_SHIFT (0x0000u)
#define CSL_EMIF_NANDERRVAL1_ERR_VALUE1_RESETVAL (0x0000u)

#define CSL_EMIF_NANDERRVAL1_RESETVAL    (0x0000u)

/* NANDERRVAL2 */


#define CSL_EMIF_NANDERRVAL2_ERR_VALUE2_MASK (0x03FFu)
#define CSL_EMIF_NANDERRVAL2_ERR_VALUE2_SHIFT (0x0000u)
#define CSL_EMIF_NANDERRVAL2_ERR_VALUE2_RESETVAL (0x0000u)

#define CSL_EMIF_NANDERRVAL2_RESETVAL    (0x0000u)

/* NANDERRVAL3 */


#define CSL_EMIF_NANDERRVAL3_ERR_VALUE3_MASK (0x03FFu)
#define CSL_EMIF_NANDERRVAL3_ERR_VALUE3_SHIFT (0x0000u)
#define CSL_EMIF_NANDERRVAL3_ERR_VALUE3_RESETVAL (0x0000u)

#define CSL_EMIF_NANDERRVAL3_RESETVAL    (0x0000u)

/* NANDERRVAL4 */


#define CSL_EMIF_NANDERRVAL4_ERR_VALUE4_MASK (0x03FFu)
#define CSL_EMIF_NANDERRVAL4_ERR_VALUE4_SHIFT (0x0000u)
#define CSL_EMIF_NANDERRVAL4_ERR_VALUE4_RESETVAL (0x0000u)

#define CSL_EMIF_NANDERRVAL4_RESETVAL    (0x0000u)

#endif
