#include "ti_msp_dl_config.h"
#include "oled.h"
#include "key.h"

/* Address in main memory to write to */
#define MAIN_BASE_ADDRESS (0x00008000)
#define STRING_LEN 16

char writeStr[STRING_LEN] = {0}; // дַ
//char writeStr[STRING_LEN] = "ABC";
char readStr[STRING_LEN] = {0};  // ȡַ
uint8_t writeStrIndex = 0;
int key_value = 0;               // ֵ

/* дFLASH */
void writeARRAYtoFLASH_Char(char *pArr, uint8_t len)
{
    uint8_t i = 0;
    uint8_t num = 0;

    /* Erase sector in main memory */
    DL_FlashCTL_unprotectSector(FLASHCTL, MAIN_BASE_ADDRESS, DL_FLASHCTL_REGION_SELECT_MAIN);
    DL_FlashCTL_eraseMemoryFromRAM(FLASHCTL, MAIN_BASE_ADDRESS, DL_FLASHCTL_COMMAND_SIZE_SECTOR);

    for (i = 0; i < len; i++)
        {
            num = (uint8_t)pArr[i];
            /* 8-bit write to flash in main memory */
            DL_FlashCTL_unprotectSector(FLASHCTL, MAIN_BASE_ADDRESS, DL_FLASHCTL_REGION_SELECT_MAIN);
            DL_FlashCTL_programMemoryFromRAM8(FLASHCTL, MAIN_BASE_ADDRESS + 8 * i, &num);
        }
}

/* FLASHжȡ */
void readARRAYfromFLASH_Char(char *pArr, uint8_t len)
{
    uint8_t i = 0;
    uint8_t num = 0;
    for (i = 0; i < len; i++)
        {
            num = *(uint8_t *)(MAIN_BASE_ADDRESS + 8 * i);
            pArr[i] = (char)num;
        }
}

int main(void)
{
    SYSCFG_DL_init(); // Initialize the device

    NVIC_EnableIRQ(SWITCH_INT_IRQN);

    OLED_Init();
    OLED_Clear();
    
    /* ãȶwriteStrиֵ */
    writeStr[0] = 'A';
    writeStr[1] = 'B';
    writeStr[2] = 'C';

    while (1)
        {
            /* ȡֱֵ̼̰ */
            do
                {
                    key_value = getKeyValue();
                }
            while (key_value == 0);
            /* ȴɿ */
            while (getKeyValue() != 0)
                {
                    __NOP();
                }
            /*  */
            switch (key_value)
                {
                case 15: // 
                    writeARRAYtoFLASH_Char(writeStr, STRING_LEN);
                    /* ʾдɹ */
                    OLED_ShowString(0, 4, "write ok!");
                    delay_cycles(16000000);
                    OLED_ShowString(0, 4, "                  ");
                    break;
                case 16: // ȡ
                    readARRAYfromFLASH_Char(readStr, STRING_LEN);
                    OLED_ShowString(8, 0, readStr);
                    break;
                case 1: // 1 2 3ֱΪַA B C
                    if (writeStrIndex < 15)
                        writeStr[writeStrIndex++] = 'A';
                    writeStr[writeStrIndex] = '\0';
                    OLED_ShowString(8, 0, writeStr);
                    break;
                case 2:
                    if (writeStrIndex < 15)
                        writeStr[writeStrIndex++] = 'B';
                    writeStr[writeStrIndex] = '\0';
                    OLED_ShowString(8, 0, writeStr);
                    break;
                case 3:
                    if (writeStrIndex < 15)
                        writeStr[writeStrIndex++] = 'C';
                    writeStr[writeStrIndex] = '\0';
                    OLED_ShowString(8, 0, writeStr);
                    break;
                }
        }
}

void GROUP1_IRQHandler(void)
{
    switch(DL_Interrupt_getPendingGroup(DL_INTERRUPT_GROUP_1))
        {
        case SWITCH_INT_IIDX:
            if(DL_GPIO_readPins(SWITCH_PORT, SWITCH_SW7_PIN) == 0)
                {
                    writeARRAYtoFLASH_Char(writeStr, STRING_LEN);
                    /* ʾдɹ */
                    OLED_ShowString(0, 4, "write ok!");
                    delay_cycles(16000000);
                    OLED_ShowString(0, 4, "                  ");
                }
            break;
        default:
            break;
        }
}
