/*
 * flash_handle.h
 *
 *  Created on: 20211114
 *      Author: FENGAO
 */

#ifndef F021_INCLUDE_FLASH_HANDLE_H_
#define F021_INCLUDE_FLASH_HANDLE_H_

#include "F021.h"

enum e_flash_status
{
    flash_succeed,
    flash_failure,
};

struct Sector_List
{
    Fapi_FlashBankType banks_num;
    uint32_t sector_num;
    uint32_t low_addr;
    uint32_t size;
};

#define SECTOR_NUM (15+12+4)

enum e_flash_status Flash_EraseSector(Fapi_FlashBankType oNewFlashBank, uint32_t sector);
enum e_flash_status Flash_EraseBanks(Fapi_FlashBankType oNewFlashBank);
enum e_flash_status Flash_WriteData(Fapi_FlashBankType oNewFlashBank, uint32_t sector, uint32_t offset, uint8_t * buff, uint32_t len);
void Flash_ReadData(Fapi_FlashBankType oNewFlashBank, uint32_t sector, uint32_t offset, uint8_t * buff, uint32_t len);



#endif /* F021_INCLUDE_FLASH_HANDLE_H_ */
